<?php
require_once __DIR__ . 
'/../includes/config.php';
require_once __DIR__ . 
'/../includes/doviz_fonksiyonlari.php';

header('Content-Type: application/json');

$from_currency = $_GET['from'] ?? '';
$to_currency = $_GET['to'] ?? '';

if (empty($from_currency) || empty($to_currency)) {
    echo json_encode(['success' => false, 'message' => 'Eksik para birimi bilgisi.']);
    exit();
}

try {
    $rate = get_exchange_rate($from_currency, $to_currency);
    echo json_encode(['success' => true, 'rate' => $rate]);
} catch (Exception $e) {
    error_log('AJAX döviz kuru hatası: ' . $e->getMessage());
    echo json_encode(['success' => false, 'message' => 'Döviz kuru alınırken bir hata oluştu.']);
}
?>

