<?php
// ajax/resim_islemleri.php

// Temel yapılandırma ve güvenlik dosyalarını dahil et
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../functions/stok_fonksiyonlari.php';

// Sadece yetkili kullanıcıların erişebildiğinden emin ol
yetkili_mi();

// Yanıt formatını JSON olarak ayarla
header('Content-Type: application/json');

// Oturumdan aktif şirket ID'sini al
$aktif_sirket_id = $_SESSION['aktif_sirket_id'] ?? null;
if (!$aktif_sirket_id) {
    echo json_encode(['success' => false, 'message' => 'Aktif şirket seçilmemiş.']);
    exit();
}

// İstek metodunun POST olduğundan emin ol
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    $_SESSION['hata'] = 'Geçersiz istek metodu.';
    header('Location: ' . $_SERVER['HTTP_REFERER']);
    exit();
}

// Gelen verileri al ve doğrula
$action = $_POST['action'] ?? '';
$resim_id = filter_input(INPUT_POST, 'resim_id', FILTER_VALIDATE_INT);
$urun_id = filter_input(INPUT_POST, 'urun_id', FILTER_VALIDATE_INT);

// Gerekli verilerin varlığını kontrol et
if (empty($action) || !$resim_id || !$urun_id) {
    $_SESSION['hata'] = 'Eksik veya geçersiz parametreler.';
    // Urun ID biliniyorsa doğru sayfaya yönlendir, değilse bir önceki sayfaya.
    $redirect_url = $urun_id ? BASE_URL . '/views/urun_duzenle.php?id=' . $urun_id : ($_SERVER['HTTP_REFERER'] ?? BASE_URL . '/views/urunler.php');
    header('Location: ' . $redirect_url);
    exit();
}


try {
    $success = false;
    $message = 'Bilinmeyen bir hata oluştu.';

    if ($action === 'delete_image') { // Formdan gelen 'delete_image' ile eşleştirildi
        if (urunResmiSil($db, $resim_id, $aktif_sirket_id)) {
            $_SESSION['mesaj'] = 'Resim başarıyla silindi.';
        } else {
            $_SESSION['hata'] = 'Resim silinirken bir hata oluştu veya resim bulunamadı.';
        }
    } elseif ($action === 'set_default') {
        if (urunResmiVarsayilanYap($db, $urun_id, $resim_id, $aktif_sirket_id)) {
            $_SESSION['mesaj'] = 'Resim varsayılan olarak ayarlandı.';
        } else {
            $_SESSION['hata'] = 'Resim varsayılan olarak ayarlanırken bir hata oluştu.';
        }
    } else {
        $_SESSION['hata'] = 'Geçersiz işlem isteği.';
    }

} catch (Exception $e) {
    error_log("Resim işlemi AJAX hatası: " . $e->getMessage());
    $_SESSION['hata'] = 'İşlem sırasında sunucu hatası oluştu.';
} finally {
    // İşlemden sonra her zaman ürün düzenleme sayfasına geri dön
    $redirect_url = BASE_URL . '/views/urun_duzenle.php?id=' . $urun_id;
    header('Location: ' . $redirect_url);
    exit();
} 