<?php
// includes klasöründen config.php dosyasını dahil et
require_once __DIR__ . '/../includes/config.php';
// functions klasöründen stok_fonksiyonlari.php dosyasını dahil et
require_once __DIR__ . '/../functions/stok_fonksiyonlari.php';
// functions klasöründen yardimci_fonksiyonlar.php dosyasını dahil et (yetkili_mi ve temizle için)
require_once __DIR__ . '/../functions/yardimci_fonksiyonlar.php';

// Veritabanı bağlantısı global olarak kullanılabilmesi için
global $db;

// Yetki kontrolü
yetkili_mi(); 

header('Content-Type: application/json');

// Sadece POST isteklerini kabul et
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Geçersiz istek yöntemi.']);
    exit;
}

$arama = temizle($_POST['arama'] ?? ''); // temizle() artık tanımlı olmalı
$tedarikci_id = filter_input(INPUT_POST, 'tedarikci_id', FILTER_VALIDATE_INT);

// Arama terimi en az 2 karakter olmalı (boşsa tümünü listelemek için daha sonra ayarlandı)
// Eğer boş arama ile tüm ürünleri listeleme özelliği isteniyorsa bu kontrol esnetilebilir.
if (strlen($arama) < 2 && !$tedarikci_id) { // Boş arama ise bu kontrolü geç
    echo json_encode(['success' => false, 'message' => 'En az 2 karakter giriniz veya tedarikçi seçiniz.']);
    exit;
}

try {
    $urunler = [];
    $sirket_id = $_SESSION['aktif_sirket_id'];

    if (!empty($arama)) {
        // Önce barkod ile ara
        $urun = barkodIleUrunAra($db, $arama, $sirket_id, $tedarikci_id);
        
        if ($urun) {
            // Barkod bulundu, tek sonuç döndür
            $urunler = [$urun];
        } else {
            // Barkod bulunamadıysa, ürün adı ile ara
            $urunler = urunAra($db, $arama, $sirket_id, 20, $tedarikci_id); // Limit artırıldı veya ayarlandı
        }
    } else {
        // Arama terimi boşsa tüm aktif ürünleri listele (tedarikçi filtresi varsa uygula)
        $sql = "SELECT u.*, ms.miktar as stok_miktari, k.kategori_adi, u.birim FROM urunler u 
                LEFT JOIN mevcut_stok ms ON u.id = ms.urun_id AND ms.sirket_id = u.sirket_id 
                LEFT JOIN kategoriler k ON u.kategori_id = k.id AND k.sirket_id = u.sirket_id 
                WHERE u.aktif = 1 AND u.sirket_id = ?";
        $params = [$sirket_id];
        
        // Tedarikçi filtresi varsa ekle
        if ($tedarikci_id) {
            $sql .= " AND u.tedarikci_id = ?";
            $params[] = $tedarikci_id;
        }
        
        $sql .= " ORDER BY u.urun_adi LIMIT 50";
        
        $stmt_all = $db->prepare($sql);
        $stmt_all->execute($params);
        $urunler = $stmt_all->fetchAll(PDO::FETCH_ASSOC);
    }
    
    // Her ürün için para birimi alanlarını garanti et
    foreach ($urunler as &$urun) {
        if (!isset($urun['alis_para_birimi'])) $urun['alis_para_birimi'] = 'TL';
        if (!isset($urun['satis_para_birimi'])) $urun['satis_para_birimi'] = 'TL';
    }
    unset($urun);
    echo json_encode([
        'success' => true,
        'urunler' => $urunler
    ]);
    
} catch (Exception $e) {
    error_log("Ürün arama AJAX hatası: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Arama sırasında bir hata oluştu: ' . $e->getMessage()
    ]);
}
?>