<?php

// Veri temizleme fonksiyonları
function tamsayi($value) {
    return filter_var($value, FILTER_VALIDATE_INT);
}

function ondalik($value) {
    $value = str_replace(",", ".", (string)$value);
    return filter_var($value, FILTER_VALIDATE_FLOAT);
}

// Brute-force koruması
function brute_force_kontrol() {
    $max_deneme = 5;
    $bekleme_suresi = 300;

    if (!isset($_SESSION["login_attempts"])) {
        $_SESSION["login_attempts"] = 0;
    }
    if (!isset($_SESSION["last_attempt_time"])) {
        $_SESSION["last_attempt_time"] = 0;
    }

    if($_SESSION["login_attempts"] >= $max_deneme) {
        if(time() - $_SESSION["last_attempt_time"] < $bekleme_suresi) {
            $kalan_sure = $bekleme_suresi - (time() - $_SESSION["last_attempt_time"]);
            $_SESSION["hata"] = "Çok fazla hatalı giriş denemesi. Lütfen " . ceil($kalan_sure/60) . " dakika sonra tekrar deneyin.";
            return false;
        } else {
            $_SESSION["login_attempts"] = 0;
            unset($_SESSION["last_attempt_time"]);
        }
    }
    return true;
}

function brute_force_log_attempt() {
    if (!isset($_SESSION["login_attempts"])) {
        $_SESSION["login_attempts"] = 0;
    }
    $_SESSION["login_attempts"]++;
    $_SESSION["last_attempt_time"] = time();
}

// Yardımcı Fonksiyonlar
function hesapBakiyeGuncelle(PDO $db, int $hesap_id, float $degisim): bool {
    try {
        $stmt = $db->prepare("UPDATE hesaplar SET bakiye = bakiye + :degisim WHERE id = :hesap_id");
        $stmt->bindParam(":degisim", $degisim, PDO::PARAM_STR);
        $stmt->bindParam(":hesap_id", $hesap_id, PDO::PARAM_INT);
        return $stmt->execute();
    } catch (PDOException $e) {
        error_log("Hesap Bakiye Güncelleme Hatası (Hesap ID: {$hesap_id}): " . $e->getMessage());
        return false;
    }
}

function cariBakiyeGuncelle(PDO $db, int $cari_id, float $borc_degisim = 0.0, float $alacak_degisim = 0.0): bool {
    try {
        $sql = "UPDATE cariler SET
                    toplam_borc = toplam_borc + :borc_degisim,
                    toplam_alacak = toplam_alacak + :alacak_degisim,
                    bakiye = (toplam_alacak + :alacak_degisim_tekrar) - (toplam_borc + :borc_degisim_tekrar)
                WHERE id = :cari_id";

        $stmt = $db->prepare($sql);
        $params = [
            ":borc_degisim" => $borc_degisim,
            ":alacak_degisim" => $alacak_degisim,
            ":borc_degisim_tekrar" => $borc_degisim,
            ":alacak_degisim_tekrar" => $alacak_degisim,
            ":cari_id" => $cari_id
        ];
        return $stmt->execute($params);
    } catch (PDOException $e) {
        error_log("Cari Bakiye Güncelleme Hatası (Cari ID: {$cari_id}) - Hata: " . $e->getMessage());
        return false;
    }
}

function hesapHareketiEkle(PDO $db, int $hesap_id, int $sirket_id, string $tur, float $tutar, string $aciklama, ?string $tarih = null, ?int $cari_id = null, ?int $borc_id = null, ?string $para_birimi = 'TL', ?int $baglanti_id = null): bool {
    try {
        $sql = "INSERT INTO hesap_hareketleri (hesap_id, sirket_id, tur, tutar, aciklama, cari_id, borc_id, para_birimi, baglanti_id, tarih)
                VALUES (:hesap_id, :sirket_id, :tur, :tutar, :aciklama, :cari_id, :borc_id, :para_birimi, :baglanti_id, :tarih)";
        $stmt = $db->prepare($sql);
        $stmt->bindParam(":hesap_id", $hesap_id, PDO::PARAM_INT);
        $stmt->bindParam(":sirket_id", $sirket_id, PDO::PARAM_INT);
        $stmt->bindParam(":tur", $tur, PDO::PARAM_STR);
        $stmt->bindParam(":tutar", $tutar, PDO::PARAM_STR);
        $stmt->bindParam(":aciklama", $aciklama, PDO::PARAM_STR);
        $stmt->bindParam(':cari_id', $cari_id, $cari_id === null ? PDO::PARAM_NULL : PDO::PARAM_INT);
        $stmt->bindParam(':borc_id', $borc_id, $borc_id === null ? PDO::PARAM_NULL : PDO::PARAM_INT);
        $stmt->bindParam(':baglanti_id', $baglanti_id, $baglanti_id === null ? PDO::PARAM_NULL : PDO::PARAM_INT);
        $stmt->bindParam(':para_birimi', $para_birimi, PDO::PARAM_STR);
        $stmt->bindParam(":tarih", $tarih, PDO::PARAM_STR); // Yeni eklenen tarih parametresi
        return $stmt->execute();
    } catch (PDOException $e) {
        error_log("Hesap Hareketi Ekleme Hatası (Hesap ID: {$hesap_id}, Tutar: {$tutar}): " . $e->getMessage());
        return false;
    }
}
