<?php
// Bu dosya, cari ekleme modalını ve formunu içerir. Tüm sayfalarda include edilebilir.
// Gerekli değişkenler: $cari_gruplari, $csrf_token

// Cari grupları yüklenmemişse yükle
if (!isset($cari_gruplari) || empty($cari_gruplari)) {
    try {
        $aktif_sirket_id = $_SESSION['aktif_sirket_id'] ?? 0;
        $stmt_cari_gruplari = $db->prepare("SELECT * FROM cari_gruplari WHERE sirket_id = ? ORDER BY grup_adi");
        $stmt_cari_gruplari->execute([$aktif_sirket_id]);
        $cari_gruplari = $stmt_cari_gruplari->fetchAll(PDO::FETCH_ASSOC);
    } catch (PDOException $e) {
        error_log("Cari grupları yükleme hatası: " . $e->getMessage());
        $cari_gruplari = [];
    }
}

// CSRF token oluşturulmamışsa oluştur
if (!isset($csrf_token)) {
    $csrf_token = csrf_token_olustur();
}
?>
<div class="modal fade" id="yeniCariModal" tabindex="-1" aria-labelledby="yeniCariModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="yeniCariModalLabel">Yeni Cari Ekle</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="yeniCariForm">
                    <input type="hidden" name="csrf_token" value="<?= $csrf_token ?>">
                    <div class="mb-3">
                        <label for="yeni_ad_soyad" class="form-label">Ad Soyad / Firma Adı <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="yeni_ad_soyad" name="ad_soyad" required>
                    </div>
                    <div class="mb-3">
                        <label for="yeni_telefon" class="form-label">Telefon</label>
                        <input type="tel" class="form-control" id="yeni_telefon" name="telefon">
                    </div>
                    <div class="mb-3">
                        <label for="yeni_eposta" class="form-label">E-posta</label>
                        <input type="email" class="form-control" id="yeni_eposta" name="eposta">
                    </div>
                    <div class="mb-3">
                        <label for="yeni_grup_id" class="form-label">Cari Grubu <span class="text-danger">*</span></label>
                        <select class="form-select" id="yeni_grup_id" name="grup_id" required>
                            <option value="">-- Grup Seçin --</option>
                            <?php foreach($cari_gruplari as $grup): ?>
                                <option value="<?= $grup['id'] ?>"><?= temizle($grup['grup_adi']) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="yeni_adres" class="form-label">Adres</label>
                        <textarea class="form-control" id="yeni_adres" name="adres" rows="2"></textarea>
                    </div>
                </form>
                <div id="cariEkleMessage" class="alert d-none mt-3"></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                <button type="button" class="btn btn-primary" id="cariEkleBtn">Cari Ekle</button>
            </div>
        </div>
    </div>
</div> 