<?php

if (!function_exists('format_turkish_date')) {
    /**
     * DateTime nesnesini Türkçe ay ve gün isimleriyle formatlar.
     * @param DateTime $date Formatlanacak tarih.
     * @param string $format PHP date() fonksiyonu formatı.
     * @return string Türkçeleştirilmiş tarih.
     */
    function format_turkish_date(DateTime $date, string $format): string
    {
        $months = [
            'January'   => 'Ocak',
            'February'  => 'Şubat',
            'March'     => 'Mart',
            'April'     => 'Nisan',
            'May'       => 'Mayıs',
            'June'      => 'Haziran',
            'July'      => 'Temmuz',
            'August'    => 'Ağustos',
            'September' => 'Eylül',
            'October'   => 'Ekim',
            'November'  => 'Kasım',
            'December'  => 'Aralık',
        ];

        $days = [
            'Monday'    => 'Pazartesi',
            'Tuesday'   => 'Salı',
            'Wednesday' => 'Çarşamba',
            'Thursday'  => 'Perşembe',
            'Friday'    => 'Cuma',
            'Saturday'  => 'Cumartesi',
            'Sunday'    => 'Pazar',
        ];

        $formatted_date = $date->format($format);

        // Ay isimlerini değiştir
        $formatted_date = str_replace(array_keys($months), array_values($months), $formatted_date);

        // Gün isimlerini değiştir
        $formatted_date = str_replace(array_keys($days), array_values($days), $formatted_date);

        return $formatted_date;
    }
}
