<?php
// Bu dosya, config.php içinden, session_start() sonrası çağrılmalıdır.

// Güvenlik: Eğer config.php tarafından çağrılmazsa, çalışmayı durdur.
if (!defined('KURULUM_TAMAMLANDI')) {
    die("Doğrudan erişim engellendi.");
}

// Global scope'da veritabanı bağlantısını kullan
global $db;

// Değişkenleri başlangıçta null/boş olarak ayarlayalım.
$aktif_sirket_id = null;
$kullanici_sirketleri = [];
$aktif_sirket_adi = '';

// Kullanıcı giriş yapmış mı kontrol et
if (isset($_SESSION['kullanici_id'])) {

    $kullanici_id = $_SESSION['kullanici_id'];

    // 0. Oturum Güvenlik Kontrolleri
    // Oturum Sabitleme Koruması: Periyodik olarak oturum kimliğini yenile
    if (!isset($_SESSION['last_regenerate']) || time() - $_SESSION['last_regenerate'] > 300) { // Her 5 dakikada bir
        if (!headers_sent()) {
            session_regenerate_id(true);
            $_SESSION['last_regenerate'] = time();
        }
    }

    // Oturum Hırsızlığı Koruması: IP adresi ve User-Agent kontrolü
    if (!isset($_SESSION['HTTP_USER_AGENT'])) {
        $_SESSION['HTTP_USER_AGENT'] = $_SERVER['HTTP_USER_AGENT'] ?? '';
    }
    if ($_SESSION['HTTP_USER_AGENT'] !== ($_SERVER['HTTP_USER_AGENT'] ?? '')) {
        session_unset();
        session_destroy();
        // Session ayarlarını tekrar yap ve yeni oturum başlat
        if (session_status() === PHP_SESSION_NONE) {
            session_name("Odjoo_YONETIM_SID");
            session_set_cookie_params([
                "lifetime" => 86400,
                "path" => "/",
                "domain" => $_SERVER["HTTP_HOST"],
                "secure" => isset($_SERVER["HTTPS"]),
                "httponly" => true,
                "samesite" => "Strict"
            ]);
            session_start();
        }
        $_SESSION['hata'] = "Güvenlik uyarısı: Oturum bilginiz değişti. Lütfen tekrar giriş yapınız.";
        if (!headers_sent()) {
            header("Location: " . BASE_URL . "/views/login.php");
            exit;
        } else {
            echo '<script>window.location.href = "' . BASE_URL . '/views/login.php";</script>';
            exit;
        }
    }

    // Son aktivite zamanını kontrol et (Idle Timeout)
    $session_timeout = 1800; // 30 dakika (saniye cinsinden)
    if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity']) > $session_timeout) {
        session_unset();
        session_destroy();
        // Session ayarlarını tekrar yap ve yeni oturum başlat
        if (session_status() === PHP_SESSION_NONE) {
            session_name("Odjoo_YONETIM_SID");
            session_set_cookie_params([
                "lifetime" => 86400,
                "path" => "/",
                "domain" => $_SERVER["HTTP_HOST"],
                "secure" => isset($_SERVER["HTTPS"]),
                "httponly" => true,
                "samesite" => "Strict"
            ]);
            session_start();
        }
        $_SESSION['hata'] = "Oturum süreniz dolmuştur. Güvenlik nedeniyle tekrar giriş yapmanız gerekmektedir.";
        if (!headers_sent()) {
            header("Location: " . BASE_URL . "/views/login.php");
            exit;
        } else {
            echo '<script>window.location.href = "' . BASE_URL . '/views/login.php";</script>';
            exit;
        }
    }
    $_SESSION['last_activity'] = time(); // Her istekte aktiviteyi güncelle


    // 1. Kullanıcının şirket listesini al
    // Bu veri her istekte güncel kalır, böylece yetki değişiklikleri yansır.
    try {
        $stmt_sirket = $db->prepare("
            SELECT s.id, s.sirket_adi
            FROM kullanici_sirket_iliskisi k_s
            JOIN sirketler s ON k_s.sirket_id = s.id
            WHERE k_s.kullanici_id = ? AND s.aktif_mi = 1
            ORDER BY s.sirket_adi ASC
        ");
        $stmt_sirket->execute([$kullanici_id]);
        $kullanici_sirketleri = $stmt_sirket->fetchAll(PDO::FETCH_ASSOC);
        $_SESSION['kullanici_sirketleri'] = $kullanici_sirketleri;

    } catch (PDOException $e) {
        error_log("Kullanıcı şirketleri alınamadı: " . $e->getMessage());
        // Belki de kullanıcıyı çıkış yapmaya zorlamak daha iyi olur
        if (!headers_sent()) {
            header("Location: " . BASE_URL . "/views/cikis.php");
            exit;
        } else {
            echo '<script>window.location.href = "' . BASE_URL . '/views/cikis.php";</script>';
            exit;
        }
    }

    // 2. Aktif şirketi belirle
    if (empty($kullanici_sirketleri)) {
        // Kullanıcının yetkili olduğu aktif bir şirket yoksa.
        // Şirket oluşturma sayfasında olanları yönlendirme
        $mevcut_sayfa = basename($_SERVER['PHP_SELF']);
        $istisna_sayfalar = ['index.php', 'sirket_olustur.php', 'cikis.php'];
        
        if (!in_array($mevcut_sayfa, $istisna_sayfalar)) {
            if (!headers_sent()) {
                header("Location: " . BASE_URL . "/views/index.php");
                exit;
            } else {
                echo '<script>window.location.href = "' . BASE_URL . '/views/index.php";</script>';
                exit;
            }
        }
        
        // İstisnai sayfalarda şirket bilgilerini boş bırak
        $_SESSION['aktif_sirket_id'] = null;
        $_SESSION['aktif_sirket_adi'] = null;
        $_SESSION['kullanici_sirketleri'] = [];
        return; // Fonksiyonu sonlandır
    }

    // Aktif şirket ID'si session'da var mı? Ve hala geçerli mi?
    $aktif_sirket_id_gecerli = false;
    if (isset($_SESSION['aktif_sirket_id'])) {
        foreach ($kullanici_sirketleri as $sirket) {
            if ($sirket['id'] == $_SESSION['aktif_sirket_id']) {
                $aktif_sirket_id_gecerli = true;
                break;
            }
        }
    }

    // Eğer session'daki aktif şirket ID'si artık geçersizse veya hiç set edilmemişse,
    // kullanıcının ilk şirketini aktif şirket yap.
    if (!$aktif_sirket_id_gecerli) {
        $_SESSION['aktif_sirket_id'] = $kullanici_sirketleri[0]['id'];
        $_SESSION['aktif_sirket_adi'] = $kullanici_sirketleri[0]['sirket_adi'];
    }

    // 3. Global değişkenleri ayarla (kolay erişim için)
    // Bu değişkenler artık tüm sayfalarda mevcut olacak.
    $aktif_sirket_id = $_SESSION['aktif_sirket_id'];
    $aktif_sirket_adi = $_SESSION['aktif_sirket_adi'];
    // $kullanici_sirketleri zaten bu script içinde tanımlı ve navbar'da kullanılabilir.
    
    // 4. Initialize language system
    // Dil sistemini başlat
    initLanguageSystem();
} 