<?php if (isset($_SESSION['kullanici_id'])): ?>
<div class="sidebar text-white" style="width: 250px; min-height: 100vh; position: fixed; left: 0; top: 0; padding-top: 56px; z-index: 1000; overflow-y: auto; background-color: rgb(52 73 94);">
    <div class="p-3">
        <!-- Kullanıcı Bilgileri -->
        <div class="d-flex align-items-center mb-4 pb-2 border-bottom">
            <i class="bi bi-person-circle fs-4 me-2"></i>
            <div>
                <div class="fw-bold"><?= htmlspecialchars($_SESSION['ad_soyad'] ?? '') ?></div>
                <small class="text-muted"><?= ucfirst($_SESSION['yetki_seviyesi'] ?? '') ?></small>
            </div>
        </div>
        
        <ul class="nav nav-pills flex-column">
            <!-- Ana Menü -->
            <li class="nav-item">
                <a href="index.php" class="nav-link text-white <?= basename($_SERVER['PHP_SELF']) == 'index.php' ? 'active' : '' ?>">
                    <i class="bi bi-speedometer2 me-2"></i> <?= __("dashboard") ?>
                </a>
            </li>

            <!-- İşlemler -->
            <?php if (isset($filtered_menu['islemler']) && !empty($filtered_menu['islemler'])): ?>
            <li class="nav-item">
                <a href="#islemlerSubmenu" data-bs-toggle="collapse" class="nav-link text-white">
                    <i class="bi bi-receipt-cutoff me-2"></i> <?= __('operations') ?>
                    <i class="bi bi-chevron-down ms-auto"></i>
                </a>
                <ul class="nav flex-column ms-4 collapse" id="islemlerSubmenu">
                    <?php foreach ($filtered_menu['islemler'] as $page => $title): ?>
                        <?php if ($stok_islemleri_aktif == '1' || !in_array($page, ['satis_yeni','alis_yeni'])): ?>
                        <li class="nav-item">
                            <a href="<?= $page ?>.php" class="nav-link text-white <?= basename($_SERVER['PHP_SELF']) == $page . ".php" ? "active" : "" ?>">
                                <i class="bi bi-<?= $page == 'satis_yeni' ? 'cart-plus' : ($page == 'alis_yeni' ? 'bag-plus' : ($page == 'cari_alacaklandir' ? 'arrow-up-circle' : ($page == 'cari_borclandir' ? 'arrow-down-circle' : ($page == 'transfer_ekle' ? 'arrow-left-right' : 'cash')))) ?> me-2"></i>
                                <?= $title ?>
                            </a>
                        </li>
                        <?php endif; ?>
                    <?php endforeach; ?>
                    <li class="nav-item">
                        <a href="kasa_gider.php" class="nav-link text-white <?= basename($_SERVER["PHP_SELF"]) == "kasa_gider.php" ? "active" : "" ?>">
                            <i class="bi bi-cash-stack me-2"></i> <?= __('cash_receipt') ?>
                        </a>
                    </li>
                </ul>
            </li>
            <?php endif; ?>

            <!-- Faturalar -->
            <?php if ($stok_islemleri_aktif == '1' && isset($filtered_menu['faturalar']) && !empty($filtered_menu['faturalar'])): ?>
            <li class="nav-item">
                <a href="#faturalarSubmenu" data-bs-toggle="collapse" class="nav-link text-white">
                    <i class="bi bi-file-earmark-text me-2"></i> <?= __('invoices') ?>
                    <i class="bi bi-chevron-down ms-auto"></i>
                </a>
                <ul class="nav flex-column ms-4 collapse" id="faturalarSubmenu">
                    <?php foreach ($filtered_menu['faturalar'] as $page => $title): ?>
                        <li class="nav-item">
                            <a href="<?= $page ?>.php" class="nav-link text-white <?= basename($_SERVER['PHP_SELF']) == $page . ".php" ? "active" : "" ?>">
                                <i class="bi bi-<?= $page == 'satis_faturalari' ? 'receipt' : 'file-earmark-plus' ?> me-2"></i>
                                <?= $title ?>
                            </a>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </li>
            <?php endif; ?>

            <!-- Teklifler -->
            <?php if ($teklifler_modulu_aktif == '1' && isset($filtered_menu['teklifler'])): ?>
            <li class="nav-item">
                <a href="#tekliflerSubmenu" data-bs-toggle="collapse" class="nav-link text-white">
                    <i class="bi bi-file-earmark-text me-2"></i> <?= __('offers') ?>
                    <i class="bi bi-chevron-down ms-auto"></i>
                </a>
                <ul class="nav flex-column ms-4 collapse" id="tekliflerSubmenu">
                    <li class="nav-item">
                        <a href="teklifler.php" class="nav-link text-white <?= basename($_SERVER["PHP_SELF"]) == "teklifler.php" ? "active" : "" ?>">
                            <i class="bi bi-list-ul me-2"></i><?= __('offer_list') ?>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="teklif_yeni.php" class="nav-link text-white <?= basename($_SERVER["PHP_SELF"]) == "teklif_yeni.php" ? "active" : "" ?>">
                            <i class="bi bi-file-earmark-plus me-2"></i><?= __('new_offer') ?>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="teklifstoksuz.php" class="nav-link text-white <?= basename($_SERVER["PHP_SELF"]) == "teklifstoksuz.php" ? "active" : "" ?>">
                            <i class="bi bi-file-earmark-text-fill me-2"></i><?= __('offer_without_stock') ?>
                        </a>
                    </li>
                </ul>
            </li>
            <?php endif; ?>

            <!-- Stok Yönetimi -->
            <?php if ($stok_islemleri_aktif == '1' && isset($filtered_menu['stok']) && !empty($filtered_menu['stok'])): ?>
            <li class="nav-item">
                <a href="#stokSubmenu" data-bs-toggle="collapse" class="nav-link text-white">
                    <i class="bi bi-box-seam me-2"></i> <?= __('inventory') ?>
                    <i class="bi bi-chevron-down ms-auto"></i>
                </a>
                <ul class="nav flex-column ms-4 collapse" id="stokSubmenu">
                    <?php foreach ($filtered_menu['stok'] as $page => $title): ?>
                        <li class="nav-item">
                            <a href="<?= $page ?>.php" class="nav-link text-white <?= basename($_SERVER['PHP_SELF']) == $page . ".php" ? "active" : "" ?>">
                                <i class="bi bi-<?= $page == 'urun_ekle' ? 'plus-circle' : ($page == 'urunler' ? 'list-ul' : ($page == 'stok_hareketleri' ? 'clock-history' : ($page == 'en_cok_satan_urunler' ? 'trophy' : 'graph-up'))) ?> me-2"></i>
                                <?= $title ?>
                            </a>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </li>
            <?php endif; ?>

            <!-- Cariler -->
            <?php if (isset($filtered_menu['cariler'])): ?>
            <li class="nav-item">
                <a href="cariler.php" class="nav-link text-white <?= basename($_SERVER['PHP_SELF']) == 'cariler.php' ? 'active' : '' ?>">
                    <i class="bi bi-people me-2"></i> <?= __('customers') ?>
                </a>
            </li>
            <?php endif; ?>

            <!-- Raporlar -->
            <?php if (isset($filtered_menu['raporlar']) && !empty($filtered_menu['raporlar'])): ?>
            <li class="nav-item">
                <a href="#raporlarSubmenu" data-bs-toggle="collapse" class="nav-link text-white">
                    <i class="bi bi-clipboard-data me-2"></i> <?= __('reports') ?>
                    <i class="bi bi-chevron-down ms-auto"></i>
                </a>
                <ul class="nav flex-column ms-4 collapse" id="raporlarSubmenu">
                    <?php foreach ($filtered_menu['raporlar'] as $page => $title): ?>
                        <li class="nav-item">
                            <a href="<?= $page ?>.php" class="nav-link text-white <?= basename($_SERVER['PHP_SELF']) == $page . ".php" ? "active" : "" ?>">
                                <i class="bi bi-<?= $page == 'hesap_hareketleri' ? 'list-ol' : ($page == 'cari_ekstre' ? 'person-lines-fill' : 'pie-chart') ?> me-2"></i>
                                <?= $title ?>
                            </a>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </li>
            <?php endif; ?>

            <!-- Yönetim -->
            <li class="nav-item">
                <a href="#yonetimSubmenu" data-bs-toggle="collapse" class="nav-link text-white">
                    <i class="bi bi-gear me-2"></i> <?= __('management') ?>
                    <i class="bi bi-chevron-down ms-auto"></i>
                </a>
                <ul class="nav flex-column ms-4 collapse" id="yonetimSubmenu">
                    <?php if (in_array($_SESSION['yetki_seviyesi'] ?? '', ['admin', 'yonetici'])): ?>
                        <li class="nav-item">
                            <a href="kullanicilar.php" class="nav-link text-white <?= in_array(basename($_SERVER['PHP_SELF']), ['kullanicilar.php', 'kullanici_ekle.php', 'kullanici_duzenle.php']) ? 'active' : '' ?>">
                                <i class="bi bi-people me-2"></i> <?= __("user_management") ?>
                            </a>
                        </li>
                    <?php endif; ?>
                    
                    <?php foreach ($filtered_menu['yonetim'] as $page => $title): ?>
                        <?php if (in_array($page, ['kategoriler', 'hesaplar', 'ayarlar', 'firma_yonetimi', 'yetki_seviyeleri', 'firma_bilgileri', 'guvenlik'])): ?>
                            <li class="nav-item">
                                <a href="<?= BASE_URL ?>/views/ayarlar.php?section=<?= $page ?>" class="nav-link text-white <?= basename($_SERVER['PHP_SELF']) == 'ayarlar.php' && ($_GET['section'] ?? '') == $page ? 'active' : '' ?>">
                                    <i class="bi bi-<?= $page == 'kategoriler' ? 'tags' : ($page == 'hesaplar' ? 'wallet2' : 'gear') ?> me-2"></i>
                                    <?= $title ?>
                                </a>
                            </li>
                        <?php else: ?>
                            <li class="nav-item">
                                <a href="<?= $page ?>.php" class="nav-link text-white <?= basename($_SERVER['PHP_SELF']) == $page . '.php' ? 'active' : '' ?>">
                                    <i class="bi bi-<?= $page == 'kullanicilar' ? 'people-fill' : ($page == 'loglar' ? 'journal-text' : 'shield-check') ?> me-2"></i>
                                    <?= $title ?>
                                </a>
                            </li>
                        <?php endif; ?>
                    <?php endforeach; ?>

                    <?php if ($coklu_para_birimi_aktif == '1'): ?>
                        <li class="nav-item">
                            <a href="#" class="nav-link text-white" data-bs-toggle="modal" data-bs-target="#dovizModal">
                                <i class="bi bi-currency-exchange me-2"></i> <?= __('exchange_rates') ?>
                            </a>
                        </li>
                    <?php endif; ?>
                    
                    <li class="nav-item">
                        <a href="toplu_islem.php" class="nav-link text-white <?= basename($_SERVER['PHP_SELF']) == 'toplu_islem.php' ? 'active' : '' ?>">
                            <i class="bi bi-collection me-2"></i> <?= __('batch_operations') ?>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="hatirlatici.php" class="nav-link text-white <?= basename($_SERVER['PHP_SELF']) == 'hatirlatici.php' ? 'active' : '' ?>">
                            <i class="bi bi-bell me-2"></i> <?= __('reminder') ?>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="yedek_islemi.php" class="nav-link text-white <?= basename($_SERVER['PHP_SELF']) == 'yedek_islemi.php' ? 'active' : '' ?>">
                            <i class="bi bi-download me-2"></i> <?= __('backup_operations') ?>
                        </a>
                    </li>
                </ul>
            </li>

            <!-- Şirket Seçimi -->
            <?php if (isset($_SESSION['kullanici_sirketleri']) && count($_SESSION['kullanici_sirketleri']) > 1): ?>
            <li class="nav-item mt-3 border-top pt-3">
                <div class="dropdown">
                    <a href="#" class="d-flex align-items-center text-white text-decoration-none dropdown-toggle" id="sirketSecimDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="bi bi-building me-2"></i>
                        <span class="text-truncate" style="max-width: 180px;"><?= temizle($_SESSION['aktif_sirket_adi']) ?></span>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-dark" aria-labelledby="sirketSecimDropdown">
                        <?php foreach ($_SESSION['kullanici_sirketleri'] as $sirket): ?>
                            <li>
                                <a class="dropdown-item <?= ($sirket['id'] == $_SESSION['aktif_sirket_id']) ? 'active' : '' ?>" 
                                   href="<?= BASE_URL ?>/views/sirket_degistir.php?id=<?= $sirket['id'] ?>">
                                    <?= temizle($sirket['sirket_adi']) ?>
                                </a>
                            </li>
                        <?php endforeach; ?>
                        <li><hr class="dropdown-divider"></li>
                        <li>
                            <a class="dropdown-item" href="<?= BASE_URL ?>/views/ayarlar.php?section=firma_yonetimi">
                                <i class="bi bi-pencil-square me-2"></i>Firmaları Yönet
                            </a>
                        </li>
                    </ul>
                </div>
            </li>
            <?php endif; ?>

            <!-- Çıkış -->
            <li class="nav-item mt-3 border-top pt-3">
                <a href="cikis.php" class="nav-link text-white">
                    <i class="bi bi-box-arrow-right me-2"></i> <?= __("logout") ?>
                </a>
            </li>
        </ul>
    </div>
</div>
<?php endif; ?>

<style>
.sidebar {
    transition: all 0.3s ease-in-out;
    box-shadow: 2px 0 10px rgba(0, 0, 0, 0.1);
    background-color: rgb(52 73 94);
}

.sidebar .nav-link {
    color: rgba(255, 255, 255, 0.8);
    border-radius: 0.25rem;
    margin-bottom: 0.1rem;
    padding: 0.5rem 1rem;
    display: flex;
    align-items: center;
    transition: all 0.2s;
    position: relative;
}

.sidebar .nav-link:hover {
    background-color: rgba(255, 255, 255, 0.1);
    color: white;
    padding-left: 1.25rem;
}

.sidebar .nav-link.active {
    background-color: #0d6efd;
    color: white;
    font-weight: 500;
}

.sidebar .nav-link i {
    width: 20px;
    text-align: center;
    margin-right: 10px;
}

.sidebar .nav-link .bi-chevron-down {
    transition: transform 0.3s;
    margin-left: auto;
    font-size: 0.8rem;
}

.sidebar .nav-link[aria-expanded="true"] .bi-chevron-down {
    transform: rotate(180deg);
}

.sidebar .nav-pills .nav-link {
    border-radius: 0.25rem;
}

.sidebar .dropdown-menu {
    background-color: rgba(0, 0, 0, 0.2);
    border: none;
    box-shadow: none;
    margin: 0;
    padding: 0;
}

.sidebar .dropdown-item {
    color: rgba(255, 255, 255, 0.8);
    padding: 0.5rem 1.5rem;
    border-radius: 0.25rem;
    margin: 0.1rem 0.5rem;
    font-size: 0.9rem;
}

.sidebar .dropdown-item:hover,
.sidebar .dropdown-item:focus {
    background-color: rgba(255, 255, 255, 0.1);
    color: white;
}

.sidebar .dropdown-item.active {
    background-color: #0d6efd;
    color: white;
}

/* Ana içerik alanı */
.main-content {
    transition: all 0.3s ease-in-out;
    min-height: 100vh;
}

/* Mobil görünüm */
@media (max-width: 991.98px) {
    .sidebar {
        margin-left: -250px;
    }
    
    .sidebar.show {
        margin-left: 0;
        box-shadow: 3px 0 15px rgba(0, 0, 0, 0.2);
    }
    
    .main-content {
        margin-left: 0;
    }
    
    .main-content.sidebar-collapsed {
        margin-left: 0;
    }
    
    /* Alt menüler için stil */
    .sidebar .nav-pills .nav-link[data-bs-toggle="collapse"]::after {
        content: '\f282';
        font-family: 'bootstrap-icons';
        position: absolute;
        right: 1rem;
        transition: transform 0.3s;
    }
    
    .sidebar .nav-pills .nav-link[data-bs-toggle="collapse"][aria-expanded="true"]::after {
        transform: rotate(180deg);
    }
}

/* Scrollbar stilleri */
.sidebar::-webkit-scrollbar {
    width: 6px;
}

.sidebar::-webkit-scrollbar-track {
    background: rgba(255, 255, 255, 0.1);
}

.sidebar::-webkit-scrollbar-thumb {
    background-color: rgba(255, 255, 255, 0.2);
    border-radius: 3px;
}

.sidebar::-webkit-scrollbar-thumb:hover {
    background-color: rgba(255, 255, 255, 0.3);
}
</style>
