<?php

/**
 * Yetkilendirme Kontrol Sistemi
 * Sayfa ve işlem bazlı yetki kontrolü
 */

/**
 * Sayfa erişim yetkisi kontrol et
 * @param string $sayfa_adi Sayfa adı
 * @param string $islem_tipi İşlem türü (goruntule, ekle, duzenle, sil)
 * @return bool Erişim yetkisi var mı?
 */
function sayfa_yetki_kontrol($sayfa_adi, $islem_tipi = 'goruntule') {
    // Giriş yapmamışsa erişim yok
    if (!isset($_SESSION['kullanici_id'])) {
        return false;
    }
    
    // Admin her şeye erişebilir
    if (isset($_SESSION['yetki_seviyesi']) && $_SESSION['yetki_seviyesi'] === 'admin') {
        return true;
    }
    
    // Kullanıcının yetkilerini al
    $kullanici_yetkiler = isset($_SESSION['yetkiler']) ? 
        json_decode($_SESSION['yetkiler'], true) : [];
    
    if (!$kullanici_yetkiler) {
        $kullanici_yetkiler = [];
    }
    
    // Sayfa bazlı yetki kontrolü
    $yetki_haritasi = [
        // Ana sayfa
        'index' => ['tum_kullanicilar' => true],
        
        // Stok yönetimi
        'urunler' => ['goruntule' => ['stok_goruntuleme', 'stok_yonetimi'], 'ekle' => ['stok_yonetimi'], 'duzenle' => ['stok_yonetimi'], 'sil' => ['stok_yonetimi']],
        'urun_ekle' => ['stok_yonetimi'],
        'urun_duzenle' => ['stok_yonetimi'],
        'urun_sil' => ['stok_yonetimi'],
        'stok_hareketleri' => ['stok_goruntuleme', 'stok_yonetimi'],
        'stok_raporlari' => ['stok_goruntuleme', 'stok_yonetimi', 'raporlar'],
        'en_cok_satan_urunler' => ['stok_goruntuleme', 'stok_yonetimi', 'raporlar'],
        
        // Satış işlemleri
        'satis' => ['satis_islemleri'],
        'satis_yeni' => ['satis_islemleri'],
        'satis_faturalari' => ['satis_islemleri', 'faturalar'],
        
        // Alış işlemleri
        'alis' => ['alis_islemleri'],
        'alis_yeni' => ['alis_islemleri'],
        'alis_faturalari' => ['alis_islemleri', 'faturalar'],

        // YENİ: Teklif İşlemleri
        'teklifler' => ['teklif_yonetimi'],
        'teklif_yeni' => ['teklif_yonetimi'],
        'teklif_goruntule' => ['teklif_yonetimi'],
        'teklif_donustur' => ['teklif_yonetimi', 'satis_islemleri'],
        
        // Cari yönetimi
        'cariler' => ['goruntule' => ['cari_goruntuleme', 'cari_yonetimi'], 'ekle' => ['cari_yonetimi'], 'duzenle' => ['cari_yonetimi'], 'sil' => ['cari_yonetimi']],
        'cari_detay' => ['cari_goruntuleme', 'cari_yonetimi'],
        'cari_duzenle' => ['cari_yonetimi'],
        'cari_sil' => ['cari_yonetimi'],
        'cari_ekstre' => ['cari_goruntuleme', 'cari_yonetimi', 'raporlar'],
        
        // Hesap yönetimi
        'hesaplar' => ['goruntule' => ['hesap_yonetimi', 'genel_ayarlar'], 'ekle' => ['hesap_yonetimi', 'genel_ayarlar'], 'duzenle' => ['hesap_yonetimi', 'genel_ayarlar'], 'sil' => ['hesap_yonetimi', 'genel_ayarlar']],
        'hesap_hareketleri' => ['hesap_yonetimi', 'raporlar'],
        'odeme_al' => ['hesap_yonetimi'],
        'odeme_yap' => ['hesap_yonetimi'],
        'transfer_ekle' => ['hesap_yonetimi'],
        
        // Kategoriler
        'kategoriler' => ['goruntule' => ['stok_yonetimi', 'genel_ayarlar'], 'ekle' => ['stok_yonetimi', 'genel_ayarlar'], 'duzenle' => ['stok_yonetimi', 'genel_ayarlar'], 'sil' => ['stok_yonetimi', 'genel_ayarlar']],
        
        // Faturalar
        'fatura_goruntule' => ['faturalar'],
        'fatura_pdf' => ['faturalar'],
        'fatura_duzenle' => ['faturalar'], // Yeni eklenen yetki
        'fatura_sil' => ['faturalar'], // Yeni eklenen yetki
        
        // Raporlar
        'raporlar' => ['raporlar'],
        'kasa_gider_makbuzlari' => ['goruntule' => ['hesap_yonetimi', 'raporlar'], 'ekle' => ['hesap_yonetimi'], 'duzenle' => ['hesap_yonetimi'], 'sil' => ['hesap_yonetimi']],
        
        // Araçlar
        'arama' => ['tum_kullanicilar' => true],
        'toplu_islem' => ['stok_yonetimi', 'cari_yonetimi'],
        'hatirlatici' => ['tum_kullanicilar' => true],
        'yedek_islemi' => ['admin_yetkiler'],
        
        // Kullanıcı yönetimi
        'kullanicilar' => ['kullanici_yonetimi'],
        'kullanici_ekle' => ['kullanici_yonetimi'],
        'kullanici_duzenle' => ['kullanici_yonetimi'],
        'kullanici_sil' => ['kullanici_yonetimi'],
        
        // Log kayıtları
        'loglar' => ['log_goruntuleme'],
        
        // Ayarlar
        'ayarlar' => ['genel_ayarlar'],
        'guvenlik_kontrol' => ['admin_yetkiler'],
        
        // Profil
        'profil' => ['tum_kullanicilar' => true]
    ];
    
    if (!isset($yetki_haritasi[$sayfa_adi])) {
        return false;
    }
    
    $sayfa_yetkileri = $yetki_haritasi[$sayfa_adi];
    
    if (isset($sayfa_yetkileri['tum_kullanicilar']) && $sayfa_yetkileri['tum_kullanicilar']) {
        return true;
    }
    
    if (is_array($sayfa_yetkileri) && isset($sayfa_yetkileri[$islem_tipi])) {
        $gerekli_yetkiler = $sayfa_yetkileri[$islem_tipi];
    } else {
        $gerekli_yetkiler = $sayfa_yetkileri;
    }
    
    if (is_array($gerekli_yetkiler)) {
        foreach ($gerekli_yetkiler as $yetki) {
            // Bu satırda bir hata vardı, düzeltildi.
            if (isset($kullanici_yetkiler[$yetki]) && $kullanici_yetkiler[$yetki]) {
                 return true;
            }
            if ($yetki === 'admin_yetkiler' && isset($_SESSION['yetki_seviyesi']) && $_SESSION['yetki_seviyesi'] === 'admin') {
                return true;
            }
        }
    }
    
    return false;
}

/**
 * Yetki kontrolü ile sayfa erişimini kontrol et ve gerekirse yönlendir
 * @param string $sayfa_adi Sayfa adı
 * @param string $islem_tipi İşlem türü
 * @param string $yonlendirme_url Erişim yoksa yönlendirilecek URL
 */
function yetki_kontrol_ve_yonlendir($sayfa_adi, $islem_tipi = 'goruntule', $yonlendirme_url = 'index.php') {
    if (!sayfa_yetki_kontrol($sayfa_adi, $islem_tipi)) {
        $_SESSION['hata'] = "Bu sayfaya erişim yetkiniz bulunmamaktadır.";
        header("Location: $yonlendirme_url");
        exit();
    }
}

/**
 * Kullanıcı oturum bilgilerini güncelle (yetki değişikliklerinde)
 * @param PDO $db Veritabanı bağlantısı
 * @param int $kullanici_id Kullanıcı ID'si
 */
function kullanici_oturum_guncelle($db, $kullanici_id) {
    try {
        $stmt = $db->prepare("SELECT yetki_seviyesi, yetkiler FROM kullanicilar WHERE id = ? AND aktif = 1");
        $stmt->execute([$kullanici_id]);
        $kullanici = $stmt->fetch();
        
        if ($kullanici && isset($_SESSION['kullanici_id']) && $_SESSION['kullanici_id'] == $kullanici_id) {
            $_SESSION['yetki_seviyesi'] = $kullanici['yetki_seviyesi'];
            $_SESSION['yetkiler'] = $kullanici['yetkiler'];
        }
        
    } catch (Exception $e) {
        error_log("Kullanıcı oturum güncelleme hatası: " . $e->getMessage());
    }
}
