-- phpMyAdmin SQL Dump
-- version 5.2.0
-- https://www.phpmyadmin.net/
--
-- Anamakine: 127.0.0.1
-- Üretim Zamanı: 24 Eki 2025, 18:08:47
-- Sunucu sürümü: 10.4.24-MariaDB
-- PHP Sürümü: 8.0.19

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Veritabanı: `fejox`
--

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `aktif_oturumlar`
--

CREATE TABLE `aktif_oturumlar` (
  `id` int(11) NOT NULL,
  `kullanici_id` int(11) NOT NULL,
  `session_id` varchar(128) NOT NULL,
  `ip_adresi` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `son_aktivite` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `olusturulma_tarihi` timestamp NOT NULL DEFAULT current_timestamp(),
  `sirket_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `ayarlar`
--

CREATE TABLE `ayarlar` (
  `ayar_adi` varchar(100) COLLATE utf8mb4_turkish_ci NOT NULL,
  `ayar_degeri` text COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `aciklama` varchar(255) COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `stok_resim_yukleme_aktif` tinyint(1) NOT NULL DEFAULT 0,
  `stok_resim_yukleme_dizin` varchar(255) COLLATE utf8mb4_turkish_ci DEFAULT 'uploads/urun_resimleri',
  `sirket_id` int(11) DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `borclar`
--

CREATE TABLE `borclar` (
  `sirket_id` int(11) NOT NULL,
  `id` int(11) NOT NULL,
  `cari_id` int(11) NOT NULL,
  `tur` enum('satis','alis') COLLATE utf8mb4_turkish_ci NOT NULL COMMENT 'Bu kayıt bir Satış mı yoksa Alış mı?',
  `kategori_id` int(11) DEFAULT NULL,
  `tutar` decimal(15,2) NOT NULL COMMENT 'İşlem tutarı',
  `aciklama` text COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `tarih` date NOT NULL COMMENT 'İşlem tarihi',
  `vade_tarihi` date DEFAULT NULL COMMENT 'Ödeme vadesi (varsa)',
  `odeme_durumu` varchar(20) COLLATE utf8mb4_turkish_ci NOT NULL DEFAULT 'odenmedi',
  `odenen_tutar` decimal(15,2) NOT NULL DEFAULT 0.00 COMMENT 'Bu işleme karşılık yapılan ödeme/tahsilat toplamı',
  `durum` enum('odenmedi','kismen_odendi','odendi') COLLATE utf8mb4_turkish_ci NOT NULL DEFAULT 'odenmedi',
  `olusturulma_tarihi` datetime NOT NULL DEFAULT current_timestamp(),
  `stoklu_islem` tinyint(1) DEFAULT 0,
  `para_birimi` varchar(10) COLLATE utf8mb4_turkish_ci DEFAULT 'TRY',
  `toplam_kdv` decimal(15,2) DEFAULT 0.00,
  `indirim_tutari` decimal(10,2) NOT NULL DEFAULT 0.00,
  `tax_snapshot` LONGTEXT COLLATE utf8mb4_turkish_ci DEFAULT NULL COMMENT 'KDV hesaplama audit trail (JSON)'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci COMMENT='Satış ve Alış işlemleri (fatura benzeri kayıtlar)';

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `cariler`
--

CREATE TABLE `cariler` (
  `sirket_id` int(11) NOT NULL,
  `id` int(11) NOT NULL,
  `ad_soyad` varchar(150) COLLATE utf8mb4_turkish_ci NOT NULL,
  `telefon` varchar(20) COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `adres` text COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `eposta` text COLLATE utf8mb4_turkish_ci NOT NULL,
  `grup_id` int(11) DEFAULT NULL,
  `toplam_borc` decimal(15,2) NOT NULL DEFAULT 0.00 COMMENT 'Müşterinin bize olan toplam borcu',
  `toplam_alacak` decimal(15,2) NOT NULL DEFAULT 0.00 COMMENT 'Bizim tedarikçiye olan toplam borcumuz',
  `bakiye` decimal(15,2) NOT NULL DEFAULT 0.00 COMMENT 'Hesaplanan Bakiye (toplam_alacak - toplam_borc)',
  `aktif` tinyint(1) NOT NULL DEFAULT 1,
  `olusturulma_tarihi` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci COMMENT='Müşteriler, Tedarikçiler ve diğer bağlantılar';

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `cari_gruplari`
--

CREATE TABLE `cari_gruplari` (
  `sirket_id` int(11) NOT NULL,
  `id` int(11) NOT NULL,
  `grup_adi` varchar(50) COLLATE utf8mb4_turkish_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci COMMENT='Carileri gruplamak için (Müşteri, Tedarikçi vb.)';

--
-- Tablo döküm verisi `cari_gruplari`
--

INSERT INTO `cari_gruplari` (`sirket_id`, `id`, `grup_adi`) VALUES
(1, 1, 'Müşteri'),
(1, 2, 'Tedarikçi'),
(1, 3, 'Diğer');

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `doviz_kurlari`
--

CREATE TABLE `doviz_kurlari` (
  `id` int(11) NOT NULL,
  `para_birimi` varchar(3) NOT NULL,
  `alis` decimal(10,4) NOT NULL,
  `satis` decimal(10,4) NOT NULL,
  `guncelleme_tarihi` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Tablo döküm verisi `doviz_kurlari`
--

INSERT INTO `doviz_kurlari` (`id`, `para_birimi`, `alis`, `satis`, `guncelleme_tarihi`) VALUES
(1, 'USD', '41.8966', '41.9721', '2025-10-22 19:09:08'),
(2, 'EUR', '48.5808', '48.6683', '2025-10-22 19:09:08'),
(3, 'GBP', '55.7242', '56.0147', '2025-10-22 19:09:08'),
(4, 'CHF', '52.5012', '52.8383', '2025-10-22 19:09:08'),
(5, 'JPY', '27.5372', '27.7195', '2025-10-22 19:09:08'),
(6, 'RUB', '0.5100', '0.5167', '2025-10-22 19:09:08'),
(614, 'AUD', '27.1489', '27.3259', '2025-10-22 19:09:08'),
(615, 'DKK', '6.4939', '6.5258', '2025-10-22 19:09:08'),
(619, 'SEK', '4.4225', '4.4683', '2025-10-22 19:09:08'),
(620, 'CAD', '29.8588', '29.9935', '2025-10-22 19:09:08'),
(621, 'KWD', '135.8956', '137.6738', '2025-10-22 19:09:08'),
(622, 'NOK', '4.1630', '4.1910', '2025-10-22 19:09:08'),
(623, 'SAR', '11.1712', '11.1914', '2025-10-22 19:09:08'),
(625, 'BGN', '24.7000', '25.0232', '2025-10-22 19:09:08'),
(626, 'RON', '9.5044', '9.6288', '2025-10-22 19:09:08'),
(628, 'CNY', '5.8477', '5.9243', '2025-10-22 19:09:08'),
(629, 'PKR', '0.1471', '0.1490', '2025-10-22 19:09:08'),
(630, 'QAR', '11.4299', '11.5794', '2025-10-22 19:09:08'),
(631, 'KRW', '0.0291', '0.0295', '2025-10-22 19:09:08'),
(632, 'AZN', '24.5069', '24.8276', '2025-10-22 19:09:08'),
(633, 'AED', '11.3427', '11.4911', '2025-10-22 19:09:08'),
(655, 'TRY', '1.0000', '1.0000', '2025-08-23 02:11:43');

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `fatura_detaylari`
--

CREATE TABLE `fatura_detaylari` (
  `id` int(11) NOT NULL,
  `borc_id` int(11) NOT NULL COMMENT 'Ana fatura kaydı',
  `urun_id` int(11) NOT NULL,
  `miktar` decimal(10,2) NOT NULL,
  `birim_fiyat` decimal(10,2) NOT NULL,
  `toplam_tutar` decimal(15,2) NOT NULL,
  `kdv_orani` decimal(5,2) DEFAULT 18.00,
  `kdv_tutari` decimal(15,2) DEFAULT 0.00,
  `sirket_id` int(11) NOT NULL,
  `para_birimi` varchar(10) COLLATE utf8mb4_turkish_ci DEFAULT 'TRY',
  `kur` decimal(10,4) DEFAULT 1.0000,
  `cari_id` int(11) DEFAULT NULL,
  `islem_turu` enum('alis','satis') COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `alis_para_birimi` varchar(10) COLLATE utf8mb4_turkish_ci DEFAULT 'TRY'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci COMMENT='Fatura satır detayları (stoklu işlemler için)';

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `hatirlaticilar`
--

CREATE TABLE `hatirlaticilar` (
  `id` int(11) NOT NULL,
  `sirket_id` int(11) NOT NULL,
  `baslik` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `aciklama` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hatirlatma_tarihi` date NOT NULL,
  `oncelik` enum('dusuk','normal','yuksek') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'normal',
  `cari_id` int(11) DEFAULT NULL,
  `borc_id` int(11) DEFAULT NULL,
  `kullanici_id` int(11) NOT NULL,
  `olusturma_tarihi` datetime NOT NULL,
  `guncelleme_tarihi` datetime DEFAULT NULL,
  `durum` enum('aktif','tamamlandi') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'aktif'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `hesaplar`
--

CREATE TABLE `hesaplar` (
  `sirket_id` int(11) NOT NULL,
  `id` int(11) NOT NULL,
  `hesap_adi` varchar(100) COLLATE utf8mb4_turkish_ci NOT NULL,
  `hesap_turu` enum('banka','kasa','kredi_karti') COLLATE utf8mb4_turkish_ci NOT NULL,
  `bakiye` decimal(15,2) NOT NULL DEFAULT 0.00 COMMENT 'Hesabın güncel bakiyesi',
  `baslangic_bakiye` decimal(15,2) NOT NULL DEFAULT 0.00,
  `aciklama` text COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `para_birimi` varchar(3) COLLATE utf8mb4_turkish_ci NOT NULL DEFAULT 'TRY',
  `aktif` tinyint(1) NOT NULL DEFAULT 1,
  `olusturulma_tarihi` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci COMMENT='Kasa, Banka, Kredi Kartı gibi para hesapları';

--
-- Tablo döküm verisi `hesaplar`
--

INSERT INTO `hesaplar` (`sirket_id`, `id`, `hesap_adi`, `hesap_turu`, `bakiye`, `baslangic_bakiye`, `aciklama`, `para_birimi`, `aktif`, `olusturulma_tarihi`) VALUES
(1, 1, 'Merkez Kasa', 'kasa', '0.00', '0.00', NULL, 'TRY', 1, '2025-08-11 01:48:38'),
(1, 2, 'Çek Hesabı', 'kasa', '0.00', '0.00', NULL, 'TRY', 1, '2025-08-12 08:45:06'),
(1, 3, 'Euro Kasası', 'banka', '0.00', '0.00', NULL, 'EUR', 1, '2025-08-15 20:57:24'),
(1, 4, 'USD Hesabı', 'kasa', '0.00', '0.00', NULL, 'USD', 1, '2025-10-19 23:46:26');

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `hesap_hareketleri`
--

CREATE TABLE `hesap_hareketleri` (
  `sirket_id` int(11) NOT NULL,
  `id` int(11) NOT NULL,
  `hesap_id` int(11) NOT NULL COMMENT 'Hangi hesabı etkilediği',
  `cari_id` int(11) DEFAULT NULL COMMENT 'Hangi cari ile ilgili (varsa)',
  `borc_id` int(11) DEFAULT NULL COMMENT 'Hangi satış/alış işlemi ile ilgili (varsa)',
  `tur` enum('giris','cikis','transfer') COLLATE utf8mb4_turkish_ci NOT NULL COMMENT 'Hesaba para girişi mi, çıkışı mı?',
  `tutar` decimal(15,2) NOT NULL COMMENT 'Hareket tutarı (Her zaman pozitif)',
  `aciklama` text COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `tarih` datetime NOT NULL DEFAULT current_timestamp() COMMENT 'Hareketin gerçekleştiği tarih/saat',
  `guncelleme_tarihi` datetime DEFAULT NULL,
  `baglanti_id` int(11) DEFAULT NULL COMMENT 'Transfer ise diğer hesap hareketi IDsi',
  `fatura_id` int(11) DEFAULT NULL,
  `musteri_id` int(11) DEFAULT NULL,
  `para_birimi` varchar(3) COLLATE utf8mb4_turkish_ci NOT NULL DEFAULT 'TRY'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci COMMENT='Tüm para giriş/çıkış ve transferlerinin kaydı';

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `kategoriler`
--

CREATE TABLE `kategoriler` (
  `sirket_id` int(11) NOT NULL,
  `id` int(11) NOT NULL,
  `kategori_adi` varchar(100) COLLATE utf8mb4_turkish_ci NOT NULL,
  `tip` enum('urun','islem') COLLATE utf8mb4_turkish_ci NOT NULL DEFAULT 'islem'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci COMMENT='Satış/Alış işlemlerini kategorize etmek için';

--
-- Tablo döküm verisi `kategoriler`
--

INSERT INTO `kategoriler` (`sirket_id`, `id`, `kategori_adi`, `tip`) VALUES
(1, 1, 'Genel Ürün Satışı', 'islem'),
(1, 2, 'Hizmet Satışı', 'islem'),
(1, 3, 'Mal Alışı', 'islem'),
(1, 4, 'Ofis Gideri', 'islem'),
(1, 5, 'Personel Gideri', 'islem'),
(1, 6, 'Satış', 'islem'),
(1, 7, 'Alış', 'islem'),
(1, 8, 'Kablo', 'urun'),
(1, 9, 'Kalem', 'urun'),
(1, 10, 'Silgi', 'urun');

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `kullanicilar`
--

CREATE TABLE `kullanicilar` (
  `id` int(11) NOT NULL,
  `kullanici_adi` varchar(50) COLLATE utf8mb4_turkish_ci NOT NULL,
  `sifre` varchar(255) COLLATE utf8mb4_turkish_ci NOT NULL,
  `ad_soyad` varchar(100) COLLATE utf8mb4_turkish_ci NOT NULL,
  `email` text COLLATE utf8mb4_turkish_ci NOT NULL,
  `son_giris` datetime DEFAULT NULL,
  `son_ip` varchar(45) COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `aktif` tinyint(1) NOT NULL DEFAULT 1,
  `yetki_seviyesi` enum('admin','yonetici','kullanici','misafir') COLLATE utf8mb4_turkish_ci NOT NULL DEFAULT 'kullanici',
  `yetkiler` text COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `olusturulma_tarihi` datetime NOT NULL DEFAULT current_timestamp(),
  `guncelleme_tarihi` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `olusturan_kullanici_id` int(11) DEFAULT NULL,
  `aciklama` text COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `ekran_kilidi_aktif` tinyint(1) NOT NULL DEFAULT 0,
  `ekran_kilidi_sifre` varchar(255) COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `ekran_kilidi_sure` int(11) NOT NULL DEFAULT 5,
  `dil` varchar(5) COLLATE utf8mb4_turkish_ci NOT NULL DEFAULT 'tr'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci COMMENT='Sisteme giriş yapacak kullanıcılar';

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `kullanici_sifre_gecmisi`
--

CREATE TABLE `kullanici_sifre_gecmisi` (
  `id` int(11) NOT NULL,
  `kullanici_id` int(11) NOT NULL,
  `sifre_hash` varchar(255) NOT NULL,
  `olusturulma_tarihi` timestamp NOT NULL DEFAULT current_timestamp(),
  `sirket_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `kullanici_sirket_iliskisi`
--

CREATE TABLE `kullanici_sirket_iliskisi` (
  `id` int(11) NOT NULL,
  `kullanici_id` int(11) NOT NULL,
  `sirket_id` int(11) NOT NULL,
  `rol` enum('admin','yonetici','kullanici') NOT NULL DEFAULT 'kullanici'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `mevcut_stok`
--

CREATE TABLE `mevcut_stok` (
  `id` int(11) NOT NULL,
  `urun_id` int(11) NOT NULL,
  `miktar` decimal(10,2) DEFAULT 0.00,
  `ortalama_maliyet` decimal(10,2) DEFAULT 0.00,
  `son_guncelleme` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `sirket_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci COMMENT='Güncel stok durumu ve ortalama maliyet';

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `oturum_loglari`
--

CREATE TABLE `oturum_loglari` (
  `id` int(11) NOT NULL,
  `kullanici_id` int(11) DEFAULT NULL,
  `islem_tipi` enum('giris','cikis','basarisiz_giris') NOT NULL,
  `ip_adresi` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `olusturulma_tarihi` timestamp NOT NULL DEFAULT current_timestamp(),
  `sirket_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `sifre_sifirlama`
--

CREATE TABLE `sifre_sifirlama` (
  `id` int(11) NOT NULL,
  `kullanici_id` int(11) NOT NULL,
  `token` varchar(64) NOT NULL,
  `gecerlilik_tarihi` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `kullanildi` tinyint(1) NOT NULL DEFAULT 0,
  `olusturulma_tarihi` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `silinen_kayitlar`
--

CREATE TABLE `silinen_kayitlar` (
  `id` int(11) NOT NULL,
  `log_id` int(11) NOT NULL,
  `tablo_adi` varchar(50) NOT NULL,
  `kayit_id` int(11) NOT NULL,
  `kayit_verisi` text NOT NULL,
  `silinme_tarihi` timestamp NOT NULL DEFAULT current_timestamp(),
  `geri_alindi` tinyint(1) DEFAULT 0,
  `geri_alma_tarihi` timestamp NULL DEFAULT NULL,
  `sirket_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `sirketler`
--

CREATE TABLE `sirketler` (
  `id` int(11) NOT NULL,
  `sirket_adi` varchar(255) DEFAULT NULL,
  `para_birimi` varchar(3) NOT NULL DEFAULT 'TRY',
  `logo_yolu` varchar(255) DEFAULT NULL,
  `aktif_mi` tinyint(1) NOT NULL DEFAULT 1,
  `olusturulma_tarihi` timestamp NOT NULL DEFAULT current_timestamp(),
  `adres` text DEFAULT NULL,
  `telefon` varchar(30) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `vergi_dairesi` varchar(100) DEFAULT NULL,
  `vergi_no` varchar(50) DEFAULT NULL,
  `web_sitesi` varchar(255) DEFAULT NULL,
  `teklifler_modulu_aktif` tinyint(1) NOT NULL DEFAULT 1,
  `stok_islemleri_aktif` tinyint(1) NOT NULL DEFAULT 0,
  `coklu_para_birimi` int(1) NOT NULL DEFAULT 0 COMMENT 'Çoklu para birimi özelliği aktif mi?'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `sistem_loglari`
--

CREATE TABLE `sistem_loglari` (
  `id` int(11) NOT NULL,
  `kullanici_id` int(11) DEFAULT NULL,
  `islem_tipi` varchar(50) NOT NULL,
  `tablo_adi` varchar(50) DEFAULT NULL,
  `kayit_id` int(11) DEFAULT NULL,
  `eski_deger` text DEFAULT NULL,
  `yeni_deger` text DEFAULT NULL,
  `aciklama` text DEFAULT NULL,
  `ip_adresi` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `olusturulma_tarihi` timestamp NOT NULL DEFAULT current_timestamp(),
  `geri_alindi` tinyint(1) DEFAULT NULL COMMENT 'NULL: Geri alma mümkün, 0: Geri alınmadı, 1: Geri alındı',
  `geri_alma_tarihi` timestamp NULL DEFAULT NULL,
  `sirket_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `stok_hareketleri`
--

CREATE TABLE `stok_hareketleri` (
  `id` int(11) NOT NULL,
  `urun_id` int(11) NOT NULL,
  `hareket_turu` enum('giris','cikis','sayim','transfer') COLLATE utf8mb4_turkish_ci NOT NULL,
  `miktar` decimal(10,2) NOT NULL,
  `birim_fiyat` decimal(10,2) DEFAULT NULL,
  `toplam_tutar` decimal(15,2) DEFAULT NULL,
  `aciklama` text COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `borc_id` int(11) DEFAULT NULL COMMENT 'Hangi satış/alış işlemi ile ilgili',
  `cari_id` int(11) DEFAULT NULL,
  `tarih` datetime DEFAULT current_timestamp(),
  `kullanici_id` int(11) DEFAULT NULL,
  `sirket_id` int(11) NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci COMMENT='Tüm stok giriş/çıkış hareketleri';

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `teklifler`
--

CREATE TABLE `teklifler` (
  `id` int(11) NOT NULL,
  `sirket_id` int(11) NOT NULL,
  `cari_id` int(11) NOT NULL,
  `teklif_tarihi` date NOT NULL,
  `gecerlilik_tarihi` date DEFAULT NULL,
  `para_birimi` varchar(5) NOT NULL,
  `tutar` decimal(10,2) NOT NULL DEFAULT 0.00,
  `toplam_kdv` decimal(10,2) NOT NULL DEFAULT 0.00,
  `indirim_tutari` decimal(10,2) NOT NULL DEFAULT 0.00,
  `durum` enum('Beklemede','Onaylandı','Reddedildi','Faturalastirildi') NOT NULL DEFAULT 'Beklemede',
  `aciklama` text DEFAULT NULL,
  `olusturulma_tarihi` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `teklif_detaylari`
--

CREATE TABLE `teklif_detaylari` (
  `id` int(11) NOT NULL,
  `teklif_id` int(11) NOT NULL,
  `urun_id` int(11) NOT NULL,
  `miktar` decimal(10,2) NOT NULL,
  `birim_fiyat` decimal(10,2) NOT NULL,
  `kdv_orani` decimal(5,2) NOT NULL,
  `kdv_tutari` decimal(10,2) NOT NULL,
  `toplam_tutar` decimal(10,2) NOT NULL,
  `sirket_id` int(11) NOT NULL,
  `para_birimi` varchar(3) DEFAULT 'TRY',
  `kur` decimal(10,4) DEFAULT 1.0000
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `urunler`
--

CREATE TABLE `urunler` (
  `id` int(11) NOT NULL,
  `sirket_id` int(11) NOT NULL,
  `urun_adi` varchar(150) COLLATE utf8mb4_turkish_ci NOT NULL,
  `barkod` varchar(50) COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `kategori_id` int(11) DEFAULT NULL,
  `birim` varchar(20) COLLATE utf8mb4_turkish_ci DEFAULT 'adet',
  `tedarikci_id` int(11) DEFAULT NULL,
  `alis_fiyati` decimal(10,2) DEFAULT 0.00,
  `alis_fiyati2` decimal(10,2) DEFAULT 0.00,
  `satis_fiyati` decimal(10,2) DEFAULT 0.00,
  `satis_fiyati2` decimal(10,2) DEFAULT 0.00,
  `kdv_orani` decimal(5,2) NOT NULL DEFAULT 0.00,
  `kdv_orani2` decimal(5,2) DEFAULT 0.00,
  `alis_para_birimi` varchar(4) COLLATE utf8mb4_turkish_ci NOT NULL DEFAULT 'USD',
  `satis_para_birimi` varchar(4) COLLATE utf8mb4_turkish_ci NOT NULL DEFAULT 'TRY',
  `kritik_stok` int(11) DEFAULT 0,
  `mevcut_stok_baslangic` varchar(21) COLLATE utf8mb4_turkish_ci NOT NULL,
  `aciklama` text COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `aktif` tinyint(1) DEFAULT 1,
  `olusturulma_tarihi` datetime DEFAULT current_timestamp(),
  `guncelleme_tarihi` text COLLATE utf8mb4_turkish_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci COMMENT='Ürün bilgileri ve fiyatları';

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `urun_resimleri`
--

CREATE TABLE `urun_resimleri` (
  `id` int(11) NOT NULL,
  `urun_id` int(11) NOT NULL,
  `resim_yolu` varchar(255) COLLATE utf8mb4_turkish_ci NOT NULL,
  `sira` int(11) DEFAULT 0,
  `olusturulma_tarihi` datetime DEFAULT current_timestamp(),
  `varsayilan` tinyint(1) NOT NULL DEFAULT 0,
  `sirket_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `yetki_gruplari`
--

CREATE TABLE `yetki_gruplari` (
  `id` int(11) NOT NULL,
  `grup_adi` varchar(100) NOT NULL,
  `aciklama` text DEFAULT NULL,
  `yetkiler` text NOT NULL,
  `aktif` tinyint(1) NOT NULL DEFAULT 1,
  `olusturulma_tarihi` timestamp NOT NULL DEFAULT current_timestamp(),
  `guncelleme_tarihi` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Tablo döküm verisi `yetki_gruplari`
--

INSERT INTO `yetki_gruplari` (`id`, `grup_adi`, `aciklama`, `yetkiler`, `aktif`, `olusturulma_tarihi`, `guncelleme_tarihi`) VALUES
(1, 'Admin', 'Tam yetki - Tüm işlemleri yapabilirff', '{\"teklif_yonetimi\":true,\"admin_yetkiler\":true}', 1, '2025-06-30 23:44:58', '2025-07-15 16:14:27'),
(2, 'Yönetici', 'Yönetim yetkileri - Kullanıcı yönetimi hariç tüm işlemler', '{\"stok_yonetimi\":true,\"satis_islemleri\":true,\"alis_islemleri\":true,\"cari_yonetimi\":true,\"hesap_yonetimi\":true,\"raporlar\":true,\"faturalar\":true}', 1, '2025-06-30 23:44:58', '2025-07-04 08:33:24'),
(3, 'Satış Personeli', 'Sadece satış işlemleri', '{\"satis_islemleri\": true, \"stok_goruntuleme\": true, \"cari_goruntuleme\": true, \"faturalar\": true}', 1, '2025-06-30 23:44:58', '2025-06-30 23:44:58'),
(4, 'Muhasebe', 'Muhasebe işlemleri', '{\"hesap_yonetimi\": true, \"raporlar\": true, \"faturalar\": true, \"cari_yonetimi\": true}', 1, '2025-06-30 23:44:58', '2025-06-30 23:44:58'),
(5, 'Misafir', 'Sadece görüntüleme', '{\"stok_goruntuleme\":true,\"raporlar\":true}', 1, '2025-06-30 23:44:58', '2025-07-08 10:27:22');

--
-- Dökümü yapılmış tablolar için indeksler
--

--
-- Tablo için indeksler `aktif_oturumlar`
--
ALTER TABLE `aktif_oturumlar`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `session_id` (`session_id`),
  ADD KEY `idx_kullanici_id` (`kullanici_id`),
  ADD KEY `idx_son_aktivite` (`son_aktivite`),
  ADD KEY `fk_aktif_oturumlar_sirket_id` (`sirket_id`);

--
-- Tablo için indeksler `ayarlar`
--
ALTER TABLE `ayarlar`
  ADD PRIMARY KEY (`ayar_adi`),
  ADD UNIQUE KEY `ayar_adi` (`ayar_adi`,`sirket_id`),
  ADD UNIQUE KEY `ayar_adi_2` (`ayar_adi`,`sirket_id`);

--
-- Tablo için indeksler `borclar`
--
ALTER TABLE `borclar`
  ADD PRIMARY KEY (`id`),
  ADD KEY `cari_id` (`cari_id`),
  ADD KEY `kategori_id` (`kategori_id`),
  ADD KEY `tur` (`tur`),
  ADD KEY `tarih` (`tarih`),
  ADD KEY `vade_tarihi` (`vade_tarihi`),
  ADD KEY `durum` (`durum`),
  ADD KEY `fk_borclar_sirket_id` (`sirket_id`);

--
-- Tablo için indeksler `cariler`
--
ALTER TABLE `cariler`
  ADD PRIMARY KEY (`id`),
  ADD KEY `grup_id` (`grup_id`),
  ADD KEY `fk_cariler_sirket_id` (`sirket_id`);

--
-- Tablo için indeksler `cari_gruplari`
--
ALTER TABLE `cari_gruplari`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `grup_adi_sirket_id_unique` (`grup_adi`,`sirket_id`),
  ADD KEY `fk_cari_gruplari_sirket` (`sirket_id`);

--
-- Tablo için indeksler `doviz_kurlari`
--
ALTER TABLE `doviz_kurlari`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `para_birimi` (`para_birimi`);

--
-- Tablo için indeksler `fatura_detaylari`
--
ALTER TABLE `fatura_detaylari`
  ADD PRIMARY KEY (`id`),
  ADD KEY `borc_id` (`borc_id`),
  ADD KEY `urun_id` (`urun_id`),
  ADD KEY `fk_fatura_detaylari_sirket_id` (`sirket_id`),
  ADD KEY `idx_para_birimi` (`para_birimi`),
  ADD KEY `idx_cari_id` (`cari_id`),
  ADD KEY `idx_islem_turu` (`islem_turu`);

--
-- Tablo için indeksler `hatirlaticilar`
--
ALTER TABLE `hatirlaticilar`
  ADD PRIMARY KEY (`id`),
  ADD KEY `cari_id` (`cari_id`),
  ADD KEY `borc_id` (`borc_id`),
  ADD KEY `fk_hatirlaticilar_sirket_id` (`sirket_id`);

--
-- Tablo için indeksler `hesaplar`
--
ALTER TABLE `hesaplar`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fk_hesaplar_sirket_id` (`sirket_id`);

--
-- Tablo için indeksler `hesap_hareketleri`
--
ALTER TABLE `hesap_hareketleri`
  ADD PRIMARY KEY (`id`),
  ADD KEY `hesap_id` (`hesap_id`),
  ADD KEY `cari_id` (`cari_id`),
  ADD KEY `borc_id` (`borc_id`),
  ADD KEY `tur` (`tur`),
  ADD KEY `tarih` (`tarih`),
  ADD KEY `fk_hesap_hareketleri_sirket_id` (`sirket_id`);

--
-- Tablo için indeksler `kategoriler`
--
ALTER TABLE `kategoriler`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `kategori_sirket_unique` (`kategori_adi`,`sirket_id`),
  ADD KEY `fk_kategoriler_sirket_id` (`sirket_id`);

--
-- Tablo için indeksler `kullanicilar`
--
ALTER TABLE `kullanicilar`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `kullanici_adi` (`kullanici_adi`);

--
-- Tablo için indeksler `kullanici_sifre_gecmisi`
--
ALTER TABLE `kullanici_sifre_gecmisi`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_kullanici_id` (`kullanici_id`),
  ADD KEY `idx_olusturulma_tarihi` (`olusturulma_tarihi`),
  ADD KEY `fk_kullanici_sifre_gecmisi_sirket_id` (`sirket_id`);

--
-- Tablo için indeksler `kullanici_sirket_iliskisi`
--
ALTER TABLE `kullanici_sirket_iliskisi`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `kullanici_sirket` (`kullanici_id`,`sirket_id`),
  ADD KEY `kullanici_sirket_iliskisi_ibfk_2` (`sirket_id`);

--
-- Tablo için indeksler `mevcut_stok`
--
ALTER TABLE `mevcut_stok`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `urun_id` (`urun_id`),
  ADD KEY `fk_mevcut_stok_sirket_id` (`sirket_id`);

--
-- Tablo için indeksler `oturum_loglari`
--
ALTER TABLE `oturum_loglari`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_kullanici_id` (`kullanici_id`),
  ADD KEY `idx_islem_tipi` (`islem_tipi`),
  ADD KEY `idx_olusturulma_tarihi` (`olusturulma_tarihi`),
  ADD KEY `fk_oturum_loglari_sirket_id` (`sirket_id`);

--
-- Tablo için indeksler `sifre_sifirlama`
--
ALTER TABLE `sifre_sifirlama`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `token` (`token`),
  ADD KEY `idx_kullanici_id` (`kullanici_id`),
  ADD KEY `idx_gecerlilik_tarihi` (`gecerlilik_tarihi`);

--
-- Tablo için indeksler `silinen_kayitlar`
--
ALTER TABLE `silinen_kayitlar`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_log_id` (`log_id`),
  ADD KEY `idx_tablo_adi` (`tablo_adi`),
  ADD KEY `idx_kayit_id` (`kayit_id`),
  ADD KEY `idx_geri_alindi` (`geri_alindi`),
  ADD KEY `fk_silinen_kayitlar_sirket_id` (`sirket_id`);

--
-- Tablo için indeksler `sirketler`
--
ALTER TABLE `sirketler`
  ADD PRIMARY KEY (`id`);

--
-- Tablo için indeksler `sistem_loglari`
--
ALTER TABLE `sistem_loglari`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_kullanici_id` (`kullanici_id`),
  ADD KEY `idx_islem_tipi` (`islem_tipi`),
  ADD KEY `idx_tablo_adi` (`tablo_adi`),
  ADD KEY `idx_kayit_id` (`kayit_id`),
  ADD KEY `idx_olusturulma_tarihi` (`olusturulma_tarihi`),
  ADD KEY `fk_sistem_loglari_sirket_id` (`sirket_id`);

--
-- Tablo için indeksler `stok_hareketleri`
--
ALTER TABLE `stok_hareketleri`
  ADD PRIMARY KEY (`id`),
  ADD KEY `urun_id` (`urun_id`),
  ADD KEY `borc_id` (`borc_id`),
  ADD KEY `cari_id` (`cari_id`),
  ADD KEY `tarih` (`tarih`),
  ADD KEY `hareket_turu` (`hareket_turu`),
  ADD KEY `fk_stok_hareketleri_sirket_id` (`sirket_id`);

--
-- Tablo için indeksler `teklifler`
--
ALTER TABLE `teklifler`
  ADD PRIMARY KEY (`id`),
  ADD KEY `cari_id` (`cari_id`),
  ADD KEY `fk_teklifler_sirket_id` (`sirket_id`);

--
-- Tablo için indeksler `teklif_detaylari`
--
ALTER TABLE `teklif_detaylari`
  ADD PRIMARY KEY (`id`),
  ADD KEY `teklif_id` (`teklif_id`),
  ADD KEY `urun_id` (`urun_id`),
  ADD KEY `fk_teklif_detaylari_sirket_id` (`sirket_id`);

--
-- Tablo için indeksler `urunler`
--
ALTER TABLE `urunler`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `barkod` (`barkod`),
  ADD KEY `kategori_id` (`kategori_id`),
  ADD KEY `urun_adi` (`urun_adi`),
  ADD KEY `idx_tedarikci` (`tedarikci_id`),
  ADD KEY `fk_urunler_sirket_id` (`sirket_id`);

--
-- Tablo için indeksler `urun_resimleri`
--
ALTER TABLE `urun_resimleri`
  ADD PRIMARY KEY (`id`),
  ADD KEY `urun_id` (`urun_id`),
  ADD KEY `fk_urun_resimleri_sirket_id` (`sirket_id`);

--
-- Tablo için indeksler `yetki_gruplari`
--
ALTER TABLE `yetki_gruplari`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `grup_adi` (`grup_adi`);

--
-- Dökümü yapılmış tablolar için AUTO_INCREMENT değeri
--

--
-- Tablo için AUTO_INCREMENT değeri `aktif_oturumlar`
--
ALTER TABLE `aktif_oturumlar`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- Tablo için AUTO_INCREMENT değeri `borclar`
--
ALTER TABLE `borclar`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- Tablo için AUTO_INCREMENT değeri `cariler`
--
ALTER TABLE `cariler`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- Tablo için AUTO_INCREMENT değeri `cari_gruplari`
--
ALTER TABLE `cari_gruplari`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=15;

--
-- Tablo için AUTO_INCREMENT değeri `doviz_kurlari`
--
ALTER TABLE `doviz_kurlari`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1225;

--
-- Tablo için AUTO_INCREMENT değeri `fatura_detaylari`
--
ALTER TABLE `fatura_detaylari`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- Tablo için AUTO_INCREMENT değeri `hatirlaticilar`
--
ALTER TABLE `hatirlaticilar`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- Tablo için AUTO_INCREMENT değeri `hesaplar`
--
ALTER TABLE `hesaplar`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=24;

--
-- Tablo için AUTO_INCREMENT değeri `hesap_hareketleri`
--
ALTER TABLE `hesap_hareketleri`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- Tablo için AUTO_INCREMENT değeri `kategoriler`
--
ALTER TABLE `kategoriler`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=45;

--
-- Tablo için AUTO_INCREMENT değeri `kullanicilar`
--
ALTER TABLE `kullanicilar`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- Tablo için AUTO_INCREMENT değeri `kullanici_sifre_gecmisi`
--
ALTER TABLE `kullanici_sifre_gecmisi`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- Tablo için AUTO_INCREMENT değeri `kullanici_sirket_iliskisi`
--
ALTER TABLE `kullanici_sirket_iliskisi`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- Tablo için AUTO_INCREMENT değeri `mevcut_stok`
--
ALTER TABLE `mevcut_stok`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- Tablo için AUTO_INCREMENT değeri `oturum_loglari`
--
ALTER TABLE `oturum_loglari`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- Tablo için AUTO_INCREMENT değeri `sifre_sifirlama`
--
ALTER TABLE `sifre_sifirlama`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- Tablo için AUTO_INCREMENT değeri `silinen_kayitlar`
--
ALTER TABLE `silinen_kayitlar`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- Tablo için AUTO_INCREMENT değeri `sirketler`
--
ALTER TABLE `sirketler`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- Tablo için AUTO_INCREMENT değeri `sistem_loglari`
--
ALTER TABLE `sistem_loglari`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- Tablo için AUTO_INCREMENT değeri `stok_hareketleri`
--
ALTER TABLE `stok_hareketleri`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- Tablo için AUTO_INCREMENT değeri `teklifler`
--
ALTER TABLE `teklifler`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- Tablo için AUTO_INCREMENT değeri `teklif_detaylari`
--
ALTER TABLE `teklif_detaylari`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- Tablo için AUTO_INCREMENT değeri `urunler`
--
ALTER TABLE `urunler`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- Tablo için AUTO_INCREMENT değeri `urun_resimleri`
--
ALTER TABLE `urun_resimleri`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- Tablo için AUTO_INCREMENT değeri `yetki_gruplari`
--
ALTER TABLE `yetki_gruplari`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- Dökümü yapılmış tablolar için kısıtlamalar
--

--
-- Tablo kısıtlamaları `aktif_oturumlar`
--
ALTER TABLE `aktif_oturumlar`
  ADD CONSTRAINT `aktif_oturumlar_ibfk_1` FOREIGN KEY (`kullanici_id`) REFERENCES `kullanicilar` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_aktif_oturumlar_sirket_id` FOREIGN KEY (`sirket_id`) REFERENCES `sirketler` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Tablo kısıtlamaları `borclar`
--
ALTER TABLE `borclar`
  ADD CONSTRAINT `fk_borc_cari` FOREIGN KEY (`cari_id`) REFERENCES `cariler` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_borc_kategori` FOREIGN KEY (`kategori_id`) REFERENCES `kategoriler` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_borclar_sirket_id` FOREIGN KEY (`sirket_id`) REFERENCES `sirketler` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Tablo kısıtlamaları `cariler`
--
ALTER TABLE `cariler`
  ADD CONSTRAINT `fk_cari_grup` FOREIGN KEY (`grup_id`) REFERENCES `cari_gruplari` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_cariler_sirket_id` FOREIGN KEY (`sirket_id`) REFERENCES `sirketler` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Tablo kısıtlamaları `cari_gruplari`
--
ALTER TABLE `cari_gruplari`
  ADD CONSTRAINT `fk_cari_gruplari_sirket` FOREIGN KEY (`sirket_id`) REFERENCES `sirketler` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Tablo kısıtlamaları `fatura_detaylari`
--
ALTER TABLE `fatura_detaylari`
  ADD CONSTRAINT `fatura_detaylari_ibfk_1` FOREIGN KEY (`borc_id`) REFERENCES `borclar` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fatura_detaylari_ibfk_2` FOREIGN KEY (`urun_id`) REFERENCES `urunler` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_fatura_detaylari_sirket_id` FOREIGN KEY (`sirket_id`) REFERENCES `sirketler` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Tablo kısıtlamaları `hatirlaticilar`
--
ALTER TABLE `hatirlaticilar`
  ADD CONSTRAINT `fk_hatirlaticilar_sirket_id` FOREIGN KEY (`sirket_id`) REFERENCES `sirketler` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `hatirlaticilar_ibfk_1` FOREIGN KEY (`cari_id`) REFERENCES `cariler` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `hatirlaticilar_ibfk_2` FOREIGN KEY (`borc_id`) REFERENCES `borclar` (`id`) ON DELETE SET NULL;

--
-- Tablo kısıtlamaları `hesaplar`
--
ALTER TABLE `hesaplar`
  ADD CONSTRAINT `fk_hesaplar_sirket_id` FOREIGN KEY (`sirket_id`) REFERENCES `sirketler` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Tablo kısıtlamaları `hesap_hareketleri`
--
ALTER TABLE `hesap_hareketleri`
  ADD CONSTRAINT `fk_hareket_borc_iliski` FOREIGN KEY (`borc_id`) REFERENCES `borclar` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_hareket_cari` FOREIGN KEY (`cari_id`) REFERENCES `cariler` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_hareket_hesap` FOREIGN KEY (`hesap_id`) REFERENCES `hesaplar` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_hesap_hareketleri_sirket_id` FOREIGN KEY (`sirket_id`) REFERENCES `sirketler` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Tablo kısıtlamaları `kategoriler`
--
ALTER TABLE `kategoriler`
  ADD CONSTRAINT `fk_kategoriler_sirket_id` FOREIGN KEY (`sirket_id`) REFERENCES `sirketler` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Tablo kısıtlamaları `kullanici_sifre_gecmisi`
--
ALTER TABLE `kullanici_sifre_gecmisi`
  ADD CONSTRAINT `fk_kullanici_sifre_gecmisi_sirket_id` FOREIGN KEY (`sirket_id`) REFERENCES `sirketler` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `kullanici_sifre_gecmisi_ibfk_1` FOREIGN KEY (`kullanici_id`) REFERENCES `kullanicilar` (`id`) ON DELETE CASCADE;

--
-- Tablo kısıtlamaları `kullanici_sirket_iliskisi`
--
ALTER TABLE `kullanici_sirket_iliskisi`
  ADD CONSTRAINT `kullanici_sirket_iliskisi_ibfk_1` FOREIGN KEY (`kullanici_id`) REFERENCES `kullanicilar` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `kullanici_sirket_iliskisi_ibfk_2` FOREIGN KEY (`sirket_id`) REFERENCES `sirketler` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Tablo kısıtlamaları `mevcut_stok`
--
ALTER TABLE `mevcut_stok`
  ADD CONSTRAINT `fk_mevcut_stok_sirket_id` FOREIGN KEY (`sirket_id`) REFERENCES `sirketler` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `mevcut_stok_ibfk_1` FOREIGN KEY (`urun_id`) REFERENCES `urunler` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Tablo kısıtlamaları `oturum_loglari`
--
ALTER TABLE `oturum_loglari`
  ADD CONSTRAINT `fk_oturum_loglari_sirket_id` FOREIGN KEY (`sirket_id`) REFERENCES `sirketler` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Tablo kısıtlamaları `sifre_sifirlama`
--
ALTER TABLE `sifre_sifirlama`
  ADD CONSTRAINT `sifre_sifirlama_ibfk_1` FOREIGN KEY (`kullanici_id`) REFERENCES `kullanicilar` (`id`) ON DELETE CASCADE;

--
-- Tablo kısıtlamaları `silinen_kayitlar`
--
ALTER TABLE `silinen_kayitlar`
  ADD CONSTRAINT `fk_silinen_kayitlar_sirket_id` FOREIGN KEY (`sirket_id`) REFERENCES `sirketler` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `silinen_kayitlar_ibfk_1` FOREIGN KEY (`log_id`) REFERENCES `sistem_loglari` (`id`) ON DELETE CASCADE;

--
-- Tablo kısıtlamaları `sistem_loglari`
--
ALTER TABLE `sistem_loglari`
  ADD CONSTRAINT `fk_sistem_loglari_sirket_id` FOREIGN KEY (`sirket_id`) REFERENCES `sirketler` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Tablo kısıtlamaları `stok_hareketleri`
--
ALTER TABLE `stok_hareketleri`
  ADD CONSTRAINT `fk_stok_hareketleri_sirket_id` FOREIGN KEY (`sirket_id`) REFERENCES `sirketler` (`id`),
  ADD CONSTRAINT `stok_hareketleri_ibfk_1` FOREIGN KEY (`urun_id`) REFERENCES `urunler` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `stok_hareketleri_ibfk_2` FOREIGN KEY (`borc_id`) REFERENCES `borclar` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `stok_hareketleri_ibfk_3` FOREIGN KEY (`cari_id`) REFERENCES `cariler` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

--
-- Tablo kısıtlamaları `teklifler`
--
ALTER TABLE `teklifler`
  ADD CONSTRAINT `fk_teklifler_cari` FOREIGN KEY (`cari_id`) REFERENCES `cariler` (`id`),
  ADD CONSTRAINT `fk_teklifler_sirket_id` FOREIGN KEY (`sirket_id`) REFERENCES `sirketler` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Tablo kısıtlamaları `teklif_detaylari`
--
ALTER TABLE `teklif_detaylari`
  ADD CONSTRAINT `fk_teklif_detaylari_sirket_id` FOREIGN KEY (`sirket_id`) REFERENCES `sirketler` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_teklif_detaylari_teklif` FOREIGN KEY (`teklif_id`) REFERENCES `teklifler` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_teklif_detaylari_urun` FOREIGN KEY (`urun_id`) REFERENCES `urunler` (`id`);

--
-- Tablo kısıtlamaları `urunler`
--
ALTER TABLE `urunler`
  ADD CONSTRAINT `fk_urunler_sirket_id` FOREIGN KEY (`sirket_id`) REFERENCES `sirketler` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_urunler_tedarikci` FOREIGN KEY (`tedarikci_id`) REFERENCES `cariler` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `urunler_ibfk_1` FOREIGN KEY (`kategori_id`) REFERENCES `kategoriler` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

--
-- Tablo kısıtlamaları `urun_resimleri`
--
ALTER TABLE `urun_resimleri`
  ADD CONSTRAINT `fk_urun_resimleri_sirket_id` FOREIGN KEY (`sirket_id`) REFERENCES `sirketler` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `urun_resimleri_ibfk_1` FOREIGN KEY (`urun_id`) REFERENCES `urunler` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
