<?php
/**
 * Turkish Language File
 * Türkçe Dil Dosyası
 */

return [
    'view_permission_details' => 'Yetki detaylarını görüntüle',
    // General / Genel
    'welcome' => 'Hoş Geldiniz',
    'dashboard' => 'Ana Panel',
    'profile' => 'Profil',
    'settings' => 'Ayarlar',
    'logout' => 'Çıkış',
    'login' => 'Giriş',
    'save' => 'Kaydet',
    'cancel' => 'İptal',
    'edit' => 'Düzenle',
    'delete' => 'Sil',
    'add' => 'Ekle',
    'search' => 'Ara',

    // Password strength
    'password_strength_requirement' => 'Şifre en az 8 karakter olmalı, büyük harf, küçük harf, rakam ve özel karakter içermelidir.',
    
    // Header / Üst Menü
    'operations' => 'İşlemler',
    'inventory' => 'Stok',
    'reports' => 'Raporlar',
    'management' => 'Yönetim',
    'switch_company' => 'Şirket Değiştir',
    'select_company' => 'Şirket Seçiniz',
    'language' => 'Dil',
    
    // Footer / Alt Bilgi
    'all_rights_reserved' => 'Tüm Hakları Saklıdır',
    'developer' => 'Geliştirici',
    // Navigation / Menü
    'sales_invoices' => 'Satış Faturaları',
    'purchase_invoices' => 'Alış Faturaları',
    'new_purchase_invoice' => 'Yeni Alış Faturası',
    'sales_invoice' => 'Satış Faturası',
    'purchase_invoice' => 'Alış Faturası',
    'invoice' => 'Fatura',
    'invoice_number' => 'Fatura No',
    'invoice_no' => 'Fatura No',
    'invoice_details' => 'Fatura Detayları',
    'view_related_invoice' => 'İlgili Faturayı Görüntüle',
    'invoice_date' => 'Fatura Tarihi',
    'due_date' => 'Vade Tarihi',
    'payment_status' => 'Ödeme Durumu',
    'paid' => 'Ödendi',
    'partially_paid' => 'Kısmen Ödendi',
    'unpaid' => 'Ödenmedi',
    'customer' => 'Müşteri',
    'supplier' => 'Tedarikçi',
    'company_info' => 'Firma Bilgileri',
    'tax_office' => 'Vergi Dairesi',
    'tax_number' => 'Vergi No',
    'tax' => 'KDV',
    'tax_rate' => 'KDV Oranı',
    'tax_amount' => 'KDV Tutarı',
    'tax_included' => 'KDV Dahil',
    'tax_excluded' => 'KDV Hariç',
    'tax_summary' => 'KDV Özeti',
    'tax_calculation' => 'KDV Hesaplama',
    'tax_type' => 'KDV Türü',
    'address' => 'Adres',
    'phone' => 'Telefon',
    'description_items' => 'Açıklama Kalemleri',
    'no_description_items' => 'Açıklama kalemi yok',
    'product_name' => 'Ürün adı',
    'quantity' => 'Miktar',
    'unit_price' => 'Birim Fiyat',
    'vat_amount' => 'KDV Tutarı',
    'amount' => 'Tutar',
    'subtotal' => 'Ara Toplam',
    'total_vat' => 'Toplam KDV',
    'discount' => 'İndirim',
    'total_amount' => 'Genel Toplam',
    'paid_amount' => 'Ödenen Tutar',
    'remaining_amount' => 'Kalan Tutar',
    'print' => 'Yazdır',
    'download_pdf' => 'PDF İndir',
    'download_excel' => 'Excel İndir',
    'edit' => 'Düzenle',
    'back' => 'Geri',
    'save' => 'Kaydet',
    'generated_by' => 'Bu fatura Begeb Creative Yönetim sistemi tarafından oluşturulmuştur.',
    'error_invalid_invoice_id' => 'Geçersiz fatura ID\'si.',
    'error_invoice_not_found' => 'Fatura bulunamadı veya yetkiniz yok.',
    'error_database' => 'Veritabanı hatası oluştu',
    'error_invalid_token' => 'Geçersiz güvenlik tokeni.',
    'error_invalid_status' => 'Geçersiz ödeme durumu.',
    'success_payment_status_updated' => 'Ödeme durumu güncellendi.',
    'supplier' => 'Tedarikçi',
    'search' => 'Ara',
    'from_date' => 'Başlangıç Tarihi',
    'to_date' => 'Bitiş Tarihi',
    'product_service' => 'Ürün/Hizmet',
    'quantity' => 'Adet',
    'unit_price' => 'Birim Fiyat',
    'product_currency' => 'Ürün PB',
    'exchange_rate' => 'Kur',
    'vat_rate' => 'KDV (%)',
    'vat_amount' => 'KDV Tutarı',
    'total' => 'Toplam',
    'delete' => 'Sil',
    'add_product' => 'Ürün Ekle',
    'select_product' => 'Ürün Seç',
    'search_product_placeholder' => 'Ürün adı veya stok kodu ile ara...',
    'product_name' => 'Ürün adı',
    'stock_code' => 'Stok Kodu',
    'price' => 'Fiyat',
    'subtotal' => 'Ara Toplam',
    'total_vat' => 'Toplam KDV',
    'discount' => 'İndirim',
    'grand_total' => 'Genel Toplam',
    'description' => 'Açıklama',
    'edit_invoice' => 'Fatura Düzenle',
    'back_to_invoice' => 'Fatura Detayına Dön',
    'invalid_invoice_id' => 'Geçersiz Fatura ID.',
    'database_error' => 'Veritabanı hatası: Veriler yüklenemedi.',
    'customer_required' => 'Cari Seçimi zorunludur.',
    'due_date' => 'Vade Tarihi',
    'customer' => 'Müşteri',
    'total_amount' => 'Toplam Tutar',
    'remaining_amount' => 'Kalan Tutar',
    'payment_status' => 'Ödeme Durumu',
    'actions' => 'İşlemler',
    'paid' => 'Ödendi',
    'partially_paid' => 'Kısmen Ödendi',
    'unpaid' => 'Ödenmedi',
    'overdue' => 'Gecikmiş',
    'search_placeholder' => 'Fatura no, Müşteri adı veya Açıklama...',
    'filter' => 'Filtrele',
    'clear_filters' => 'Filtreleri Temizle',
    'all' => 'Tümü',
    'from_date' => 'Başlangıç Tarihi',
    'to_date' => 'Bitiş Tarihi',
    'offers' => 'Teklifler',
    'offer_list' => 'Teklif Listesi',
    'new_offer' => 'Yeni Teklif',
    'offer_without_stock' => 'Stoksuz Teklif',
    'customers' => 'Cariler',
    'reports' => 'Raporlar',
    'cash_receipt' => 'Kasa Gider Makbuzu',
    'exchange_rates' => 'Döviz Kurları',
    'batch_operations' => 'Toplu İşlemler',
    'reminder' => 'Hatırlatıcı',
    'backup_operations' => 'Yedek İşlemleri',
    
    // Sales Page / Satış Sayfası
    'sale_transaction' => 'Satış İşlemi',
    'invoice_products' => 'Fatura Ürünleri',
    'add_product' => 'Ürün Ekle',
    'supplier' => 'Tedarikçi',
    'category' => 'Kategori',
    'transaction_date' => 'İşlem Tarihi',
    'description' => 'Açıklama',
    'product_name' => 'Ürün adı',
    'quantity' => 'Miktar',
    'unit_price' => 'Birim Fiyat',
    'rate' => 'Kur',
    'current_rate' => 'Güncel Kur',
    'vat_rate' => 'KDV %',
    'vat_amount' => 'KDV Tutarı',
    'total' => 'Toplam',
    'delete' => 'Sil',
    'subtotal' => 'Ara Toplam',
    'total_vat' => 'Toplam KDV',
    'discount' => 'İndirim',
    'grand_total' => 'Genel Toplam',
    'payment_transactions' => 'Ödeme İşlemleri',
    'payment_made_in_cash' => 'Ödeme peşin yapıldı',
    'due_date' => 'Vade Tarihi',
    'payment_account' => 'Ödemenin Yapıldığı Hesap',
    'select_account' => '-- Hesap Seçin --',
    'payment_date' => 'Ödeme Tarihi',
    'save_sale' => 'Satışı Kaydet',
    'select_products' => 'Ürün Seçin',
    'select_supplier' => 'Tedarikçi Seçilmedi',
    'select_category' => '-- Kategori Seçin --',
    'invoice_currency' => 'Fatura Para Birimi',
    'all_suppliers' => 'Tüm Tedarikçiler',
    'search_product_barcode' => 'Ürün adı veya barkod yazın...',
    'saving' => 'Kaydediliyor...',
    'loading_products' => 'Ürünler yükleniyor...',
    'no_products_found' => 'Ürün bulunamadı',
    'select' => 'Seçili',
    'selected' => 'Seçilen',
    'invalid_form_submission' => 'Geçersiz form gönderimi!',
    'purchase_transaction' => 'Alış İşlemi',
    'supplier_required' => 'Tedarikçi Seçimi zorunludur.',
    'category_required' => 'Kategori Seçimi zorunludur.',
    'valid_date_required' => 'Geçerli bir işlem tarihi giriniz.',
    'at_least_one_product_required' => 'Alış için en az bir ürün eklemelisiniz.',
    'discount_cannot_exceed_total' => 'İndirim Tutarı fatura toplamından fazla olamaz.',
    'account_required_for_cash_payment' => 'Peşin ödeme için hesap Seçimi zorunludur.',
    'purchase_saved_successfully' => 'Alış işlemi başarıyla kaydedildi.',
    'credit_customer' => 'Cariyi Alacaklandır',
    'transaction_items' => 'İşlem Kalemleri',
    'add_item' => 'Kalem Ekle',
    'description' => 'Açıklama',
    'amount' => 'Tutar',
    'remove' => 'Sil',
    'subtotal' => 'Ara Toplam',
    'total' => 'Toplam',
    'cash_payment' => 'Peşin Ödendi',
    'payment_account' => 'Ödeme Hesabı',
    'payment_date' => 'Ödeme Tarihi',
    'save_credit' => 'Kaydet',
    'select_category_required' => 'Kategori Seçimi zorunludur.',
    'valid_date_required' => 'Geçerli bir işlem tarihi giriniz.',
    'amount_required' => 'Tutar girişi zorunludur.',
    'amount_greater_than_zero' => 'İşlem Tutarı 0\'dan büyük olmalıdır.',
    'account_required_for_cash' => 'Peşin ödeme için hesap Seçimi zorunludur.',
    'credit_saved_success' => 'Cari alacaklandırma işlemi başarıyla kaydedildi.',
    'error_occurred' => 'Bir hata oluştu:',
    'failed_to_save_credit' => 'Cari alacaklandırma işlemi kaydedilirken bir hata oluştu.',
    'select_customer' => 'Cari Seçin',
    'no_recipient_selected' => 'Alıcı seçilmedi',
    'search_or_add_new_recipient' => 'Ara veya yeni alıcı ekle',
    'description' => 'Açıklama',
    'new_sales_invoice' => 'Yeni Satış Faturası',
    'no_records_found' => 'Kayıt bulunamadı',
    'at_least_one_item_required' => 'En az bir kalem eklenmelidir',
    'debit_customer' => 'Cariyi Borçlandır',
    'debit_saved_success' => 'Cari borçlandırma işlemi başarıyla kaydedildi.',
    'failed_to_save_debit' => 'Cari borçlandırma işlemi kaydedilirken bir hata oluştu.',
    'save_debit' => 'Kaydet',
    'receive_payment' => 'Ödeme Alma (Tahsilat)',
    'payment_received' => 'Ödeme Alındı',
    'payment_info' => 'Ödeme Bilgileri',
    'payment_saved' => 'Ödeme başarıyla kaydedildi.',
    'payment_failed' => 'Ödeme kaydedilirken hata oluştu.',
    'payment_amount_required' => 'Ödeme Tutarı gerekli.',
    'valid_payment_amount' => 'Geçerli bir ödeme Tutarı girin (0\'dan büyük).',
    'payment_date_required' => 'Ödeme tarihi gerekli.',
    'account_selection_required' => 'Hesap Seçimi zorunludur.',
    'customer_selection_required' => 'Cari Seçimi zorunludur.',
    'save_payment' => 'Ödemeyi Kaydet',
    'payment_description' => 'Ödeme Açıklaması',
    'payment_date' => 'Ödeme Tarihi',
    'payment_account' => 'Tahsilat Hesabı',
    'select_account' => 'Hesap Seçin',
    'payment_received_success' => 'Ödeme başarıyla alındı.',
    'payment_made_success' => 'Ödeme başarıyla yapıldı.',
    'make_payment' => 'Ödeme Yapma',
    'payment_made' => 'Ödeme Yapıldı',
    'payment_information' => 'Ödeme Bilgileri',
    'payment_recipient' => 'Ödeme Yapılacak Cari (Tedarikçi)',
    'payment_recipient_required' => 'Ödeme yapılacak cari (Tedarikçi) Seçimi zorunludur.',
    'insufficient_funds' => 'Yetersiz bakiye! (Mevcut: {amount} {currency})',
    'save_payment_btn' => 'Ödemeyi Kaydet',
    'add_transfer' => 'Para Transferi',
    'transfer' => 'Transfer',
    'from_account' => 'Gönderen Hesap',
    'to_account' => 'Alıcı Hesap',
    'transfer_amount' => 'Transfer Tutarı',
    'transfer_date' => 'Transfer Tarihi',
    'transfer_description' => 'Transfer Açıklaması',
    'exchange_rate' => 'Döviz Kuru',
    'use_manual_rate' => 'Manuel Kur Kullan',
    'amount_in_target_currency' => 'Hedef Para Birimi Tutarı',
    'same_account_transfer_error' => 'Aynı hesaplar arası transfer yapılamaz!',
    'invalid_amount_error' => 'Geçerli bir tutar giriniz!',
    'select_source_account' => 'Kaynak hesap Seçin',
    'select_target_account' => 'Hedef hesap Seçin',
    'add_expense' => 'Kasa Gideri',
    'expense' => 'Gider',
    'expense_type' => 'Gider Türü',
    'expense_date' => 'Gider Tarihi',
    'expense_amount' => 'Gider Tutarı',
    'expense_description' => 'Gider Açıklaması',
    'select_expense_type' => 'Gider türü Seçin',
    'select_payment_method' => 'Ödeme yöntemi Seçin',
    'expense_added_success' => 'Gider başarıyla eklendi',
    'transfer_added_success' => 'Transfer başarıyla eklendi',
    'source_account' => 'Kaynak Hesap',
    'target_account' => 'Hedef Hesap',
    'transfer_amount_placeholder' => 'Transfer Tutarını giriniz',
    'exchange_rate_placeholder' => 'Döviz kuru otomatik hesaplanacak',
    'automatic_exchange_rate_info' => 'Döviz kuru otomatik olarak güncel kurdan hesaplanacaktır',
    'fill_required_fields' => 'Tüm zorunlu alanları doldurunuz',
    'selected_account_not_found' => 'Seçilen hesap bulunamadı!',
    'insufficient_balance' => 'Yetersiz bakiye!',
    'select_cash_register' => 'Kasa Seçiniz',
    'save_expense' => 'Gideri Kaydet',
    'expense_added_successfully' => 'Gider başarıyla kaydedildi!',
    'invalid_security_token' => 'Geçersiz güvenlik anahtarı!',
    'save' => 'Kaydet',
    'error_occurred' => 'Bir hata oluştu:',
    'failed_to_save_purchase' => 'Alış işlemi kaydedilirken bir hata oluştu.',
    'select_supplier' => 'Tedarikçi Seçin',
    'no_supplier_selected' => 'Tedarikçi Seçilmedi',
    'save_purchase' => 'Alışı Kaydet',
    'add_product' => 'Ürün Ekle',
    'user' => 'Kullanıcı',
    'filter' => 'Filtrele',
    'export' => 'Dışa Aktar',
    'import' => 'İçe Aktar',
    'back' => 'Geri',
    'next' => 'İleri',
    'previous' => 'Önceki',
    'close' => 'Kapat',
    'confirm' => 'Onayla',
    'yes' => 'Evet',
    'logs' => 'Kayıtlar',
    'security_checks' => 'Güvenlik Kontrolleri',
    'ok' => 'Tamam', 
    'error' => 'Hata',
    'success' => 'Başarılı',
    'warning' => 'Uyarı',
    'info' => 'Bilgi',
    'loading' => 'Yükleniyor...',
    'please_wait' => 'Lütfen bekleyin...',
    
    // Dashboard / Ana Panel
    'welcome_user' => 'Hoş geldiniz, :name!',
    'active_company' => 'Aktif şirket: :company',
    'current_time' => 'Mevcut Zaman',
    'total_customers' => 'Toplam Cari',
    'customer_receivables' => 'Müşteri Alacakları',
    'supplier_debts' => 'Tedarikçi Borçları',
    'net_balance' => 'Net Cari Bakiye',
    'total_sales' => 'Toplam Satış',
    'total_purchases' => 'Toplam Alış',
    'profit_loss' => 'Kar/Zarar',
    'monthly_income_expense_chart' => 'Aylık Gelir-Gider Grafiği',
    'income' => 'Gelir',
    'expense' => 'Gider',
    'account_balances' => 'Hesap Bakiyeleri',
    'recent_account_movements' => 'Son Hesap Hareketleri',
    'upcoming_due_receivables' => 'Yaklaşan / Geçmiş Vade (Tahsilatlar)',
    'upcoming_due_payments' => 'Yaklaşan / Geçmiş Vade (Ödemeler)',
    'recent_logins' => 'Son Girişler',
    'best_selling_products' => 'En Çok Satan Ürünler',
    'reports_best_selling_products' => 'En Çok Satan Ürünler',
    'number_to_show' => 'Gösterilecek Sayı',
    'first_10' => 'İlk 10',
    'first_20' => 'İlk 20',
    'first_50' => 'İlk 50',
    'first_100' => 'İlk 100',
    'fetch' => 'Getir',
    'percent_share' => 'Piyasa Payı',
    'sold_product_variety' => 'Satılan Ürün Çeşidi',
    'sales_quantity' => 'Satış Miktarı',
    'sales_amount' => 'Satış Tutarı',
    'average_price' => 'Ortalama Fiyat',
    'customer_count' => 'Müşteri Sayısı',
    'sales_count' => 'Satış Sayısı',
    'last_sale' => 'Son Satış',
    'performance' => 'Performans',
    'distinct_customers' => 'Farklı Müşteriler',
    'received_goods_services' => 'Alınan Mal/Hizmetler',
    'transfer_description_placeholder' => 'Transfer açıklaması giriniz',
    'detailed_reports' => 'Detaylı Raporlar',
    'summary_reports' => 'Özet Raporlar',
    'customer_statement' => 'Cari Hesap Ekstresi',
    'detailed_sales_report' => 'Detaylı Satış Raporu',
    'view_all_movements' => 'Tüm Hareketleri Gör',
    
    // Quotes / Teklifler
    'quotes' => 'Teklifler',
    'quote' => 'Teklif',
    'new_quote' => 'Yeni Teklif',
    'quote_without_stock' => 'Stoksuz Teklif',
    'quote_date' => 'Teklif Tarihi',
    'quote_number' => 'Teklif No',
    'quote_status' => 'Teklif Durumu',
    'convert_to_invoice' => 'Faturaya Dönüştür',
    'confirm_convert_to_invoice' => 'Bu teklifi faturaya Dönüştürmek istediĞŸinizden emin misiniz?',
    'confirm_cancel_quote' => 'Bu teklifi iptal etmek istediĞŸinizden emin misiniz?',
    'confirm_delete_quote' => 'Bu teklifi silmek istediĞŸinizden emin misiniz?',
    'no_quotes_found' => 'Henüz kayıtlı teklif bulunmamaktadır.',
    'quote_created' => 'Teklif başarıyla oluşturuldu.',
    'quote_updated' => 'Teklif başarıyla güncellendi.',
    'edit_quote' => 'Stoksuz Teklif Düzenle',
    'error_loading_quote' => 'Teklif bilgileri alınırken hata oluştu!',
    'invalid_form_submission' => 'Geçersiz form gönderimi!',
    'customer_selection_required' => 'Müşteri Seçimi zorunludur.',
    'quote_date_required' => 'Teklif tarihi zorunludur.',
    'at_least_one_item_required' => 'Teklif için en az bir kalem eklemelisiniz.',
    'user_updated_quote_log' => 'kullanıcısı, #%s ID\'li stoksuz teklifi güncelleyerek Müşteri: %s, tutar: %s olarak deĞŸiştirdi.',
    'quote_updated_success' => 'Stoksuz Teklif #%s başarıyla güncellendi.',
    'error_updating_quote' => 'Teklif güncellenirken bir hata oluştu',
    'quote_list' => 'Teklif Listesi',
    'select_customer' => 'Müşteri Seçin',
    'general_information_about_quote' => 'Teklif hakkında genel bilgi...',
    'transaction_items' => 'İşlem Kalemleri',
    'add_item' => 'Kalem Ekle',
    'e_g_consulting_services_project_management' => 'Örn: Danışmanlık hizmeti, Proje yönetimi',
    'total_information' => 'Toplam Bilgileri',
    'update_quote' => 'Teklifi Güncelle',
    'new_quote' => 'Yeni Teklif Oluştur',
    'quote_information' => 'Teklif Bilgileri',
    'customer_selection_required' => 'Müşteri Seçimi zorunludur.',
    'quote_date_required' => 'Teklif tarihi zorunludur.',
    'at_least_one_product_required' => 'Teklif için en az bir ürün eklemelisiniz.',
    'quote_created_success' => 'Teklif #%s başarıyla oluşturuldu.',
    'error_creating_quote' => 'Teklif oluşturulurken bir hata oluştu',
    'quote_list' => 'Teklif Listesi',
    'select_customer' => 'Müşteri Seçin...',
    'add_new_customer' => 'Yeni Müşteri Ekle',
    'quote_date' => 'Teklif Tarihi',
    'valid_until' => 'Geçerlilik Tarihi',
    'description' => 'Açıklama',
    'products' => 'Ürünler',
    'add_product' => 'Ürün Ekle',
    'invoice_currency' => 'Fatura Para Birimi',
    'product_name' => 'Ürün adı',
    'quantity' => 'Miktar',
    'unit_price' => 'Birim Fiyat',
    'product_currency' => 'Ürün PB',
    'exchange_rate' => 'Kur',
    'vat' => 'KDV',
    'vat_amount' => 'KDV Tutarı',
    'total' => 'Toplam',
    'subtotal' => 'Ara Toplam',
    'total_vat' => 'Toplam KDV',
    'discount' => 'İndirim',
    'grand_total' => 'Genel Toplam',
    'save_quote' => 'Teklifi Kaydet',
    'select_product' => 'Ürün Seç',
    'search_product' => 'Ürün ara...',
    'all_suppliers' => 'Tüm Tedarikçiler',
    'no_products_found' => 'Ürün bulunamadı',
    'select' => 'Seç',
    'remove' => 'Kaldır',
    'no_customer_selected' => 'Henüz Müşteri Seçilmedi',
    'search_customer' => 'Müşteri ara',
    'customer' => 'Müşteri',
    'error' => 'Hata',
    'please_correct_errors' => 'Lütfen aşaĞŸıdaki hataları düzeltin',
    'user_created_quote_log' => 'kullanıcısı, #%s ID\'li yeni bir teklif oluşturdu. Müşteri: %s, Tutar: %s',
    'quote_without_stock_created' => 'Stoksuz Teklif #%s başarıyla oluşturuldu.',
    'quote_without_stock' => 'Stoksuz Teklif Oluştur',
    'quote_information' => 'Teklif Bilgileri',
    'customer_required' => 'Müşteri Seçimi zorunludur.',
    'quote_date_required' => 'Teklif tarihi zorunludur.',
    'at_least_one_item_required' => 'Teklif için en az bir kalem eklemelisiniz.',
    'general_description' => 'Genel Açıklama',
    'transaction_items' => 'İşlem Kalemleri',
    'add_item' => 'Kalem Ekle',
    'description' => 'Açıklama',
    'amount' => 'Tutar',
    'save_quote' => 'Stoksuz Teklifi Kaydet',
    'at_least_one_item' => 'En az bir kalem eklenmelidir.',
    'customer_not_found' => 'Müşteri bulunamadı',
    'search_customer' => 'Müşteri ara...',
    'valid_until' => 'Geçerlilik Tarihi',
    'select' => 'Seç',
    'remove' => 'Kaldır',
    'no_customer_selected' => 'Henüz Müşteri Seçilmedi',
    'e_g_consulting_services_project_management' => 'Örn: Danışmanlık hizmeti, Proje yönetimi',
    'grand_total' => 'Genel Toplam',
    'error_creating_quote' => 'Teklif oluşturulurken bir hata oluştu',
    'quote_list' => 'Teklif Listesi',
    'search_customer' => 'Müşteri adı yazın...',
    'quote_date' => 'Teklif Tarihi',
    'valid_until' => 'Geçerlilik Tarihi',
    'general_description' => 'Genel Açıklama',
    'transaction_items' => 'İşlem Kalemleri',
    'add_item' => 'Kalem Ekle',
    'description' => 'Açıklama',
    'amount' => 'Tutar',
    'save_quote' => 'Stoksuz Teklifi Kaydet',
    'at_least_one_item' => 'En az bir kalem bulunmalıdır.',
    'customer_not_found' => 'Cari bulunamadı',
    'quote_deleted' => 'Teklif başarıyla silindi.',
    'quote_converted' => 'Teklif faturaya Dönüştürüldü.',
    'quote_cancelled' => 'Teklif iptal edildi.',
    'beklemede' => 'Beklemede',
    'onaylandı' => 'Onaylandı',
    'reddedildi' => 'Reddedildi',
    'faturalastirildi' => 'Faturalaştırıldı',
    
    // Quote View Page / Teklif Görüntüleme Sayfası
    'invalid_quote_id' => 'Geçersiz teklif ID\'si.',
    'company_info_not_found' => 'Firma bilgileri bulunamadı!',
    'quote_not_found' => 'Teklif bulunamadı.',
    'quote_details' => 'Teklif Detayı',
    'download_pdf' => 'PDF İndir',
    'print' => 'Yazdır',
    'back_to_quotes' => 'Teklif Listesi',
    'company_logo' => 'Firma Logosu',
    'customer' => 'Müşteri',
    'address_not_specified' => 'Adres belirtilmemiş',
    'no_phone' => 'Telefon yok',
    'quote_information' => 'Teklif Bilgileri',
    'valid_until' => 'Geçerlilik Tarihi',
    'description' => 'Açıklama',
    'amount' => 'Tutar',
    'product_service_name' => 'Ürün/Hizmet adı',
    'quantity' => 'Miktar',
    'unit_price_original' => 'Birim Fiyat (Orijinal PB)',
    'vat' => 'KDV',
    'amount_quote_currency' => 'Tutar (Teklif PB)',
    'no_quote_items' => 'Teklif kalemi bulunmuyor.',
    'subtotal' => 'Ara Toplam',
    'total_vat' => 'Toplam KDV',
    'discount' => 'İndirim',
    'grand_total' => 'Genel Toplam',
    'notes' => 'Notlar',
    'price_currency_note' => 'Ürün fiyatları kendi para birimlerinde, tutarlar ve toplamlar ise teklif para biriminde (:currency) gösterilmektedir.',
    'generated_by_odjoo' => 'Bu teklif Begeb Creative Yönetim sistemi tarafından oluşturulmuştur. | :website',
    'page_x_of_y' => 'Sayfa :current / :total',
    'quote_not_found_or_not_belongs' => 'Teklif bulunamadı veya bu şirkete ait deĞŸil.',
    'phone' => 'Tel',
    'unit_price' => 'Birim Fiyat',
    'quote_info' => 'Sayın :name - Bu teklifin bedeli :amount\'dir.',
    'quote_info_with_days' => 'Sayın :name - Bu teklifin bedeli :amount\'dir. Bu teklif :days gün geçerlidir.',
    
    // Quick Actions / Hızlı İşlemler
    'add_stock' => 'Stok Ekle',
    'create_invoice' => 'Fatura Oluştur',
    'add_customer' => 'Cari Ekle',
    'backup' => 'Yedek Al',
    
    // Account Types / Hesap Türleri
    'bank' => 'Banka',
    'cash' => 'Kasa',
    'credit_card' => 'Kredi Kartı',
    
    // Movement Types / Hareket Türleri
    'income_movement' => 'Giriş',
    'expense_movement' => 'Ã‡ıkış',
    'transfer_movement' => 'Transfer',
    
    // Due Status / Vade Durumu
    'due_today' => 'Bugün Vade',
    'days_remaining' => ':days gün kaldı',
    'days_overdue' => ':days gün geçti',
    
    // System Messages / Sistem Mesajları
    'no_company_assigned' => 'Henüz bir şirkete atanmadınız!',
    'create_company_message' => 'Sistemi kullanabilmek için yeni bir şirket oluşturmanız gerekiyor.',
    'create_company' => 'Åirket Oluştur',
    'system_info' => 'Begeb Creative v2.0 - Sisteminizi düzenli olarak yedekleyin. Destek için :email adresine ulaşabilirsiniz.',
    'no_data_available' => 'Henüz veri bulunmamaktadır.',
    'no_accounts_added' => 'Henüz hesap eklenmemiş.',
    'no_movements_recorded' => 'Henüz hesap hareketi kaydedilmemiş.',
    'no_due_receivables' => 'Vadesi yaklaşan veya geçmiş tahsilat bulunmamaktadır.',
    'no_due_payments' => 'Vadesi yaklaşan veya geçmiş ödeme bulunmamaktadır.',
    
    // Profile Settings / Profil Ayarları
    'profile_management' => 'Profil Yönetimi',
    'general_information' => 'Genel Bilgiler',
    'change_password' => 'Åifre DeĞŸiştir',
    'full_name' => 'Ad Soyad',
    'username' => 'Kullanıcı adı',
    'old_password' => 'Eski Åifre',
    'new_password' => 'Yeni Åifre',
    'confirm_new_password' => 'Yeni Åifre (Tekrar)',
    'password_min_length' => 'Åifreniz en az 6 karakter olmalıdır.',
    'update_information' => 'Bilgileri Güncelle',
    'change_password_button' => 'Åifreyi DeĞŸiştir',
    'language_settings' => 'Dil Ayarları',
    'select_language' => 'Dil Seçin',
    'language_updated' => 'Dil ayarı başarıyla güncellendi!',
    
    // Validation Messages / DoĞŸrulama Mesajları
    'name_username_required' => 'Ad Soyad ve Kullanıcı adı boş bırakılamaz!',
    'username_already_exists' => 'Bu kullanıcı adı zaten kullanılıyor. Lütfen farklı bir kullanıcı adı Seçin.',
    'update_error' => 'Bilgi güncelleme sırasında bir hata oluştu: :error',
    'old_password_incorrect' => 'Girilen eski şifre hatalı!',
    'passwords_not_match' => 'Yeni şifreler birbiriyle uyuşmuyor!',
    'password_too_short' => 'Yeni şifre en az 6 karakter uzunluĞŸunda olmalıdır!',
    'password_update_error' => 'Åifre deĞŸiştirme sırasında bir hata oluştu: :error',
    'information_updated' => 'Bilgileriniz başarıyla güncellendi!',
    'password_changed' => 'Åifreniz başarıyla deĞŸiştirildi!',
    
    // Currency / Para Birimi
    'currency_symbol' => 'â‚º',
    'amount' => 'Tutar',
    'balance' => 'Bakiye',
    'total' => 'Toplam',
    
    // Time / Zaman
    'date' => 'Tarih',
    'time' => 'Saat',
    'created_at' => 'Oluşturulma Tarihi',
    'updated_at' => 'Güncellenme Tarihi',
    'last_login' => 'Son Giriş',
    
    // Status / Durum
    'active' => 'Aktif',
    'inactive' => 'Pasif',
    'pending' => 'Beklemede',
    'completed' => 'Tamamlandı',
    'cancelled' => 'İptal Edildi',
    
    // Navigation / Navigasyon
    'home' => 'Ana Sayfa',
    'customers' => 'Cariler',
    'products' => 'Ürünler',
    'invoices' => 'Faturalar',
    'reports' => 'Raporlar',
    'backups' => 'Yedekler',
    'seller_info' => 'SATICI BİLGİLERİ',
    'buyer_info' => 'ALICI BİLGİLERİ',
    'page' => 'Sayfa',
    'vat' => 'KDV',
    'grand_total' => 'GENEL TOPLAM',
    'users' => 'Kullanıcılar',
    'companies' => 'Åirketler',
    
    // Common Actions / Yaygın İşlemler
    'view' => 'Görüntüle',
    'print' => 'Yazdır',
    'download' => 'İndir',
    'upload' => 'Yükle',
    'refresh' => 'Yenile',
    'reset' => 'Sıfırla',
    'clear' => 'Temizle',
    'select_all' => 'Tümünü Seç',
    'deselect_all' => 'Seçimi Kaldır',
    
    // Months / Aylar
    'january' => 'Ocak',
    'february' => 'Åubat',
    'march' => 'Mart',
    'april' => 'Nisan',
    'may' => 'Mayıs',
    'june' => 'Haziran',
    'july' => 'Temmuz',
    'august' => 'AĞŸustos',
    'september' => 'Eylül',
    'october' => 'Ekim',
    'november' => 'Kasım',
    'december' => 'Aralık',
    
    // Product Management
    'most_sold_products' => 'En Çok Satılan Ürünler',
    'product_management' => 'Ürün Yönetimi',
    'stock_purchase_value' => 'Stok Alış Değeri',
    'total_value_in_tl' => 'Toplam değer TL karşılığı',
    'stock_sales_value' => 'Stok Satış Değeri',
    'product_variety' => 'Ürün Çeşidi',
    'total_stock' => 'Toplam Stok',
    'search_product' => 'Ürün Ara',
    'product_name_or_barcode' => 'Ürün adı veya barkod...',
    'all_categories' => 'Tüm Kategoriler',
    'no_products_yet' => 'Henüz ürün eklenmemiş.',
    'no_products_matching_criteria' => 'Arama kriterlerine uygun ürün bulunamadı.',
    'add_first_product' => 'İlk Ürünü Ekle',
    'add_new_product' => 'Yeni Ürün Ekle',
    'image' => 'Resim',
    'stock' => 'Stok',
    'total_value' => 'Toplam Değer',
    'stock_detail_analysis' => 'Stok Detay Analizi',
    'product_details_stock_analysis' => 'Ürün detayları, stok hareketleri ve finansal analiz',
    'product_list' => 'Ürün Listesi',
    'all_movements' => 'Tüm Hareketler',
    'current_stock' => 'Mevcut Stok',
    'current_quantity' => 'Güncel miktar',
    'total_entry' => 'Toplam Giriş',
    'all_time' => 'Tüm zamanlar',
    'total_exit' => 'Toplam Çıkış',
    'profit_loss' => 'Kar/Zarar',
    'purchase_prices' => 'Alış Fiyatları',
    'purchase_price' => 'Alış Fiyatı',
    'purchase_price_2' => 'Alış Fiyatı 2',
    'average_cost' => 'Ortalama Maliyet',
    'sales_prices' => 'Satış Fiyatları',
    'sale_price' => 'Satış Fiyatı',
    'sale_price_2' => 'Satış Fiyatı 2',
    'profit_margin' => 'Kar Marjı',
    'stock_status' => 'Stok Durumu',
    'critical_stock' => 'Kritik Stok',
    'stock_value' => 'Stok Değeri',
    'filter_options' => 'Filtreleme Seçenekleri',
    'filter_description' => 'Stok hareketlerini belirli kriterlere göre filtreleyin',
    'customer_supplier' => 'Cari/Tedarikçi',
    'all' => 'Tümü',
    'movement_type' => 'Hareket Türü',
    'entry' => 'Giriş',
    'exit' => 'Çıkış',
    'inventory' => 'Stok',
    'transfer' => 'Transfer',
    'start_date' => 'Başlangıç',
    'end_date' => 'Bitiş',
    'filter' => 'Filtrele',
    'date' => 'Tarih',
    'amount' => 'Miktar',
    'unit_price' => 'Birim Fiyat',
    'total_amount' => 'Toplam Tutar',
    'invoice_info' => 'Fatura Bilgisi',
    'description' => 'Açıklama',
    'user' => 'Kullanıcı',
    'no_movements_found' => 'Seçilen kriterlere uygun stok hareketi bulunamadı.',
    'unknown' => 'Bilinmiyor',
    'in_currency' => 'cinsinden',
    'stock_movement_summary' => 'Stok Hareketi Özeti',
    'last_30_days' => 'Son 30 Gün',
    'this_month' => 'Bu Ay',
    'stock_movements' => 'Stok Hareketleri',
    'product_list' => 'Ürün Listesi',
    'error_loading_product_list' => 'Ürün listesi yüklenirken bir hata oluştu.',
    'error_loading_stock_movements' => 'Stok hareketleri yüklenirken bir veritabanı hatası oluştu.',
    'no_stock_movements_yet' => 'Henüz stok hareketi bulunmamaktadır.',
    'product_name_detail' => 'Ürün Adı / Detay',
    'transaction_type' => 'İşlem Türü',
    'entry' => 'Giriş',
    'exit' => 'Çıkış',
    'current' => 'Cari',
    'info' => 'Bilgi',
    'add_product' => 'Ürün Ekle',
    'product_information' => 'Ürün Bilgileri',
    'piece' => 'Adet',
    'kilogram' => 'Kilogram',
    'gram' => 'Gram',
    'liter' => 'Litre',
    'meter' => 'Metre',
    'package' => 'Paket',
    'box' => 'Kutu',
    'barcode' => 'Barkod',
    'read' => 'Oku',
    'barcode_reader_help' => 'Barkod okuyucu ile okutabilir veya manuel girebilirsiniz.',
    'select_category' => '-- Kategori Seçin --',
    'purchase_price' => 'Alış Fiyatı',
    'currency' => 'Para Birimi',
    'selling_price' => 'Satış Fiyatı',
    'vat_rate' => 'KDV Oranı (%)',
    'vat_free' => 'KDVsiz',
    'critical_stock_quantity' => 'Kritik Stok Miktarı',
    'warning_below_quantity' => 'Bu miktarın altında uyarı verilir.',
    'current_stock_initial' => 'Mevcut Stok (Başlangıç)',
    'initial_stock_help' => 'Ürün ilk eklendiğinde iş yerinde bulunan mevcut stok miktarı.',
    'product_images' => 'Ürün Resimleri',
    'upload_image' => 'Resim Yükle',
    'multiple_images_help' => 'Birden fazla resim seçebilirsiniz. Desteklenen formatlar: JPG, PNG.',
    'save_product' => 'Ürünü Kaydet',
    'product_added_successfully' => 'Ürün başarıyla eklendi.',
    'error_adding_product' => 'Ürün eklenirken bir hata oluştu.',
    'product_name_required' => 'Ürün adı zorunludur.',
    'valid_purchase_price_required' => 'Geçerli bir alış fiyatı giriniz.',
    'valid_selling_price_required' => 'Geçerli bir satış fiyatı giriniz.',
    'vat_rate_range' => 'KDV oranı 0-100 arasında olmalıdır.',
    'valid_critical_stock_required' => 'Geçerli bir kritik stok miktarı giriniz.',
    'barcode_already_used' => 'Bu barkod bu şirkette zaten kullanılıyor.',
    'please_correct_errors' => 'Lütfen hataları düzeltin',
    'delete_product' => 'Ürün Sil',
    'attention' => 'Dikkat!',
    'delete_warning' => 'Bu ürünü silmek üzeresiniz. Bu işlem geri alınamaz!',
    'when_product_deleted' => 'Ürün silindiğinde:',
    'removed_from_list' => 'Ürün listesinden kaldırılacak',
    'cannot_use_new_transactions' => 'Yeni satış/alış işlemlerinde kullanılamayacak',
    'existing_records_preserved' => 'Mevcut fatura ve stok hareketleri korunacak',
    'usage_status' => 'Kullanım Durumu',
    'product_to_delete' => 'Silinecek Ürün Bilgileri',
    'uncategorized' => 'Kategorisiz',
    'created_date' => 'Oluşturulma Tarihi',
    'delete_confirmation' => 'Silme Onayı',
    'type_yes_to_confirm' => 'Bu ürünü silmek istediğinizi onaylamak için <strong>"EVET"</strong> yazın:',
    'type_yes_placeholder' => 'EVET yazın...',
    'product_deleted_successfully' => 'Ürün başarıyla silindi.',
    'must_type_yes' => 'Silme işlemi için "EVET" yazmanız gerekiyor.',
    'invalid_product_id' => 'Geçersiz ürün IDsi.',
    'product_not_found_or_not_belongs' => 'Ürün bulunamadı veya bu şirkete ait değil.',
    'error_loading_product' => 'Ürün bilgileri yüklenirken bir hata oluştu.',
    'product_used_in_invoices' => 'Bu ürün :count adet fatura detayında kullanılmış.',
    'product_has_stock_movements' => 'Bu ürün için :count adet stok hareketi kaydı bulunuyor.',
    'product_used_in_quotes' => 'Bu ürün :count adet teklif detayında kullanılmış.',
    'error_deleting_product' => 'Ürün silinirken bir hata oluştu.',
    'invalid_request_method' => 'Geçersiz istek yöntemi.',
    'min_2_chars_or_select_supplier' => 'En az 2 karakter giriniz veya tedarikçi seçiniz.',
    'search_error' => 'Arama sırasında bir hata oluştu',
    
    // Stok Raporları / Stock Reports
    'detailed_stock_reports' => 'Detaylı Stok Raporları',
    'report_filters' => 'Rapor Filtreleri',
    'report_type' => 'Rapor Türü',
    'movement_details' => 'Hareket Detayları',
    'product_summary' => 'Ürün Bazında Özet',
    'customer_supplier_summary' => 'Müşteri/Tedarikçi Özeti',
    'stock_movements' => 'Stok Hareketleri',
    'product' => 'Ürün',
    'all_products' => 'Tüm Ürünler',
    'customer_supplier' => 'Müşteri/Tedarikçi',
    'all' => 'Tümü',
    'entry_purchase' => 'Giriş (Alış)',
    'exit_sale' => 'Çıkış (Satış)',
    'inventory_count' => 'Sayım',
    'get_report' => 'Raporu Getir',
    'reset' => 'Temizle',
    'stock_movement_details' => 'Stok Hareket Detayları',
    'product_summary_report' => 'Ürün Bazında Özet Rapor',
    'no_data_found' => 'Seçilen kriterlere uygun veri bulunamadı.',
    'date_range' => 'Tarih Aralığı',
    'start_date' => 'Başlangıç Tarihi',
    'end_date' => 'Bitiş Tarihi',
    'transaction_type' => 'İşlem Türü',
    'all_transactions' => 'Tüm İşlemler',
    'entry' => 'Giriş',
    'exit' => 'Çıkış',
    'date' => 'Tarih',
    'total_amount' => 'Toplam Tutar',
    'unit_price' => 'Birim Fiyat',
    'description' => 'Açıklama',
    'process_type' => 'İşlem Türü',
    'product_name' => 'Ürün Adı',
    'total_entry' => 'Toplam Giriş',
    'total_exit' => 'Toplam Çıkış',
    'net_quantity' => 'Net Miktar',
    'entry_amount' => 'Giriş Tutarı',
    'exit_amount' => 'Çıkış Tutarı',
    'net_amount' => 'Net Tutar',
    'transaction_count' => 'İşlem Sayısı',
    'current_stock' => 'Mevcut Stok',
    'customer_name' => 'Cari Adı',
    'total_purchase_quantity' => 'Toplam Alış Miktarı',
    'total_sales_quantity' => 'Toplam Satış Miktarı',
    'total_purchase_amount' => 'Toplam Alış Tutarı',
    'total_sales_amount' => 'Toplam Satış Tutarı',
    'different_products' => 'Farklı Ürün',
    'total_transactions' => 'Toplam İşlem',
    'total_entry_quantity' => 'Toplam Giriş Miktarı',
    'total_exit_quantity' => 'Toplam Çıkış Miktarı',
    'purchase_prices' => 'Alış Fiyatları',
    'purchase_price' => 'Alış Fiyatı 1',
    'purchase_price_2' => 'Alış Fiyatı 2',
    'average_cost' => 'Ortalama Maliyet',
    'sales_prices' => 'Satış Fiyatları',
    'sale_price' => 'Satış Fiyatı 1',
    'sale_price_2' => 'Satış Fiyatı 2',
    'profit_margin' => 'Kar Marjı',
    'stock_status' => 'Stok Durumu',
    'filter_options' => 'Filtreleme Seçenekleri',
    'filter_description' => 'Stok hareketlerini belirli kriterlere göre filtreleyin',
    'last_30_days' => 'Son 30 Gün',
    'this_month' => 'Bu Ay',
    'critical_stock' => 'Kritik Stok',
    'stock_value' => 'Stok Değeri',
    'profit_margin_1' => 'Kar Marjı 1',
    'start' => 'Başlangıç',
    'end' => 'Bitiş',
    'current_quantity' => 'Mevcut Miktar',
    'all_time' => 'Tüm Zamanlar',
    'stock_detail' => 'Stok Detayı',
    'all_movements' => 'Tüm Hareketler',
    'customer_supplier' => 'Cari/Tedarikçi',
    'profit_margin' => 'Kar Marjı',
    'average_exit_price' => 'Ortalama Çıkış Fiyatı',
    'average_entry_price' => 'Ortalama Giriş Fiyatı',
    'stock_turnover_rate' => 'Stok Devir Hızı',
    'performance_analysis' => 'Performans Analizi',
    'movement_type' => 'Hareket Türü',
    'invoice_info' => 'Fatura Bilgisi',
    'financial_summary' => 'Finansal Özet',
    'total_purchase_amount' => 'Toplam Alış Tutarı',
    'total_sales_amount' => 'Toplam Satış Tutarı',
    'current_stock_value' => 'Mevcut Stok Değeri',
    'total_profit_loss' => 'Toplam Kar/Zarar',
    'product_management' => 'Ürün Yönetimi',
    'add_new_product' => 'Yeni Ürün Ekle',
    'product_variety' => 'Ürün Çeşidi',
    'total_stock' => 'Toplam Stok',
    'stock_purchase_value' => 'Stok Alış Değeri',
    'stock_sale_value' => 'Stok Satış Değeri',
    'total_value_in_tl' => 'Toplam değer TL karşılığı',
    'product_search' => 'Ürün Ara',
    'product_search_placeholder' => 'Ürün adı veya barkod...',
    'category' => 'Kategori',
    'all_categories' => 'Tüm Kategoriler',
    'search' => 'Ara',
    'product_list' => 'Ürün Listesi',
    'no_products_added' => 'Henüz ürün eklenmemiş.',
    'no_products_found' => 'Arama kriterlerine uygun ürün bulunamadı.',
    'add_first_product' => 'İlk Ürünü Ekle',
    'image' => 'Resim',
    'product_name' => 'Ürün Adı',
    'barcode' => 'Barkod',
    'unit' => 'Birim',
    'purchase_price' => 'Alış Fiyatı',
    'sale_price' => 'Satış Fiyatı',
    'vat' => 'KDV',
    'vat_free' => 'KDV\'siz',
    'stock' => 'Stok',
    'critical_stock_level' => 'Kritik Stok',
    'total_value' => 'Toplam Değer',
    'actions' => 'İşlemler',
    'edit' => 'Düzenle',
    'stock_detail_analysis' => 'Stok Detay Analizi',
    'stock_movements' => 'Stok Hareketleri',



    // Product Edit Page
    'edit_product' => 'Ürün Düzenle',
    'invalid_product_id' => 'Geçersiz ürün ID\'si.',
    'product_not_found' => 'Ürün bulunamadı veya bu şirkete ait değil.',
    'invalid_form_submission' => 'Geçersiz form gönderimi!',
    'product_name_required' => 'Ürün adı zorunludur.',
    'valid_purchase_price' => 'Geçerli bir alış fiyatı giriniz.',
    'valid_sale_price' => 'Geçerli bir satış fiyatı giriniz.',
    'valid_vat_rate' => 'KDV oranı 0-100 arasında olmalıdır.',
    'barcode_in_use' => 'Bu barkod zaten başka bir ürün tarafından kullanılıyor.',
    'product_updated' => 'Ürün bilgileri başarıyla güncellendi.',
    'product_update_error' => 'Ürün güncellenirken bir hata oluştu.',
    'image_upload_error' => 'Ürün resmi yüklenirken bir hata oluştu.',
    'image_uploaded' => 'Yeni resim başarıyla eklendi.',
    'product_list' => 'Ürün Listesi',
    'delete' => 'Sil',
    'delete_confirm' => 'Bu ürünü ve ilgili tüm stok kayıtlarını kalıcı olarak silmek istediğinizden emin misiniz? Bu işlem geri alınamaz.',
    'product_info' => 'Ürün Bilgileri',
    'product_name' => 'Ürün Adı',
    'unit' => 'Birim',
    'piece' => 'Adet',
    'kg' => 'Kilogram',
    'gram' => 'Gram',
    'liter' => 'Litre',
    'meter' => 'Metre',
    'package' => 'Paket',
    'box' => 'Kutu',
    'purchase_price' => 'Alış Fiyatı',
    'sale_price' => 'Satış Fiyatı',
    'vat_rate' => 'KDV Oranı',
    'barcode' => 'Barkod',
    'category' => 'Kategori',
    'select_category' => 'Kategori Seçin',
    'critical_stock' => 'Kritik Stok',
    'initial_stock' => 'Başlangıç Stok Miktarı',
    'description' => 'Açıklama',
    'save_changes' => 'Değişiklikleri Kaydet',
    'product_images' => 'Ürün Resimleri',
    'set_as_default' => 'Varsayılan Yap',
    'delete_image' => 'Resmi Sil',
    'add_image' => 'Resim Ekle',
    'drag_drop_image' => 'Resmi sürükleyip bırakın veya tıklayın',
    'or' => 'veya',
    'browse' => 'Gözat',
    'upload' => 'Yükle',
    'please_fix_errors' => 'Lütfen hataları düzeltin:',
    'product_information' => 'Ürün Bilgileri',
    'product_images' => 'Ürün Resimleri',
    'upload_selected' => 'Seçilenleri Yükle',
    'initial_stock_note' => 'Bu değer sadece stok başlangıç değeridir, düzenlenemez',
    'stock_movements' => 'Stok Hareketleri',
    'update_information' => 'Bilgileri Güncelle',
    'low_stock_warning' => 'Bu miktarın altında stok uyarısı verilir',
    'critical_stock_amount' => 'Kritik Stok Miktarı',
    'add_product' => 'Ürün Ekle',
    'product_information' => 'Ürün Bilgileri',
    'product_name_required' => 'Ürün adı zorunludur',
    'barcode' => 'Barkod',
    'barcode_scan' => 'Oku',
    'barcode_scan_help' => 'Barkod okuyucu ile okutabilir veya manuel girebilirsiniz',
    'category' => 'Kategori',
    'select_category' => 'Kategori Seçin',
    'unit' => 'Birim',
    'piece' => 'Adet',
    'kg' => 'Kilogram',
    'gram' => 'Gram',
    'liter' => 'Litre',
    'meter' => 'Metre',
    'package' => 'Paket',
    'box' => 'Kutu',
    'purchase_price' => 'Alış Fiyatı',
    'sale_price' => 'Satış Fiyatı',
    'vat_rate' => 'KDV Oranı',
    'vat_free' => 'KDV Hariç',
    'vat_included' => 'KDV Dahil',
    'critical_stock' => 'Kritik Stok',
    'initial_stock' => 'Başlangıç Stok',
    'description' => 'Açıklama',
    'product_images' => 'Ürün Resimleri',
    'upload_image' => 'Resim Yükle',
    'multiple_images_help' => 'Birden fazla resim seçebilirsiniz. Desteklenen formatlar: JPG, PNG',
    'save_product' => 'Ürünü Kaydet',
    'cancel' => 'İptal',
    'back_to_products' => 'Ürün Listesine Dön',
    'product_added_success' => 'Ürün başarıyla eklendi',
    'error_adding_product' => 'Ürün eklenirken bir hata oluştu',
    'invalid_form_submission' => 'Geçersiz form gönderimi',
    'barcode_already_exists' => 'Bu barkod zaten kullanılıyor',
    'invalid_price' => 'Geçersiz fiyat değeri',
    'invalid_stock_value' => 'Geçersiz stok değeri',
    'invalid_vat_rate' => 'Geçersiz KDV oranı (0-100 arasında olmalıdır)',
    
    // Cariler (Customers/Accounts)
    'customer_management' => 'Cari Yönetimi',
    'add_new_customer' => 'Yeni Cari Ekle',
    'customer_name_required' => 'Ad Soyad / Firma Adı zorunludur',
    'customer_group_required' => 'Cari grubu seçilmelidir',
    'customer_added_success' => 'Cari başarıyla eklendi',
    'error_adding_customer' => 'Cari eklenirken bir hata oluştu',
    'customer_list' => 'Cari Listesi',
    'customer_details' => 'Cari Detayları',
    'customer_name' => 'Ad Soyad / Firma',
    'phone' => 'Telefon',
    'address' => 'Adres',
    'group' => 'Grup',
    'select_group' => 'Grup Seçin',
    'total_debt' => 'Toplam Borç',
    'total_credit' => 'Toplam Alacak',
    'net_balance' => 'Net Bakiye',
    'customer' => 'Müşteri',
    'supplier' => 'Tedarikçi',
    'debtor' => 'Borçlu',
    'creditor' => 'Alacaklı',
    'total_customers' => 'Toplam Cari',
    'total_supplier_debt' => 'Toplam Tedarikçi Borcu',
    'total_customer_debt' => 'Toplam Müşteri Borcu',
    'balance_summary' => 'Bakiye Özeti',
    'balance_description' => 'İşaretler: B = Borçlu (Müşteri bize borçlu), A = Alacaklı (Biz müşteriye borçluyuz)',
    'customer_transactions' => 'Cari İşlemleri',
    'edit_customer' => 'Cari Düzenle',
    'delete_customer' => 'Cari Sil',
    'delete_customer_confirm' => 'Bu cariyi silmek istediğinize emin misiniz? Bu cariye ait TÜM işlemler (satış, alış, ödeme vb.) SİLİNMEZ ancak cari bilgisi kaybolur. Bu işlem önerilmez, bunun yerine cariyi pasif yapmayı düşünebilirsiniz. Yine de silmek istiyor musunuz?',
    'customer_not_found' => 'Cari bulunamadı',
    'customer_updated' => 'Cari bilgileri güncellendi',
    'error_updating_customer' => 'Cari güncellenirken bir hata oluştu',
    'customer_deleted' => 'Cari silindi',
    'error_deleting_customer' => 'Cari silinirken bir hata oluştu',
    'customer_search_placeholder' => 'İsim, telefon veya grup ara...',
    'customer_balance' => 'Cari Bakiye',
    'customer_transactions' => 'Cari Hareketleri',
    'no_customers_found' => 'Kayıtlı cari bulunamadı',
    'customer_type' => 'Cari Türü',
    'customer_type_customer' => 'Müşteri',
    'customer_type_supplier' => 'Tedarikçi',
    'customer_type_both' => 'Her İkisi',
    'only_positive_debts' => 'Sadece pozitif borçlar',
    'total_of_all_customers' => 'Tüm carilerin toplamı',
    'debtor_short' => 'B',
    'creditor_short' => 'A',
    'customer_debt_to_us' => 'Müşterinin Borcu (Bize)',
    'our_debt_to_supplier' => 'Bizim Borcumuz (Tedarikçiye)',
    'customer_management_description' => 'Şirkete kayıtlı cari hesapların yönetimi',
    'edit_customer' => 'Cari Düzenle',
    'customer_not_found' => 'Cari bulunamadı veya bu şirkete ait değil.',
    'customer_updated' => 'Cari başarıyla güncellendi.',
    'error_updating_customer' => 'Cari güncellenirken hata oluştu.',
    'back_to_customer' => 'İptal',


    // Account Transactions / Hesap İşlemleri
    'period_totals' => 'Dönem Toplamları',
    'period_net_balance' => 'Dönem Net Bakiyesi',
    'related_transaction' => 'İlişkili İşlem',
    'account' => 'Hesap',
    'account_transactions' => 'Hesap Hareketleri',
    'transaction_details' => 'İşlem Detayları',
    'transaction_id' => 'İşlem No',
    'transaction_type' => 'İşlem Türü',
    'entry' => 'Giriş',
    'exit' => 'Çıkış',
    'transfer' => 'Transfer',
    'entry_collection' => 'Giriş (Tahsilat vb.)',
    'exit_payment' => 'Çıkış (Ödeme vb.)',
    'entry_payment' => 'Giriş (Ödeme vb.)',
    'exit_collection' => 'Çıkış (Tahsilat vb.)',
    'entry_debit' => 'Giriş (Borç vb.)',
    'exit_credit' => 'Çıkış (Alacak vb.)',
    'entry_credit' => 'Giriş (Alacak vb.)',
    'exit_debit' => 'Çıkış (Borç vb.)',
    'entry_transfer' => 'Giriş (Transfer vb.)',
    'accounts' => 'Hesaplar',
    'all_accounts' => 'Tüm Hesaplar',
    'all_customers' => 'Tüm Cariler',
    'all_types' => 'Tüm Türler',
    'apply_filter' => 'Filtrele',
    'clear_filter' => 'Filtreyi Temizle',
    'no_transactions_found' => 'Seçili kriterlere uygun hesap hareketi bulunamadı.',
    'target' => 'Hedef',
    'debt_id' => 'Borç ID',
    'invoice' => 'Fatura',
    'download_receipt' => 'Makbuz İndir',
    'view_details' => 'Detayları Görüntüle',
    'edit' => 'Düzenle',
    'delete' => 'Sil',
    'multiple' => 'Çoklu',
    'confirm_delete_transaction' => 'Bu hesap hareketini silmek istediğinizden emin misiniz?',
    'transaction_deleted_successfully' => 'Hesap hareketi başarıyla silindi.',
    'error_deleting_transaction' => 'Hesap hareketi silinirken bir hata oluştu. Lütfen tekrar deneyin.',
    'transaction_updated_successfully' => 'Hesap hareketi başarıyla güncellendi.',
    'error_updating_transaction' => 'Hesap hareketi güncellenirken bir hata oluştu. Lütfen tekrar deneyin.',
    'details_not_loaded' => 'Detaylar yüklenemedi',
    'unknown_error' => 'Bilinmeyen hata',
    // Account Statement / Cari Ekstre
    'account_statement' => 'Cari Ekstre',
    'statement' => 'Ekstre',
    'please_select_an_account' => 'Lütfen Bir Cari Hesap Seçin',
    'period_selection' => 'Dönem Seçimi',
    'start_date' => 'Başlangıç Tarihi',
    'end_date' => 'Bitiş Tarihi',
    'get' => 'Getir',
    'this_month' => 'Bu Ay',
    'last_month' => 'Geçen Ay',
    'download_pdf' => 'PDF İndir',
    'print' => 'Yazdır',
    'date' => 'Tarih',
    'description' => 'Açıklama',
    'debit' => 'Borç',
    'credit' => 'Alacak',
    'balance' => 'Bakiye',
    'opening_balance' => 'Devir Bakiye',
    'before' => 'öncesi',
    'no_transactions_found_in_selected_period' => 'Seçilen tarih aralığında hareket bulunamadı.',
    'period_totals' => 'Dönem İçi Toplamlar',
    'closing_balance' => 'Son Bakiye',
    'selected_account_not_found_or_error_loading' => 'Seçilen cari bulunamadı veya yüklenirken bir hata oluştu.',
    'please_select_an_account_to_view_statement' => 'Lütfen ekstre görüntülemek için yukarıdan bir cari seçiniz.',
    'no_accounts_found_in_system' => 'Sistemde kayıtlı cari bulunmamaktadır.',
    'specified_account_id_not_found_or_not_belongs_to_company' => 'Belirtilen Cari ID bulunamadı veya bu şirkete ait değil.',
    'database_error_while_creating_statement' => 'Ekstre oluşturulurken bir veritabanı hatası oluştu.',
    
    // Kasa Gider Makbuzları
    'cash_expense_receipts' => 'Kasa Gider Makbuzları',
    'and_transactions' => 've Transfer İşlemleri',
    'new_receipt' => 'Yeni Makbuz',
    'total_receipts' => 'Toplam Makbuz',
    'total_expense' => 'Toplam Gider',
    'average_expense' => 'Ortalama Gider',
    'minimum_expense' => 'En Düşük Gider',
    'maximum_expense' => 'En Yüksek Gider',
    'filtering_and_search' => 'Filtreleme ve Arama',
    'search_description' => 'Açıklama Arama',
    'search_description_placeholder' => 'Açıklama ara...',
    'filter' => 'Filtrele',
    'clear' => 'Temizle',
    'cash_expense_receipts_and_transactions' => 'Kasa Gider Makbuzları ve Transfer İşlemleri',
    'no_cash_expense_receipts_found' => 'Belirtilen kriterlere uygun kasa gider makbuzu bulunamadı.',
    'transaction_type' => 'İşlem Türü',
    'actions' => 'İşlemler',
    'transfer_out' => 'Transfer Çıkışı',
    'expense' => 'Gider',
    'view_pdf' => 'PDF Görüntüle',
    'page_navigation' => 'Sayfa Navigasyonu',
    'edit_cash_expense_receipt' => 'Kasa Gider Makbuzu Düzenle',
    'update' => 'Güncelle',
    'confirm_receipt_deletion' => 'Makbuz Silme Onayı',
    'are_you_sure_delete_receipt' => 'Bu kasa gider makbuzunu silmek istediğinizden emin misiniz?',
    'warning' => 'Uyarı',
    'this_action_cannot_be_undone' => 'Bu işlem geri alınamaz ve makbuz tutarı hesaba geri eklenecektir.',
    'yes_delete' => 'Evet, Sil',
    'invalid_form_submission' => 'Geçersiz form gönderimi!',
    'cash_expense_receipt_updated_successfully' => 'Kasa gider makbuzu başarıyla güncellendi.',
    'record_to_update_not_found' => 'Güncellenecek kayıt bulunamadı.',
    'error_occurred_while_updating' => 'Güncelleme sırasında hata oluştu',
    'please_fill_all_fields_correctly' => 'Tüm alanları doğru şekilde doldurunuz.',
    'invalid_security_key' => 'Geçersiz güvenlik anahtarı!',
    'cash_expense_receipt_deleted_successfully' => 'Kasa gider makbuzu başarıyla silindi.',
    'record_to_delete_not_found' => 'Silinecek kayıt bulunamadı.',
    'error_occurred_while_deleting' => 'Silme sırasında hata oluştu',
    'cash_expense_receipt_updated' => 'Kasa gider makbuzu güncellendi',
    
    // Reports Page Additions
    'odjoo_management' => 'Begeb Creative Yönetim',
    'date_range_filtering' => 'Tarih Aralığı Filtreleme',
    'start_date' => 'Başlangıç Tarihi',
    'end_date' => 'Bitiş Tarihi',
    'debts_by_category' => 'Kategori Bazında Borçlar',
    'delay' => 'Gecikme',
    'description' => 'Açıklama',
    'receivable' => 'Alacak',
    'debt' => 'Borç',
    'day_late_singular' => 'gün gecikme',
    'days_late_plural' => 'gün gecikme',
    'total_liabilities' => 'Toplam Yükümlülükler',
    'equity_percentage' => 'Özkaynak %',
    'net_current_position' => 'Net Cari Pozisyon',
    'our_total_receivables' => 'Toplam Alacaklarımız',
    'receivables_from_customers' => 'Müşterilerden alacaklarımız',
    'our_total_debts' => 'Toplam Borçlarımız',
    'debts_to_suppliers' => 'Tedarikçilere borçlarımız',
    'total_stock_value_original' => 'Genel Stok Değeri Toplamı (Orijinal)',
    'multiple_currencies' => 'Çoklu Para Birimi',
    'stock_information' => 'Stok Bilgileri',
    'stock_product_count' => 'Stok Ürün Sayısı',
    'total_product_variety' => 'Toplam Ürün Çeşidi',
    'total_stock_quantity' => 'Toplam Stok Miktarı',
    'filter' => 'Filtrele',
    'clear_filter' => 'Filtreyi Temizle',
    'total_balance' => 'Toplam Bakiye',
    'total_assets' => 'Toplam Varlıklar',
    'financial_status' => 'Finansal Durum',
    'our_receivables_exceed_debts' => 'Alacaklarımız borçlarımızdan fazla',
    'our_debts_exceed_receivables' => 'Borçlarımız alacaklarımızdan fazla',
    'net_position' => 'Net Pozisyon',
    'cash_expense_receipt_deleted' => 'Kasa gider makbuzu silindi',
    
    // Users Page
    'user_management' => 'Kullanıcı Yönetimi',
    'no_permission_to_access_this_page' => 'Bu sayfaya erişim yetkiniz bulunmamaktadır.',
    'company_selection_required' => 'Şirket seçimi yapılmadan bu sayfaya erişilemez.',
    'user_status_updated_successfully' => 'Kullanıcı durumu başarıyla güncellendi.',
    'admin' => 'Admin',
    'manager' => 'Yönetici',
    'user' => 'Kullanıcı',
    'users' => 'Kullanıcılar',
    'guest' => 'Misafir',
    'odjoo_management' => 'Begeb Creative Yönetim',
    'new_user' => 'Yeni Kullanıcı',
    'filters' => 'Filtreler',
    'permission_level' => 'Yetki Seviyesi',
    'all' => 'Tümü',
    'status' => 'Durum',
    'active' => 'Aktif',
    'inactive' => 'Pasif',
    'search' => 'Ara',
    'search_users_placeholder' => 'Kullanıcı adı, ad soyad veya e-posta',
    'clear' => 'Temizle',
    'username' => 'Kullanıcı Adı',
    'full_name' => 'Ad Soyad',
    'email' => 'E-posta',
    'actions' => 'İşlemler',
    'you' => 'Siz',
    'no_users_found' => 'Kullanıcı bulunamadı',
    'no_users_matching_criteria' => 'Belirtilen kriterlere uygun kullanıcı bulunmamaktadır.',
    'edit' => 'Düzenle',
    'delete' => 'Sil',
    'last_login' => 'Son Giriş',
    'registration_date' => 'Kayıt Tarihi',
    'login_count' => '%d giriş',
    'never_logged_in' => 'Hiç giriş yapmamış',
    'created_by' => 'Oluşturan: %s',
    'deactivate' => 'Pasif Yap',
    'activate' => 'Aktif Yap',
    'confirm_change_user_status' => 'Kullanıcı durumunu değiştirmek istediğinizden emin misiniz?',
    'confirm_delete_user' => 'Bu kullanıcıyı silmek istediğinizden emin misiniz? Bu işlem geri alınamaz!',
    'database_error' => 'Veritabanı hatası',
    'edit_user' => 'Kullanıcı Düzenle',
    'invalid_user_id' => 'Geçersiz kullanıcı ID\'si.',
    'user_not_found' => 'Kullanıcı bulunamadı.',
    'error_loading_user' => 'Kullanıcı bilgileri yüklenirken bir hata oluştu.',
    'invalid_form_submission' => 'Geçersiz form gönderimi!',
    'username_required' => 'Kullanıcı adı boş bırakılamaz.',
    'full_name_required' => 'Ad Soyad boş bırakılamaz.',
    'permission_level_required' => 'Yetki seviyesi boş bırakılamaz.',
    'password_min_length' => 'Şifre en az 6 karakter olmalıdır.',
    'passwords_do_not_match' => 'Şifreler uyuşmuyor.',
    'user_updated_successfully' => 'Kullanıcı başarıyla güncellendi.',
    'error_updating_user' => 'Kullanıcı güncellenirken bir hata oluştu.',
    'please_correct_errors' => 'Lütfen hataları düzeltin',
    'new_password_leave_blank' => 'Yeni Şifre (Değiştirmek istemiyorsanız boş bırakın)',
    'confirm_new_password' => 'Yeni Şifre Tekrar',
    'update_user' => 'Kullanıcıyı Güncelle',
    'go_back' => 'Geri Dön',
    // Raporlar Sayfası
    'reports' => 'Raporlar',
    'income_expense_summary' => 'Gelir-Gider Özeti',
    'account_balances' => 'Hesap Bakiyeleri',
    'overdue_debts_credits' => 'Vadesi Geçmiş Borçlar/Alacaklar',
    'financial_status_summary' => 'Finansal Durum Özeti',
    'liabilities' => 'Yükümlülükler',
    'net_worth' => 'Net Değer',
    'stock_value_report' => 'Stok Değer Raporu',
    'in_tl' => 'TL Karşılığı',
    'debug_information' => 'Hata Ayıklama Bilgileri',
    'total_income' => 'Toplam Gelir',
    'total_expense' => 'Toplam Gider',
    'net_status' => 'Net Durum',
    'account_name' => 'Hesap Adı',
    'account_type' => 'Hesap Türü',
    'balance' => 'Bakiye',
    'no_overdue_debts_or_credits_found' => 'Vadesi geçmiş borç veya alacak bulunmamaktadır.',
    'assets' => 'Varlıklar',
    'cash_bank' => 'Kasa & Banka',
    'customer_receivables' => 'Müşteri Alacakları',
    'stock_value' => 'Stok Değeri',
    'supplier_debts' => 'Tedarikçi Borçları',
    'credit_card' => 'Kredi Kartı',
    'type' => 'Tür',
    'current' => 'Cari',
    'amount' => 'Tutar',
    'due_date' => 'Vade Tarihi',
    'product_name' => 'Ürün Adı',
    'stock_quantity' => 'Stok Miktarı',
    'unit_purchase_price' => 'Birim Alış Fiyatı',
    'original_value' => 'Orijinal Değer',
    'equivalent_in_tl' => 'TL Karşılığı',
    'exchange_rates' => 'Döviz Kurları',
    'currency' => 'Para Birimi',
    'rate' => 'Kur',
    'days_late' => 'gün gecikme',
    'days_late_singular' => 'gün gecikme',
    'days_late_plural' => 'gün gecikme',
    'an_error_occurred_while_retrieving_reports_please_try_again_later' => 'Raporlar alınırken hata oluştu. Lütfen daha sonra tekrar deneyin.',
    'assets_liabilities' => 'Varlıklar - Yükümlülükler',
    'save_changes' => 'Kaydet',
    'customer_name_label' => 'Ad Soyad',
    'phone_label' => 'Telefon',
    'address_label' => 'Adres',
    'customer_group_label' => 'Cari Grubu',
    'invalid_company' => 'Bu işlemi yapmaya yetkiniz yok.',
    
    // User Management / Kullanıcı Yönetimi
    'add_new_user' => 'Yeni Kullanıcı Ekle',
    'user_information' => 'Kullanıcı Bilgileri',
    'username_allowed_chars' => 'Sadece harf, rakam, alt çizgi ve nokta kullanabilirsiniz',
    'password' => 'Şifre',
    'confirm_password' => 'Şifre Tekrar',
    'description' => 'Açıklama',
    'user_active' => 'Kullanıcı aktif',
    'add_user' => 'Kullanıcı Ekle',
    'user_added_successfully' => 'Kullanıcı başarıyla eklendi',
    'error_adding_user' => 'Kullanıcı eklenirken bir hata oluştu',
    'permission_level_descriptions' => 'Yetki Seviyesi Açıklamaları',
    'can_do_all_operations' => 'Tüm işlemleri yapabilir',
    'user_management' => 'Kullanıcı Yönetimi',
    'system_settings' => 'Sistem Ayarları',
    'log_records' => 'Log Kayıtları',
    'stock_management' => 'Stok Yönetimi',
    'sales_purchase_operations' => 'Satış/Alış İşlemleri',
    'current_account_management' => 'Cari Yönetimi',
    'account_management' => 'Hesap Yönetimi',
    'reports_and_invoices' => 'Raporlar ve Faturalar',
    'sales_operations' => 'Satış İşlemleri',
    'view_stock' => 'Stok Görüntüleme',
    'view_current_account' => 'Cari Görüntüleme',
    'invoice_operations' => 'Fatura İşlemleri',
    'only_view_stock' => 'Sadece stok görüntüleme',
    'view_reports' => 'Raporları görüntüleme',
    'admin' => 'Yönetici',
    'manager' => 'Müdür',
    'user' => 'Kullanıcı',
    'guest' => 'Misafir',
    
    // Log Management / Log Yönetimi
    'log_records' => 'Log Kayıtları',
    'record_restored_successfully' => 'Kayıt başarıyla geri alındı.',
    'error_restoring_record' => 'Kayıt geri alınırken bir hata oluştu.',
    'filters' => 'Filtreler',
    'all' => 'Tümü',
    'operation_type' => 'İşlem Türü',
    'table' => 'Tablo',
    'start_date' => 'Başlangıç Tarihi',
    'end_date' => 'Bitiş Tarihi',
    'filter' => 'Filtrele',
    'clear' => 'Temizle',
    'records' => 'kayıt',
    'date_time' => 'Tarih/Saat',
    'user' => 'Kullanıcı',
    'operation' => 'İşlem',
    'record_id' => 'Kayıt ID',
    'description' => 'Açıklama',
    'ip_address' => 'IP Adresi',
    'actions' => 'İşlemler',
    'system' => 'Sistem',
    'view' => 'Görüntüle',
    'confirm_restore_record' => 'Bu kaydı geri almak istediğinizden emin misiniz?',
    'restore' => 'Geri Al',
    'restored' => 'Geri Alındı',
    'no_restore_info' => 'Geri Alma Bilgisi Yok',
    'log_details' => 'Log Detayları',
    'user_agent' => 'Tarayıcı Bilgisi',
    'old_values' => 'Eski Değerler',
    'new_values' => 'Yeni Değerler',
    'previous' => 'Önceki',
    'next' => 'Sonraki',
    'no_logs_found' => 'Log kaydı bulunamadı',
    'no_logs_matching_criteria' => 'Belirtilen kriterlere uygun log kaydı bulunmamaktadır.',
    
    // Settings / Ayarlar
    'site_settings' => 'Site Ayarları',
    'settings_menu' => 'Ayarlar Menüsü',
    'module_settings' => 'Modül Ayarları',
    'cash_and_bank_accounts' => 'Kasa ve Banka Hesapları',
    'categories' => 'Kategoriler',
    'current_account_groups' => 'Cari Grupları',
    'stock_settings' => 'Stok Ayarları',
    'invoices' => 'Faturalar',
    'invoice_settings' => 'Fatura Ayarları',
    'show_product_quantities_in_invoices' => 'Faturalarda ürün adetleri gösterilsin mi?',
    'show_product_quantities_in_invoices_help' => 'Bu seçenek aktif edildiğinde, faturalarda her ürünün miktarı (adet) görüntülenecektir.',
    'total_products' => 'Toplam Ürün',
    'total_products_in_invoice' => 'Toplam %s adet ürün bulunmaktadır.',
    'items' => 'Adet',
    'company_management' => 'Firma Yönetimi',
    'permission_levels' => 'Yetki Seviyeleri',
    'screen_lock' => 'Ekran Kilidi',
    
    // Module Settings / Modül Ayarları
    'invalid_security_token' => 'Geçersiz güvenlik tokenı!',
    'settings_saved_successfully' => 'Ayarlar başarıyla kaydedildi!',
    'error_saving_settings' => 'Ayarlar kaydedilirken bir hata oluştu',
    'enable_quotes_module' => 'Teklifler Modülünü Aktif Et',
    'enable_quotes_module_description' => 'Teklifler modülünün menüde ve ilgili yerlerde görünür olup olmadığını kontrol eder.',
    'enable_stock_operations' => 'Stok İşlemlerini Aktif Et',
    'enable_stock_operations_description' => 'Bu seçenek aktif edildiğinde, stok yönetimi ile ilgili menüler, raporlar ve işlemler görünür olur. Pasif edildiğinde stokla ilgili tüm özellikler gizlenir ve ürün hareketleri sadece tutar üzerinden yönetilir.',
    'save_settings' => 'Ayarları Kaydet',
    
    // Account Management / Hesap Yönetimi
    'account_management' => 'Hesap Yönetimi',
    'existing_accounts' => 'Mevcut Hesaplar',
    'account_name' => 'Hesap Adı',
    'account_type' => 'Hesap Türü',
    'initial_balance' => 'Başlangıç Bakiyesi',
    'current_balance' => 'Mevcut Bakiye',
    'currency' => 'Para Birimi',
    'actions' => 'İşlemler',
    'edit' => 'Düzenle',
    'delete' => 'Sil',
    'transactions' => 'Hareketler',
    'no_accounts_found' => 'Henüz hiç hesap eklenmemiş.',
    'add_new_account' => 'Yeni Hesap Ekle',
    'edit_account' => 'Hesap Düzenle',
    'update_account' => 'Hesabı Güncelle',
    'add_account' => 'Hesap Ekle',
    'select_option' => 'Seçiniz',
    'bank' => 'Banka',
    'cash' => 'Kasa',
    'credit_card' => 'Kredi Kartı',
    'turkish_lira' => 'Türk Lirası',
    'us_dollar' => 'Amerikan Doları',
    'euro' => 'Euro',
    'british_pound' => 'İngiliz Sterlini',
    'initial_balance_not_editable' => 'Başlangıç bakiyesi güncellenemez. Hesap hareketleri ile değiştirilebilir.',
    'example' => 'Örn',
    'or' => 'veya',
    'cancel' => 'İptal',
    'account_name_already_exists' => 'Bu hesap adı zaten mevcut!',
    'account_updated_successfully' => 'Hesap başarıyla güncellendi.',
    'account_added_successfully' => 'Hesap başarıyla eklendi.',
    'account_deleted_successfully' => 'Hesap başarıyla silindi.',
    'account_not_found_or_not_owned' => 'Hesap bulunamadı veya bu şirkete ait değil.',
    'cannot_delete_account_with_transactions' => 'Bu hesaba bağlı hareketler olduğu için silinemez. Önce ilgili hareketleri silin veya başka bir hesaba aktarın.',
    'confirm_delete_account' => 'Bu hesabı silmek istediğinize emin misiniz? Bu hesaba bağlı hareketler varsa silinemez!',
    'account_name_type_currency_required' => 'Hesap adı, türü ve para birimi boş olamaz.',
    'account_operation_error' => 'Hesap işlemi sırasında bir hata oluştu',
    'error_loading_accounts' => 'Hesaplar yüklenirken bir hata oluştu',
    'currency_formatting_script' => 'Para birimi formatlama için betik',
    'convert_to_numeric_on_focus' => 'Odaklandığında Türkçe formatı sayısal formata çevir',
    'convert_to_currency_on_blur' => 'Odaktan çıktığında tekrar Türkçe para birimi formatına çevir',
    'format_existing_value_on_load' => 'Sayfa yüklendiğinde mevcut değeri formatla',
    'account_updated_log' => 'Hesap güncellendi: :account (:currency)',
    'account_added_log' => 'Yeni hesap eklendi: :account (:currency)',
    'account_deleted_log' => 'Hesap silindi: :account',
    
    // Category Management / Kategori Yönetimi
    'category_management' => 'Kategori Yönetimi',
    'transaction_categories' => 'İşlem Kategorileri (Gider/Gelir)',
    'product_categories' => 'Ürün Kategorileri',
    'category_name' => 'Kategori Adı',
    'category_not_found' => 'Kategori bulunamadı.',
    'error_loading_category' => 'Kategori bilgileri alınırken hata oluştu.',
    'invalid_category_type' => 'Geçersiz kategori tipi.',
    'category_name_required' => 'Kategori adı boş olamaz.',
    'category_name_already_exists' => 'Bu kategori adı zaten başka bir kategori tarafından kullanılıyor!',
    'category_name_exists_for_type' => 'Bu kategori adı bu tip için zaten mevcut!',
    'category_updated_successfully' => 'Kategori başarıyla güncellendi.',
    'category_added_successfully' => 'Kategori başarıyla eklendi.',
    'error_loading_categories' => 'Kategoriler yüklenirken bir hata oluştu.',
    'edit_category' => 'Kategori Düzenle',
    'add_new_product_category' => 'Yeni Ürün Kategorisi Ekle',
    'add_new_transaction_category' => 'Yeni İşlem Kategorisi Ekle',
    'save_category' => 'Kategoriyi Kaydet',
    'update' => 'Güncelle',
    'cancel' => 'İptal',
    'existing_product_categories' => 'Mevcut Ürün Kategorileri',
    'existing_transaction_categories' => 'Mevcut İşlem Kategorileri',
    'actions' => 'İşlemler',
    
    // Company Management / Firma Yönetimi
    'company_management' => 'Firma Yönetimi',
    'company_logo' => 'Firma Logosu',
    'upload_logo' => 'Logo Yükle',
    'change_logo' => 'Logoyu Değiştir',
    'remove_logo' => 'Logoyu Kaldır',
    'logo_upload_help' => 'Maksimum boyut: 2MB. İzin verilen formatlar: JPG, JPEG, PNG, GIF.',
    'logo_uploaded_success' => 'Logo başarıyla yüklendi.',
    'logo_upload_failed' => 'Logo yüklenirken bir hata oluştu.',
    'logo_removed_success' => 'Logo başarıyla kaldırıldı.',
    'invalid_file_type' => 'Geçersiz dosya türü. Sadece JPG, JPEG, PNG ve GIF formatlarında dosya yükleyebilirsiniz.',
    'logo_upload_too_large' => 'Dosya boyutu çok büyük. Maksimum 2MB boyutunda dosya yükleyebilirsiniz.',
    'existing_companies' => 'Mevcut Firmalar',
    'company_name' => 'Firma Adı',
    'status' => 'Durum',
    'active' => 'Aktif',
    'passive' => 'Pasif',
    'add_new_company' => 'Yeni Firma Ekle',
    'edit_company' => 'Firma Düzenle',
    'address' => 'Adres',
    'phone' => 'Telefon',
    'email' => 'E-posta',
    'company_settings' => 'Firma Ayarları',
    'currency' => 'Para Birimi',
    'enable_quotes_module' => 'Teklifler Modülünü Aktif Et',
    'quotes_module_description' => 'Teklifler modülünün menüde ve ilgili yerlerde görünür olup olmadığını kontrol eder.',
    'enable_inventory_management' => 'Stok İşlemlerini Aktif Et',
    'inventory_management_description' => 'Bu seçenek aktif edildiğinde, stok yönetimi ile ilgili menüler, raporlar ve işlemler görünür olur. Pasif edildiğinde stokla ilgili tüm özellikler gizlenir ve ürün hareketleri sadece tutar üzerinden yönetilir.',
    'enable_multiple_currencies' => 'Çoklu Para Birimini Etkinleştir',
    'multiple_currencies_description' => 'Farklı para birimlerinde işlem yapmaya izin verir',
    'company_active' => 'Firma Aktif',
    'invalid_security_token' => 'Geçersiz güvenlik anahtarı!',
    'no_permission_to_update_company' => 'Bu firmayı güncelleme yetkiniz bulunmamaktadır.',
    'company_info_updated_successfully' => 'Firma bilgileri ve ayarları başarıyla güncellendi.',
    'company_created_successfully' => 'Yeni firma başarıyla oluşturuldu ve ayarları kaydedildi.',
    'cannot_delete_active_company' => 'Aktif olarak işlem yaptığınız firmayı silemezsiniz. Lütfen önce başka bir firmaya geçiş yapın.',
    'cannot_delete_main_company' => 'Ana firma (ID: 1) güvenlik nedeniyle silinemez.',
    'no_permission_to_delete_company' => 'Bu firmayı silme yetkiniz bulunmamaktadır.',
    'company_deleted_successfully' => 'Firma ve ilişkili tüm veriler başarıyla silindi.',
    'confirm_company_deletion' => 'Bu firmayı ve içindeki TÜM verileri (ürünler, cariler, faturalar vb.) kalıcı olarak silmek istediğinize emin misiniz? Bu işlem geri alınamaz!',
    'edit' => 'Düzenle',
    'delete' => 'Sil',
    'no_product_categories_found' => 'Bu şirket için henüz ürün kategorisi eklenmemiş.',
    'no_transaction_categories_found' => 'Bu şirket için henüz işlem kategorisi eklenmemiş.',
    'confirm_delete_category' => 'Bu kategoriyi silmek istediğinizden emin misiniz? Kategoriye bağlı bir işlem varsa silinemez.',
    'category_updated_log' => ':category adlı kategori güncellendi.',
    'category_added_log' => ':category adlı kategori eklendi.',
    
    // Customer Group Management / Cari Grup Yönetimi
    'customer_group_management' => 'Cari Grubu Yönetimi',
    'group_not_found' => 'Grup bulunamadı.',
    'error_loading_group' => 'Grup bilgileri alınırken hata oluştu.',
    'group_name_required' => 'Grup adı boş olamaz.',
    'group_name_already_exists' => 'Bu grup adı zaten başka bir grup tarafından kullanılıyor!',
    'customer_group_updated_successfully' => 'Cari grubu başarıyla güncellendi.',
    'customer_group_added_successfully' => 'Cari grubu başarıyla eklendi.',
    'error_loading_customer_groups' => 'Cari grupları yüklenirken bir hata oluştu.',
    'edit_group' => 'Grup Düzenle',
    'add_new_group' => 'Yeni Grup Ekle',
    'save_group' => 'Grubu Kaydet',
    'existing_groups' => 'Mevcut Gruplar',
    'group_name' => 'Grup Adı',
    'no_customer_groups_found' => 'Bu şirket için henüz cari grubu eklenmemiş.',
    'confirm_delete_group' => 'Bu grubu silmek istediğinizden emin misiniz? Gruba ait cari varsa işlem başarısız olacaktır.',
    'delete_group' => 'Grubu Sil',
    'edit_group' => 'Grubu Düzenle',
    
    // Stock and Image Settings / Stok ve Resim Ayarları
    'stock_and_image_settings' => 'Stok ve Resim Ayarları',
    'invalid_form_submission' => 'Geçersiz form gönderimi!',
    'directory_creation_failed' => 'Dizin oluşturulamadı',
    'check_directory_permissions' => 'Lütfen üst dizin için yazma izinlerini kontrol edin.',
    'not_a_directory' => 'Belirtilen yol bir dizin değil',
    'database_error_while_updating_settings' => 'Ayarlar güncellenirken bir veritabanı hatası oluştu.',
    'information' => 'Bilgi',
    'stock_settings_description' => 'Bu ayarlar, ürün resim yükleme ve diğer stokla ilgili genel sistem davranışlarını kontrol eder.',
    'image_upload_settings' => 'Resim Yükleme Ayarları',
    'enable_image_upload_in_stock_section' => 'Stok Bölümüne Resim Yüklemeyi Aktif Et',
    'enable_image_upload_help' => 'Bu seçenek aktif edildiğinde, ürün ekleme/düzenleme sayfalarında resim yükleme alanı görünür olur.',
    'image_upload_directory' => 'Resim Yükleme Dizini',
    'image_upload_directory_help' => 'Yüklenecek ürün resimlerinin kaydedileceği dizin. Proje ana dizinine göre belirtilmelidir.',
    'directory_permissions_note' => 'Dizin mevcut değilse oluşturulmaya çalışılır ve yazma izinleri kontrol edilir.',
    'image_visibility_settings' => 'Resim Görünürlük Ayarları',
    'show_product_images' => 'Ürün resimleri görünsün mü?',
    'show_product_images_help' => 'Bu seçenek aktif edildiğinde, ürün listelerinde ürün resimleri görünür.',
    'show_images_in_pdf' => 'PDF\'lerde ürün resimleri görünsün mü?',
    'show_images_in_pdf_help' => 'Bu seçenek aktif edildiğinde, fatura ve rapor PDF\'lerinde ürün resimleri görünür.',
    'save_settings' => 'Ayarları Kaydet',
    'important_notes' => 'Önemli Notlar',
    'image_settings_note_1' => 'Bu ayarlar ürünlerinize ait resimlerin sistemde ve PDF çıktılarında görünüp görünmeyeceğini kontrol eder.',
    'image_settings_note_2' => 'İkinci fiyat alanları aktif edildiğinde, mevcut ürünler için bu alanlar boş olacaktır.',
    'image_settings_note_3' => 'Bu alanlar isteğe bağlıdır ve doldurulmak zorunda değildir.',
    'image_settings_note_4' => 'API entegrasyonu için bu alanların doldurulması önerilir.',
    'settings_take_effect_immediately' => 'Ayar değişiklikleri anında etkili olur.',
    'example' => 'Örnek',
    'stock_and_image_settings_updated_successfully' => 'Stok ve Resim ayarları başarıyla güncellendi.',
    'stock_and_image_settings_updated_log' => 'Stok ve Resim ayarları şirket bazında güncellendi',
    
    // Permission Levels / Yetki Seviyeleri
    'permission_levels_management' => 'Yetki Seviyeleri Yönetimi',
    'add_new_permission_group' => 'Yeni Yetki Grubu Ekle',
    'edit_permission_group' => 'Yetki Grubunu Düzenle',
    'existing_permission_groups' => 'Mevcut Yetki Grupları',
    'group_name' => 'Grup Adı',
    'description' => 'Açıklama',
    'permissions' => 'Yetkiler',
    'status' => 'Durum',
    'actions' => 'İşlemler',
    'active' => 'Aktif',
    'passive' => 'Pasif',
    'update_group' => 'Grubu Güncelle',
    'cancel' => 'İptal',
    'add_group' => 'Grup Ekle',
    'no_permissions_defined' => 'Tanımlı yetki yok',
    'no_permission_groups_added' => 'Henüz hiç yetki grubu eklenmemiş.',
    'delete' => 'Sil',
    'edit' => 'Düzenle',
    'confirm_delete_group' => 'Bu yetki grubunu silmek istediğinize emin misiniz? Bu yetki grubunu kullanan kullanıcılar varsa silinemez!',
    'group_name_cannot_be_empty' => 'Grup adı boş olamaz.',
    'group_name_already_exists' => 'Bu grup adı zaten mevcut!',
    'group_name_already_used' => 'Bu grup adı zaten başka bir gruba ait!',
    'group_to_edit_not_found' => 'Düzenlenecek grup bulunamadı.',
    'permission_group_added_successfully' => 'Yetki grubu başarıyla eklendi.',
    'permission_group_updated_successfully' => 'Yetki grubu başarıyla güncellendi.',
    'error_loading_group_info' => 'Yetki grubu bilgileri çekilirken bir hata oluştu.',
    'error_loading_permission_groups' => 'Yetki grupları yüklenirken bir hata oluştu.',
    'group_permissions' => 'Grup Yetkileri',
    
    // Permission Descriptions / Yetki Açıklamaları
    'stock_management' => 'Stok Yönetimi (Ürün ekleme/düzenleme/silme)',
    'stock_viewing' => 'Stok Görüntüleme (Ürün listeleme/raporlama)',
    'sales_operations' => 'Satış İşlemleri (Satış yapma/faturalar)',
    'purchase_operations' => 'Alış İşlemleri (Alış yapma/faturalar)',
    'quote_management' => 'Teklif Yönetimi (Oluşturma/Düzenleme/Dönüştürme)',
    'customer_management' => 'Cari Yönetimi (Cari ekleme/düzenleme/silme)',
    'customer_viewing' => 'Cari Görüntüleme (Cari listeleme/detay)',
    'account_management' => 'Hesap Yönetimi (Hesap ekleme/düzenleme/silme/hareketler)',
    'view_reports' => 'Raporları Görüntüleme (Tüm raporlar)',
    'view_invoices' => 'Faturaları Görüntüleme (Tüm faturalar)',
    'user_management' => 'Kullanıcı Yönetimi (Kullanıcı ekleme/düzenleme/silme)',
    'view_logs' => 'Log Kayıtlarını Görüntüleme',
    'access_general_settings' => 'Genel Ayarlara Erişim (Site ayarları/Kategoriler/Hesaplar)',
    'all_admin_privileges' => 'Tüm Yönetici Yetkileri (Dikkat: Genellikle Admin rolüne özel)',
    
    // Security Settings / Güvenlik Ayarları
    'security_settings' => 'Güvenlik Ayarları',
    'management' => 'Yönetim',
    'invalid_form_submission' => 'Geçersiz form gönderimi!',
    'screen_lock_time_minutes' => 'Ekran kilidi süresi en az 1 dakika olmalıdır.',
    'new_passwords_dont_match' => 'Yeni şifreler uyuşmuyor.',
    'screen_lock_password_min_length' => 'Ekran kilidi şifresi en az 4 karakter olmalıdır.',
    'security_settings_updated' => 'Güvenlik ayarları başarıyla güncellendi.',
    'an_error_occurred' => 'Bir hata oluştu',
    'enable_auto_screen_lock' => 'Otomatik Ekran Kilidini Aktif Et',
    'idle_timeout_minutes' => 'Boşta Kalma Süresi (Dakika)',
    'screen_will_lock_after' => 'Bu süre sonunda işlem yapılmazsa ekran kilitlenir.',
    'screen_lock_password' => 'Ekran Kilidi Şifresi',
    'no_screen_lock_password_set' => 'Henüz bir ekran kilidi şifresi belirlemediniz. Özelliği kullanmak için şifre belirlemeniz gerekmektedir.',
    'new_password' => 'Yeni Şifre',
    'enter_new_password' => 'Yeni şifrenizi girin',
    'new_password_repeat' => 'Yeni Şifre (Tekrar)',
    're_enter_new_password' => 'Yeni şifrenizi tekrar girin',
    'save_settings' => 'Ayarları Kaydet',
    
    // Login Page / Giriş Sayfası
    'login_page_title' => 'Begeb Creative Yönetim - Giriş',
    'app_name' => 'Begeb Creative Yönetim',
    'business_management_panel' => 'İşletme Yönetim Paneli Girişi',
    'username_password_required' => 'Kullanıcı adı ve şifre alanları boş bırakılamaz!',
    'too_many_failed_attempts' => 'Çok fazla hatalı giriş denemesi.',
    'invalid_username_or_password' => 'Kullanıcı adı veya şifre hatalı!',
    'system_error_try_again' => 'Sistem hatası oluştu. Lütfen daha sonra tekrar deneyin.',
    'session_expired_login_again' => 'Oturum süreniz doldu. Lütfen tekrar giriş yapın.',
    'session_terminated_security' => 'Güvenlik nedeniyle oturumunuz sonlandırıldı.',
    'login_failed' => 'GİRİŞ BAŞARISIZ!',
    'registration_successful_login_now' => 'Kayıt başarılı! Giriş yapabilirsiniz.',
    'username' => 'Kullanıcı Adı',
    'password' => 'Şifre',
    'login' => 'Giriş Yap',
    'sign_up' => 'Üye Ol',
    'forgot_password' => 'Şifremi Unuttum?',
    'close' => 'Kapat',
    'full_name' => 'Ad Soyad',
    'email' => 'E-posta',
    'password_repeat' => 'Şifre (Tekrar)',
    'register' => 'Kayıt Ol',
    'already_have_account' => 'Zaten hesabınız var mı? Giriş yapın',
    'full_name_min_length' => 'Ad Soyad en az 3 karakter olmalı.',
    'username_min_length' => 'Kullanıcı adı en az 3 karakter olmalı.',
    'enter_valid_email' => 'Geçerli bir e-posta giriniz.',
    'password_min_length' => 'Şifre en az 6 karakter olmalı.',
    'passwords_dont_match' => 'Şifreler eşleşmiyor.',
    'username_or_email_exists' => 'Bu kullanıcı adı veya e-posta zaten kayıtlı.',
    'database_error_register' => 'Veritabanı hatası nedeniyle kayıt yapılamadı. Lütfen tekrar deneyin.',
    
    // Installation / Kurulum
    'installation' => 'Kurulum',
    'system_management' => 'Sistem Yönetimi',
    'welcome_to_odjoo' => 'Begeb Creative Yönetim Sistemine Hoş Geldiniz',
    'welcome_description' => 'Aşağıdaki seçeneklerden birini seçerek devam edebilirsiniz.',
    'new_installation' => 'Yeni Kurulum',
    'new_installation_desc' => 'Sıfırdan yeni bir kurulum yapın',
    'system_backup' => 'Sistem Yedeklemesi',
    'system_backup_desc' => 'Mevcut sisteminizin yedeğini alın',
    'system_restore' => 'Sistem Geri Yükleme',
    'system_restore_desc' => 'Daha önce alınmış bir yedekten geri yükleme yapın',
    'continue' => 'Devam Et',
    'database_connection' => 'Veritabanı Bağlantısı',
    'database_connection_desc' => 'Lütfen veritabanı bağlantı bilgilerini giriniz',
    'database_server' => 'Veritabanı Sunucusu',
    'database_name' => 'Veritabanı Adı',
    'database_username' => 'Veritabanı Kullanıcı Adı',
    'database_password' => 'Veritabanı Şifresi',
    'connection_successful' => 'Veritabanı bağlantısı başarılı! Kurulum işlemi başlatılıyor...',
    'connection_error' => 'Veritabanı bağlantı hatası',
    'required_fields' => 'Lütfen tüm gerekli alanları doldurun.',
    'installation_in_progress' => 'Kurulum Devam Ediyor',
    'installation_complete' => 'Kurulum Tamamlandı',
    'installation_error' => 'Kurulum Hatası',
    'create_company' => 'Şirket Oluştur',
    'company_name' => 'Şirket Adı',
    'address' => 'Adres',
    'phone' => 'Telefon',
    'email' => 'E-posta',
    'currency' => 'Para Birimi',
    'stock_module' => 'Stok Modülü Aktif',
    'quotation_module' => 'Teklif Modülü Aktif',
    'create_admin_user' => 'Yönetici Kullanıcı Oluştur',
    'admin_full_name' => 'Yönetici Adı Soyadı',
    'admin_username' => 'Yönetici Kullanıcı Adı',
    'admin_email' => 'Yönetici E-posta',
    'admin_password' => 'Yönetici Şifresi',
    'complete_installation' => 'Kurulumu Tamamla',
    'installation_success' => 'Kurulum Başarılı!',
    'installation_success_desc' => 'Sistem başarıyla kuruldu. Aşağıdaki butona tıklayarak giriş sayfasına gidebilirsiniz.',
    'go_to_login' => 'Giriş Sayfasına Git',
    'invalid_csrf' => 'Geçersiz CSRF token!',
    'company_required' => 'Şirket adı gereklidir.',
    'admin_required' => 'Tüm gerekli alanları doldurun: Yönetici adı soyadı, Yönetici kullanıcı adı ve Şifresi.',
    'delete_install_file' => '`install.php` dosyasını sunucunuzdan silin.',
    'installation_type' => 'Kurulum Türü',
    'full_installation' => 'Tam Kurulum (Tüm tabloları oluştur)',
    'partial_installation' => 'Kısmi Kurulum (Sadece eksik tabloları ekle)',
    'sql_file_not_found' => 'SQL dosyası bulunamadı: %s',
    'sql_file_not_readable' => 'SQL dosyası okunamadı: %s',
    'config_update_failed' => 'config.php dosyası güncellenemedi. Lütfen \'includes\' klasörüne yazma izni verin.',
    'config_not_found' => 'config.php dosyası bulunamadı.',
    'sql_error' => 'SQL hatası',
    'start_installation' => 'Kuruluma Başla',
    'system_update' => 'Sistemi Güncelle',
    'system_update_desc' => 'Mevcut sistemi güncelleyin. Yeni özellikler ve güvenlik güncellemeleri ile sisteminizi güncel tutun.',
    'start_update' => 'Güncellemeye Başla',
    'backup_restore' => 'Yedek Yükleme',
    'backup_restore_desc' => 'Önceden oluşturulmuş yedek dosyalarınızı sisteme yükleyin ve verilerinizi geri yükleyin.',
    'start_restore' => 'Yedek Yüklemeye Başla',
    'feature_secure' => 'Güvenli',
    'feature_secure_desc' => 'Gelişmiş güvenlik önlemleri ile verileriniz güvende',
    'feature_easy' => 'Kullanımı Kolay',
    'feature_easy_desc' => 'Sade ve anlaşılır arayüzü ile kolay kullanım',
    'feature_support' => '7/24 Destek',
    'feature_support_desc' => 'Uzman ekibimiz her zaman yanınızda',
    'feature_customizable' => 'Özelleştirilebilir',
    'feature_customizable_desc' => 'İhtiyaçlarınıza göre kolayca özelleştirilebilir',
    'feature_fast' => 'Hızlı',
    'feature_fast_desc' => 'Yüksek performanslı altyapı ile hızlı çalışır',
    'feature_responsive' => 'Duyarlı Tasarım',
    'feature_responsive_desc' => 'Tüm cihazlarda mükemmel görünüm',
    'feature_easy_install' => 'Kolay Kurulum',
    'feature_easy_install_desc' => 'Birkaç adımda kolay kurulum',
    'feature_multi_user' => 'Çok Kullanıcılı',
    'feature_multi_user_desc' => 'Aynı anda birden fazla kullanıcı ile çalışabilme',
    'missing_database_info' => 'Veritabanı bilgileri eksik. Lütfen tekrar deneyin.',
    'full_installation_complete' => 'Tam kurulum başarıyla tamamlandı!',
    'partial_installation_complete' => 'Eksik tablolar ve varsayılan veriler eklenmeye çalışıldı.',
    'invalid_installation_action' => 'Geçersiz kurulum aksiyonu seçildi.',
    'starting' => 'Başlatılıyor',
    'admin_creation_error' => 'Yönetici kullanıcı oluşturulurken bir hata oluştu',
    'company_created_successfully' => 'Şirket başarıyla oluşturuldu! Şimdi bir yönetici kullanıcı oluşturun.',
    'error_creating_company' => 'Şirket oluşturulurken bir hata oluştu',
    'all_data_deleted_and_installed' => 'Tüm veriler silindi ve sıfırdan kurulum tamamlandı!',
    'install_complete_message' => 'Kurulum başarıyla tamamlandı! Lütfen `install.php` dosyasını sunucunuzdan silin.',
    'installation' => 'Kurulum',
    'odjoo_installation' => 'Begeb Creative Kurulum',
    'system_setup_guide' => 'Sisteminizi adım adım kurun',
    'odjoo_setup_wizard' => 'Begeb Creative Kurulum Sihirbazı',
    'database_information' => 'Veritabanı Bilgileri',
    'enter_database_credentials' => 'Lütfen veritabanı bağlantı bilgilerinizi girin.',
    'database_server' => 'Veritabanı Sunucusu',
    'database_name' => 'Veritabanı Adı',
    'database_username' => 'Veritabanı Kullanıcı Adı',
    'database_password' => 'Veritabanı Şifresi',
    'test_connection_and_continue' => 'Bağlantıyı Test Et ve Devam Et',
    'installation_options' => 'Kurulum Seçenekleri',
    'create_admin_user' => 'Yönetici Kullanıcı Oluşturma',
    'create_company_and_continue' => 'Şirketi Oluştur ve Devam Et',
    'full_name' => 'Adı Soyadı',
    'username' => 'Kullanıcı Adı',
    'email' => 'E-posta',
    'password' => 'Şifre',
    'confirm_password' => 'Şifre Tekrar',
    'create_admin_and_complete' => 'Yönetici Oluştur ve Kurulumu Tamamla',
    'system_installed_successfully' => 'Sisteminiz başarıyla kuruldu ve yönetici hesabınız oluşturuldu.',
    'important' => 'Önemli',
    'security_warning_install_php' => 'Güvenliğiniz için lütfen sunucunuzdaki <code>install.php</code> dosyasını silin veya erişimini engelleyin.',
    'login_to_system' => 'Sisteme Giriş Yap',
    'back_to_home' => 'Ana Sayfaya Dön',
    'warning_irreversible_action' => 'Bu işlem mevcut veritabanındaki tüm verileri ve tabloları siler, geri alınamaz!',
    'drop_all_data_and_install' => 'Tüm Verileri Sil ve Sıfırdan Kur (Geri Alınamaz!)',
    'confirm_drop_tables' => 'Bu işlem mevcut veritabanındaki TÜM verileri ve tabloları silecek. Devam etmek istediğinize emin misiniz?',
    // Update page translations
    'update_database' => 'Veritabanı Güncelleme',
    'update_safely' => 'Sisteminizi güvenli bir şekilde güncelleyin.',
    'update_wizard' => 'Begeb Creative Güncelleme Sihirbazı',
    'schema_differences_found' => 'Şema Farklılıkları Tespit Edildi',
    'schema_differences_description' => 'Aşağıdaki veritabanı şema farklılıkları bulundu. Lütfen değişiklikleri onaylayın:',
    'missing_tables' => 'Eksik Tablolar',
    'missing_columns' => 'Eksik Sütunlar',
    'missing_indexes' => 'Eksik İndeksler',
    'missing_foreign_keys' => 'Eksik Yabancı Anahtarlar',
    'column_differences' => 'Sütun Farklılıkları',
    'update_confirmation' => 'Güncellemeyi Onayla',
    'update_confirmation_text' => 'Yukarıdaki değişiklikleri uygulamak istediğinizden emin misiniz? Bu işlem geri alınamaz!',
    'update_success' => 'Güncelleme Başarılı',
    'update_success_message' => 'Veritabanı başarıyla güncellendi!',
    'update_error' => 'Güncelleme Hatası',
    'update_error_message' => 'Güncelleme sırasında bir hata oluştu: ',
    'admin_creation_error' => 'Yönetici kullanıcı oluşturulurken bir hata oluştu',
    'sql_file_not_found' => 'SQL dosyası bulunamadı: %s',
    'sql_file_unreadable' => 'SQL dosyası okunamadı: %s',
    'config_update_failed' => 'config.php dosyası güncellenemedi. Lütfen includes klasörüne yazma izni verin.',
    'config_file_not_found' => 'config.php dosyası bulunamadı.',
    'invalid_csrf_token' => 'Geçersiz CSRF token!',
    'fill_required_fields' => 'Lütfen tüm gerekli alanları doldurun.',
    'db_connection_success' => 'Veritabanı bağlantısı başarılı! Kurulum işlemi başlatılıyor...',
    'db_connection_error' => 'Veritabanı bağlantı hatası',
    'installation_progress' => 'Kurulum devam ediyor... %%s%%',
    'installation_complete' => 'Kurulum tamamlandı!',
    'installation_error' => 'Kurulum sırasında bir hata oluştu',
    'drop_confirm' => 'Tüm verileri silip sıfırdan kurulum yapmak istediğinizden emin misiniz?',
    'install_success' => 'Kurulum başarıyla tamamlandı!',
    
    // Depo Yönetimi
    'warehouse_management' => 'Depo Yönetimi',
    'warehouse' => 'Depo',
    'warehouses' => 'Depolar',
    'warehouse_name' => 'Depo Adı',
    'add_warehouse' => 'Depo Ekle',
    'add_new_warehouse' => 'Yeni Depo Ekle',
    'edit_warehouse' => 'Depo Düzenle',
    'delete_warehouse' => 'Depo Sil',
    'existing_warehouses' => 'Mevcut Depolar',
    'no_warehouses_found' => 'Depo bulunamadı',
    'warehouse_added_successfully' => 'Depo başarıyla eklendi',
    'warehouse_updated_successfully' => 'Depo başarıyla güncellendi',
    'warehouse_deleted_successfully' => 'Depo başarıyla silindi',
    'confirm_delete_warehouse' => 'Bu depoyu silmek istediğinizden emin misiniz?',
    'warehouse_name_required' => 'Depo adı gereklidir',
    'warehouse_name_exists' => 'Bu depo adı zaten kullanılıyor',
    'warehouse_not_found' => 'Depo bulunamadı',
    'error_loading_warehouse' => 'Depo yüklenirken hata oluştu',
    'warehouse_in_use' => 'Bu depo kullanımda olduğu için silinemez',
    
    // Raf Yönetimi
    'shelf_management' => 'Raf Yönetimi',
    'shelf' => 'Raf',
    'shelves' => 'Raflar',
    'shelf_name' => 'Raf Adı',
    'add_shelf' => 'Raf Ekle',
    'add_new_shelf' => 'Yeni Raf Ekle',
    'edit_shelf' => 'Raf Düzenle',
    'delete_shelf' => 'Raf Sil',
    'existing_shelves' => 'Mevcut Raflar',
    'no_shelves_found' => 'Raf bulunamadı',
    'shelf_added_successfully' => 'Raf başarıyla eklendi',
    'shelf_updated_successfully' => 'Raf başarıyla güncellendi',
    'shelf_deleted_successfully' => 'Raf başarıyla silindi',
    'confirm_delete_shelf' => 'Bu rafı silmek istediğinizden emin misiniz?',
    'shelf_name_required' => 'Raf adı gereklidir',
    'shelf_name_exists' => 'Bu raf adı zaten kullanılıyor',
    'shelf_not_found' => 'Raf bulunamadı',
    'error_loading_shelf' => 'Raf yüklenirken hata oluştu',
    'shelf_in_use' => 'Bu raf kullanımda olduğu için silinemez',
    
    // Modül ve Genel
    'enable_warehouse_management' => 'Depo Yönetimini Aktif Et',
    'warehouse_management_description' => 'Ürünler için depo ve raf yönetimi özelliğini aktif eder',
    'select_warehouse' => 'Depo Seçin',
    'select_shelf' => 'Raf Seçin',
    'warehouse_stock_distribution' => 'Depo/Raf Stok Dağılımı',
    'warehouse_and_shelf' => 'Depo ve Raf',
    'warehouse_shelf_info' => 'Depo/Raf Bilgisi',
    'stock_by_warehouse' => 'Depoya Göre Stok',
    'stock_by_shelf' => 'Rafa Göre Stok',
    'warehouse_info_view_only' => 'Depo bilgisi sadece görüntüleme amaçlıdır',
    'shelf_info_view_only' => 'Raf bilgisi sadece görüntüleme amaçlıdır',
    'warehouse_shelf_distribution' => 'Depo/Raf Stok Dağılımı',
    
    // Marka Yönetimi
    'brand_management' => 'Marka Yönetimi',
    'brand' => 'Marka',
    'brands' => 'Markalar',
    'brand_name' => 'Marka Adı',
    'add_brand' => 'Marka Ekle',
    'add_new_brand' => 'Yeni Marka Ekle',
    'edit_brand' => 'Marka Düzenle',
    'delete_brand' => 'Marka Sil',
    'existing_brands' => 'Mevcut Markalar',
    'no_brands_found' => 'Marka bulunamadı',
    'brand_added_successfully' => 'Marka başarıyla eklendi',
    'brand_updated_successfully' => 'Marka başarıyla güncellendi',
    'brand_deleted_successfully' => 'Marka başarıyla silindi',
    'confirm_delete_brand' => 'Bu markayı silmek istediğinizden emin misiniz?',
    'brand_name_required' => 'Marka adı gereklidir',
    'brand_name_already_exists' => 'Bu marka adı zaten kullanılıyor',
    'brand_not_found' => 'Marka bulunamadı',
    'error_loading_brand' => 'Marka yüklenirken hata oluştu',
    'error_loading_brands' => 'Markalar yüklenirken hata oluştu',
    'brand_in_use' => 'Bu marka kullanımda olduğu için silinemez',
    'save_brand' => 'Markayı Kaydet',
    'select_brand' => 'Marka Seçin',
    'brand_added_log' => '{brand} markası eklendi',
    'brand_updated_log' => '{brand} markası güncellendi',
    'brand_deleted_log' => '{brand} markası silindi'
];