<?php
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../functions/log_fonksiyonlari.php';
yetkili_mi();

$sayfa_baslik = __("purchase_transaction");
$paraBirimi = getParaBirimiSembolu(); // Para birimi sembolünü al

// Form gönderildiğinde
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (!csrf_token_dogrula($_POST['csrf_token'] ?? '')) {
        $_SESSION['hata'] = __("invalid_form_submission");
        header("Location: alis_yeni.php");
        exit();
    }

    // Aktif şirket ID'sini al
    $aktif_sirket_id = $_SESSION['aktif_sirket_id'];

    // Form verilerini al
    $cari_id = filter_input(INPUT_POST, 'cari_id', FILTER_VALIDATE_INT);
    $kategori_id = filter_input(INPUT_POST, 'kategori_id', FILTER_VALIDATE_INT);
    $tarih = filter_input(INPUT_POST, 'tarih', FILTER_SANITIZE_SPECIAL_CHARS);
    $vade_tarihi = filter_input(INPUT_POST, 'vade_tarihi', FILTER_SANITIZE_SPECIAL_CHARS);
    $pesin_odendi = isset($_POST['pesin_odendi']) && $_POST['pesin_odendi'] == '1';
    $hesap_id = filter_input(INPUT_POST, 'hesap_id', FILTER_VALIDATE_INT);
    $odeme_tarihi = filter_input(INPUT_POST, 'odeme_tarihi', FILTER_SANITIZE_SPECIAL_CHARS);
    $aciklama = temizle($_POST['aciklama'] ?? '');
    $indirim_tutari = filter_var(str_replace(',', '.', $_POST['indirim_tutari'] ?? '0'), FILTER_VALIDATE_FLOAT);
    if ($indirim_tutari === false) $indirim_tutari = 0;

    // Ürün detayları
    $urun_detaylari = [];
    $toplam_tutar = 0;
    $toplam_kdv = 0;

    $urun_ids = $_POST['urun_id'] ?? [];
    $miktarlar = $_POST['miktar'] ?? [];
    $birim_fiyatlar = $_POST['birim_fiyat'] ?? [];
    $kdv_oranlari = $_POST['kdv_orani'] ?? [];
    $kurlar = $_POST['kur'] ?? [];
    $alis_para_birimleri = $_POST['alis_para_birimi'] ?? [];
    $fatura_para_birimi = temizle($_POST['fatura_para_birimi'] ?? 'TL');

    foreach ($urun_ids as $index => $urun_id) {
        if (!empty($urun_id) && !empty($miktarlar[$index]) && isset($birim_fiyatlar[$index])) {
            $miktar = filter_var(str_replace(',', '.', $miktarlar[$index]), FILTER_VALIDATE_FLOAT);
            $birim_fiyat = filter_var(str_replace(',', '.', $birim_fiyatlar[$index]), FILTER_VALIDATE_FLOAT);
            $kdv_orani = filter_var(str_replace(',', '.', $kdv_oranlari[$index]), FILTER_VALIDATE_FLOAT);
            $kur = filter_var(str_replace(',', '.', $kurlar[$index] ?? '1'), FILTER_VALIDATE_FLOAT);
            $alis_para_birimi = temizle($alis_para_birimleri[$index] ?? 'TL');

            if ($miktar > 0 && $birim_fiyat >= 0) {
                // KDV ve toplam önce orijinal para biriminde hesaplanır, sonra fatura para birimine çevrilir
                $satir_toplam_orj = $miktar * $birim_fiyat; // Orijinal para birimi
                $kdv_tutari_orj = ($satir_toplam_orj * $kdv_orani) / 100; // Orijinal para birimi

                $satir_toplam_fatura_pb = $satir_toplam_orj * $kur; // Fatura para birimi
                $kdv_tutari_fatura_pb = $kdv_tutari_orj * $kur; // Fatura para birimi

                $urun_detaylari[] = [
                    'urun_id' => $urun_id,
                    'miktar' => $miktar,
                    'birim_fiyat' => $birim_fiyat, // Orijinal birim fiyat
                    'toplam_tutar' => $satir_toplam_fatura_pb, // Fatura para birimi cinsinden toplam tutar
                    'kdv_orani' => $kdv_orani,
                    'kdv_tutari' => $kdv_tutari_fatura_pb, // Fatura para birimi cinsinden KDV tutarı
                    'cari_id' => $cari_id,
                    'islem_turu' => 'alis',
                    'kur' => $kur,
                    'alis_para_birimi' => $alis_para_birimi
                ];

                // Genel toplama çevrilmiş tutarları ekle
                $toplam_tutar += $satir_toplam_fatura_pb;
                $toplam_kdv += $kdv_tutari_fatura_pb;
            }
        }
    }
    
    $kdv_dahil_tutar = $toplam_tutar + $toplam_kdv;
    $odenecek_tutar = $kdv_dahil_tutar - $indirim_tutari;

    $hatalar = [];
    if (empty($cari_id)) $hatalar[] = __("supplier_required");
    if (empty($kategori_id)) $hatalar[] = __("category_required");
    if (empty($tarih) || !preg_match("/^\d{4}-\d{2}-\d{2}$/", $tarih)) $hatalar[] = __("valid_date_required");
    if (empty($urun_detaylari)) $hatalar[] = __("at_least_one_product_required");
    if ($odenecek_tutar < 0) $hatalar[] = __("discount_cannot_exceed_total");
    if ($pesin_odendi && empty($hesap_id)) $hatalar[] = __("account_required_for_cash_payment");
    $vade_tarihi = empty($vade_tarihi) ? null : $vade_tarihi;
    $fatura_para_birimi = temizle($_POST['fatura_para_birimi'] ?? 'TL');
    if ($fatura_para_birimi === 'TL') { $fatura_para_birimi = 'TRY'; }

    if (empty($hatalar)) {
        try {
            $db->beginTransaction();

            $odenen_tutar_db = $pesin_odendi ? $odenecek_tutar : 0;

            // Alış işlemi 'borclar' tablosuna 'alis' türü ile kaydedilir.
            $stmt_borc = $db->prepare("INSERT INTO borclar
                (sirket_id, cari_id, tur, kategori_id, tutar, toplam_kdv, indirim_tutari, odenen_tutar, aciklama, tarih, vade_tarihi, stoklu_islem, olusturulma_tarihi, para_birimi)
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 1, NOW(), ?)");
            $stmt_borc->execute([$aktif_sirket_id, $cari_id, 'alis', $kategori_id, $toplam_tutar, $toplam_kdv, $indirim_tutari, $odenen_tutar_db, $aciklama, $tarih, $vade_tarihi, $fatura_para_birimi]);
            $borc_id = $db->lastInsertId();

            if (!faturaDetayiEkle($db, $borc_id, $urun_detaylari, $aktif_sirket_id)) {
                throw new Exception("Fatura detayları kaydedilemedi.");
            }
            // Fatura detayları eklendikten sonra stok güncellemesi
            require_once __DIR__ . '/../functions/stok_fonksiyonlari.php';
            foreach ($urun_detaylari as $kalem) {
                // Ürün adını al
                $stmt_urun = $db->prepare("SELECT urun_adi FROM urunler WHERE id = ?");
                $stmt_urun->execute([$kalem['urun_id']]);
                $urun_adi = $stmt_urun->fetchColumn() ?: 'Bilinmeyen Ürün';
                
                stokGuncelle(
                    $db, 
                    $kalem['urun_id'], 
                    $kalem['miktar'], 
                    $kalem['birim_fiyat'],
                    "Alış faturası ile stok girişi - {$urun_adi}",
                    $borc_id,
                    'alis_faturasi'
                );
            }


            if ($pesin_odendi) {
                    error_log("--- PESIN ODEME BASLADI ---");
                    error_log("Fatura Para Birimi: {$fatura_para_birimi}, Odenecek Tutar (Orijinal): {$odenecek_tutar}");
                if ($odenecek_tutar > 0) {
                    // Peşin alışta hesaptan para çıkar
                    // ÖNEMLİ: $odenecek_tutar zaten fatura para biriminde. Hesap ve fatura PB aynı olmalı.
                    // Bu senaryoda farklı para birimindeki bir hesaptan ödeme desteklenmiyor.
                    // Gelecekte desteklenecekse, burada TCMB'den çapraz kur alınmalıdır.
                    if (!hesapBakiyeGuncelle($db, $hesap_id, -$odenecek_tutar)) {
                        throw new Exception("Hesap bakiyesi güncellenemedi.");
                    }
                    $hareket_aciklama = "Alış Faturası Ödemesi (#{$borc_id}): " . $aciklama;
                    if (!hesapHareketiEkle($db, $hesap_id, $aktif_sirket_id, 'cikis', $odenecek_tutar, $hareket_aciklama, $odeme_tarihi, $cari_id, $borc_id, $fatura_para_birimi)) {
                        throw new Exception("Hesap hareketi eklenemedi.");
                    }
                }
                $_SESSION['mesaj'] = "Alış işlemi ve peşin ödeme başarıyla kaydedildi.";
                error_log("--- PESIN ODEME BITTI ---");
            } else {
                error_log("--- VADELI ODEME BASLADI ---");
                error_log("Fatura Para Birimi: {$fatura_para_birimi}, Odenecek Tutar (Orijinal): {$odenecek_tutar}");
                 if ($odenecek_tutar > 0) {
                    // Vadeli alışta tedarikçiye borç artar
                    // $odenecek_tutar zaten fatura para biriminde.
                    if (!cariBakiyeGuncelle($db, $cari_id, 0.0, $odenecek_tutar)) {
                        throw new Exception("Cari bakiyesi güncellenemedi.");
                    }
                 }
                $_SESSION['mesaj'] = "Vadeli alış işlemi başarıyla kaydedildi.";
            }

            $db->commit();
            
            $stmt_cari_ad = $db->prepare("SELECT ad_soyad FROM cariler WHERE id = ?");
            $stmt_cari_ad->execute([$cari_id]);
            $cari_adi = $stmt_cari_ad->fetchColumn();
            $log_mesaji = "kullanıcısı, #{$borc_id} ID'li yeni bir alış faturası oluşturdu. Tedarikçi: {$cari_adi}, Tutar: " . number_format($odenecek_tutar, 2) . " {$paraBirimi}";
            sistem_log_ekle($db, 'Fatura Alış', 'borclar', $borc_id, null, null, $log_mesaji);

            header("Location: borc_detay.php?id=" . $borc_id);
            exit();

        } catch (Exception $e) {
            if ($db->inTransaction()) $db->rollBack();
            $_SESSION['hata'] = "Alış eklenirken bir hata oluştu: " . $e->getMessage();
            $_SESSION['form_verileri_alis'] = $_POST;
            header("Location: alis_yeni.php");
            exit();
        }
    } else {
        $_SESSION['form_hatalari_alis'] = $hatalar;
        $_SESSION['form_verileri_alis'] = $_POST;
        header("Location: alis_yeni.php");
        exit();
    }
}

try {
    $aktif_sirket_id = $_SESSION['aktif_sirket_id'];

    // Şirketin para birimi ayarlarını kontrol et
    $stmt_sirket = $db->prepare("SELECT coklu_para_birimi, para_birimi FROM sirketler WHERE id = ?");
    $stmt_sirket->execute([$aktif_sirket_id]);
    $sirket_ayarlari = $stmt_sirket->fetch(PDO::FETCH_ASSOC);
    $coklu_para_birimi_aktif = $sirket_ayarlari['coklu_para_birimi'] ?? 0;
    $sirket_para_birimi = $sirket_ayarlari['para_birimi'] ?? 'TL';
    $cariler = $db->query("SELECT id, ad_soyad FROM cariler WHERE sirket_id = $aktif_sirket_id ORDER BY ad_soyad")->fetchAll(PDO::FETCH_ASSOC);
    
    $stmt_kategoriler = $db->prepare("SELECT id, kategori_adi FROM kategoriler WHERE sirket_id = ? AND tip = 'islem' ORDER BY kategori_adi");
    $stmt_kategoriler->execute([$aktif_sirket_id]);
    $kategoriler = $stmt_kategoriler->fetchAll(PDO::FETCH_ASSOC);

    $hesaplar = $db->query("SELECT id, hesap_adi, bakiye FROM hesaplar WHERE sirket_id = $aktif_sirket_id AND hesap_turu != 'kredi_karti' ORDER BY hesap_adi")->fetchAll(PDO::FETCH_ASSOC);
    
    $stmt_cari_gruplari = $db->prepare("SELECT * FROM cari_gruplari WHERE sirket_id = ? ORDER BY grup_adi");
    $stmt_cari_gruplari->execute([$aktif_sirket_id]);
    $cari_gruplari = $stmt_cari_gruplari->fetchAll(PDO::FETCH_ASSOC);

    // Döviz kurlarını veritabanından çek
    try {
        $stmt_doviz = $db->prepare("SELECT para_birimi, alis, satis, guncelleme_tarihi FROM doviz_kurlari ORDER BY id");
        $stmt_doviz->execute();
        $doviz_kurlari = $stmt_doviz->fetchAll(PDO::FETCH_ASSOC);
    } catch (PDOException $e2) {
        error_log('Döviz kurları çekilemedi: ' . $e2->getMessage());
        $doviz_kurlari = [];
    }

} catch (PDOException $e) {
    error_log("Alış sayfası veri çekme hatası: " . $e->getMessage());
    $_SESSION['hata'] = "Gerekli veriler yüklenirken bir hata oluştu: " . $e->getMessage();
    $cariler = []; $kategoriler = []; $hesaplar = [];
    $coklu_para_birimi_aktif = 0; // Hata durumunda çoklu para birimini kapalı varsay
    $sirket_para_birimi = 'TL'; // Hata durumunda varsayılanı TL yap
}

    $csrf_token = csrf_token_olustur();
    $form_hatalari = $_SESSION['form_hatalari_alis'] ?? [];
    $form_verileri = $_SESSION['form_verileri_alis'] ?? [];
    unset($_SESSION['form_hatalari_alis'], $_SESSION['form_verileri_alis']);
    
    // URL'den cari_id parametresi varsa, o cariyi otomatik seç
    $otomatik_cari_id = null;
    $otomatik_cari_adi = '';
    if (isset($_GET['cari_id']) && !empty($_GET['cari_id'])) {
        $otomatik_cari_id = filter_var($_GET['cari_id'], FILTER_VALIDATE_INT);
        if ($otomatik_cari_id) {
            try {
                $stmt_cari = $db->prepare("SELECT id, ad_soyad FROM cariler WHERE id = ? AND sirket_id = ?");
                $stmt_cari->execute([$otomatik_cari_id, $aktif_sirket_id]);
                $otomatik_cari = $stmt_cari->fetch(PDO::FETCH_ASSOC);
                if ($otomatik_cari) {
                    $otomatik_cari_adi = $otomatik_cari['ad_soyad'];
                } else {
                    $otomatik_cari_id = null; // Cari bulunamadıysa sıfırla
                }
            } catch (PDOException $e) {
                error_log("Cari bilgisi alınamadı: " . $e->getMessage());
                $otomatik_cari_id = null;
            }
        }
    }
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Odjoo Yönetim - <?= temizle($sayfa_baslik) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        .hidden { display: none !important; }
        .toplam-alan { background: #fff3cd; border: 1px solid #ffeeba; border-radius: 0.375rem; }
        .is-invalid { border-color: #dc3545 !important; }
        
        /* Tedarikçi arama sonuçları için güzel görünüm */
        #cariSonuclar {
            position: absolute;
            top: 100%;
            left: 0;
            right: 0;
            z-index: 1050;
            background: white;
            border: 1px solid #dee2e6;
            border-radius: 0.375rem;
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
            max-height: 250px;
            overflow-y: auto;
        }
        
        .autocomplete-suggestion {
            display: block;
            padding: 0.75rem 1rem;
            text-decoration: none;
            color: #212529;
            border-bottom: 1px solid #f8f9fa;
            transition: all 0.2s ease-in-out;
            cursor: pointer;
        }
        
        .autocomplete-suggestion:last-child {
            border-bottom: none;
        }
        
        .autocomplete-suggestion:hover {
            background-color: #e9ecef;
            color: #0d6efd;
            text-decoration: none;
        }
        
        .autocomplete-suggestion:focus {
            background-color: #0d6efd;
            color: white;
            outline: none;
        }
        
        .autocomplete-suggestion.text-muted {
            font-style: italic;
            color: #6c757d !important;
            cursor: default;
        }
        
        .autocomplete-suggestion.text-muted:hover {
            background-color: transparent;
            color: #6c757d !important;
        }
        
        /* Tedarikçi arama input container için relative position */
        .position-relative {
            position: relative;
        }
    </style>
</head>
<body>
    <?php include __DIR__ . '/../includes/navbar.php'; ?>

    <div class="container mt-4">
        <h2><i class="bi bi-truck"></i> <?= temizle($sayfa_baslik) ?></h2>
        <hr>
         
        <form method="post" id="alisForm">
            <input type="hidden" name="fatura_tipi" value="alis">
            <input type="hidden" id="coklu_para_birimi_aktif" value="<?= $coklu_para_birimi_aktif ? '1' : '0' ?>">
            <input type="hidden" name="csrf_token" value="<?= $csrf_token ?>">
            
            <div class="row">
                <div class="col-lg-12">
                    
                    <!-- Döviz Kurları İşlemi bloğu kaldırıldı: kurlar artık sadece veritabanından okunup hesaplamalarda kullanılıyor -->
                    <!-- Para birimi seçimi, satis_yeni.php ile aynı header yapısına taşındı -->

                        <!-- 1. Temel Bilgiler -->
                    <div class="card shadow-sm mb-4">
                        <div class="card-header bg-light d-flex flex-wrap align-items-center justify-content-between">
                            <h5 class="mb-0"><i class="bi bi-box-seam me-2"></i><?= __('invoice_products') ?></h5>
                            <div class="d-flex align-items-center gap-2 ms-auto">
                                <?php if ($coklu_para_birimi_aktif): ?>
                                    <label for="fatura_para_birimi" class="form-label mb-0 small"><?= __('invoice_currency') ?></label>
                                    <select class="form-select form-select-sm w-auto" id="fatura_para_birimi" name="fatura_para_birimi" onchange="handleFaturaParaBirimiChange.call(this)">
                                        <option value="TL" <?= ($sirket_para_birimi == 'TL' || $sirket_para_birimi == 'TRY') ? 'selected' : '' ?>>TL</option>
                                        <?php $___seen_pb = []; foreach ($doviz_kurlari as $kur): $pb = $kur['para_birimi']; if (in_array($pb, $___seen_pb)) continue; $___seen_pb[] = $pb; ?>
                                            <option value="<?= htmlspecialchars($pb) ?>" <?= ($sirket_para_birimi == $pb) ? 'selected' : '' ?>><?= htmlspecialchars($pb) ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                <?php endif; ?>
                                <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#urunSecModal"><i class="bi bi-plus-circle"></i> <?= __('add_product') ?></button>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="cari_arama" class="form-label"><?= __('supplier') ?> <span class="text-danger">*</span></label>
                                    <div class="input-group position-relative">
                                        <input type="text" class="form-control" id="cari_arama" placeholder="<?= __('supplier') ?> <?= __('search') ?>..." autocomplete="off" value="<?= htmlspecialchars($otomatik_cari_adi) ?>">
                                        <button type="button" class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#yeniCariModal"><i class="bi bi-plus-circle"></i></button>
                                        <div id="cariSonuclar" style="display: none;"></div>
                                    </div>
                                    <input type="hidden" id="cari_id" name="cari_id" value="<?= htmlspecialchars($otomatik_cari_id ?? $form_verileri['cari_id'] ?? '') ?>" required>
                                    <div id="seciliCari" class="form-text mt-2">
                                        <?php if ($otomatik_cari_id && $otomatik_cari_adi): ?>
                                            <div class="alert alert-success p-2"><?= __('selected') ?>: <strong><?= htmlspecialchars($otomatik_cari_adi) ?></strong></div>
                                        <?php else: ?>
                                            <span class="text-muted"><?= __('no_supplier_selected') ?></span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="kategori_id" class="form-label"><?= __('category') ?> <span class="text-danger">*</span></label>
                                    <select class="form-select" id="kategori_id" name="kategori_id" required>
                                        <option value=""><?= __('select_category') ?></option>
                                        <?php foreach ($kategoriler as $kategori): ?>
                                            <option value="<?= $kategori['id'] ?>" <?= (isset($form_verileri['kategori_id']) && $form_verileri['kategori_id'] == $kategori['id']) ? 'selected' : '' ?>><?= temizle($kategori['kategori_adi']) ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="tarih" class="form-label"><?= __('transaction_date') ?> <span class="text-danger">*</span></label>
                                    <input type="date" class="form-control" id="tarih" name="tarih" required value="<?= htmlspecialchars($form_verileri['tarih'] ?? date('Y-m-d')) ?>">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="aciklama" class="form-label"><?= __('description') ?></label>
                                    <textarea class="form-control" id="aciklama" name="aciklama" rows="1"><?= htmlspecialchars($form_verileri['aciklama'] ?? '') ?></textarea>
                                </div>
                            </div>
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <thead class="table-light">
                                        <tr>
                                             <th style="width: 5%;">#</th>
                                            <th style="width: 31%;"><?= __('product_name') ?></th>
                                            <th style="width: 10%;"><?= __('quantity') ?></th>
                                            <th style="width: 10%;"><?= __('unit_price') ?></th>
                                            <?php if ($coklu_para_birimi_aktif): ?><th style="width: 10%;">Kur</th><?php endif; ?>
                                            <?php if ($coklu_para_birimi_aktif): ?><th style="width: 10%;">Güncel Kur</th><?php endif; ?>
                                            <th style="width: 8%;"><?= __('rate') ?></th>
                                            <th style="width: 10%;"><?= __('vat_amount') ?></th>
                                            <th style="width: 10%;"><?= __('total') ?></th>
                                            <th style="width: 5%;"><?= __('delete') ?></th>
                                        </tr>
                                    </thead>
                                    <tbody id="urunListesi">
                                        <!-- Ürün satırları buraya eklenecek -->
                                    </tbody>
                                </table>
                            </div>
                            <div class="row mt-3">
                                <div class="col-12 mb-2">
                                    <div class="p-2 bg-white rounded">
                                        <i class="bi bi-box-seam me-2"></i>
                                        <strong id="toplamUrunAdedi">0 adet ürün eklendi</strong>
                                    </div>
                                </div>
                                <div class="col-md-5 ms-auto">
                                    <div class="toplam-alan p-3">
                                        <ul class="list-group">
                                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                                <?= __('subtotal') ?>: <span><span id="araToplam">0,00</span><span id="araToplamParaBirimi"> <?= $sirket_para_birimi ?></span></span>
                                            </li>
                                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                                <?= __('total_vat') ?>: <span><span id="toplamKdv">0,00</span><span id="toplamKdvParaBirimi"> <?= $sirket_para_birimi ?></span></span>
                                            </li>
                                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                                <?= __('discount') ?>:
                                                <div style="width: 120px;">
                                                    <input type="text" class="form-control form-control-sm text-end" id="indirim_tutari" name="indirim_tutari" value="0,00" oninput="genelToplamGuncelle()">
                                                </div>
                                            </li>
                                            <li class="list-group-item d-flex justify-content-between align-items-center bg-light">
                                                <strong><?= __('grand_total') ?>:</strong> <strong><span id="toplamTutar">0,00</span><span id="genelToplamParaBirimi"> <?= $sirket_para_birimi ?></span></strong>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    
                    <!-- 3. Ödeme Bilgileri -->
                    <div class="card shadow-sm mb-4">
                        <div class="card-header bg-light">
                            <h5 class="mb-0"><i class="bi bi-credit-card me-2"></i><?= __('payment_transactions') ?></h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="1" id="pesin_odendi" name="pesin_odendi" <?= (isset($form_verileri['pesin_odendi']) && $form_verileri['pesin_odendi'] == '1') ? 'checked' : '' ?>>
                                        <label class="form-check-label" for="pesin_odendi"><?= __('payment_made_in_cash') ?></label>
                                    </div>
                                </div>
                                <div id="vadeli_alanlar" class="col-md-6 mb-3">
                                    <label for="vade_tarihi" class="form-label"><?= __('due_date') ?></label>
                                    <input type="date" class="form-control" id="vade_tarihi" name="vade_tarihi" value="<?= htmlspecialchars($form_verileri['vade_tarihi'] ?? '') ?>">
                                </div>
                                <div id="pesin_alanlar" class="col-md-12 hidden">
                                     <div class="row">
                                         <div class="col-md-6 mb-3">
                                             <label for="hesap_id" class="form-label"><?= __('payment_account') ?> <span class="text-danger">*</span></label>
                                             <select class="form-select" id="hesap_id" name="hesap_id">
                                                 <option value=""><?= __('select_account') ?></option>
                                                 <?php foreach ($hesaplar as $hesap): ?>
                                                     <option value="<?= $hesap['id'] ?>" <?= (isset($form_verileri['hesap_id']) && $form_verileri['hesap_id'] == $hesap['id']) ? 'selected' : '' ?>><?= temizle($hesap['hesap_adi']) ?> (<?= number_format($hesap['bakiye'], 2) ?> <?= $paraBirimi ?>)</option>
                                                 <?php endforeach; ?>
                                             </select>
                                         </div>
                                         <div class="col-md-6 mb-3">
                                             <label for="odeme_tarihi" class="form-label"><?= __('payment_date') ?></label>
                                             <input type="date" class="form-control" id="odeme_tarihi" name="odeme_tarihi" value="<?= htmlspecialchars($form_verileri['odeme_tarihi'] ?? date('Y-m-d')) ?>">
                                         </div>
                                     </div>
                                 </div>
                            </div>
                        </div>
                    </div>

                    <!-- Kaydet Butonu -->
                    <div class="card shadow-sm">
                        <div class="card-body text-center">
                            <button type="submit" class="btn btn-primary btn-lg"><i class="bi bi-save me-2"></i> <?= __('save_purchase') ?></button>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>

    <!-- Modals -->
    <div class="modal fade" id="urunSecModal" tabindex="-1" aria-labelledby="urunSecModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="urunSecModalLabel"><?= __('select_products') ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row mb-3">
                        <div class="col-md-8">
                            <input type="text" class="form-control" id="urunArama" placeholder="<?= __('search_product_barcode') ?>">
                        </div>
                        <div class="col-md-4">
                            <select class="form-select" id="tedarikciFiltre">
                                <option value=""><?= __('all_suppliers') ?></option>
                                <?php
                                // Tedarikçi listesini getir
                                $stmt_tedarikciler = $db->prepare("
                                    SELECT DISTINCT c.id, c.ad_soyad 
                                    FROM cariler c 
                                    JOIN urunler u ON c.id = u.tedarikci_id AND u.sirket_id = c.sirket_id
                                    WHERE u.tedarikci_id IS NOT NULL AND c.sirket_id = ? 
                                    ORDER BY c.ad_soyad
                                ");
                                $stmt_tedarikciler->execute([$aktif_sirket_id]);
                                $tedarikciler = $stmt_tedarikciler->fetchAll(PDO::FETCH_ASSOC);
                                foreach ($tedarikciler as $tedarikci): ?>
                                    <option value="<?= $tedarikci['id'] ?>"><?= temizle($tedarikci['ad_soyad']) ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div id="urunSonuclari" style="max-height: 300px; overflow-y: auto;"></div>
                </div>
            </div>
        </div>
    </div>
    
    <?php include __DIR__ . '/../includes/cari_ekle_modal.php'; ?>

    <script src="<?= BASE_URL ?>/assets/js/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // PHP'den gelen ayarı JavaScript değişkenine ata
        const cokluParaBirimiAktif = <?= $coklu_para_birimi_aktif ? 'true' : 'false' ?>;
    </script>
    <script>
        // Başlangıç fatura para birimini PHP'den al ve global değişkene ata
        (function(){
            var pb = '<?= strtoupper($sirket_para_birimi ?? 'TL') ?>';
            if (pb === 'TRY' || pb === 'TL') pb = 'TL';
            window.initialFaturaParaBirimi = pb;
        })();
    </script>
    <script>
        // Para birimi seçimi değiştiğinde toplam alanlarındaki para birimi etiketlerini anında güncelle
        document.addEventListener('DOMContentLoaded', function() {
            const pbSelect = document.getElementById('fatura_para_birimi');
            const araPB = document.getElementById('araToplamParaBirimi');
            const genelPB = document.getElementById('genelToplamParaBirimi');

            function applyPBLabel() {
                if (!pbSelect || !araPB || !genelPB) return;
                const val = (pbSelect.value || '').toUpperCase();
                const goster = (val === 'TRY' || val === 'TL') ? 'TL' : val;
                araPB.textContent = ' ' + goster;
                genelPB.textContent = ' ' + goster;
            }

            if (pbSelect) {
                pbSelect.addEventListener('change', applyPBLabel);
                applyPBLabel(); // ilk yüklemede mevcut seçime göre ayarla
            }
        });
    </script>
    <script>
        // Peşin ödeme checkbox kontrolü
        document.addEventListener('DOMContentLoaded', function() {
            const pesinOdendiCheckbox = document.getElementById('pesin_odendi');
            const pesinAlanlar = document.getElementById('pesin_alanlar');
            const vadeliAlanlar = document.getElementById('vadeli_alanlar');

            function toggleOdemeAlanlari() {
                if (pesinOdendiCheckbox.checked) {
                    pesinAlanlar.classList.remove('hidden');
                    vadeliAlanlar.classList.add('hidden');
                } else {
                    pesinAlanlar.classList.add('hidden');
                    vadeliAlanlar.classList.remove('hidden');
                }
            }

            pesinOdendiCheckbox.addEventListener('change', toggleOdemeAlanlari);

            // Sayfa yüklendiğinde durumu kontrol et
            toggleOdemeAlanlari();
        });
    </script>
    <script>
    // Sayfa bazlı: DB'den gelen kurlarla harici fetch yerine çalışacak fonksiyon
    (function(){
        <?php $dk = $doviz_kurlari ?? []; ?>
        const dovizKurlari = <?= json_encode($dk, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES) ?>;
        // Yardımcı: belirli PB için obje bul
        function findPB(kod){
            if (!kod) return null;
            return dovizKurlari.find(k => k.para_birimi === kod.toUpperCase()) || null;
        }
        // Cross-rate hesaplama: urunPB -> hedefPB
        window.fetchKur = async function(fromPB, toPB){
            // TL uygulamada TRY kodu ile tutuluyor olabilir
            const from = (fromPB === 'TL') ? 'TRY' : (fromPB||'').toUpperCase();
            const to = (toPB === 'TL') ? 'TRY' : (toPB||'').toUpperCase();
            if (!from || !to || from === to) return 1.0;

            // TL -> yabancı: 1 TRY kaç foreign? Bizde tablo foreign/TRY: satis = 1 foreign kaç TRY
            // Dönüşüm mantığı:
            // - from = TRY, to = FX: kur = 1 / FX.satis (TRY -> FX)
            // - from = FX, to = TRY: kur = FX.satis (FX -> TRY)
            // - from = FX1, to = FX2: kur = FX1.satis / FX2.satis
            const fromRec = (from === 'TRY') ? null : findPB(from);
            const toRec = (to === 'TRY') ? null : findPB(to);

            if (from === 'TRY' && toRec) {
                const val = 1.0 / parseFloat(toRec.satis || '1');
                return isNaN(val) ? 1.0 : val;
            }
            if (to === 'TRY' && fromRec) {
                const val = parseFloat(fromRec.satis || '1');
                return isNaN(val) ? 1.0 : val;
            }
            if (fromRec && toRec) {
                const val = parseFloat(fromRec.satis || '1') / parseFloat(toRec.satis || '1');
                return isNaN(val) ? 1.0 : val;
            }
            return 1.0;
        };

        // Fatura para birimi değişince satır kurlarını ve toplamları güncelle
        window.handleFaturaParaBirimiChange = async function() {
            const yeniParaBirimi = this.value;
            const araToplamParaBirimi = document.getElementById('araToplamParaBirimi');
            const toplamKdvParaBirimi = document.getElementById('toplamKdvParaBirimi');
            const genelToplamParaBirimi = document.getElementById('genelToplamParaBirimi');

            // Etiketleri güncelle
            if (araToplamParaBirimi) araToplamParaBirimi.textContent = ' ' + yeniParaBirimi;
            if (toplamKdvParaBirimi) toplamKdvParaBirimi.textContent = ' ' + yeniParaBirimi;
            if (genelToplamParaBirimi) genelToplamParaBirimi.textContent = ' ' + yeniParaBirimi;

            const promises = [];
            document.querySelectorAll('#urunListesi tr').forEach(row => {
                const alisParaBirimiInput = row.querySelector('input[name="alis_para_birimi[]"]');
                const kurInput = row.querySelector('input[name="kur[]"]');
                if (!alisParaBirimiInput || !kurInput) return;

                const alisParaBirimi = alisParaBirimiInput.value;
                if ((alisParaBirimi || '').toUpperCase() === (yeniParaBirimi || '').toUpperCase()) {
                    kurInput.value = (1.0).toFixed(4);
                    kurInput.readOnly = true;
                } else {
                    kurInput.readOnly = false;
                    const p = window.fetchKur(alisParaBirimi, yeniParaBirimi).then(yeniKur => {
                        kurInput.value = (parseFloat(yeniKur) || 1.0).toFixed(4);
                    });
                    promises.push(p);
                }
            });

            await Promise.all(promises);
            if (typeof window.genelToplamGuncelle === 'function') window.genelToplamGuncelle();
        };
    })();
    </script>
    <script src="js/fatura.js"></script>
    <script src="js/stokarama.js"></script>
    <script src="js/cariarama.js"></script>
     <!-- Bu dosya adını kontrol etmek gerekebilir -->
    <script>
    // Peşin ödeme checkbox kontrolü
    document.addEventListener('DOMContentLoaded', function() {
        const pesinCheckbox = document.getElementById('pesin_odendi');
        const vadeliAlanlar = document.getElementById('vadeli_alanlar');
        const pesinAlanlar = document.getElementById('pesin_alanlar');
        const vadeInput = document.getElementById('vade_tarihi');
        const hesapInput = document.getElementById('hesap_id');

        function toggleAlanlar() {
            if (pesinCheckbox.checked) {
                vadeliAlanlar.classList.add('hidden');
                pesinAlanlar.classList.remove('hidden');
                vadeInput.required = false;
                hesapInput.required = true;
            } else {
                vadeliAlanlar.classList.remove('hidden');
                pesinAlanlar.classList.add('hidden');
                vadeInput.required = false;
                hesapInput.required = false;
            }
        }

        pesinCheckbox.addEventListener('change', toggleAlanlar);
        toggleAlanlar(); // Sayfa yüklendiğinde çalıştır
    });
    
    // AJAX ile cari ekleme işlemi
    $(function(){
        $('#cariEkleBtn').off('click').on('click', function() {
            var form = $('#yeniCariForm');
            var btn = $(this);
            btn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm"></span> Kaydediliyor...');
            $.ajax({
                url: '<?= BASE_URL ?>/ajax/cari_ekle_ajax.php',
                method: 'POST',
                data: form.serialize(),
                dataType: 'json',
                success: function(data) {
                    if(data.success) {
                        $('#cariEkleMessage').removeClass('d-none alert-danger').addClass('alert-success').text(data.message);
                        setTimeout(function(){
                            $('#yeniCariModal').modal('hide');
                            form[0].reset();
                            $('#cariEkleMessage').addClass('d-none');
                            // Sayfada cari arama varsa otomatik ekle
                             if ($('#cari_arama').length) {
                                $('#cari_id').val(data.id);
                                const selectedText = '<?= addslashes(__('selected')) ?>';
                                $('#seciliCari').html(`<div class="alert alert-success p-2">${selectedText}: <strong>${data.ad_soyad}</strong></div>`);
                                $('#cariSonuclar').hide();
                            }
                        }, 1000);
                    } else {
                        $('#cariEkleMessage').removeClass('d-none alert-success').addClass('alert-danger').text(data.message);
                    }
                },
                error: function() {
                    $('#cariEkleMessage').removeClass('d-none alert-success').addClass('alert-danger').text('Cari eklenirken bir hata oluştu.');
                },
                complete: function() {
                    btn.prop('disabled', false).html('Cari Ekle');
                }
            });
        });
    });
    </script>
    
    <?php include __DIR__ . '/../includes/footer.php'; ?>
</body>
</html>
