<?php
ob_start(); // Sayfa çıktısını tamponlamayı başlat
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/ayar_fonksiyonlari.php'; // Genel ayar fonksiyonları
require_once __DIR__ . '/../includes/yetki_kontrol.php';    // Yetki kontrolü fonksiyonları
require_once __DIR__ . '/../functions/yardimci_fonksiyonlar.php'; // temizle, csrf_token_dogrula, csrf_token_olustur vb.
require_once __DIR__ . '/../functions/log_fonksiyonlari.php'; // Loglama fonksiyonları (alt dosyalarda da kullanılabilecek)

$sayfa_baslik = __("site_settings");

// Yalnızca adminler erişebilir
yetki_kontrol_ve_yonlendir('ayarlar', 'goruntule');

$current_section = $_GET['section'] ?? 'genel'; // Varsayılan olarak GENEL ayarlar (Türkçe)

$csrf_token = csrf_token_olustur(); // CSRF token ana sayfada oluşturulup alt sayfalara aktarılır.

// Bu kısım, alt dosyalardan gelen session mesajlarını görüntüler.
// Navbar'da zaten global mesajlar gösteriliyor, bu yüzden burada tekrar göstermek isteyip istemediğinize siz karar verin.
// Eğer navbar'da gösterilen genel mesajlar sizin için yeterliyse, aşağıdaki foreach döngülerini kaldırabilirsiniz.
/*
if (isset($_SESSION["mesaj"])) {
    echo "<div class=\"container mt-3\"><div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">" . temizle($_SESSION["mesaj"]) . "<button type=\"button\" class=\"btn-close\" data-bs-dismiss=\"alert\" aria-label=\"Close\"></button></div></div>";
    unset($_SESSION["mesaj"]);
}
if (isset($_SESSION["hata"])) {
    echo "<div class=\"container mt-3\"><div class=\"alert alert-danger alert-dismissible fade show\" role=\"alert\">" . temizle($_SESSION["hata"]) . "<button type=\"button\" class=\"btn-close\" data-bs-dismiss=\"alert\" aria-label=\"Close\"></button></div></div>";
    unset($_SESSION["hata"]);
}
*/
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= __("odjoo_management") ?> - <?= temizle($sayfa_baslik) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <style>
        body {
            background-color: #f8f9fa; /* Arka plan rengi */
        }
        .settings-sidebar {
            background-color: #ffffff; /* Beyaz arka plan */
            padding: 20px;
            border-radius: 0.75rem; /* Daha yuvarlak köşeler */
            box-shadow: 0 0.25rem 0.75rem rgba(0, 0, 0, 0.08); /* Daha belirgin gölge */
            min-height: 500px;
        }
        .settings-sidebar h5 {
            color: #343a40; /* Koyu gri başlık */
            padding-bottom: 15px;
            margin-bottom: 15px;
            border-bottom: 1px solid #e9ecef; /* Alt çizgi */
        }
        .settings-sidebar .nav-link {
            color: #495057; /* Varsayılan menü rengi */
            border-radius: 0.5rem; /* Daha yuvarlak link köşeleri */
            margin-bottom: 8px; /* Linkler arası boşluk */
            transition: all 0.3s ease; /* Yumuşak geçiş efekti */
            display: flex; /* İkon ve metni hizalamak için */
            align-items: center; /* Dikeyde ortalama */
        }
        .settings-sidebar .nav-link:hover {
            background-color: #e2e6ea; /* Hover arka planı */
            color: #0056b3; /* Hover rengi */
        }
        .settings-sidebar .nav-link.active {
            background-color: #007bff; /* Aktif arka plan */
            color: white; /* Aktif yazı rengi */
            font-weight: 600; /* Daha kalın font */
            box-shadow: 0 0.125rem 0.25rem rgba(0, 123, 255, 0.2); /* Aktif duruma gölge */
        }
        .settings-sidebar .nav-link.active i {
            color: white; /* Aktif ikon rengi */
        }
        .settings-sidebar .nav-link i {
            margin-right: 10px; /* İkon ile metin arası boşluk */
            font-size: 1.1em; /* İkon boyutu */
        }
    </style>
</head>
<body>
    <?php include __DIR__ . '/../includes/navbar.php'; ?>

    <div class="container mt-4">
        <div class="row">
		
				
					
            <div class="col-md-3">
                <div class="settings-sidebar shadow-sm">
                    <h5 class="mb-3"><?= __("settings_menu") ?></h5>
                    <nav class="nav flex-column">
                        <a class="nav-link <?= ($current_section == 'genel' || $current_section == 'moduller') ? 'active' : '' ?>" href="<?= BASE_URL ?>/views/ayarlar.php?section=genel">
                            <i class="bi bi-gear me-2"></i> <?= __("module_settings") ?>
                        </a>
                        <a class="nav-link <?= ($current_section == 'hesaplar') ? 'active' : '' ?>" href="<?= BASE_URL ?>/views/ayarlar.php?section=hesaplar">
                            <i class="bi bi-tags me-2"></i> <?= __("cash_and_bank_accounts") ?>
                        </a>
						<a class="nav-link <?= ($current_section == 'kategoriler') ? 'active' : '' ?>" href="<?= BASE_URL ?>/views/ayarlar.php?section=kategoriler">
                            <i class="bi bi-tags me-2"></i> <?= __("categories") ?>
                        </a>
                        <a class="nav-link <?= ($current_section == 'markalar') ? 'active' : '' ?>" href="<?= BASE_URL ?>/views/ayarlar.php?section=markalar">
                            <i class="bi bi-award me-2"></i> <?= __("brands") ?>
                        </a>
                        <a class="nav-link <?= ($current_section == 'depolar') ? 'active' : '' ?>" href="<?= BASE_URL ?>/views/ayarlar.php?section=depolar">
                            <i class="bi bi-building me-2"></i> <?= __("warehouse_management") ?>
                        </a>
                        <a class="nav-link <?= ($current_section == 'raflar') ? 'active' : '' ?>" href="<?= BASE_URL ?>/views/ayarlar.php?section=raflar">
                            <i class="bi bi-bookshelf me-2"></i> <?= __("shelf_management") ?>
                        </a>
                        <a class="nav-link <?= ($current_section == 'cari_gruplari') ? 'active' : '' ?>" href="<?= BASE_URL ?>/views/ayarlar.php?section=cari_gruplari">
                            <i class="bi bi-collection-fill me-2"></i> <?= __("current_account_groups") ?>
                        </a>
						<a class="nav-link <?= ($current_section == 'stok_ayarlari') ? 'active' : '' ?>" href="<?= BASE_URL ?>/views/ayarlar.php?section=stok_ayarlari">
                            <i class="bi bi-box-seam me-2"></i> <?= __("stock_settings") ?>
                        </a>
                        <a class="nav-link <?= ($current_section == 'faturalar') ? 'active' : '' ?>" href="<?= BASE_URL ?>/views/ayarlar.php?section=faturalar">
                            <i class="bi bi-receipt me-2"></i> <?= __("invoices") ?>
                        </a>
						<a class="nav-link <?= ($current_section == 'firma_yonetimi') ? 'active' : '' ?>" href="<?= BASE_URL ?>/views/ayarlar.php?section=firma_yonetimi">
                            <i class="bi bi-buildings me-2"></i> <?= __("company_management") ?>
                        </a>
						<a class="nav-link <?= ($current_section == 'yetki_seviyeleri') ? 'active' : '' ?>" href="<?= BASE_URL ?>/views/ayarlar.php?section=yetki_seviyeleri">
                            <i class="bi bi-tags me-2"></i> <?= __("permission_levels") ?>
						</a>
						<a class="nav-link <?= ($current_section == 'guvenlik') ? 'active' : '' ?>" href="<?= BASE_URL ?>/views/ayarlar.php?section=guvenlik">
                            <i class="bi bi-tags me-2"></i> <?= __("screen_lock") ?>
						</a>
                        </nav>
                </div>
            </div>

            <div class="col-md-9">
                    <?php
                    // Seçilen bölüme göre ilgili dosyayı dahil et
                    $include_file = __DIR__ . '/ayarlar/' . $current_section . '.php';
                    if (file_exists($include_file)) {
                        include $include_file;
                    } else {
                        // Geçersiz bölüm durumunda varsayılan olarak genel ayarları göster
                        include __DIR__ . '/ayarlar/genel.php'; 
                    }
                    ?>
            </div>
    </div>
    </div> <!-- Yeni eklenen kapanış div'i -->
      <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
      <?php include __DIR__ . '/../includes/footer.php'; ?>
</body>
</html>
<?php ob_end_flush(); // Tamponu temizle ve çıktıyı gönder ?>
