<?php
require_once __DIR__ . '/../../includes/config.php';
require_once __DIR__ . '/../../includes/yetki_kontrol.php';
yetki_kontrol_ve_yonlendir('ayarlar', 'sil');

$aktif_sirket_id = $_SESSION['aktif_sirket_id'];

// Gerekli parametreleri ve güvenlik tokenını kontrol et
$depo_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$depo_id || !isset($_GET['csrf_token']) || !csrf_token_dogrula($_GET['csrf_token'])) {
    $_SESSION['hata'] = __("invalid_request_or_token");
    header("Location: ../ayarlar.php?section=depolar");
    exit();
}

try {
    // 1. Deponun varlığını ve şirkete ait olduğunu doğrula
    $stmt_check_owner = $db->prepare("SELECT COUNT(*) FROM depolar WHERE id = ? AND sirket_id = ?");
    $stmt_check_owner->execute([$depo_id, $aktif_sirket_id]);
    if ($stmt_check_owner->fetchColumn() == 0) {
        throw new Exception(__("warehouse_not_found"));
    }

    // 2. Bu deponun herhangi bir ürün tarafından kullanılıp kullanılmadığını kontrol et
    $stmt_check_usage = $db->prepare("SELECT COUNT(*) FROM urun_depo_raf WHERE depo_id = ? AND sirket_id = ?");
    $stmt_check_usage->execute([$depo_id, $aktif_sirket_id]);
    if ($stmt_check_usage->fetchColumn() > 0) {
        throw new Exception(__("warehouse_in_use"));
    }
    
    // 3. Hiçbir yerde kullanılmıyorsa sil
    // Önce depo bilgilerini al (geri alma için)
    $stmt_depo = $db->prepare("SELECT * FROM depolar WHERE id = ? AND sirket_id = ?");
    $stmt_depo->execute([$depo_id, $aktif_sirket_id]);
    $depo = $stmt_depo->fetch(PDO::FETCH_ASSOC);
    
    // Depoyu sil
    $stmt_delete = $db->prepare("DELETE FROM depolar WHERE id = ? AND sirket_id = ?");
    $stmt_delete->execute([$depo_id, $aktif_sirket_id]);

    if ($stmt_delete->rowCount() > 0) {
        // Silinen kaydı logla ve geri alma için sakla
        $log_id = sistem_log_ekle($db, 'sil', 'depolar', $depo_id, $depo, null, __('warehouse_deleted_successfully') . ': ' . $depo['depo_adi']);
        if ($log_id) {
            silinen_kayit_ekle($db, $log_id, 'depolar', $depo_id, $depo);
        }
        $_SESSION['mesaj'] = __("warehouse_deleted_successfully");
    } else {
        throw new Exception(__("warehouse_not_found"));
    }

} catch (Exception $e) {
    error_log("Depo silme hatası: " . $e->getMessage());
    $_SESSION['hata'] = $e->getMessage();
}

// Sonuç ne olursa olsun ana sayfaya geri dön
header("Location: ../ayarlar.php?section=depolar");
exit();
?>
