<?php
// Bu dosya, ana ayarlar.php tarafından include edildiği için,
// temel include'lar ve yetkilendirme zaten yapılmıştır.
$aktif_sirket_id = $_SESSION['aktif_sirket_id'];

// Log fonksiyonlarını dahil et
require_once __DIR__ . '/../../functions/log_fonksiyonlari.php';

// Düzenlenecek depo bilgileri
$duzenlenecek_depo = [
    'id' => '',
    'depo_adi' => '',
    'aciklama' => ''
];

// Depo düzenleme için verileri çek
if (isset($_GET['duzenle'])) {
    $depo_id = (int)$_GET['duzenle'];
    try {
        $stmt = $db->prepare("SELECT id, depo_adi, aciklama FROM depolar WHERE id = ? AND sirket_id = ?");
        $stmt->execute([$depo_id, $aktif_sirket_id]);
        $duzenlenecek_depo = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$duzenlenecek_depo) {
            $_SESSION['hata'] = __("warehouse_not_found");
            header("Location: ayarlar.php?section=depolar");
            exit();
        }
    } catch (PDOException $e) {
        error_log("Depo getirme hatası: " . $e->getMessage());
        $_SESSION['hata'] = __("error_loading_warehouse");
    }
}

// Depo ekleme veya güncelleme
if ($_SERVER['REQUEST_METHOD'] == 'POST' && (isset($_POST['depo_ekle']) || isset($_POST['depo_guncelle']))) {
    if (!csrf_token_dogrula($_POST['csrf_token'] ?? '')) {
        $_SESSION['hata'] = __("invalid_security_token");
    } else {
        $depo_adi = trim(temizle($_POST['depo_adi']));
        $aciklama = trim(temizle($_POST['aciklama'] ?? ''));
        $depo_id = isset($_POST['depo_id']) ? (int)$_POST['depo_id'] : null;

        if (empty($depo_adi)) {
            $_SESSION['hata'] = __("warehouse_name_required");
        } else {
            try {
                if (isset($_POST['depo_guncelle']) && $depo_id) {
                    // Depo güncelleme
                    // Yeni adın başka bir depoda kullanılıp kullanılmadığını kontrol et
                    $stmt_check = $db->prepare("SELECT id FROM depolar WHERE depo_adi = ? AND sirket_id = ? AND id != ?");
                    $stmt_check->execute([$depo_adi, $aktif_sirket_id, $depo_id]);
                    if ($stmt_check->fetch()) {
                        throw new Exception(__("warehouse_name_exists"));
                    }

                    $stmt_update = $db->prepare("UPDATE depolar SET depo_adi = ?, aciklama = ? WHERE id = ? AND sirket_id = ?");
                    $stmt_update->execute([$depo_adi, $aciklama, $depo_id, $aktif_sirket_id]);
                    
                    // Log ekle
                    sistem_log_ekle(
                        $db,
                        'guncelle',
                        'depolar',
                        $depo_id,
                        ['depo_adi' => $duzenlenecek_depo['depo_adi']],
                        ['depo_adi' => $depo_adi],
                        __('warehouse_updated_successfully') . ': ' . $depo_adi,
                        $kullanici_id
                    );
                    
                    $_SESSION['mesaj'] = __("warehouse_updated_successfully");
                } else {
                    // Depo ekleme
                    // Şirket bazında depo adı kontrolü
                    $stmt_check = $db->prepare("SELECT id FROM depolar WHERE depo_adi = ? AND sirket_id = ?");
                    $stmt_check->execute([$depo_adi, $aktif_sirket_id]);
                    if ($stmt_check->fetch()) {
                        throw new Exception(__("warehouse_name_exists"));
                    }

                    $stmt = $db->prepare("INSERT INTO depolar (sirket_id, depo_adi, aciklama) VALUES (?, ?, ?)");
                    $stmt->execute([$aktif_sirket_id, $depo_adi, $aciklama]);
                    
                    // Log ekle
                    $yeni_depo_id = $db->lastInsertId();
                    sistem_log_ekle(
                        $db,
                        'ekle',
                        'depolar',
                        $yeni_depo_id,
                        null,
                        ['depo_adi' => $depo_adi],
                        __('warehouse_added_successfully') . ': ' . $depo_adi,
                        $kullanici_id
                    );
                    
                    $_SESSION['mesaj'] = __("warehouse_added_successfully");
                }
            } catch (Exception $e) {
                error_log("Depo işlem hatası: " . $e->getMessage());
                $_SESSION['hata'] = $e->getMessage();
            }
        }
    }
    // Kullanıcıyı sayfada tutmak için yönlendir
    header("Location: ?section=depolar");
    exit();
}

// Depoları getir (sadece aktif şirkete ait olanları)
$depolar = [];
try {
    $stmt = $db->prepare("SELECT id, depo_adi, aciklama FROM depolar WHERE sirket_id = ? ORDER BY depo_adi");
    $stmt->execute([$aktif_sirket_id]);
    $depolar = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch(PDOException $e) {
    error_log("Depo listeleme hatası: " . $e->getMessage());
    $_SESSION['hata'] = __("error_loading_warehouse");
}

?>

<?php if (isset($_SESSION['mesaj'])): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert"><?= $_SESSION['mesaj']; unset($_SESSION['mesaj']); ?><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>
<?php endif; ?>
<?php if (isset($_SESSION['hata'])): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert"><?= $_SESSION['hata']; unset($_SESSION['hata']); ?><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>
<?php endif; ?>

<h3 class="mb-4"><i class="bi bi-building me-2"></i><?= __("warehouse_management") ?></h3>

<div class="row">
    <div class="col-md-4">
        <div class="card shadow-sm mb-3">
            <div class="card-header bg-<?= $duzenlenecek_depo['id'] ? 'warning' : 'success' ?> text-white">
                <h5 class="mb-0"><i class="bi <?= $duzenlenecek_depo['id'] ? 'bi-pencil-square' : 'bi-plus-circle' ?> me-2"></i><?= $duzenlenecek_depo['id'] ? __('edit_warehouse') : __('add_new_warehouse') ?></h5>
            </div>
            <div class="card-body">
                <form method="post" action="ayarlar.php?section=depolar">
                    <input type="hidden" name="csrf_token" value="<?= $csrf_token ?>">
                    <?php if ($duzenlenecek_depo['id']): ?>
                        <input type="hidden" name="depo_id" value="<?= $duzenlenecek_depo['id'] ?>">
                    <?php endif; ?>
                    <div class="mb-3">
                        <label for="depo_adi" class="form-label"><?= __("warehouse_name") ?> <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="depo_adi" name="depo_adi" value="<?= htmlspecialchars($duzenlenecek_depo['depo_adi'], ENT_QUOTES) ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="aciklama" class="form-label"><?= __("description") ?></label>
                        <textarea class="form-control" id="aciklama" name="aciklama" rows="3"><?= htmlspecialchars($duzenlenecek_depo['aciklama'] ?? '', ENT_QUOTES) ?></textarea>
                    </div>
                    <?php if ($duzenlenecek_depo['id']): ?>
                        <div class="d-flex justify-content-center gap-2">
                            <button type="submit" name="depo_guncelle" class="btn btn-warning flex-fill">
                                <i class="bi bi-check-circle me-1"></i> <?= __("update") ?>
                            </button>
                            <a href="?section=depolar" class="btn btn-secondary flex-fill">
                                <i class="bi bi-x-circle me-1"></i> <?= __("cancel") ?>
                            </a>
                        </div>
                    <?php else: ?>
                        <button type="submit" name="depo_ekle" class="btn btn-success w-100">
                            <i class="bi bi-save me-1"></i> <?= __("save") ?>
                        </button>
                    <?php endif; ?>
                </form>
            </div>
        </div>
    </div>
    <div class="col-md-8">
        <div class="card shadow-sm">
             <div class="card-header"><h5 class="mb-0"><i class="bi bi-list-ul me-2"></i><?= __('existing_warehouses'); ?></h5></div>
            <div class="card-body p-0">
                <?php if (!empty($depolar)): ?>
                    <div class="table-responsive">
                        <table class="table table-striped table-hover mb-0">
                            <thead>
                                <tr>
                                    <th><?= __("warehouse_name") ?></th>
                                    <th><?= __("description") ?></th>
                                    <th class="text-end" style="width: 200px;"><?= __("actions") ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($depolar as $depo): ?>
                                <tr>
                                    <td><?= temizle($depo['depo_adi']) ?></td>
                                    <td><?= temizle($depo['aciklama'] ?? '-') ?></td>
                                    <td class="text-end">
                                        <div class="btn-group btn-group-sm" role="group">
                                            <a href="?section=depolar&duzenle=<?= $depo['id'] ?>" class="btn btn-outline-warning" title="<?= __("edit_warehouse") ?>">
                                                <i class="bi bi-pencil"></i> <?= __("edit") ?>
                                            </a>
                                            <a href="ayarlar/depo_sil.php?id=<?= $depo['id'] ?>&csrf_token=<?= $csrf_token ?>" class="btn btn-outline-danger" title="<?= __("delete_warehouse") ?>" onclick="return confirm('<?= __("confirm_delete_warehouse") ?>')">
                                                <i class="bi bi-trash"></i> <?= __("delete") ?>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <div class="alert alert-light m-3 text-center" role="alert">
                       <?= __('no_warehouses_found') ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
