<?php
// Aktif şirket ID'sini al
$aktif_sirket_id = $_SESSION['aktif_sirket_id'] ?? 0;

// Fatura ayarlarını işle
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['fatura_ayarlari_kaydet'])) {
    try {
        // CSRF token doğrulama
        csrf_token_dogrula($_POST['csrf_token']);
        
        // Form verilerini al
        $urun_adetleri_goster = isset($_POST['urun_adetleri_goster']) ? 1 : 0;
        
        // Ayarları güncelle
        update_site_setting($db, 'fatura_urun_adetleri_goster', $urun_adetleri_goster, $aktif_sirket_id);
        
        // Başarı mesajı
        $_SESSION['mesaj'] = __('settings_updated_successfully');
        
        // Sayfayı yenile
        header('Location: ' . $_SERVER['REQUEST_URI']);
        exit();
    } catch (Exception $e) {
        $_SESSION['hata'] = $e->getMessage();
    }
}

// Mevcut ayarları yükle
$urun_adetleri_goster = (int)get_site_setting($db, 'fatura_urun_adetleri_goster', 1, $aktif_sirket_id);
?>

<div class="card shadow-sm">
    <div class="card-header bg-primary text-white">
        <h5 class="mb-0"><?= __('invoice_settings') ?></h5>
    </div>
    <div class="card-body">
        <form method="post" action="">
            <input type="hidden" name="csrf_token" value="<?= $csrf_token ?>">
            
            <div class="mb-3 form-check form-switch">
                <input type="checkbox" class="form-check-input" id="urun_adetleri_goster" name="urun_adetleri_goster" 
                       value="1" <?= $urun_adetleri_goster ? 'checked' : '' ?> >
                <label class="form-check-label" for="urun_adetleri_goster">
                    <?= __('show_product_quantities_in_invoices') ?>
                </label>
                <small class="form-text text-muted d-block">
                    <?= __('show_product_quantities_in_invoices_help') ?>
                </small>
            </div>
            
            <button type="submit" name="fatura_ayarlari_kaydet" class="btn btn-primary">
                <i class="bi bi-save me-1"></i> <?= __('save_settings') ?>
            </button>
        </form>
    </div>
</div>
