<?php
// Bu dosya, ana ayarlar.php tarafından include edilir.
yetkili_mi('admin'); // Sadece Adminler erişebilir

$sayfa_baslik = __("company_management");
$aktif_sirket_id = $_SESSION['aktif_sirket_id'] ?? 0;

// POST İşlemleri (Ekleme / Güncelleme)
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['sirket_kaydet'])) {
    if (!csrf_token_dogrula($_POST['csrf_token'] ?? '')) {
        $_SESSION['hata'] = __("invalid_security_token");
    } else {
        $sirket_id = filter_input(INPUT_POST, 'sirket_id', FILTER_VALIDATE_INT);
        $sirket_adi = temizle($_POST['sirket_adi']);
        $adres = temizle($_POST['adres'] ?? '');
        $telefon = temizle($_POST['telefon'] ?? '');
        $email = temizle($_POST['email'] ?? '');
        $aktif_mi = isset($_POST['aktif_mi']) ? 1 : 0;
        $logo_yolu = '';

        // Yeni eklenen ayarlar
        $para_birimi = temizle($_POST["para_birimi"] ?? "TRY");
        $teklifler_modulu_aktif = !empty($_POST["teklifler_modulu_aktif"]) ? '1' : '0';
        $stok_islemleri_aktif = !empty($_POST["stok_islemleri_aktif"]) ? '1' : '0';
        $coklu_para_birimi = !empty($_POST["coklu_para_birimi"]) ? '1' : '0';
        $depo_yonetimi_aktif = !empty($_POST["depo_yonetimi_aktif"]) ? '1' : '0';

        try {
            $db->beginTransaction();

            // Logo yükleme işlemi
            if (isset($_FILES['logo']) && $_FILES['logo']['error'] === UPLOAD_ERR_OK) {
                $upload_dir = __DIR__ . '/../../uploads/company_logos/';
                $file_extension = strtolower(pathinfo($_FILES['logo']['name'], PATHINFO_EXTENSION));
                $allowed_extensions = ['jpg', 'jpeg', 'png', 'gif'];
                
                if (in_array($file_extension, $allowed_extensions)) {
                    $new_filename = 'logo_' . ($sirket_id ?: 'new') . '_' . time() . '.' . $file_extension;
                    $target_file = $upload_dir . $new_filename;
                    
                    if (move_uploaded_file($_FILES['logo']['tmp_name'], $target_file)) {
                        $logo_yolu = 'uploads/company_logos/' . $new_filename;
                        
                        // Eski logoyu sil
                        if ($sirket_id && !empty($duzenlenecek_sirket['logo_yolu'])) {
                            $old_logo_path = __DIR__ . '/../../' . ltrim($duzenlenecek_sirket['logo_yolu'], '/');
                            if (file_exists($old_logo_path)) {
                                @unlink($old_logo_path);
                            }
                        }
                    } else {
                        throw new Exception(__("logo_upload_failed"));
                    }
                } else {
                    throw new Exception(__("invalid_file_type"));
                }
            } elseif ($sirket_id && !empty($duzenlenecek_sirket['logo_yolu'])) {
                $logo_yolu = $duzenlenecek_sirket['logo_yolu'];
            }
            
            if ($sirket_id) {
                // Güncelleme - Önce yetki kontrolü
                $stmt_yetki = $db->prepare("SELECT COUNT(*) FROM kullanici_sirket_iliskisi WHERE kullanici_id = ? AND sirket_id = ?");
                $stmt_yetki->execute([$_SESSION['kullanici_id'], $sirket_id]);
                if ($stmt_yetki->fetchColumn() == 0) {
                    throw new Exception(__("no_permission_to_update_company"));
                }
                
                $update_fields = "sirket_adi=?, adres=?, telefon=?, email=?, aktif_mi=?, para_birimi=?, teklifler_modulu_aktif=?, stok_islemleri_aktif=?, coklu_para_birimi=?, depo_yonetimi_aktif=?";
                $params = [$sirket_adi, $adres, $telefon, $email, $aktif_mi, $para_birimi, $teklifler_modulu_aktif, $stok_islemleri_aktif, $coklu_para_birimi, $depo_yonetimi_aktif];
                
                if (!empty($logo_yolu)) {
                    $update_fields .= ", logo_yolu=?";
                    $params[] = $logo_yolu;
                }
                
                $params[] = $sirket_id; // WHERE koşulu için
                
                $stmt = $db->prepare("UPDATE sirketler SET $update_fields WHERE id=?");
                $stmt->execute($params);
                
                // update_site_setting çağrıları kaldırıldı
                // update_site_setting($db, "teklifler_modulu_aktif", $teklifler_modulu_aktif, $sirket_id);
                // update_site_setting($db, "stok_islemleri_aktif", $stok_islemleri_aktif, $sirket_id);

                $_SESSION['mesaj'] = __("company_info_updated_successfully");
            } else {
                // Ekleme
                $stmt = $db->prepare("INSERT INTO sirketler (sirket_adi, adres, telefon, email, aktif_mi, para_birimi, teklifler_modulu_aktif, stok_islemleri_aktif, coklu_para_birimi, depo_yonetimi_aktif, logo_yolu) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                $stmt->execute([$sirket_adi, $adres, $telefon, $email, $aktif_mi, $para_birimi, $teklifler_modulu_aktif, $stok_islemleri_aktif, $coklu_para_birimi, $depo_yonetimi_aktif, $logo_yolu]);
                $yeni_sirket_id = $db->lastInsertId();
                
                // Eğer yeni bir şirket oluşturulduysa ve logo yüklendiyse, dosya adını güncelle
                if (!empty($logo_yolu) && $yeni_sirket_id) {
                    $new_path = 'uploads/company_logos/logo_' . $yeni_sirket_id . '_' . time() . '.' . pathinfo($logo_yolu, PATHINFO_EXTENSION);
                    rename(__DIR__ . '/../../' . $logo_yolu, __DIR__ . '/../../' . $new_path);
                    
                    $stmt = $db->prepare("UPDATE sirketler SET logo_yolu = ? WHERE id = ?");
                    $stmt->execute([$new_path, $yeni_sirket_id]);
                    $logo_yolu = $new_path;
                }

                // Şirketi oluşturan admini otomatik olarak bu şirkete ata
                $kullanici_id = $_SESSION['kullanici_id'];
                $stmt_iliski = $db->prepare("INSERT INTO kullanici_sirket_iliskisi (kullanici_id, sirket_id, rol) VALUES (?, ?, 'admin')");
                $stmt_iliski->execute([$kullanici_id, $yeni_sirket_id]);

                // update_site_setting çağrıları kaldırıldı
                // update_site_setting($db, "stok_islemleri_aktif", $stok_islemleri_aktif, $yeni_sirket_id);

                $_SESSION['mesaj'] = __("company_created_successfully");
            }
            $db->commit();
        } catch (PDOException $e) {
            $db->rollBack();
            $_SESSION['hata'] = "Veritabanı hatası: " . $e->getMessage();
        } catch (Exception $e) {
            $db->rollBack();
            $_SESSION['hata'] = $e->getMessage();
        }
    }
}

// Silme İşlemi
if (isset($_GET['sil'])) {
    if (!csrf_token_dogrula($_GET['csrf_token'] ?? '')) {
        $_SESSION['hata'] = __("invalid_security_token");
    } else {
        $sil_id = filter_input(INPUT_GET, 'sil', FILTER_VALIDATE_INT);
        if ($sil_id == $aktif_sirket_id) {
            $_SESSION['hata'] = __("cannot_delete_active_company");
        } elseif ($sil_id == 1) {
            $_SESSION['hata'] = __("cannot_delete_main_company");
        } else {
            try {
                // Silme yetkisi kontrolü
                $stmt_yetki = $db->prepare("SELECT COUNT(*) FROM kullanici_sirket_iliskisi WHERE kullanici_id = ? AND sirket_id = ?");
                $stmt_yetki->execute([$_SESSION['kullanici_id'], $sil_id]);
                if ($stmt_yetki->fetchColumn() == 0) {
                    $_SESSION['hata'] = __("no_permission_to_delete_company");
                } else {
                    $stmt = $db->prepare("DELETE FROM sirketler WHERE id = ?");
                    $stmt->execute([$sil_id]);
                    $_SESSION['mesaj'] = __("company_deleted_successfully");
                }
            } catch (PDOException $e) {
                $_SESSION['hata'] = "Silme işlemi sırasında hata oluştu: " . $e->getMessage();
            }
        }
    }
}

// Düzenleme için veri çekme ve şirket ayarlarını çekme
$duzenlenecek_sirket = null;
if (isset($_GET['duzenle'])) {
    $duzenle_id = filter_input(INPUT_GET, 'duzenle', FILTER_VALIDATE_INT);
    
    // Şirket temel bilgilerini ve yeni ayarları çek
    $stmt = $db->prepare("SELECT *, teklifler_modulu_aktif, stok_islemleri_aktif FROM sirketler WHERE id = ?");
    $stmt->execute([$duzenle_id]);
    $duzenlenecek_sirket = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($duzenlenecek_sirket) {
        // Eski ayar fonksiyonu çağrıları kaldırıldı
        $duzenlenecek_sirket['para_birimi'] = $duzenlenecek_sirket['para_birimi'] ?? 'TRY';
        // $duzenlenecek_sirket['teklifler_modulu_aktif'] = get_site_setting($db, 'teklifler_modulu_aktif', '1', $duzenle_id); kaldırıldı
        // $duzenlenecek_sirket['stok_islemleri_aktif'] = get_site_setting($db, 'stok_islemleri_aktif', '0', $duzenle_id); kaldırıldı
    }
}

// Logo silme işlemi
if (isset($_POST['logo_sil']) && $_POST['logo_sil'] == '1' && !empty($duzenlenecek_sirket['logo_yolu'])) {
    $logo_path = __DIR__ . '/../../' . $duzenlenecek_sirket['logo_yolu'];
    if (file_exists($logo_path)) {
        @unlink($logo_path);
    }
    $stmt = $db->prepare("UPDATE sirketler SET logo_yolu = NULL WHERE id = ?");
    $stmt->execute([$duzenlenecek_sirket['id']]);
    $duzenlenecek_sirket['logo_yolu'] = null;
    $_SESSION['mesaj'] = __("logo_deleted_successfully");
}

// Düzenlenecek şirket bilgilerini al
if (isset($_GET['duzenle'])) {
    $duzenle_id = filter_input(INPUT_GET, 'duzenle', FILTER_VALIDATE_INT);
    
    // Yetki kontrolü
    $stmt = $db->prepare("SELECT s.* FROM sirketler s 
                          INNER JOIN kullanici_sirket_iliskisi ksi ON s.id = ksi.sirket_id 
                          WHERE s.id = ? AND ksi.kullanici_id = ?");
    $stmt->execute([$duzenle_id, $_SESSION['kullanici_id']]);
    $duzenlenecek_sirket = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$duzenlenecek_sirket) {
        $_SESSION['hata'] = __("no_permission_to_edit_company");
        header("Location: ayarlar.php?section=firma_yonetimi");
        exit();
    }
}

// Yeni şirket eklerken varsayılan değerleri tanımla (eğer düzenleme yapılmıyorsa)
if (!$duzenlenecek_sirket) {
    $duzenlenecek_sirket = [
        'id' => null,
        'sirket_adi' => '',
        'adres' => '',
        'telefon' => '',
        'email' => '',
        'aktif_mi' => 1,
        'para_birimi' => 'TRY',
        'teklifler_modulu_aktif' => '1', // Varsayılan olarak aktif
        'stok_islemleri_aktif' => '0', // Varsayılan olarak pasif
        'depo_yonetimi_aktif' => '0' // Varsayılan olarak pasif
    ];
}

// Desteklenen Para Birimleri ve Diller
// Para birimlerini veritabanından dinamik al
try {
    $stmt_pb = $db->prepare("SELECT DISTINCT para_birimi FROM doviz_kurlari ORDER BY para_birimi");
    $stmt_pb->execute();
    $desteklenen_para_birimleri = array_map(function($r){ return $r['para_birimi']; }, $stmt_pb->fetchAll(PDO::FETCH_ASSOC));
} catch (PDOException $e) {
    error_log('Para birimleri yüklenemedi: ' . $e->getMessage());
    // Hata durumunda minimal bir liste kullan
    $desteklenen_para_birimleri = ['USD','EUR','GBP','TRY'];
}

// Sadece kullanıcının yetkili olduğu şirketleri listele
$stmt = $db->prepare("
    SELECT s.* 
    FROM sirketler s 
    INNER JOIN kullanici_sirket_iliskisi ksi ON s.id = ksi.sirket_id 
    WHERE ksi.kullanici_id = ? 
    ORDER BY s.sirket_adi
");
$stmt->execute([$_SESSION['kullanici_id']]);
$sirketler = $stmt->fetchAll(PDO::FETCH_ASSOC);

?>
<style>
    .mb-3 {
        padding: 20px;
    }
</style>

<?php if (isset($_SESSION['mesaj'])): ?>
<div class="alert alert-success alert-dismissible fade show" role="alert"><?= $_SESSION['mesaj'] ?><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>
<?php unset($_SESSION['mesaj']); endif; ?>
<?php if (isset($_SESSION['hata'])): ?>
<div class="alert alert-danger alert-dismissible fade show" role="alert"><?= $_SESSION['hata'] ?><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>
<?php unset($_SESSION['hata']); endif; ?>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><i class="bi bi-list-ul"></i> <?= __("existing_companies") ?></h5>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>ID</th>
                                <th><?= __("company_name") ?></th>
                                <th><?= __("status") ?></th>
                                <th><?= __("actions") ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($sirketler as $sirket): ?>
                            <tr class="<?= $sirket['id'] == $aktif_sirket_id ? 'table-info' : '' ?>">
                                <td><?= $sirket['id'] ?></td>
                                <td>
                                    <?= temizle($sirket['sirket_adi']) ?>
                                    <?php if ($sirket['id'] == $aktif_sirket_id): ?>
                                        <span class="badge bg-success ms-2"><?= __("active") ?></span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?= $sirket['aktif_mi'] ? '<span class="badge bg-primary">'.__("active").'</span>' : '<span class="badge bg-danger">'.__("passive").'</span>' ?>
                                </td>
                                <td>
                                    <a href="ayarlar.php?section=firma_yonetimi&duzenle=<?= $sirket['id'] ?>" class="btn btn-sm btn-warning" title="<?= __("edit") ?>"><i class="bi bi-pencil"></i></a>
                                    <a href="ayarlar.php?section=firma_yonetimi&sil=<?= $sirket['id'] ?>&csrf_token=<?= $csrf_token ?>" 
                                       onclick="return confirm('<?= __("confirm_company_deletion") ?>')" 
                                       class="btn btn-sm btn-danger" title="<?= __("delete") ?>"><i class="bi bi-trash"></i></a>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row mt-4">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><i class="bi bi-pencil-square"></i> <?= $duzenlenecek_sirket['id'] ? __('edit_company') : __('add_new_company') ?></h5>
            </div>
            <div class="card-body p-0">
                <form method="post" action="ayarlar.php?section=firma_yonetimi" enctype="multipart/form-data" class="p-3">
                    <input type="hidden" name="csrf_token" value="<?= $csrf_token ?>">
                    <input type="hidden" name="sirket_id" value="<?= $duzenlenecek_sirket['id'] ?? '' ?>">
                    
                    <!-- Professional Logo Upload Section -->
                    <div class="mb-4">
                        <label class="form-label fw-bold"><?= __("company_logo") ?></label>
                        <div class="d-flex align-items-start gap-4">
                            <!-- Logo Preview -->
                            <div class="text-center">
                                <div class="position-relative d-inline-block">
                                    <?php if (!empty($duzenlenecek_sirket['logo_yolu'])): ?>
                                        <img id="logo-preview" src="<?= htmlspecialchars((strpos($duzenlenecek_sirket['logo_yolu'], 'http') === 0 ? '' : '../') . $duzenlenecek_sirket['logo_yolu']) ?>" 
                                             alt="<?= __("current_logo") ?>" 
                                             class="img-thumbnail mb-2" 
                                             style="width: 150px; height: 150px; object-fit: contain; background-color: #f8f9fa;">
                                        <div class="form-check mt-2">
                                            <input class="form-check-input" type="checkbox" name="logo_sil" id="logo_sil" value="1">
                                            <label class="form-check-label text-danger" for="logo_sil">
                                                <i class="bi bi-trash"></i> <?= __("delete_logo") ?>
                                            </label>
                                        </div>
                                    <?php else: ?>
                                        <div id="logo-placeholder" class="d-flex flex-column align-items-center justify-content-center bg-light border rounded" 
                                             style="width: 150px; height: 150px;">
                                            <i class="bi bi-building fs-1 text-muted mb-2"></i>
                                            <small class="text-muted">Logo Yok</small>
                                        </div>
                                        <img id="logo-preview" src="" alt="" class="img-thumbnail d-none" style="width: 150px; height: 150px; object-fit: contain;">
                                    <?php endif; ?>
                                </div>
                            </div>
                            
                            <!-- Upload Controls -->
                            <div class="flex-grow-1">
                                <div class="mb-3">
                                    <div class="d-flex flex-column">
                                        <label for="logo" class="btn btn-outline-primary mb-2 align-self-start">
                                            <i class="bi bi-upload me-2"></i><?= __("select_logo") ?>
                                        </label>
                                        <input type="file" class="form-control d-none" id="logo" name="logo" accept="image/jpeg,image/png,image/gif">
                                        <div class="form-text">
                                            <small class="d-block text-muted"><?= __("recommended_size") ?>: 300x300px</small>
                                            <small class="d-block text-muted"><?= __("max_file_size") ?>: 2MB</small>
                                            <small class="d-block text-muted"><?= __("allowed_formats") ?>: JPG, PNG, GIF</small>
                                        </div>
                                    </div>
                                </div>
                                
                                <div id="file-info" class="alert alert-info p-2 mb-3 d-none">
                                    <div class="d-flex align-items-center">
                                        <i class="bi bi-info-circle me-2"></i>
                                        <div class="flex-grow-1" style="min-width: 0;">
                                            <div id="file-name" class="text-truncate" style="max-width: 100%;"></div>
                                            <small id="file-size" class="text-muted"></small>
                                        </div>
                                        <button type="button" class="btn-close ms-2" aria-label="Kapat" onclick="document.getElementById('file-info').classList.add('d-none');"></button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="sirket_adi" class="form-label"><?= __("company_name") ?> (*)</label>
                        <input type="text" class="form-control" id="sirket_adi" name="sirket_adi" value="<?= temizle($duzenlenecek_sirket['sirket_adi'] ?? '') ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="adres" class="form-label"><?= __("address") ?></label>
                        <textarea class="form-control" id="adres" name="adres" rows="2"><?= temizle($duzenlenecek_sirket['adres'] ?? '') ?></textarea>
                    </div>
                    <div class="mb-3">
                        <label for="telefon" class="form-label"><?= __("phone") ?></label>
                        <input type="text" class="form-control" id="telefon" name="telefon" value="<?= temizle($duzenlenecek_sirket['telefon'] ?? '') ?>">
                    </div>
                    <div class="mb-3">
                        <label for="email" class="form-label"><?= __("email") ?></label>
                        <input type="email" class="form-control" id="email" name="email" value="<?= temizle($duzenlenecek_sirket['email'] ?? '') ?>">
                    </div>

                    <!-- Yeni Eklenen Ayarlar -->
                    <hr class="my-4">
                    <div class="mb-3">
                        <h6 class="border-bottom pb-2"><i class="bi bi-gear me-2"></i> <?= __("company_settings") ?></h6>
                    </div>
                    
                    <div class="mb-3">
                        <label for="para_birimi" class="form-label"><?= __("currency") ?></label>
                        <select class="form-select" id="para_birimi" name="para_birimi" required>
                            <?php 
                                $secili_pb = $duzenlenecek_sirket['para_birimi'] ?? 'TRY';
                                // TL seçeneğini başta göster (TRY ile normalize edilerek)
                            ?>
                            <option value="TL" <?= ($secili_pb === 'TL' || $secili_pb === 'TRY') ? 'selected' : '' ?>>TL</option>
                            <?php 
                                $gosterilenler = ['TL'];
                                foreach ($desteklenen_para_birimleri as $pb): 
                                    // TRY zaten TL ile temsil edildi, tekrarlama
                                    if ($pb === 'TRY' || in_array($pb, $gosterilenler)) continue; 
                                    $selected = ($secili_pb === $pb) ? 'selected' : '';
                            ?>
                                <option value="<?= htmlspecialchars($pb) ?>" <?= $selected ?>><?= htmlspecialchars($pb) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="card mb-3 border-0 shadow-sm">
                        <div class="card-body p-3">
                            <h6 class="card-title border-bottom pb-2 mb-3"><?= __("module_settings") ?></h6>
                            
                            <div class="d-flex flex-column gap-3">
                                <div class="d-flex align-items-center">
                                    <div class="form-check form-switch me-3">
                                        <input class="form-check-input" type="checkbox" id="teklifler_modulu_aktif" 
                                               name="teklifler_modulu_aktif" value="1" <?= ($duzenlenecek_sirket['teklifler_modulu_aktif'] ?? '1') == '1' ? 'checked' : '' ?>>
                                    </div>
                                    <div class="flex-grow-1">
                                        <label class="form-check-label d-block" for="teklifler_modulu_aktif">
                                            <strong><?= __("enable_quotes_module") ?></strong>
                                            <div class="form-text text-muted small"><?= __("quotes_module_description") ?></div>
                                        </label>
                                    </div>
                                </div>

                                <div class="d-flex align-items-center">
                                    <div class="form-check form-switch me-3">
                                        <input class="form-check-input" type="checkbox" id="stok_islemleri_aktif" 
                                               name="stok_islemleri_aktif" value="1" <?= ($duzenlenecek_sirket['stok_islemleri_aktif'] ?? '0') == '1' ? 'checked' : '' ?>>
                                    </div>
                                    <div class="flex-grow-1">
                                        <label class="form-check-label d-block" for="stok_islemleri_aktif">
                                            <strong><?= __("enable_inventory_module") ?></strong>
                                            <div class="form-text text-muted small"><?= __("inventory_module_description") ?></div>
                                        </label>
                                    </div>
                                </div>

                                <div class="d-flex align-items-center">
                                    <div class="form-check form-switch me-3">
                                        <input class="form-check-input" type="checkbox" id="coklu_para_birimi" 
                                               name="coklu_para_birimi" value="1" <?= ($duzenlenecek_sirket['coklu_para_birimi'] ?? '0') == '1' ? 'checked' : '' ?>>
                                    </div>
                                    <div class="flex-grow-1">
                                        <label class="form-check-label d-block" for="coklu_para_birimi">
                                            <strong><?= __("enable_multiple_currencies") ?></strong>
                                            <div class="form-text text-muted small"><?= __("multiple_currencies_description") ?></div>
                                        </label>
                                    </div>
                                </div>

                                <div class="d-flex align-items-center">
                                    <div class="form-check form-switch me-3">
                                        <input class="form-check-input" type="checkbox" id="depo_yonetimi_aktif" 
                                               name="depo_yonetimi_aktif" value="1" <?= ($duzenlenecek_sirket['depo_yonetimi_aktif'] ?? '0') == '1' ? 'checked' : '' ?>>
                                    </div>
                                    <div class="flex-grow-1">
                                        <label class="form-check-label d-block" for="depo_yonetimi_aktif">
                                            <strong><?= __("enable_warehouse_management") ?></strong>
                                            <div class="form-text text-muted small"><?= __("warehouse_management_description") ?></div>
                                        </label>
                                    </div>
                                </div>

                                <div class="d-flex align-items-center">
                                    <div class="form-check form-switch me-3">
                                        <input class="form-check-input" type="checkbox" role="switch" id="aktif_mi" name="aktif_mi" <?= ($duzenlenecek_sirket['aktif_mi'] ?? 1) ? 'checked' : '' ?>>
                        
                                    </div>
                                    <div class="flex-grow-1">
                                        <label class="form-check-label d-block" for="aktif_mi">
                                            <strong><?= __("company_active") ?></strong>
                                            <div class="form-text text-muted small"><?= __("company_active") ?></div>
                                        </label>
                                    </div>
                                </div>



                            </div>
                        </div>
                    </div>

                    <div class="form-check form-switch mb-4">
                        
                    </div>
                    <div class="d-flex justify-content-between">
                        <button type="submit" name="sirket_kaydet" class="btn btn-primary"><i class="bi bi-save"></i> <?= __("save") ?></button>
                        <?php if ($duzenlenecek_sirket['id']): ?>
                        <a href="ayarlar.php?section=firma_yonetimi" class="btn btn-secondary"><?= __("cancel") ?></a>
                        <?php endif; ?>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Logo Upload JavaScript -->
<script src="../assets/js/logo-upload.js"></script>
