<?php
// Bu dosya, ana ayarlar.php tarafından include edildiği için,
// temel include'lar (config, yetki, yardımcı fonksiyonlar, log fonksiyonları, ayar_fonksiyonlari)
// zaten ana ayarlar.php'de yapılmış olacaktır.
// Bu yüzden burada ek require_once gerekmez.

// Genel Ayarlar için PHP Mantığı

// Form gönderildiğinde ayarları kaydetme
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['ayarlari_kaydet'])) {
    // CSRF token, ana ayarlar.php'den alınır ve burada kullanılır.
    if (!csrf_token_dogrula($_POST['csrf_token'] ?? '')) {
        $_SESSION['hata'] = __("invalid_security_token"); // Ana sayfada gösterilecek
    } else {
        // Debugging: POST verilerini kontrol et
        error_log("POST verileri: " . print_r($_POST, true));

        // Site Adı, Varsayılan Para Birimi, Resmi Kullanım Dili kaldırıldı
        $teklifler_modulu_aktif_post = !empty($_POST["teklifler_modulu_aktif"]) ? '1' : '0';
        $stok_islemleri_aktif_post = !empty($_POST["stok_islemleri_aktif"]) ? '1' : '0';

        try {
            $db->beginTransaction(); // $db global olarak ana sayfadan geliyor.
            $aktif_sirket_id = $_SESSION['aktif_sirket_id'] ?? null; // Aktif şirket ID'sini al

            // Debugging: Aktif şirket ID'sini kontrol et
            error_log("Aktif Şirket ID: " . $aktif_sirket_id);

            // Şirket bilgilerini doğrudan güncelle
            $stmt_update = $db->prepare("UPDATE sirketler SET teklifler_modulu_aktif = ?, stok_islemleri_aktif = ? WHERE id = ?");
            $result_update = $stmt_update->execute([$teklifler_modulu_aktif_post, $stok_islemleri_aktif_post, $aktif_sirket_id]);

            // Debugging: Update sonuçlarını kontrol et
            error_log("Şirket ayarları güncelleme sonucu: " . ($result_update ? 'Başarılı' : 'Başarısız'));

            $db->commit();
            $_SESSION['mesaj'] = __("settings_saved_successfully"); // Ana sayfada gösterilecek
        } catch (Exception $e) {
            $db->rollBack();
            error_log("Ayarlar kaydedilirken bir hata oluştu: " . $e->getMessage());
            $_SESSION['hata'] = __("error_saving_settings") . ": " . $e->getMessage(); // Ana sayfada gösterilecek
        }
    }
}

// Mevcut ayarları veritabanından çek (şirket bazlı)
$aktif_sirket_id = $_SESSION['aktif_sirket_id'] ?? null; // Aktif şirket ID'sini al

// Mevcut şirket bilgilerini çek
$current_sirket_bilgileri = [];
if ($aktif_sirket_id) {
    $stmt_current_sirket = $db->prepare("SELECT teklifler_modulu_aktif, stok_islemleri_aktif FROM sirketler WHERE id = ?");
    $stmt_current_sirket->execute([$aktif_sirket_id]);
    $current_sirket_bilgileri = $stmt_current_sirket->fetch(PDO::FETCH_ASSOC);
}

$current_teklifler_modulu_aktif = $current_sirket_bilgileri['teklifler_modulu_aktif'] ?? '1';
$current_stok_islemleri_aktif = $current_sirket_bilgileri['stok_islemleri_aktif'] ?? '0';

// Debugging kodları kaldırıldı
// Desteklenen Para Birimleri ve Diller kaldırıldı

// CSRF token ana sayfadan geliyor, burada kullanıma hazır.
?>

<?php if (isset($_SESSION['mesaj'])): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?= $_SESSION['mesaj'] ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php unset($_SESSION['mesaj']); ?>
<?php endif; ?>
<?php if (isset($_SESSION['hata'])): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <?= $_SESSION['hata'] ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php unset($_SESSION['hata']); ?>
<?php endif; ?>

<div class="card shadow">
    <div class="card-header bg-primary text-white">
        <h5 class="mb-0"><i class="bi bi-gear-fill me-2"></i> <?= __("module_settings") ?></h5> <!-- Başlığı değiştirdim -->
    </div>
    <div class="card-body">
        <form method="post">
            <input type="hidden" name="csrf_token" value="<?= $csrf_token ?>">
            <!-- Site Adı, Varsayılan Para Birimi, Resmi Kullanım Dili alanları kaldırıldı -->

            <div class="form-check form-switch mb-3">
                <input class="form-check-input" type="checkbox" id="teklifler_modulu_aktif" 
                       name="teklifler_modulu_aktif" value="1" <?= $current_teklifler_modulu_aktif == '1' ? 'checked' : '' ?>>
                <label class="form-check-label" for="teklifler_modulu_aktif">
                    <strong><?= __("enable_quotes_module") ?></strong>
                </label>
                <div class="form-text"><?= __("enable_quotes_module_description") ?></div>
            </div>

            <div class="form-check form-switch mb-3">
                <input class="form-check-input" type="checkbox" id="stok_islemleri_aktif" 
                       name="stok_islemleri_aktif" value="1" <?= $current_stok_islemleri_aktif == '1' ? 'checked' : '' ?>>
                <label class="form-check-label" for="stok_islemleri_aktif">
                    <strong><?= __("enable_stock_operations") ?></strong>
                </label>
                <div class="form-text"><?= __("enable_stock_operations_description") ?></div>
            </div>
            
            <button type="submit" name="ayarlari_kaydet" class="btn btn-primary"><?= __("save_settings") ?></button>
        </form>
    </div>
</div>
