<?php
// Bu dosya, ana ayarlar.php tarafından include edildiği için,
// temel include'lar (config, yetki, yardımcı fonksiyonlar, log fonksiyonları)
// zaten ana ayarlar.php'de yapılmış olacaktır.
// Bu yüzden burada ek require_once gerekmez.

$aktif_sirket_id = $_SESSION['aktif_sirket_id'] ?? 0;

// Hesap ekleme veya güncelleme
if ($_SERVER['REQUEST_METHOD'] == 'POST' && (isset($_POST['hesap_ekle']) || isset($_POST['hesap_guncelle']))) {
    if (!csrf_token_dogrula($_POST['csrf_token'] ?? '')) {
        $_SESSION['hata'] = __("invalid_security_token");
    } else {
        $hesap_adi = temizle($_POST['hesap_adi']);
        $hesap_turu = temizle($_POST['hesap_turu']);
        $baslangic_bakiye = floatval(str_replace(',', '.', $_POST['baslangic_bakiye'] ?? 0));
        $para_birimi = temizle($_POST['para_birimi']);
        $hesap_id = filter_input(INPUT_POST, 'hesap_id', FILTER_VALIDATE_INT);

        if (empty($hesap_adi) || empty($hesap_turu) || empty($para_birimi)) {
            $_SESSION['hata'] = __("account_name_type_currency_required");
        } else {
            try {
                $db->beginTransaction();
                
                if (isset($_POST['hesap_guncelle']) && $hesap_id) {
                    // Eski bakiyeyi al
                    $stmt_eski = $db->prepare("SELECT baslangic_bakiye, bakiye FROM hesaplar WHERE id = ? AND sirket_id = ?");
                    $stmt_eski->execute([$hesap_id, $aktif_sirket_id]);
                    $eski_veri = $stmt_eski->fetch(PDO::FETCH_ASSOC);
                    
                    // Yeni bakiye = (mevcut bakiye - eski başlangıç bakiyesi) + yeni başlangıç bakiyesi
                    $yeni_bakiye = ($eski_veri['bakiye'] - $eski_veri['baslangic_bakiye']) + $baslangic_bakiye;
                    
                    // Hesap güncelleme
                    $stmt = $db->prepare("UPDATE hesaplar SET hesap_adi = ?, hesap_turu = ?, baslangic_bakiye = ?, bakiye = ?, para_birimi = ? WHERE id = ? AND sirket_id = ?");
                    $stmt->execute([$hesap_adi, $hesap_turu, $baslangic_bakiye, $yeni_bakiye, $para_birimi, $hesap_id, $aktif_sirket_id]);
                    
                    // Loglama: Hesap Güncelleme
                    sistem_log_ekle(
                        $db,
                        'guncelle',
                        'hesaplar',
                        $hesap_id,
                        null,
                        ['hesap_adi' => $hesap_adi, 'hesap_turu' => $hesap_turu, 'baslangic_bakiye' => $baslangic_bakiye, 'para_birimi' => $para_birimi],
                        __('account_updated_log', ['account' => $hesap_adi, 'currency' => $para_birimi])
                    );
                    
                    $_SESSION['mesaj'] = __("account_updated_successfully");
                } else {
                    // Hesap ekleme
                    $stmt = $db->prepare("INSERT INTO hesaplar (sirket_id, hesap_adi, hesap_turu, baslangic_bakiye, bakiye, para_birimi) VALUES (?, ?, ?, ?, ?, ?)");
                    $stmt->execute([$aktif_sirket_id, $hesap_adi, $hesap_turu, $baslangic_bakiye, $baslangic_bakiye, $para_birimi]);
                    $eklenen_hesap_id = $db->lastInsertId();

                    // Loglama: Hesap Ekleme
                    sistem_log_ekle(
                        $db,
                        'ekle',
                        'hesaplar',
                        $eklenen_hesap_id,
                        null,
                        ['hesap_adi' => $hesap_adi, 'hesap_turu' => $hesap_turu, 'baslangic_bakiye' => $baslangic_bakiye, 'para_birimi' => $para_birimi],
                        __('account_added_log', ['account' => $hesap_adi, 'currency' => $para_birimi])
                    );

                    $_SESSION['mesaj'] = __("account_added_successfully");
                }
                
                $db->commit();
            } catch (PDOException $e) {
                $db->rollBack();
                if ($e->getCode() == '23000') { // Duplicate entry hatası
                    $_SESSION['hata'] = __("account_name_already_exists");
                } else {
                    error_log("Hesap işlemi hatası: " . $e->getMessage());
                    $_SESSION['hata'] = __("account_operation_error") . ": " . $e->getMessage();
                }
            }
        }
    }
}

// Hesap silme
if (isset($_GET['sil'])) {
    if (!csrf_token_dogrula($_GET['csrf_token'] ?? '')) {
        $_SESSION['hata'] = __("invalid_security_token");
    } else {
        $id = (int)$_GET['sil'];
        
        try {
            // Silinecek hesabın bilgilerini al - sadece aktif şirketin hesapları
            $stmt_hesap_info = $db->prepare("SELECT * FROM hesaplar WHERE id = ? AND sirket_id = ?");
            $stmt_hesap_info->execute([$id, $aktif_sirket_id]);
            $silinecek_hesap_bilgisi = $stmt_hesap_info->fetch(PDO::FETCH_ASSOC);

            if (!$silinecek_hesap_bilgisi) {
                throw new Exception(__("account_not_found_or_not_owned"));
            }

            // Hesabın hareketleri var mı kontrol et
            $kullanilan_hesap = $db->prepare("SELECT COUNT(*) FROM hesap_hareketleri WHERE hesap_id = ?");
            $kullanilan_hesap->execute([$id]);

            if ($kullanilan_hesap->fetchColumn() > 0) {
                throw new Exception(__("cannot_delete_account_with_transactions"));
            }

            $db->beginTransaction();

            $stmt = $db->prepare("DELETE FROM hesaplar WHERE id = ? AND sirket_id = ?");
            $stmt->execute([$id, $aktif_sirket_id]);

            // Loglama: Hesap Silme
            $log_id = sistem_log_ekle(
                $db,
                'sil',
                'hesaplar',
                $id,
                $silinecek_hesap_bilgisi,
                null,
                __('account_deleted_log', ['account' => $silinecek_hesap_bilgisi['hesap_adi']])
            );

            // Silinen kaydı geri alma tablosuna ekle
            if ($log_id) {
                silinen_kayit_ekle($db, $log_id, 'hesaplar', $id, $silinecek_hesap_bilgisi);
            }
            
            $db->commit();
            $_SESSION['mesaj'] = __("account_deleted_successfully");
        } catch (Exception $e) {
            $db->rollBack();
            error_log("Hesap silme hatası: " . $e->getMessage());
            $_SESSION['hata'] = $e->getMessage();
        }
    }
}

// Düzenleme için veri çekme
$duzenlenecek_hesap = null;
if (isset($_GET['duzenle'])) {
    $duzenle_id = filter_input(INPUT_GET, 'duzenle', FILTER_VALIDATE_INT);
    
    $stmt = $db->prepare("SELECT * FROM hesaplar WHERE id = ? AND sirket_id = ?");
    $stmt->execute([$duzenle_id, $aktif_sirket_id]);
    $duzenlenecek_hesap = $stmt->fetch(PDO::FETCH_ASSOC);
}

// Yeni hesap eklerken varsayılan değerleri tanımla (eğer düzenleme yapılmıyorsa)
if (!$duzenlenecek_hesap) {
    $duzenlenecek_hesap = [
        'id' => null,
        'hesap_adi' => '',
        'hesap_turu' => '',
        'baslangic_bakiye' => '0,00',
        'para_birimi' => 'TRY'
    ];
}

// Hesapları getir - sadece aktif şirketin hesapları
$hesaplar = [];
try {
    $stmt = $db->prepare("SELECT id, hesap_adi, hesap_turu, baslangic_bakiye, bakiye, para_birimi FROM hesaplar WHERE sirket_id = ? ORDER BY hesap_adi");
    $stmt->execute([$aktif_sirket_id]);
    $hesaplar = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Para birimlerini veritabanından al
    $stmt_pb = $db->prepare("SELECT DISTINCT para_birimi FROM doviz_kurlari ORDER BY para_birimi");
    $stmt_pb->execute();
    $para_birimleri = array_map(function($r) { return $r['para_birimi']; }, $stmt_pb->fetchAll(PDO::FETCH_ASSOC));
    
    // Eğer hiç para birimi yoksa, varsayılan olarak TRY ekle
    if (empty($para_birimleri)) {
        $para_birimleri = ['TRY'];
    }
} catch(PDOException $e) {
    error_log("Hesap listeleme hatası: " . $e->getMessage());
    $_SESSION['hata'] = "Hesaplar yüklenirken bir hata oluştu: " . $e->getMessage();
    $para_birimleri = ['TRY'];
}

// CSRF token ana sayfadan geliyor, burada kullanıma hazır.
?>
	

<?php if (isset($_SESSION['mesaj'])): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?= $_SESSION['mesaj'] ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php unset($_SESSION['mesaj']); ?>
<?php endif; ?>
<?php if (isset($_SESSION['hata'])): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <?= $_SESSION['hata'] ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php unset($_SESSION['hata']); ?>
<?php endif; ?>
	
    <div class="card-header">
	  <h3 class="mb-4"><i class="bi bi-tags-fill me-2"></i> <?= __("account_management") ?></h3>
    </div>
    <div class="card-body">
        <div class="card mb-4">
            <div class="card-header bg-secondary text-white">
                <h5 class="mb-0"><i class="bi bi-list-ul me-2"></i> <?= __("existing_accounts") ?></h5>
            </div>
            <div class="card-body p-0">
                <?php if (!empty($hesaplar)): ?>
                    <div class="table-responsive">
                        <table class="table table-striped table-hover mb-0">
                            <thead class="table-dark">
                                <tr>
                                    <th><?= __("account_name") ?></th>
                                    <th><?= __("account_type") ?></th>
                                    <th><?= __("initial_balance") ?></th>
                                    <th><?= __("current_balance") ?></th>
                                    <th><?= __("currency") ?></th>
                                    <th style="width: 200px;"><?= __("actions") ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($hesaplar as $hesap): ?>
                                <tr>
                                    <td><?= temizle($hesap['hesap_adi']) ?></td>
                                    <td><?= temizle($hesap['hesap_turu']) ?></td>
                                    <td><?= number_format($hesap['baslangic_bakiye'], 2, ',', '.') ?></td>
                                    <td><?= number_format($hesap['bakiye'], 2, ',', '.') ?></td>
                                    <td><?= temizle($hesap['para_birimi']) ?></td>
                                    <td>
                                        <div class="btn-group btn-group-sm" role="group">
                                            <a href="?section=hesaplar&duzenle=<?= $hesap['id'] ?>" 
                                               class="btn btn-outline-primary" 
                                               title="Düzenle">
                                                <i class="bi bi-pencil"></i> <?= __("edit") ?>
                                            </a>
                                            <a href="hesap_hareketleri.php?hesap_id=<?= $hesap['id'] ?>" 
                                               class="btn btn-outline-info" 
                                               title="Hareketler">
                                                <i class="bi bi-clock-history"></i> <?= __("transactions") ?>
                                            </a>
                                            <a href="?section=hesaplar&sil=<?= $hesap['id'] ?>&csrf_token=<?= $csrf_token ?>" 
                                               class="btn btn-outline-danger" 
                                               title="Sil" 
                                               onclick="return confirm('Bu hesabı silmek istediğinize emin misiniz? Bu hesaba bağlı hareketler varsa silinemez!')">
                                                <i class="bi bi-trash"></i> <?= __("delete") ?>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <div class="alert alert-info m-3" role="alert">
                        <?= __("no_accounts_found") ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <div class="card">
            <div class="card-header bg-success text-white">
                <h5 class="mb-0"><i class="bi bi-plus-circle me-2"></i> <?= $duzenlenecek_hesap['id'] ? __("edit_account") : __("add_new_account") ?></h5>
            </div>
            <div class="card-body">
                <form method="post" action="?section=hesaplar">
                    <input type="hidden" name="csrf_token" value="<?= $csrf_token ?>">
                    <?php if ($duzenlenecek_hesap['id']): ?>
                        <input type="hidden" name="hesap_id" value="<?= $duzenlenecek_hesap['id'] ?>">
                    <?php endif; ?>
                    <div class="mb-3">
                        <label for="hesap_adi" class="form-label"><?= __("account_name") ?></label>
                        <input type="text" class="form-control" id="hesap_adi" name="hesap_adi" value="<?= htmlspecialchars($duzenlenecek_hesap['hesap_adi'], ENT_QUOTES) ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="hesap_turu" class="form-label"><?= __("account_type") ?></label>
                        <select class="form-select" id="hesap_turu" name="hesap_turu" required>
                            <option value=""><?= __("select_option") ?>...</option>
                            <option value="banka" <?= ($duzenlenecek_hesap['hesap_turu'] == 'banka') ? 'selected' : '' ?>><?= __("bank") ?></option>
                            <option value="kasa" <?= ($duzenlenecek_hesap['hesap_turu'] == 'kasa') ? 'selected' : '' ?>><?= __("cash") ?></option>
                            <option value="kredi_karti" <?= ($duzenlenecek_hesap['hesap_turu'] == 'kredi_karti') ? 'selected' : '' ?>><?= __("credit_card") ?></option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="para_birimi" class="form-label"><?= __("currency") ?></label>
                        <select class="form-select" id="para_birimi" name="para_birimi" required>
                            <option value=""><?= __("select_option") ?>...</option>
                            <?php foreach ($para_birimleri as $pb): 
                                $selected = ($duzenlenecek_hesap['para_birimi'] == $pb) ? 'selected' : '';
                            ?>
                            <option value="<?= $pb ?>" <?= $selected ?>><?= $pb ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="baslangic_bakiye" class="form-label"><?= __("initial_balance") ?></label>
                        <?php if ($duzenlenecek_hesap['id']): ?>
                            <input type="text" class="form-control" id="baslangic_bakiye" value="<?= htmlspecialchars($duzenlenecek_hesap['baslangic_bakiye'], ENT_QUOTES) ?>" disabled>
                            <input type="hidden" name="baslangic_bakiye" value="<?= htmlspecialchars($duzenlenecek_hesap['baslangic_bakiye'], ENT_QUOTES) ?>">
                            <small class="form-text text-muted"><?= __("initial_balance_not_editable") ?></small>
                        <?php else: ?>
                            <input type="text" class="form-control" id="baslangic_bakiye" name="baslangic_bakiye" value="<?= htmlspecialchars($duzenlenecek_hesap['baslangic_bakiye'], ENT_QUOTES) ?>" data-type="currency">
                            <small class="form-text text-muted"><?= __("example") ?>: 1.234,56 <?= __("or") ?> 500,00</small>
                        <?php endif; ?>
                    </div>
                    <button type="submit" name="<?= $duzenlenecek_hesap['id'] ? 'hesap_guncelle' : 'hesap_ekle' ?>" class="btn btn-success">
                        <i class="bi <?= $duzenlenecek_hesap['id'] ? 'bi-pencil' : 'bi-plus-circle' ?>"></i> <?= $duzenlenecek_hesap['id'] ? __("update_account") : __("add_account") ?>
                    </button>
                    <?php if ($duzenlenecek_hesap['id']): ?>
                        <a href="?section=hesaplar" class="btn btn-secondary">
                            <i class="bi bi-x-circle"></i> <?= __("cancel") ?>
                        </a>
                    <?php endif; ?>
                </form>
            </div>
        </div>
    </div>


<script>
    // <?= __("currency_formatting_script") ?>
    document.addEventListener('DOMContentLoaded', function() {
        const currencyInputs = document.querySelectorAll('input[data-type="currency"]');
        currencyInputs.forEach(function(input) {
            input.addEventListener('focus', function() {
                // <?= __("convert_to_numeric_on_focus") ?>
                this.value = this.value.replace(/\./g, '').replace(',', '.');
            });
            input.addEventListener('blur', function() {
                // <?= __("convert_to_currency_on_blur") ?>
                let value = parseFloat(this.value);
                if (isNaN(value)) {
                    value = 0;
                }
                this.value = value.toLocaleString('tr-TR', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
            });
            // <?= __("format_existing_value_on_load") ?>
            let initialValue = parseFloat(input.value.replace(/\./g, '').replace(',', '.'));
            if (!isNaN(initialValue)) {
                input.value = initialValue.toLocaleString('tr-TR', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
            }
        });
    });
</script>
