<?php
require_once __DIR__ . '/../../includes/config.php';
require_once __DIR__ . '/../../includes/yetki_kontrol.php';
yetki_kontrol_ve_yonlendir('ayarlar', 'duzenle');

$sayfa_baslik = "Kategori Düzenle";
$aktif_sirket_id = $_SESSION['aktif_sirket_id'];
$tip = $_GET['tip'] ?? 'islem'; // Aktif tipi al

// ID'yi al ve doğrula
$kategori_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$kategori_id) {
    $_SESSION['hata'] = "Geçersiz kategori ID'si.";
    header("Location: ../ayarlar.php?section=kategoriler&tip=" . $tip);
    exit();
}

// Kategori bilgilerini getir ve şirkete ait olduğunu doğrula
try {
    $stmt = $db->prepare("SELECT * FROM kategoriler WHERE id = ? AND sirket_id = ?");
    $stmt->execute([$kategori_id, $aktif_sirket_id]);
    $kategori = $stmt->fetch();

    if (!$kategori) {
        $_SESSION['hata'] = "Kategori bulunamadı veya bu şirkete ait değil.";
        header("Location: ../ayarlar.php?section=kategoriler&tip=" . $tip);
        exit();
    }
} catch (PDOException $e) {
    error_log("Kategori getirme hatası: " . $e->getMessage());
    $_SESSION['hata'] = "Veritabanı hatası oluştu.";
    header("Location: ../ayarlar.php?section=kategoriler&tip=" . $tip);
    exit();
}

// Form gönderildiğinde güncelleme işlemi
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (!csrf_token_dogrula($_POST['csrf_token'] ?? '')) {
        $_SESSION['hata'] = "Geçersiz güvenlik tokenı!";
    } else {
        $yeni_kategori_adi = trim(temizle($_POST['kategori_adi']));
        if (empty($yeni_kategori_adi)) {
            $_SESSION['hata'] = "Kategori adı boş olamaz.";
        } elseif ($yeni_kategori_adi === $kategori['kategori_adi']) {
            $_SESSION['bilgi'] = "Herhangi bir değişiklik yapılmadı.";
            header("Location: ../ayarlar.php?section=kategoriler&tip=" . $tip);
            exit();
        } else {
            try {
                // Yeni adın başka bir kategoride kullanılıp kullanılmadığını kontrol et (aynı şirket ve tip için)
                $stmt_check = $db->prepare("SELECT id FROM kategoriler WHERE kategori_adi = ? AND sirket_id = ? AND tip = ? AND id != ?");
                $stmt_check->execute([$yeni_kategori_adi, $aktif_sirket_id, $kategori['tip'], $kategori_id]);
                if ($stmt_check->fetch()) {
                    throw new Exception("Bu kategori adı zaten başka bir kategori tarafından kullanılıyor!");
                }

                $stmt_update = $db->prepare("UPDATE kategoriler SET kategori_adi = ? WHERE id = ? AND sirket_id = ?");
                $stmt_update->execute([$yeni_kategori_adi, $kategori_id, $aktif_sirket_id]);

                $_SESSION['mesaj'] = "Kategori adı başarıyla güncellendi.";
                header("Location: ../ayarlar.php?section=kategoriler&tip=" . $kategori['tip']);
                exit();

            } catch (Exception $e) {
                $_SESSION['hata'] = $e->getMessage();
            }
        }
    }
    // Hata durumunda sayfanın yeniden yüklenmesi için
    header("Location: kategori_duzenle.php?id=" . $kategori_id . "&tip=" . $tip);
    exit();
}

$csrf_token = csrf_token_olustur();
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= temizle($sayfa_baslik) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
</head>
<body>
    <?php include __DIR__ . '/../../includes/navbar.php'; ?>
    <div class="container mt-4">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="card shadow-sm">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="bi bi-pencil-square me-2"></i><?= temizle($sayfa_baslik) ?></h5>
                    </div>
                    <div class="card-body">
                        <?php if (isset($_SESSION['hata'])): ?>
                            <div class="alert alert-danger"><?= $_SESSION['hata']; unset($_SESSION['hata']); ?></div>
                        <?php endif; ?>
                        <form method="post" action="kategori_duzenle.php?id=<?= $kategori['id'] ?>">
                            <input type="hidden" name="csrf_token" value="<?= $csrf_token ?>">
                            <div class="mb-3">
                                <label for="kategori_adi" class="form-label">Kategori Adı</label>
                                <input type="text" class="form-control" id="kategori_adi" name="kategori_adi" value="<?= temizle($kategori['kategori_adi']) ?>" required>
                            </div>
                            <div class="d-flex justify-content-between">
                                <a href="<?= BASE_URL ?>/views/ayarlar.php?section=kategoriler&tip=<?= $kategori['tip'] ?>" class="btn btn-secondary"><i class="bi bi-arrow-left"></i> Vazgeç</a>
                                <button type="submit" class="btn btn-success"><i class="bi bi-save me-1"></i> Değişiklikleri Kaydet</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html> 
