<?php
// Bu dosya, ana ayarlar.php tarafından include edildiği için,
// temel include'lar ve yetkilendirme zaten yapılmıştır.
$aktif_sirket_id = $_SESSION['aktif_sirket_id'];

// Log fonksiyonlarını dahil et
require_once __DIR__ . '/../../functions/log_fonksiyonlari.php';

// Düzenlenecek marka bilgileri
$duzenlenecek_marka = [
    'id' => '',
    'marka_adi' => '',
    'aciklama' => ''
];

// Marka düzenleme için verileri çek
if (isset($_GET['duzenle'])) {
    $marka_id = (int)$_GET['duzenle'];
    try {
        $stmt = $db->prepare("SELECT id, marka_adi, aciklama FROM markalar WHERE id = ? AND sirket_id = ?");
        $stmt->execute([$marka_id, $aktif_sirket_id]);
        $duzenlenecek_marka = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$duzenlenecek_marka) {
            $_SESSION['hata'] = __("brand_not_found");
            header("Location: ayarlar.php?section=markalar");
            exit();
        }
    } catch (PDOException $e) {
        error_log("Marka getirme hatası: " . $e->getMessage());
        $_SESSION['hata'] = __("error_loading_brand");
    }
}

// Marka ekleme veya güncelleme
if ($_SERVER['REQUEST_METHOD'] == 'POST' && (isset($_POST['marka_ekle']) || isset($_POST['marka_guncelle']))) {
    if (!csrf_token_dogrula($_POST['csrf_token'] ?? '')) {
        $_SESSION['hata'] = __("invalid_security_token");
    } else {
        $marka_adi = trim(temizle($_POST['marka_adi']));
        $aciklama = trim(temizle($_POST['aciklama'] ?? ''));
        $marka_id = isset($_POST['marka_id']) ? (int)$_POST['marka_id'] : null;

        if (empty($marka_adi)) {
            $_SESSION['hata'] = __("brand_name_required");
        } else {
            try {
                if (isset($_POST['marka_guncelle']) && $marka_id) {
                    // Marka güncelleme
                    // Yeni adın başka bir markada kullanılıp kullanılmadığını kontrol et
                    $stmt_check = $db->prepare("SELECT id FROM markalar WHERE marka_adi = ? AND sirket_id = ? AND id != ?");
                    $stmt_check->execute([$marka_adi, $aktif_sirket_id, $marka_id]);
                    if ($stmt_check->fetch()) {
                        throw new Exception(__("brand_name_already_exists"));
                    }

                    $stmt_update = $db->prepare("UPDATE markalar SET marka_adi = ?, aciklama = ? WHERE id = ? AND sirket_id = ?");
                    $stmt_update->execute([$marka_adi, $aciklama, $marka_id, $aktif_sirket_id]);
                    
                    // Log ekle
                    sistem_log_ekle(
                        $db,
                        'guncelle',
                        'markalar',
                        $marka_id,
                        ['marka_adi' => $duzenlenecek_marka['marka_adi']],
                        ['marka_adi' => $marka_adi, 'aciklama' => $aciklama],
                        __('brand_updated_log', ['brand' => $marka_adi]),
                        $kullanici_id
                    );
                    
                    $_SESSION['mesaj'] = __("brand_updated_successfully");
                } else {
                    // Marka ekleme
                    // Şirket bazında marka adı kontrolü
                    $stmt_check = $db->prepare("SELECT id FROM markalar WHERE marka_adi = ? AND sirket_id = ?");
                    $stmt_check->execute([$marka_adi, $aktif_sirket_id]);
                    if ($stmt_check->fetch()) {
                        throw new Exception(__("brand_name_already_exists"));
                    }

                    $stmt = $db->prepare("INSERT INTO markalar (sirket_id, marka_adi, aciklama) VALUES (?, ?, ?)");
                    $stmt->execute([$aktif_sirket_id, $marka_adi, $aciklama]);
                    
                    // Log ekle
                    $yeni_marka_id = $db->lastInsertId();
                    sistem_log_ekle(
                        $db,
                        'ekle',
                        'markalar',
                        $yeni_marka_id,
                        null,
                        ['marka_adi' => $marka_adi, 'aciklama' => $aciklama],
                        __('brand_added_log', ['brand' => $marka_adi]),
                        $kullanici_id
                    );
                    
                    $_SESSION['mesaj'] = __("brand_added_successfully");
                }
            } catch (Exception $e) {
                error_log("Marka işlem hatası: " . $e->getMessage());
                $_SESSION['hata'] = $e->getMessage();
            }
        }
    }
    header("Location: ?section=markalar");
    exit();
}

// Markaları getir (sadece aktif şirkete ait olanları)
$markalar = [];
try {
    $stmt = $db->prepare("SELECT id, marka_adi, aciklama FROM markalar WHERE sirket_id = ? ORDER BY marka_adi");
    $stmt->execute([$aktif_sirket_id]);
    $markalar = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch(PDOException $e) {
    error_log("Marka listeleme hatası: " . $e->getMessage());
    $_SESSION['hata'] = __("error_loading_brands");
}

?>

<?php if (isset($_SESSION['mesaj'])): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert"><?= $_SESSION['mesaj']; unset($_SESSION['mesaj']); ?><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>
<?php endif; ?>
<?php if (isset($_SESSION['hata'])): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert"><?= $_SESSION['hata']; unset($_SESSION['hata']); ?><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>
<?php endif; ?>

<h3 class="mb-4"><i class="bi bi-award-fill me-2"></i><?= __("brand_management") ?></h3>

<div class="row">
    <div class="col-md-4">
        <div class="card shadow-sm mb-3">
            <div class="card-header bg-<?= $duzenlenecek_marka['id'] ? 'warning' : 'success' ?> text-white">
                <h5 class="mb-0"><i class="bi <?= $duzenlenecek_marka['id'] ? 'bi-pencil-square' : 'bi-plus-circle' ?> me-2"></i><?= $duzenlenecek_marka['id'] ? __('edit_brand') : __('add_new_brand') ?></h5>
            </div>
            <div class="card-body">
                <form method="post" action="ayarlar.php?section=markalar">
                    <input type="hidden" name="csrf_token" value="<?= $csrf_token ?>">
                    <?php if ($duzenlenecek_marka['id']): ?>
                        <input type="hidden" name="marka_id" value="<?= $duzenlenecek_marka['id'] ?>">
                    <?php endif; ?>
                    <div class="mb-3">
                        <label for="marka_adi" class="form-label"><?= __("brand_name") ?> <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="marka_adi" name="marka_adi" value="<?= htmlspecialchars($duzenlenecek_marka['marka_adi'], ENT_QUOTES) ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="aciklama" class="form-label"><?= __("description") ?></label>
                        <textarea class="form-control" id="aciklama" name="aciklama" rows="3"><?= htmlspecialchars($duzenlenecek_marka['aciklama'], ENT_QUOTES) ?></textarea>
                    </div>
                    <?php if ($duzenlenecek_marka['id']): ?>
                        <div class="d-flex justify-content-center gap-2">
                            <button type="submit" name="marka_guncelle" class="btn btn-warning flex-fill">
                                <i class="bi bi-check-circle me-1"></i> <?= __("update") ?>
                            </button>
                            <a href="?section=markalar" class="btn btn-secondary flex-fill">
                                <i class="bi bi-x-circle me-1"></i> <?= __("cancel") ?>
                            </a>
                        </div>
                    <?php else: ?>
                        <button type="submit" name="marka_ekle" class="btn btn-success w-100">
                            <i class="bi bi-save me-1"></i> <?= __("save_brand") ?>
                        </button>
                    <?php endif; ?>
                </form>
            </div>
        </div>
    </div>
    <div class="col-md-8">
        <div class="card shadow-sm">
             <div class="card-header"><h5 class="mb-0"><i class="bi bi-list-ul me-2"></i><?= __('existing_brands') ?></h5></div>
            <div class="card-body p-0">
                <?php if (!empty($markalar)): ?>
                    <div class="table-responsive">
                        <table class="table table-striped table-hover mb-0">
                            <thead>
                                <tr>
                                    <th><?= __("brand_name") ?></th>
                                    <th><?= __("description") ?></th>
                                    <th class="text-end" style="width: 200px;"><?= __("actions") ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($markalar as $marka): ?>
                                    <tr>
                                        <td><strong><?= temizle($marka['marka_adi']) ?></strong></td>
                                        <td><?= temizle($marka['aciklama']) ?></td>
                                        <td class="text-end">
                                            <div class="btn-group btn-group-sm" role="group">
                                                <a href="?section=markalar&duzenle=<?= $marka['id'] ?>" class="btn btn-outline-primary" title="<?= __('edit') ?>">
                                                    <i class="bi bi-pencil"></i>
                                                </a>
                                                <a href="ayarlar/marka_sil.php?id=<?= $marka['id'] ?>&csrf_token=<?= $csrf_token ?>" class="btn btn-outline-danger" onclick="return confirm('<?= __('confirm_delete_brand') ?>')" title="<?= __('delete') ?>">
                                                    <i class="bi bi-trash"></i>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <div class="text-center p-4">
                        <i class="bi bi-inbox display-1 text-muted"></i>
                        <p class="text-muted mt-2"><?= __("no_brands_found") ?></p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
