<?php
// Bu dosya, ana ayarlar.php tarafından include edildiği için,
// temel include'lar ve yetkilendirme zaten yapılmıştır.
$aktif_sirket_id = $_SESSION['aktif_sirket_id'];

// Log fonksiyonlarını dahil et
require_once __DIR__ . '/../../functions/log_fonksiyonlari.php';

// Düzenlenecek raf bilgileri
$duzenlenecek_raf = [
    'id' => '',
    'raf_adi' => '',
    'aciklama' => ''
];

// Raf düzenleme için verileri çek
if (isset($_GET['duzenle'])) {
    $raf_id = (int)$_GET['duzenle'];
    try {
        $stmt = $db->prepare("SELECT id, raf_adi, aciklama FROM raflar WHERE id = ? AND sirket_id = ?");
        $stmt->execute([$raf_id, $aktif_sirket_id]);
        $duzenlenecek_raf = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$duzenlenecek_raf) {
            $_SESSION['hata'] = __("shelf_not_found");
            header("Location: ayarlar.php?section=raflar");
            exit();
        }
    } catch (PDOException $e) {
        error_log("Raf getirme hatası: " . $e->getMessage());
        $_SESSION['hata'] = __("error_loading_shelf");
    }
}

// Raf ekleme veya güncelleme
if ($_SERVER['REQUEST_METHOD'] == 'POST' && (isset($_POST['raf_ekle']) || isset($_POST['raf_guncelle']))) {
    if (!csrf_token_dogrula($_POST['csrf_token'] ?? '')) {
        $_SESSION['hata'] = __("invalid_security_token");
    } else {
        $raf_adi = trim(temizle($_POST['raf_adi']));
        $aciklama = trim(temizle($_POST['aciklama'] ?? ''));
        $raf_id = isset($_POST['raf_id']) ? (int)$_POST['raf_id'] : null;

        if (empty($raf_adi)) {
            $_SESSION['hata'] = __("shelf_name_required");
        } else {
            try {
                if (isset($_POST['raf_guncelle']) && $raf_id) {
                    // Raf güncelleme
                    // Yeni adın başka bir rafta kullanılıp kullanılmadığını kontrol et
                    $stmt_check = $db->prepare("SELECT id FROM raflar WHERE raf_adi = ? AND sirket_id = ? AND id != ?");
                    $stmt_check->execute([$raf_adi, $aktif_sirket_id, $raf_id]);
                    if ($stmt_check->fetch()) {
                        throw new Exception(__("shelf_name_exists"));
                    }

                    $stmt_update = $db->prepare("UPDATE raflar SET raf_adi = ?, aciklama = ? WHERE id = ? AND sirket_id = ?");
                    $stmt_update->execute([$raf_adi, $aciklama, $raf_id, $aktif_sirket_id]);
                    
                    // Log ekle
                    sistem_log_ekle(
                        $db,
                        'guncelle',
                        'raflar',
                        $raf_id,
                        ['raf_adi' => $duzenlenecek_raf['raf_adi']],
                        ['raf_adi' => $raf_adi],
                        __('shelf_updated_successfully') . ': ' . $raf_adi,
                        $kullanici_id
                    );
                    
                    $_SESSION['mesaj'] = __("shelf_updated_successfully");
                } else {
                    // Raf ekleme
                    // Şirket bazında raf adı kontrolü
                    $stmt_check = $db->prepare("SELECT id FROM raflar WHERE raf_adi = ? AND sirket_id = ?");
                    $stmt_check->execute([$raf_adi, $aktif_sirket_id]);
                    if ($stmt_check->fetch()) {
                        throw new Exception(__("shelf_name_exists"));
                    }

                    $stmt = $db->prepare("INSERT INTO raflar (sirket_id, raf_adi, aciklama) VALUES (?, ?, ?)");
                    $stmt->execute([$aktif_sirket_id, $raf_adi, $aciklama]);
                    
                    // Log ekle
                    $yeni_raf_id = $db->lastInsertId();
                    sistem_log_ekle(
                        $db,
                        'ekle',
                        'raflar',
                        $yeni_raf_id,
                        null,
                        ['raf_adi' => $raf_adi],
                        __('shelf_added_successfully') . ': ' . $raf_adi,
                        $kullanici_id
                    );
                    
                    $_SESSION['mesaj'] = __("shelf_added_successfully");
                }
            } catch (Exception $e) {
                error_log("Raf işlem hatası: " . $e->getMessage());
                $_SESSION['hata'] = $e->getMessage();
            }
        }
    }
    // Kullanıcıyı sayfada tutmak için yönlendir
    header("Location: ?section=raflar");
    exit();
}

// Rafları getir (sadece aktif şirkete ait olanları)
$raflar = [];
try {
    $stmt = $db->prepare("SELECT id, raf_adi, aciklama FROM raflar WHERE sirket_id = ? ORDER BY raf_adi");
    $stmt->execute([$aktif_sirket_id]);
    $raflar = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch(PDOException $e) {
    error_log("Raf listeleme hatası: " . $e->getMessage());
    $_SESSION['hata'] = __("error_loading_shelf");
}

?>

<?php if (isset($_SESSION['mesaj'])): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert"><?= $_SESSION['mesaj']; unset($_SESSION['mesaj']); ?><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>
<?php endif; ?>
<?php if (isset($_SESSION['hata'])): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert"><?= $_SESSION['hata']; unset($_SESSION['hata']); ?><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>
<?php endif; ?>

<h3 class="mb-4"><i class="bi bi-bookshelf me-2"></i><?= __("shelf_management") ?></h3>

<div class="row">
    <div class="col-md-4">
        <div class="card shadow-sm mb-3">
            <div class="card-header bg-<?= $duzenlenecek_raf['id'] ? 'warning' : 'success' ?> text-white">
                <h5 class="mb-0"><i class="bi <?= $duzenlenecek_raf['id'] ? 'bi-pencil-square' : 'bi-plus-circle' ?> me-2"></i><?= $duzenlenecek_raf['id'] ? __('edit_shelf') : __('add_new_shelf') ?></h5>
            </div>
            <div class="card-body">
                <form method="post" action="ayarlar.php?section=raflar">
                    <input type="hidden" name="csrf_token" value="<?= $csrf_token ?>">
                    <?php if ($duzenlenecek_raf['id']): ?>
                        <input type="hidden" name="raf_id" value="<?= $duzenlenecek_raf['id'] ?>">
                    <?php endif; ?>
                    <div class="mb-3">
                        <label for="raf_adi" class="form-label"><?= __("shelf_name") ?> <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="raf_adi" name="raf_adi" value="<?= htmlspecialchars($duzenlenecek_raf['raf_adi'], ENT_QUOTES) ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="aciklama" class="form-label"><?= __("description") ?></label>
                        <textarea class="form-control" id="aciklama" name="aciklama" rows="3"><?= htmlspecialchars($duzenlenecek_raf['aciklama'] ?? '', ENT_QUOTES) ?></textarea>
                    </div>
                    <?php if ($duzenlenecek_raf['id']): ?>
                        <div class="d-flex justify-content-center gap-2">
                            <button type="submit" name="raf_guncelle" class="btn btn-warning flex-fill">
                                <i class="bi bi-check-circle me-1"></i> <?= __("update") ?>
                            </button>
                            <a href="?section=raflar" class="btn btn-secondary flex-fill">
                                <i class="bi bi-x-circle me-1"></i> <?= __("cancel") ?>
                            </a>
                        </div>
                    <?php else: ?>
                        <button type="submit" name="raf_ekle" class="btn btn-success w-100">
                            <i class="bi bi-save me-1"></i> <?= __("save") ?>
                        </button>
                    <?php endif; ?>
                </form>
            </div>
        </div>
    </div>
    <div class="col-md-8">
        <div class="card shadow-sm">
             <div class="card-header"><h5 class="mb-0"><i class="bi bi-list-ul me-2"></i><?= __('existing_shelves'); ?></h5></div>
            <div class="card-body p-0">
                <?php if (!empty($raflar)): ?>
                    <div class="table-responsive">
                        <table class="table table-striped table-hover mb-0">
                            <thead>
                                <tr>
                                    <th><?= __("shelf_name") ?></th>
                                    <th><?= __("description") ?></th>
                                    <th class="text-end" style="width: 200px;"><?= __("actions") ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($raflar as $raf): ?>
                                <tr>
                                    <td><?= temizle($raf['raf_adi']) ?></td>
                                    <td><?= temizle($raf['aciklama'] ?? '-') ?></td>
                                    <td class="text-end">
                                        <div class="btn-group btn-group-sm" role="group">
                                            <a href="?section=raflar&duzenle=<?= $raf['id'] ?>" class="btn btn-outline-warning" title="<?= __("edit_shelf") ?>">
                                                <i class="bi bi-pencil"></i> <?= __("edit") ?>
                                            </a>
                                            <a href="ayarlar/raf_sil.php?id=<?= $raf['id'] ?>&csrf_token=<?= $csrf_token ?>" class="btn btn-outline-danger" title="<?= __("delete_shelf") ?>" onclick="return confirm('<?= __("confirm_delete_shelf") ?>')">
                                                <i class="bi bi-trash"></i> <?= __("delete") ?>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <div class="alert alert-light m-3 text-center" role="alert">
                       <?= __('no_shelves_found') ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
