<?php
// API Link Ayarları sayfası
// Bu dosya ayarlar.php tarafından include edilir

// Form gönderildiğinde
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (!csrf_token_dogrula($_POST['csrf_token'] ?? '')) {
        $_SESSION['hata'] = __("invalid_form_submission");
    } else {
        try {
            // Aktif şirket ID'sini al
            $aktif_sirket_id = $_SESSION['aktif_sirket_id'] ?? null;

            // Değişkenleri ata. Checkbox işaretli ise '1', değilse '0' olur.
            // $ikinci_fiyat_aktif kaldırıldı
            $stok_resim_yukleme_aktif = !empty($_POST["stok_resim_yukleme_aktif"]) ? '1' : '0';
            $api_resim_gorunur = !empty($_POST["api_resim_gorunur"]) ? '1' : '0';
            $api_pdf_resim_gorunur = !empty($_POST["api_pdf_resim_gorunur"]) ? '1' : '0';

            // Dizin gibi metin alanları için temizle fonksiyonu kullanılmalı ve kenar boşlukları/slashtan arındırılmalı
            $stok_resim_yukleme_dizin = trim(temizle($_POST["stok_resim_yukleme_dizin"] ?? 'uploads/urun_resimleri'), '/\\');

            // --- Dizin Kontrolü ve Oluşturma Başlangıç ---
            if (!empty($stok_resim_yukleme_dizin)) {
                $proje_koku = dirname(__DIR__, 2); // Proje kök dizinini al (views/ayarlar -> views -> proje kökü)
                $dizin_yolu_abs = $proje_koku . DIRECTORY_SEPARATOR . $stok_resim_yukleme_dizin;

                if (!file_exists($dizin_yolu_abs)) {
                    // Dizin yoksa oluşturmayı dene (recursive)
                    if (!mkdir($dizin_yolu_abs, 0775, true)) {
                        throw new Exception(__("directory_creation_failed") . ": '" . htmlspecialchars($stok_resim_yukleme_dizin) . "'. " . __("check_directory_permissions"));
                    }
                } elseif (!is_dir($dizin_yolu_abs)) {
                    throw new Exception(__("not_a_directory") . ": '" . htmlspecialchars($stok_resim_yukleme_dizin) . "'.");
                }
            }
            // --- Dizin Kontrolü ve Oluşturma Bitiş ---
            
            // Ayarları update_site_setting fonksiyonu ile güncelle
            // update_site_setting($db, 'ikinci_fiyat_kdv_aktif', $ikinci_fiyat_aktif, $aktif_sirket_id); kaldırıldı
            update_site_setting($db, 'stok_resim_yukleme_aktif', $stok_resim_yukleme_aktif, $aktif_sirket_id);
            update_site_setting($db, 'stok_resim_yukleme_dizin', $stok_resim_yukleme_dizin, $aktif_sirket_id);
            update_site_setting($db, 'api_resim_gorunur', $api_resim_gorunur, $aktif_sirket_id);
            update_site_setting($db, 'api_pdf_resim_gorunur', $api_pdf_resim_gorunur, $aktif_sirket_id);

            // Log ekle
            sistem_log_ekle($db, 'guncelle', 'ayarlar', null, null, [
                // 'ikinci_fiyat_kdv_aktif' => $ikinci_fiyat_aktif, kaldırıldı
                'stok_resim_yukleme_aktif' => $stok_resim_yukleme_aktif,
                'stok_resim_yukleme_dizin' => $stok_resim_yukleme_dizin,
                'api_resim_gorunur' => $api_resim_gorunur,
                'api_pdf_resim_gorunur' => $api_pdf_resim_gorunur,
            ], 'Stok ve Resim ayarları şirket bazında güncellendi'); // Log mesajını güncelledim
            $_SESSION['mesaj'] = "Stok ve Resim ayarları başarıyla güncellendi."; // Mesajı güncelledim
        } catch (PDOException $e) {
            error_log("Stok ve Resim ayarları güncelleme hatası: " . $e->getMessage());
            $_SESSION['hata'] = __("database_error_while_updating_settings");
        } catch (Exception $e) {
            $_SESSION['hata'] = $e->getMessage();
        }
    }
}

// Mevcut ayarları getir (şirket bazında)
try {
    $aktif_sirket_id = $_SESSION['aktif_sirket_id'] ?? null; // Aktif şirket ID'sini al

    // $ikinci_fiyat_aktif kaldırıldı
    $stok_resim_yukleme_aktif = get_site_setting($db, 'stok_resim_yukleme_aktif', '0', $aktif_sirket_id);
    $stok_resim_yukleme_dizin = get_site_setting($db, 'stok_resim_yukleme_dizin', 'uploads/urun_resimleri', $aktif_sirket_id);
    $api_resim_gorunur = get_site_setting($db, 'api_resim_gorunur', '0', $aktif_sirket_id);
    $api_pdf_resim_gorunur = get_site_setting($db, 'api_pdf_resim_gorunur', '0', $aktif_sirket_id);

} catch (PDOException $e) {
    error_log("Stok ve Resim ayarları getirme hatası: " . $e->getMessage());
    // $ikinci_fiyat_aktif kaldırıldı
    $stok_resim_yukleme_aktif = '0';
    $stok_resim_yukleme_dizin = 'uploads/urun_resimleri';
    $api_resim_gorunur = '0';
    $api_pdf_resim_gorunur = '0';
}
?>

<?php if (isset($_SESSION['mesaj'])): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?= $_SESSION['mesaj'] ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php unset($_SESSION['mesaj']); ?>
<?php endif; ?>
<?php if (isset($_SESSION['hata'])): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <?= $_SESSION['hata'] ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php unset($_SESSION['hata']); ?>
<?php endif; ?>

<div class="card shadow-sm">
    <div class="card-header bg-primary text-white">
        <h5 class="mb-0">
            <i class="bi bi-box-seam me-2"></i><?= __("stock_and_image_settings") ?>
        </h5>
    </div>
    <div class="card-body">
        <form method="post">
            <input type="hidden" name="csrf_token" value="<?= $csrf_token ?>">
            
            <div class="row">
                <div class="col-12">
                    <div class="alert alert-info" role="alert">
                        <h6 class="alert-heading"><i class="bi bi-info-circle me-2"></i><?= __("information") ?></h6>
                        <p class="mb-0">
                            <?= __("stock_settings_description") ?>
                        </p>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="card border-light">
                        <div class="card-header bg-light">
                            <h6 class="mb-0"><i class="bi bi-image me-2"></i><?= __("image_upload_settings") ?></h6> <!-- Yeni bölüm başlığı -->
                        </div>
                        <div class="card-body">
                            <div class="form-check form-switch mb-3">
                                <input class="form-check-input" type="checkbox" id="stok_resim_yukleme_aktif" 
                                       name="stok_resim_yukleme_aktif" value="1" <?= $stok_resim_yukleme_aktif == '1' ? 'checked' : '' ?>>
                                <label class="form-check-label" for="stok_resim_yukleme_aktif">
                                    <strong><?= __("enable_image_upload_in_stock_section") ?></strong>
                                </label>
                                <div class="form-text"><?= __("enable_image_upload_help") ?></div>
                            </div>
                            <div class="mb-3">
                                <label for="stok_resim_yukleme_dizin" class="form-label"><?= __("image_upload_directory") ?></label>
                                <input type="text" class="form-control" id="stok_resim_yukleme_dizin" name="stok_resim_yukleme_dizin" 
                                       value="<?= htmlspecialchars($stok_resim_yukleme_dizin ?? 'uploads/urun_resimleri') ?>">
                                <div class="form-text">
                                    <?= __("image_upload_directory_help") ?>
                                    <?= __("example") ?>: <code>uploads/urun_resimleri</code>.
                                    <br><?= __("directory_permissions_note") ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card border-light">
                        <div class="card-header bg-light">
                            <h6 class="mb-0"><i class="bi bi-image me-2"></i><?= __("image_visibility_settings") ?></h6> <!-- Başlık güncellendi -->
                        </div>
                        <div class="card-body">
                            <div class="form-check form-switch mb-3">
                                <input class="form-check-input" type="checkbox" id="api_resim_gorunur" 
                                       name="api_resim_gorunur" value="1" <?= $api_resim_gorunur == '1' ? 'checked' : '' ?>>
                                <label class="form-check-label" for="api_resim_gorunur">
                                    <strong><?= __("show_product_images") ?></strong>
                                </label>
                                <div class="form-text"><?= __("show_product_images_help") ?></div>
                            </div>
                            <div class="form-check form-switch mb-3">
                                <input class="form-check-input" type="checkbox" id="api_pdf_resim_gorunur" 
                                       name="api_pdf_resim_gorunur" value="1" <?= $api_pdf_resim_gorunur == '1' ? 'checked' : '' ?>>
                                <label class="form-check-label" for="api_pdf_resim_gorunur">
                                    <strong><?= __("show_images_in_pdf") ?></strong>
                                </label>
                                <div class="form-text"><?= __("show_images_in_pdf_help") ?></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row mt-4">
                <div class="col-12">
                    <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-save me-2"></i><?= __("save_settings") ?>
                        </button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="row mt-4">
    <div class="col-12">
        <div class="card border-warning">
            <div class="card-header bg-warning text-dark">
                <h6 class="mb-0"><i class="bi bi-exclamation-triangle me-2"></i><?= __("important_notes") ?></h6>
            </div>
            <div class="card-body">
                <ul class="mb-0">
                    <li><?= __("image_settings_note_1") ?></li>
                    <li><?= __("image_settings_note_2") ?></li>
                    <li><?= __("image_settings_note_3") ?></li>
                    <li><?= __("image_settings_note_4") ?></li>
                    <li><?= __("settings_take_effect_immediately") ?></li>
                </ul>
            </div>
        </div>
    </div>
</div>



