<?php
require_once __DIR__ . '/../includes/config.php';
yetkili_mi();

// İşlem (Borç) ID'sini al ve doğrula
if (!isset($_GET['id']) || !($borc_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT))) {
    $_SESSION['hata'] = "Geçersiz İşlem ID.";
    header("Location: index.php"); // Ana sayfaya yönlendir
    exit();
}

$aktif_sirket_id = $_SESSION['aktif_sirket_id'] ?? 0;
$sayfa_baslik = "İşlem Detayı";

// Çoklu para birimi durumunu kontrol et
$stmt_coklu_pb = $db->prepare("SELECT coklu_para_birimi FROM sirketler WHERE id = ?");
$stmt_coklu_pb->execute([$aktif_sirket_id]);
$coklu_para_birimi_aktif = (bool) ($stmt_coklu_pb->fetchColumn() ?? 0);

$borc = null; // İşlem verisini tutacak değişken
$ilgili_hareketler = []; // İlgili ödeme/tahsilatları tutacak dizi

// İşlem bilgilerini ve ilişkili verileri çek
try {
    // Ana İşlem Bilgisi
    $stmt_borc = $db->prepare("
        SELECT b.*, c.ad_soyad as cari_ad_soyad, k.kategori_adi
        FROM borclar b
        JOIN cariler c ON b.cari_id = c.id AND c.sirket_id = b.sirket_id
        LEFT JOIN kategoriler k ON b.kategori_id = k.id AND k.sirket_id = b.sirket_id
        WHERE b.id = ? AND b.sirket_id = ?
    ");
    $stmt_borc->execute([$borc_id, $aktif_sirket_id]);
    $borc = $stmt_borc->fetch(PDO::FETCH_ASSOC);

    if (!$borc) {
        $_SESSION['hata'] = "Detayı görüntülenecek işlem bulunamadı veya bu şirkete ait değil.";
        header("Location: index.php"); // Ana sayfaya yönlendir
        exit();
    }

    // Fatura para birimini al ve sembolünü belirle
    $fatura_para_birimi = $borc['para_birimi'] ?? 'TRY';
    if ($fatura_para_birimi === 'TL') $fatura_para_birimi = 'TRY';
    
    // Çoklu para birimi aktifse fatura para birimini, değilse varsayılan şirket para birimini kullan
    if ($coklu_para_birimi_aktif && $fatura_para_birimi !== 'TRY') {
        $paraBirimi = getParaBirimiSembolu($fatura_para_birimi);
    } else {
        $paraBirimi = getParaBirimiSembolu();
    }

    $sayfa_baslik .= " (#{$borc['id']} - " . ($borc['tur'] == 'satis' ? 'Satış' : 'Alış') . ")";

    // Bu İşleme Ait Ödeme/Tahsilat Hareketleri
    $stmt_hareketler = $db->prepare("
        SELECT hh.*, h.hesap_adi
        FROM hesap_hareketleri hh
        JOIN hesaplar h ON hh.hesap_id = h.id AND h.sirket_id = hh.sirket_id
        WHERE hh.borc_id = ? AND hh.sirket_id = ?
        ORDER BY hh.tarih ASC -- Eskiden yeniye sırala
    ");
    $stmt_hareketler->execute([$borc_id, $aktif_sirket_id]);
    $ilgili_hareketler = $stmt_hareketler->fetchAll(PDO::FETCH_ASSOC);

    // Borcun türüne göre ödenen toplamı hesapla
    $islem_turu = $borc['tur']; // 'alis' veya 'satis'
    $hareket_tur = ($islem_turu === 'alis') ? 'cikis' : 'giris';
    $stmt_odenen = $db->prepare("SELECT SUM(tutar) FROM hesap_hareketleri WHERE borc_id = ? AND sirket_id = ? AND tur = ?");
    $stmt_odenen->execute([$borc_id, $aktif_sirket_id, $hareket_tur]);
    $odenen_tutar = (float) $stmt_odenen->fetchColumn();

    // Fatura Detaylarını Çek (eğer stoklu işlem ise)
    $fatura_detaylari = [];
    if ($borc && $borc['stoklu_islem'] == 1) {
        $stmt_detay = $db->prepare("
            SELECT fd.*, u.urun_adi, u.barkod as stok_kodu, u.alis_para_birimi, u.satis_para_birimi
            FROM fatura_detaylari fd
            LEFT JOIN urunler u ON fd.urun_id = u.id
            WHERE fd.borc_id = ?
            ORDER BY fd.id ASC
        ");
        $stmt_detay->execute([$borc_id]);
        $fatura_detaylari = $stmt_detay->fetchAll(PDO::FETCH_ASSOC);
    }

    // Kalan tutarı hesapla
    $kalan_tutar = $borc['tutar'] + $borc['toplam_kdv'] - $borc['indirim_tutari'] - $odenen_tutar;

// Ödeme durumu hesapla
$yeni_durum = 'odenmedi';
if ($kalan_tutar <= 0.01) {
    $yeni_durum = 'odendi';
} elseif ($odenen_tutar > 0 && $kalan_tutar > 0.01) {
    $yeni_durum = 'kismen_odendi';
}


} catch (PDOException $e) {
    error_log("Borç Detay (ID: {$borc_id}) Hatası: " . $e->getMessage());
    $_SESSION['hata'] = "İşlem detayları alınırken bir hata oluştu.";
     // Hata durumunda $borc null olabilir, HTML'de kontrol edilecek.
     $borc = null;
}

$csrf_token = csrf_token_olustur(); // Silme işlemi için
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Odjoo Yönetim - <?= temizle($sayfa_baslik) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <style>
        .dl-horizontal dt { float: left; width: 160px; overflow: hidden; clear: left; text-align: right; text-overflow: ellipsis; white-space: nowrap; font-weight: bold; margin-bottom: 0.5rem;}
        .dl-horizontal dd { margin-left: 180px; margin-bottom: 0.5rem;}
        .badge-odendi { background-color: var(--bs-success); }
        .badge-kismen { background-color: var(--bs-warning); color: #000 !important; }
        .badge-odenmedi { background-color: var(--bs-danger); }
    </style>
</head>
<body>
    <?php include __DIR__ . '/../includes/navbar.php'; ?>

    <div class="container mt-4">
        <?php if ($borc): // İşlem bulunduysa ?>
        <div class="d-flex justify-content-between align-items-center mb-3">
             <h2 class="mb-0">
                <i class="bi <?= $borc['tur'] == 'satis' ? 'bi-receipt text-danger' : 'bi-cart-check text-success' ?> me-2"></i>
                <?= temizle($sayfa_baslik) ?>
            </h2>
             <div>
                 <a href="javascript:history.back()" class="btn btn-outline-secondary">
                     <i class="bi bi-arrow-left"></i> Geri Dön
                 </a>
                 <a href="borc_detay_pdf.php?id=<?= $borc['id'] ?>" target="_blank" class="btn btn-outline-secondary ms-2">
                     <i class="bi bi-file-earmark-pdf"></i> PDF'ye Çevir
                 </a>
             </div>
        </div>
        <hr>

        <div class="row g-4">
            <div class="col-md-7">
                <div class="card shadow-sm">
                    <div class="card-header">
                       <i class="bi bi-info-circle-fill me-2"></i> İşlem Bilgileri
                    </div>
                    <div class="card-body">
                         <dl class="dl-horizontal">
                            <dt>İşlem ID:</dt>
                            <dd>#<?= $borc['id'] ?></dd>

                            <dt>İşlem Türü:</dt>
                            <dd><?= ($borc['tur'] == 'satis' ? '<span class="badge bg-danger">Satış</span>' : '<span class="badge bg-success">Alış</span>') ?></dd>

                            <dt>Cari:</dt>
                            <dd><a href="cari_detay.php?id=<?= $borc['cari_id'] ?>"><?= temizle($borc['cari_ad_soyad']) ?></a></dd>

                            <dt>Kategori:</dt>
                            <dd><?= $borc['kategori_adi'] ? temizle($borc['kategori_adi']) : '-' ?></dd>

                            <dt>İşlem Tarihi:</dt>
                            <dd><?= date('d.m.Y', strtotime($borc['tarih'])) ?></dd>

                            <dt>Vade Tarihi:</dt>
                            <dd><?= $borc['vade_tarihi'] ? date('d.m.Y', strtotime($borc['vade_tarihi'])) : 'Belirtilmemiş' ?></dd>

                            <?php if ($coklu_para_birimi_aktif && $fatura_para_birimi !== 'TRY'): ?>
                            <dt>Fatura Para Birimi:</dt>
                            <dd><span class="badge bg-info"><?= $fatura_para_birimi ?> (<?= $paraBirimi ?>)</span></dd>
                            <?php endif; ?>

                            <?php if ($borc['stoklu_islem'] == '0' && !empty($borc['aciklama'])): ?>
                                <div class="card shadow-sm rounded-3 border-0 mb-3">
                                    <div class="card-body p-0">
                                        <div class="table-responsive mb-0">
                                            <table class="table table-sm table-bordered table-hover align-middle mb-0">
                                                <thead class="table-primary">
                                                    <tr>
                                                        <th class="text-center" style="width:40px;">#</th>
                                                        <th>Açıklama</th>
                                                        <th class="text-end" style="width:120px;">Tutar (<?= $paraBirimi ?>)</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php
                                                    $satirlar = preg_split('/\r\n|\r|\n/', $borc['aciklama']);
                                                    $num = 1; $bos = true;
                                                    foreach ($satirlar as $satir) {
                                                        $satir = trim($satir);
                                                        if ($satir === '') continue;
                                                        $aciklama = $satir;
                                                        $tutar = '';
                                                        if (preg_match('/^(.*)\(([^)]+)\)$/u', $satir, $parcalar)) {
                                                            $aciklama = trim($parcalar[1]);
                                                            $tutar = trim($parcalar[2]);
                                                        }
                                                        echo '<tr>';
                                                        echo '<td class="text-center">' . ($num++) . '</td>';
                                                        echo '<td>' . temizle($aciklama) . '</td>';
                                                        echo '<td class="text-end">' . temizle($tutar) . ' ' . $paraBirimi . '</td>';
                                                        echo '</tr>';
                                                        $bos = false;
                                                    }
                                                    if ($bos) {
                                                        echo '<tr><td colspan="3" class="text-center text-muted">Açıklama kalemi yok.</td></tr>';
                                                    }
                                                    ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            <?php else: ?>
                                <dt>Açıklama:</dt>
                                <dd><?= $borc['aciklama'] ? nl2br(temizle($borc['aciklama'])) : '-' ?></dd>
                            <?php endif; ?>
                        </dl>
                    </div>
                </div>
            </div>

             <div class="col-md-5">
                <div class="card shadow-sm mb-4">
                     <div class="card-header">
                       <i class="bi bi-currency-lira me-2"></i> Ödeme Durumu
                    </div>
                    <div class="card-body">
                        <dl class="dl-horizontal">
                            <?php if ($borc['stoklu_islem'] == 1): ?>
                                <dt>Ara Toplam:</dt>
                                <dd><?= number_format($borc['tutar'], 2, ',', '.') . ' ' . $paraBirimi ?></dd>

                                <dt>Toplam KDV:</dt>
                                <dd><?= number_format($borc['toplam_kdv'], 2, ',', '.') . ' ' . $paraBirimi ?></dd>

                                <?php if ($borc['indirim_tutari'] > 0): ?>
                                <dt>İndirim:</dt>
                                <dd class="text-warning">-<?= number_format($borc['indirim_tutari'], 2, ',', '.') . ' ' . $paraBirimi ?></dd>
                                <?php endif; ?>

                                <dt style="font-size: 1.1em; border-top: 1px solid #eee; padding-top: 0.5rem;">Genel Toplam:</dt>
                                <dd style="font-size: 1.1em; border-top: 1px solid #eee; padding-top: 0.5rem;"><?= number_format($borc['tutar'] + $borc['toplam_kdv'] - $borc['indirim_tutari'], 2, ',', '.') . ' ' . $paraBirimi ?></dd>
                            <?php else: ?>
                                <dt>Toplam Tutar:</dt>
                                <dd><?= number_format($borc['tutar'], 2, ',', '.') . ' ' . $paraBirimi ?></dd>
                            <?php endif; ?>

                            <hr class="my-2">

                            <dt>Ödenen Tutar:</dt>
                            <dd class="text-success"><?= number_format($odenen_tutar, 2, ',', '.') . ' ' . $paraBirimi ?></dd>

                             <dt>Kalan Tutar:</dt>
                             <dd class="fw-bold <?= $kalan_tutar > 0.01 ? 'text-danger' : 'text-success' ?>">
                                <?= number_format($kalan_tutar, 2, ',', '.') . ' ' . $paraBirimi ?>
                            </dd>

                            <dt>Durum:</dt>
                            <dd>
                                <?php
                                    $durum_class = 'badge-secondary';
                                    if ($yeni_durum == 'odendi') $durum_class = 'badge-odendi';
                                    elseif ($yeni_durum == 'kismen_odendi') $durum_class = 'badge-kismen';
                                    elseif ($yeni_durum == 'odenmedi') $durum_class = 'badge-odenmedi';
                                ?>
                                <?php
                                    // Durum etiketi Türkçe ve büyük harfli
                                    $durum_text = '';
                                    switch ($yeni_durum) {
                                        case 'odendi': $durum_text = 'FATURA ÖDENDİ'; break;
                                        case 'kismen_odendi': $durum_text = 'KISMEN ÖDENDİ'; break;
                                        default: $durum_text = 'ÖDENMEDİ';
                                    }
                                ?>
                                <span class="badge <?= $durum_class ?>" id="durum-badge">
                                    <?= $durum_text ?>
                                </span>
                                <?php
                                    // $yeni_durum'a göre buton ve ikon ayarı
                                    if ($yeni_durum == 'odendi') {
                                        $button_text = 'Geri Al';
                                        $button_class = 'btn-outline-warning';
                                        $yeni_durum_value = 'odenmedi';
                                        $button_icon = 'bi-arrow-counterclockwise';
                                    } else {
                                        $button_text = 'Ödendi Yap';
                                        $button_class = 'btn-outline-success';
                                        $yeni_durum_value = 'odendi';
                                        $button_icon = 'bi-check-lg';
                                    }
                                ?>
                                <button id="durum-degistir-btn" class="btn <?= $button_class ?> btn-sm ms-2" data-yeni-durum="<?= $yeni_durum_value ?>" title="<?= $button_text ?>">
                                    <i class="bi <?= $button_icon ?>"></i>
                                </button>
                            </dd>
                        </dl>
                    </div>
                </div>
                 <div class="card shadow-sm">
                     <div class="card-header">
                        <i class="bi bi-lightning-charge me-2"></i> İşlemler
                    </div>
                    <div class="card-body d-grid gap-2">
                        <?php if ($borc['durum'] != 'odendi'): // Henüz tam ödenmediyse ödeme/tahsilat yapma linki ?>
                            <?php if ($borc['tur'] == 'satis'): // Satışsa Tahsilat Yap ?>
                                <a href="odeme_al.php?borc_id=<?= $borc['id'] ?>&cari_id=<?= $borc['cari_id'] ?>" class="btn btn-success">
                                    <i class="bi bi-arrow-down-circle me-1"></i> Bu Satışa Tahsilat Ekle
                                </a>
                            <?php else: // Alışsa Ödeme Yap ?>
                                <a href="odeme_yap.php?borc_id=<?= $borc['id'] ?>&cari_id=<?= $borc['cari_id'] ?>" class="btn btn-danger">
                                    <i class="bi bi-arrow-up-circle me-1"></i> Bu Alışa Ödeme Ekle
                                </a>
                            <?php endif; ?>
                        <?php endif; ?>

                         <a href="borc_duzenle.php?id=<?= $borc['id'] ?>" class="btn btn-outline-warning">
                            <i class="bi bi-pencil me-1"></i> Faturayı Düzenle
                        </a>
                        <?php if (yetkili_mi(['admin', 'satis_islemleri', 'alis_islemleri'], false)): ?>
                        <form action="fatura_sil.php" method="POST" onsubmit="return confirm('Bu faturayı ve ilişkili tüm kayıtları (stok hareketleri, ödemeler/tahsilatlar, cari bakiye güncellemeleri) kalıcı olarak silmek istediğinize emin misiniz? Bu işlem geri alınamaz!');" class="d-grid">
                            <input type="hidden" name="borc_id" value="<?= $borc['id'] ?>">
                            <input type="hidden" name="csrf_token" value="<?= $csrf_token ?>">
                            <button type="submit" class="btn btn-outline-danger">
                                <i class="bi bi-trash me-1"></i> Bu Faturayı Sil
                            </button>
                        </form>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Ürün Detayları -->
        <?php if ($borc['stoklu_islem'] == 1 && !empty($fatura_detaylari)): ?>
        <div class="card shadow-sm mt-4">
            <div class="card-header">
                <i class="bi bi-box-seam me-2"></i> Fatura Ürün Detayları
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-striped table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>Barkod</th>
                                <th>Ürün Adı</th>
                                <th class="text-end">Miktar</th>
                                <th class="text-end">Birim Fiyat</th>
                                <?php if ($coklu_para_birimi_aktif): ?>
                                <th class="text-end">Ürün PB</th>
                                <th class="text-end">Kur</th>
                                <?php endif; ?>
                                <th class="text-end">KDV (%)</th>
                                <th class="text-end">Satır Toplamı</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($fatura_detaylari as $detay): ?>
                            <tr>
                                <td><?= temizle($detay['stok_kodu']) ?></td>
                                <td><?= temizle($detay['urun_adi'] ?? 'Silinmiş Ürün') ?></td>
                                <td class="text-end"><?= rtrim(rtrim(number_format($detay['miktar'], 2, ',', '.'), '0'), ',') ?></td>
                                <td class="text-end"><?= number_format($detay['birim_fiyat'], 2, ',', '.') . ' ' . $paraBirimi ?></td>
                                <?php if ($coklu_para_birimi_aktif): ?>
                                <td class="text-end">
                                    <?php 
                                    $urun_pb = $borc['tur'] == 'satis' ? ($detay['satis_para_birimi'] ?? 'TRY') : ($detay['alis_para_birimi'] ?? 'TRY');
                                    if ($urun_pb === 'TL') $urun_pb = 'TRY';
                                    $urun_pb_sembol = getParaBirimiSembolu($urun_pb);
                                    ?>
                                    <span class="badge bg-secondary"><?= $urun_pb ?> (<?= $urun_pb_sembol ?>)</span>
                                </td>
                                <td class="text-end">
                                    <?php 
                                    $kur = $detay['kur'] ?? 1;
                                    if ($kur > 0 && $kur != 1) {
                                        echo number_format($kur, 4, ',', '.');
                                    } else {
                                        echo '-';
                                    }
                                    ?>
                                </td>
                                <?php endif; ?>
                                <td class="text-end"><?= rtrim(rtrim(number_format($detay['kdv_orani'], 2, ',', '.'), '0'), ',') ?>%</td>
                                <td class="text-end fw-bold">
                                    <?php 
                                    // Satır toplamını doğru hesapla - veritabanından gelen toplam_tutar değerini kullan
                                    // Bu değer zaten kur hesaplaması yapılmış ve fatura para biriminde
                                    echo number_format($detay['toplam_tutar'], 2, ',', '.') . ' ' . $paraBirimi;
                                    ?>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <div class="card shadow-sm mt-4">
            <div class="card-header">
                <i class="bi bi-list-ol me-2"></i> Bu İşlemle İlgili Hesap Hareketleri (Ödemeler/Tahsilatlar)
            </div>
             <div class="card-body p-0">
                <?php if (empty($ilgili_hareketler)): ?>
                    <p class="text-muted p-3">Bu işlemle doğrudan ilişkili bir ödeme veya tahsilat kaydı bulunmamaktadır.</p>
                <?php else: ?>
                <div class="table-responsive">
                    <table class="table table-striped table-hover table-sm mb-0">
                         <thead class="table-light">
                            <tr>
                                <th>Tarih</th>
                                <th>Hesap</th>
                                <th>Tür</th>
                                <th class="text-end">Tutar</th>
                                <th>Açıklama</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($ilgili_hareketler as $hareket): ?>
                            <tr>
                                <td><?= date('d.m.Y H:i', strtotime($hareket['tarih'])) ?></td>
                                <td><?= temizle($hareket['hesap_adi']) ?></td>
                                <td>
                                     <?php if ($hareket['tur'] == 'giris'): ?>
                                        <span class="badge bg-success">Giriş</span>
                                    <?php elseif ($hareket['tur'] == 'cikis'): ?>
                                        <span class="badge bg-danger">Çıkış</span>
                                    <?php endif; ?>
                                </td>
                                <td class="text-end fw-bold <?= $hareket['tur'] == 'giris' ? 'text-success' : 'text-danger' ?>">
                                     <?= $hareket['tur'] == 'giris' ? '+' : '-' ?>
                                    <?= number_format($hareket['tutar'], 2, ',', '.') . ' ' . $paraBirimi ?>
                                </td>
                                <td><?= temizle($hareket['aciklama']) ?></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                <?php endif; ?>
            </div>
        </div>


        <?php else: // İşlem bulunamadıysa ?>
            <div class="alert alert-danger">
                Detayı görüntülenecek işlem bulunamadı veya yüklenirken bir hata oluştu.
                <a href="index.php" class="alert-link ms-2">Ana Sayfaya Dön</a>
            </div>
        <?php endif; ?>
    </div>

	<?php include __DIR__ . "/../includes/footer.php"; ?>
	
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
    <script>
    $(document).ready(function() {
        // Para birimi sembolünü JavaScript'te kullanabilmek için
        var paraBirimiSembol = '<?= $paraBirimi ?>';
        
        $('#durum-degistir-btn').on('click', function() {
            var button = $(this);
            var original_html = button.html(); // Orijinal buton içeriğini sakla
            var borc_id = <?= $borc_id ?>;
            var yeni_durum = button.data('yeni-durum');
            var csrf_token = '<?= $csrf_token ?>';

            var confirm_message = '"' + (yeni_durum === 'odendi' ? 'Ödendi' : 'Ödenmedi') + '" olarak işaretlemek istediğinize emin misiniz?';
            if (yeni_durum === 'odenmedi') {
                confirm_message += '\n\nUYARI: Bu işlem, bu faturaya ait tüm ödeme kayıtlarını kalıcı olarak silecektir!';
            }

            if (!confirm(confirm_message)) {
                return;
            }

            button.prop('disabled', true).html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>');

            $.ajax({
                url: '../ajax/borc_durum_guncelle.php',
                type: 'POST',
                data: {
                    borc_id: borc_id,
                    yeni_durum: yeni_durum,
                    csrf_token: csrf_token
                },
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        // Kalan tutar ve ödenen tutarı güncelle
                        $('dd').each(function() {
                            if ($(this).prev('dt').text() === 'Kalan Tutar:') {
                                $(this).text(response.guncel_veriler.kalan_tutar + ' ' + paraBirimiSembol).toggleClass('text-danger text-success', parseFloat(response.guncel_veriler.kalan_tutar.replace(/\./g, '').replace(',', '.')) <= 0.01);
                            }
                            if ($(this).prev('dt').text() === 'Ödenen Tutar:') {
                                $(this).text(response.guncel_veriler.odenen_tutar + ' ' + paraBirimiSembol);
                            }
                        });
                        
                        // Durum etiketini güncelle
                        $('#durum-badge').text(response.guncel_veriler.durum_text).removeClass('badge-odendi badge-odenmedi badge-kismen').addClass(response.guncel_veriler.durum_class);

                        // Butonu güncelle
                        var yeni_button_durum = (yeni_durum === 'odendi') ? 'odenmedi' : 'odendi';
                        var yeni_button_text = (yeni_durum === 'odendi') ? 'Geri Al' : 'Ödendi Yap';
                        var yeni_button_class = (yeni_durum === 'odendi') ? 'btn-outline-warning' : 'btn-outline-success';
                        var yeni_button_icon = (yeni_durum === 'odendi') ? 'bi-arrow-counterclockwise' : 'bi-check-lg';
                        
                        button.data('yeni-durum', yeni_button_durum)
                              .attr('title', yeni_button_text)
                              .removeClass('btn-outline-success btn-outline-warning')
                              .addClass(yeni_button_class)
                              .html('<i class="bi ' + yeni_button_icon + '"></i>');
                        
                        // CSRF token'ı güncelle (formlar için)
                        $('input[name="csrf_token"]').val(response.csrf_token);
                        
                        // Ödeme yapma/alma linklerini gizle/göster
                        if(yeni_durum === 'odendi') {
                            $('.card-body.d-grid.gap-2 a[href*="odeme_"]').hide();
                        } else {
                             $('.card-body.d-grid.gap-2 a[href*="odeme_"]').show();
                        }

                    } else {
                        alert('Hata: ' + response.message);
                        button.html(original_html); // Hata durumunda butonu eski haline getir
                    }
                },
                error: function() {
                    alert('Sunucuyla iletişim kurulamadı.');
                    button.html(original_html); // Hata durumunda butonu eski haline getir
                },
                complete: function() {
                    button.prop('disabled', false); 
                }
            });
        });
    });
    </script>
</body>
</html>
