<?php 
require_once __DIR__ . '/../includes/config.php';

require_once __DIR__ . '/../functions/log_fonksiyonlari.php';
require_once __DIR__ . '/../functions/stok_fonksiyonlari.php'; // Stok fonksiyonları eklendi
require_once __DIR__ . '/../functions/yardimci_fonksiyonlar.php';

yetkili_mi('faturalar'); // Yetki kontrolü

global $db;

// 1. ID'yi Al ve Doğrula
if (!isset($_GET['id']) || !($borc_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT))) {
    $_SESSION['hata'] = __("invalid_invoice_id");
    header("Location: index.php");
    exit();
}

$sayfa_baslik = __("edit_invoice");
$paraBirimi = getFirmaPara();
$aktif_sirket_id = $_SESSION['aktif_sirket_id'];

// Formdan gelen verileri tutmak için
$form_verileri = [];

try {
    // Çoklu para birimi durumunu kontrol et
    $stmt_coklu_pb = $db->prepare("SELECT coklu_para_birimi, para_birimi FROM sirketler WHERE id = ?");
    $stmt_coklu_pb->execute([$aktif_sirket_id]);
    $sirket_ayarlari = $stmt_coklu_pb->fetch(PDO::FETCH_ASSOC);
    $coklu_para_birimi_aktif = (bool) ($sirket_ayarlari['coklu_para_birimi'] ?? 0);
    $sirket_para_birimi = $sirket_ayarlari['para_birimi'] ?? 'TL';

    // 2. Fatura Ana Bilgilerini ve Eski Detayları Çek (POST işlemi için de lazım olacak)
    $stmt = $db->prepare("SELECT * FROM borclar WHERE id = ? AND sirket_id = ?");
    $stmt->execute([$borc_id, $aktif_sirket_id]);
    $fatura = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$fatura) {
        $_SESSION['hata'] = __("invoice_not_found");
        header("Location: index.php");
        exit();
    }

    if ($fatura['stoklu_islem'] != 1) {
        // Bu stoksuz bir işlem, kullanıcıyı ilgili düzenleme sayfasına yönlendir.
        header("Location: islem_duzenle.php?id=" . $borc_id);
        exit();
    }

    // Fatura para birimini normalize et
    $fatura_para_birimi = $fatura['para_birimi'] ?? 'TRY';
    if ($fatura_para_birimi === 'TL') $fatura_para_birimi = 'TRY';

    // Fatura detayları ve ürün para birimi bilgilerini çek
    $stmt_detay = $db->prepare("SELECT fd.*, u.alis_para_birimi, u.satis_para_birimi FROM fatura_detaylari fd LEFT JOIN urunler u ON fd.urun_id = u.id WHERE fd.borc_id = ?");
    $stmt_detay->execute([$borc_id]);
    $eski_fatura_detaylari = $stmt_detay->fetchAll(PDO::FETCH_ASSOC);
    $fatura_detaylari_json = json_encode($eski_fatura_detaylari); // JS için

} catch (PDOException $e) {
    error_log("Fatura düzenleme sayfası (veri çekme) hatası: " . $e->getMessage());
    $_SESSION['hata'] = __("database_error");
    header("Location: index.php");
    exit();
}

// Form Gönderildiğinde (POST Metodu)
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!csrf_token_dogrula($_POST['csrf_token'] ?? '')) {
        $_SESSION['hata'] = __("invalid_form_submission");
        header("Location: borc_duzenle.php?id=" . $borc_id);
        exit();
    }

    // Form verilerini al ve işle
    $form_verileri = $_POST;
    $hatalar = [];

    $cari_id = filter_input(INPUT_POST, 'cari_id', FILTER_VALIDATE_INT);
    $kategori_id = filter_input(INPUT_POST, 'kategori_id', FILTER_VALIDATE_INT);
    $fatura_no = temizle($_POST['fatura_no'] ?? '');
    $tarih = filter_input(INPUT_POST, 'tarih', FILTER_SANITIZE_SPECIAL_CHARS);
    $vade_tarihi = filter_input(INPUT_POST, 'vade_tarihi', FILTER_SANITIZE_SPECIAL_CHARS) ?: null;
    $aciklama = temizle($_POST['aciklama'] ?? '');
    $indirim_tutari = filter_var(str_replace(',', '.', $_POST['indirim_tutari'] ?? '0'), FILTER_VALIDATE_FLOAT);
    
    // Fatura para birimi (düzenleme sırasında değiştirilebilir)
    $yeni_fatura_para_birimi = temizle($_POST['fatura_para_birimi'] ?? $fatura_para_birimi);
    if ($yeni_fatura_para_birimi === 'TL') $yeni_fatura_para_birimi = 'TRY';

    // Yeni ürün detaylarını işle
    $yeni_urun_detaylari = [];
    $toplam_tutar = 0;
    $toplam_kdv = 0;
    $urun_ids = $_POST['urun_id'] ?? [];
    $kurlar = $_POST['kur'] ?? [];
    $alis_para_birimleri = $_POST['alis_para_birimi'] ?? [];
    $satis_para_birimleri = $_POST['satis_para_birimi'] ?? [];
    
    foreach ($urun_ids as $index => $urun_id) {
        if (!empty($urun_id)) {
            $miktar = (float)str_replace(',', '.', $_POST['miktar'][$index]);
            $birim_fiyat = (float)str_replace(',', '.', $_POST['birim_fiyat'][$index]);
            $kdv_orani = (float)str_replace(',', '.', $_POST['kdv_orani'][$index]);
            $kur = (float)str_replace(',', '.', $kurlar[$index] ?? '1');
            $alis_para_birimi = temizle($alis_para_birimleri[$index] ?? ($satis_para_birimleri[$index] ?? 'TL'));

            // KDV ve toplam önce orijinal para biriminde hesaplanır, sonra fatura para birimine çevrilir
            $satir_toplam_orj = $miktar * $birim_fiyat; // Orijinal para birimi
            $kdv_tutari_orj = ($satir_toplam_orj * $kdv_orani) / 100; // Orijinal para birimi

            $satir_toplam_fatura_pb = $satir_toplam_orj * $kur; // Fatura para birimi
            $kdv_tutari_fatura_pb = $kdv_tutari_orj * $kur; // Fatura para birimi

            $yeni_urun_detaylari[] = [
                'urun_id' => $urun_id,
                'miktar' => $miktar,
                'birim_fiyat' => $birim_fiyat, // Orijinal birim fiyat
                'kdv_orani' => $kdv_orani,
                'toplam_tutar' => $satir_toplam_fatura_pb, // Fatura para birimi cinsinden toplam tutar
                'kdv_tutari' => $kdv_tutari_fatura_pb, // Fatura para birimi cinsinden KDV tutarı
                'kur' => $kur,
                'alis_para_birimi' => $alis_para_birimi
            ];
            
            // Genel toplama çevrilmiş tutarları ekle
            $toplam_tutar += $satir_toplam_fatura_pb;
            $toplam_kdv += $kdv_tutari_fatura_pb;
        }
    }

    // Doğrulama
    if (empty($cari_id)) $hatalar[] = __("customer_required");
    if (empty($kategori_id)) $hatalar[] = __("category_required");
    if (empty($tarih)) $hatalar[] = __("invoice_date_required");
    if (empty($yeni_urun_detaylari)) $hatalar[] = __("at_least_one_product_required");

    if (empty($hatalar)) {
        try {
            $db->beginTransaction();

            // 1. Eski etkileri geri al
            // 1a. Eski stokları iade et
            foreach ($eski_fatura_detaylari as $detay) {
                stokGuncelle($db, $detay['urun_id'], ($fatura['tur'] == 'satis' ? $detay['miktar'] : -$detay['miktar']));
            }
            // 1b. Eski cari bakiyesini ters çevir
            $eski_toplam_fatura = $fatura['tutar'] + $fatura['toplam_kdv'] - $fatura['indirim_tutari'];
            $borc_degisim = ($fatura['tur'] == 'satis') ? -$eski_toplam_fatura : 0;
            $alacak_degisim = ($fatura['tur'] == 'alis') ? -$eski_toplam_fatura : 0;
                        cariBakiyeGuncelle($db, $fatura['cari_id'], $borc_degisim, $alacak_degisim);

            // 2. Fatura ana tablosunu (borclar) güncelle - para birimi de dahil
            $stmt_update = $db->prepare("UPDATE borclar SET cari_id=?, kategori_id=?, tutar=?, toplam_kdv=?, indirim_tutari=?, aciklama=?, tarih=?, vade_tarihi=?, para_birimi=? WHERE id=?");
            $stmt_update->execute([$cari_id, $kategori_id, $toplam_tutar, $toplam_kdv, $indirim_tutari, $aciklama, $tarih, $vade_tarihi, $yeni_fatura_para_birimi, $borc_id]);

            // 3. Eski fatura detaylarını sil
            $db->prepare("DELETE FROM fatura_detaylari WHERE borc_id = ?")->execute([$borc_id]);

            // 4. Yeni etkileri uygula
            // 4a. Yeni fatura detaylarını ekle ve yeni stokları düş
            $stmt_insert_detay = $db->prepare("INSERT INTO fatura_detaylari (borc_id, urun_id, miktar, birim_fiyat, kdv_orani, kdv_tutari, toplam_tutar, sirket_id, para_birimi, kur) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            foreach ($yeni_urun_detaylari as $detay) {
                $stmt_insert_detay->execute([
                    $borc_id, 
                    $detay['urun_id'], 
                    $detay['miktar'], 
                    $detay['birim_fiyat'], 
                    $detay['kdv_orani'], 
                    $detay['kdv_tutari'], 
                    $detay['toplam_tutar'], 
                    $aktif_sirket_id,
                    $yeni_fatura_para_birimi,
                    $detay['kur'] ?? 1.0
                ]);
                stokGuncelle($db, $detay['urun_id'], ($fatura['tur'] == 'satis' ? -$detay['miktar'] : $detay['miktar']), $detay['birim_fiyat']);
            }
            // 4b. Yeni cari bakiyesini uygula
            $yeni_toplam_fatura = $toplam_tutar + $toplam_kdv - $indirim_tutari;
            $borc_degisim = ($fatura['tur'] == 'satis') ? $yeni_toplam_fatura : 0;
            $alacak_degisim = ($fatura['tur'] == 'alis') ? $yeni_toplam_fatura : 0;
                        cariBakiyeGuncelle($db, $cari_id, $borc_degisim, $alacak_degisim);

            $db->commit();
                        sistem_log_ekle($db, 'update', 'borclar', $borc_id, json_encode($fatura), json_encode($_POST), "{$borc_id} ID'li fatura güncellendi.");
            $_SESSION['mesaj'] = __("invoice_updated");
            header("Location: borc_detay.php?id=" . $borc_id);
            exit();

        } catch (Exception $e) {
            $db->rollBack();
            error_log("Fatura güncelleme hatası: " . $e->getMessage());
            $hatalar[] = sprintf(__("update_error"), $e->getMessage());
        }
    }
    // Hata varsa, form yeniden gösterilecek ve $form_verileri kullanılacak
    $_SESSION['form_hatalari'] = $hatalar;

} else {
    // Sayfa ilk defa yükleniyorsa, form verilerini veritabanından gelen fatura bilgileriyle doldur
    $form_verileri = $fatura;
}

// Form için gerekli diğer verileri çek
$cariler = $db->query("SELECT id, ad_soyad FROM cariler WHERE sirket_id = {$aktif_sirket_id} ORDER BY ad_soyad")->fetchAll(PDO::FETCH_ASSOC);
$kategoriler = $db->query("SELECT id, kategori_adi FROM kategoriler WHERE sirket_id = {$aktif_sirket_id} ORDER BY kategori_adi")->fetchAll(PDO::FETCH_ASSOC);
// Ürün listesini çek
$urunler_listesi = $db->query("SELECT id, urun_adi, satis_fiyati as birim_fiyat, alis_fiyati, kdv_orani, barkod as stok_kodu, satis_para_birimi, alis_para_birimi FROM urunler WHERE sirket_id = {$aktif_sirket_id} ORDER BY urun_adi")->fetchAll(PDO::FETCH_ASSOC);
$urunler_json = json_encode($urunler_listesi);

// Para birimlerini çek (döviz kurları tablosundan)
$para_birimleri = $db->query("SELECT DISTINCT para_birimi FROM doviz_kurlari ORDER BY para_birimi ASC")->fetchAll(PDO::FETCH_COLUMN);
// Eğer TL yoksa ekle
if (!in_array('TL', $para_birimleri)) {
    array_unshift($para_birimleri, 'TL');
}
$para_birimleri_json = json_encode($para_birimleri);

$csrf_token = csrf_token_olustur();
$form_hatalari = $_SESSION['form_hatalari'] ?? [];
unset($_SESSION['form_hatalari']);


?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Odjoo Yönetim - <?= temizle($sayfa_baslik) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <style>
        .dl-horizontal dt { float: left; width: 160px; overflow: hidden; clear: left; text-align: right; text-overflow: ellipsis; white-space: nowrap; font-weight: bold; margin-bottom: 0.5rem;}
        .dl-horizontal dd { margin-left: 180px; margin-bottom: 0.5rem;}
        .badge-odendi { background-color: var(--bs-success); }
        .badge-kismen { background-color: var(--bs-warning); color: #000 !important; }
        .badge-odenmedi { background-color: var(--bs-danger); }
    </style>
</head>
<body>
    <?php include __DIR__ . '/../includes/navbar.php'; ?>

<div class="container mt-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h2><i class="bi bi-pencil-square me-2"></i><?= htmlspecialchars($sayfa_baslik) ?> (#<?= $borc_id ?>)</h2>
        <a href="borc_detay.php?id=<?= $borc_id ?>" class="btn btn-secondary"><i class="bi bi-arrow-left"></i> <?= __("back_to_invoice") ?></a>
    </div>

    <?php if (!empty($form_hatalari)): ?>
        <div class="alert alert-danger">
            <strong>Lütfen hataları düzeltin:</strong>
            <ul><?php foreach ($form_hatalari as $hata): ?><li><?= htmlspecialchars($hata) ?></li><?php endforeach; ?></ul>
        </div>
    <?php endif; ?>

    <form method="POST" id="faturaForm">
        <input type="hidden" name="csrf_token" value="<?= $csrf_token ?>">
        <input type="hidden" id="coklu_para_birimi_aktif" value="<?= $coklu_para_birimi_aktif ? '1' : '0' ?>">

        <!-- 1. Temel Bilgiler -->
        <div class="card shadow-sm mb-4">
            <div class="card-header"><h5 class="mb-0"><?= __("invoice_details") ?></h5></div>
            <div class="card-body">
                <div class="row g-3">
                    <div class="col-md-6">
                        <label for="cari_id" class="form-label"><?= __("customer") ?> <span class="text-danger">*</span></label>
                        <select class="form-select" id="cari_id" name="cari_id" required>
                            <?php foreach ($cariler as $cari): ?>
                                <option value="<?= $cari['id'] ?>" <?= ($form_verileri['cari_id'] ?? '') == $cari['id'] ? 'selected' : '' ?>><?= htmlspecialchars($cari['ad_soyad']) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label for="kategori_id" class="form-label"><?= __("category") ?> <span class="text-danger">*</span></label>
                        <select class="form-select" id="kategori_id" name="kategori_id" required>
                            <?php foreach ($kategoriler as $kategori): ?>
                                <option value="<?= $kategori['id'] ?>" <?= ($form_verileri['kategori_id'] ?? '') == $kategori['id'] ? 'selected' : '' ?>><?= htmlspecialchars($kategori['kategori_adi']) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label for="fatura_no" class="form-label"><?= __("invoice_number") ?></label>
                        <input type="text" class="form-control" id="fatura_no" name="fatura_no" value="<?= htmlspecialchars(isset($fatura['fatura_no']) && !empty($fatura['fatura_no']) ? $fatura['fatura_no'] : '#' . (isset($fatura['id']) ? str_pad($fatura['id'], 6, '0', STR_PAD_LEFT) : '')) ?>" readonly>
                    </div>
                    <div class="col-md-4">
                        <label for="tarih" class="form-label"><?= __("invoice_date") ?> <span class="text-danger">*</span></label>
                        <input type="date" class="form-control" id="tarih" name="tarih" value="<?= htmlspecialchars($form_verileri['tarih'] ?? date('Y-m-d')) ?>" required>
                    </div>
                    <div class="col-md-4">
                        <label for="vade_tarihi" class="form-label"><?= __("due_date") ?></label>
                        <input type="date" class="form-control" id="vade_tarihi" name="vade_tarihi" value="<?= htmlspecialchars($form_verileri['vade_tarihi'] ?? '') ?>">
                    </div>
                </div>
            </div>
        </div>

        <!-- 2. Ürün Detayları -->
        <div class="card shadow-sm mb-4">
            <div class="card-header bg-light d-flex justify-content-between align-items-center">
                <h5 class="mb-0"><i class="bi bi-box-seam me-2"></i><?= __("product_details") ?></h5>
                <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#urunSecModal"><i class="bi bi-plus-circle"></i> <?= __("add_product") ?></button>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered" id="fatura-tablosu">
                        <thead class="table-light">
                            <tr>
                                <th style="width: 5%;"><?= __("no") ?></th>
                                <th><?= __("product_service") ?></th>
                                <th style="width: 10%;"><?= __("quantity") ?></th>
                                <th style="width: 15%;"><?= __("unit_price") ?></th>
                                <?php if ($coklu_para_birimi_aktif): ?>
                                <th style="width: 10%;"><?= __("product_currency") ?></th>
                                <th style="width: 10%;"><?= __("exchange_rate") ?></th>
                                <?php endif; ?>
                                <th style="width: 10%;"><?= __("vat_rate") ?></th>
                                <th style="width: 15%;"><?= __("vat_amount") ?></th>
                                <th style="width: 15%;"><?= __("total") ?></th>
                                <th style="width: 5%;"><?= __("delete") ?></th>
                            </tr>
                        </thead>
                        <tbody id="urunListesi">
                            <!-- Satırlar JS ile buraya eklenecek -->
                        </tbody>
                    </table>
                </div>
                <div class="row mt-2">
                    <div class="col-12 mb-2">
                        <div class="p-2 bg-white rounded">
                            <i class="bi bi-box-seam me-2"></i>
                            <strong id="toplamUrunAdedi">0 adet ürün eklendi</strong>
                        </div>
                    </div>
                </div>
                <div class="row justify-content-end">
                    <div class="col-md-5">
                        <div class="toplam-alan p-3 bg-light rounded">
                            <ul class="list-group">
                                <li class="list-group-item d-flex justify-content-between align-items-center">Ara Toplam: <span id="araToplam">0,00</span></li>
                                <li class="list-group-item d-flex justify-content-between align-items-center">Toplam KDV: <span id="toplamKdv">0,00</span></li>
                                <li class="list-group-item d-flex justify-content-between align-items-center">İndirim (<?= $paraBirimi ?>): <input type="text" class="form-control form-control-sm text-end" id="indirim_tutari" name="indirim_tutari" value="<?= number_format((float)str_replace(',', '.', $form_verileri['indirim_tutari'] ?? '0'), 2, ',', '.') ?>" style="width: 100px;"></li>
                                <li class="list-group-item d-flex justify-content-between align-items-center bg-white"><strong>Genel Toplam:</strong> <strong id="toplamTutar">0,00</strong></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- 3. Açıklama ve Kaydet -->
        <div class="card shadow-sm mb-4">
            <div class="card-body">
                <div class="mb-3">
                    <label for="aciklama" class="form-label"><?= __("description") ?></label>
                    <textarea class="form-control" id="aciklama" name="aciklama" rows="3"><?= htmlspecialchars($form_verileri['aciklama'] ?? '') ?></textarea>
                </div>
                <div class="d-flex justify-content-end">
                    <button type="submit" class="btn btn-primary btn-lg"><i class="bi bi-save me-2"></i><?= __("update_invoice") ?></button>
                </div>
            </div>
        </div>
    </form>
</div>

<!-- Ürün Seçme Modalı -->
<div class="modal fade" id="urunSecModal" tabindex="-1" aria-labelledby="urunSecModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="urunSecModalLabel"><?= __("select_product") ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <input type="text" id="urunAramaInput" class="form-control mb-3" placeholder="<?= __("search_product_placeholder") ?>">
                <div class="table-responsive" style="max-height: 400px; overflow-y: auto;">
                    <table class="table table-hover">
                        <thead><tr><th><?= __("product_name") ?></th><th><?= __("stock_code") ?></th><th><?= __("price") ?></th><th><?= __("select") ?></th></tr></thead>
                        <tbody id="modalUrunListesi">
                            <!-- Ürünler JS ile yüklenecek -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include __DIR__ . "/../includes/footer.php"; ?>
	
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
    
<script src="js/fatura.js"></script>
<script src="js/doviz.js"></script>
<script>
const urunler = JSON.parse('<?= $urunler_json ?>');
const paraBirimleri = JSON.parse('<?= $para_birimleri_json ?>');
const paraBirimi = '<?= getParaBirimiSembolu($fatura_para_birimi) ?>';
const mevcutUrunler = JSON.parse('<?= $fatura_detaylari_json ?>');
const cokluParaBirimiAktif = <?= $coklu_para_birimi_aktif ? 'true' : 'false' ?>;

document.addEventListener('DOMContentLoaded', function() {
    const urunListesiTbody = document.getElementById('urunListesi');
    const modalUrunListesiTbody = document.getElementById('modalUrunListesi');
    const urunAramaInput = document.getElementById('urunAramaInput');

    // Helper Functions
    const formatCurrency = (value) => {
        return new Intl.NumberFormat('tr-TR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }).format(value);
    };
    const parseFloatOrZero = (value) => {
        if (typeof value !== 'string') {
            const parsed = parseFloat(value);
            return isNaN(parsed) ? 0 : parsed;
        }
        const cleanedValue = value.replace(/\.(?=\d{3})/g, '').replace(',', '.');
        const parsed = parseFloat(cleanedValue);
        return isNaN(parsed) ? 0 : parsed;
    };

    // Satır numaralarını güncelle
    const satirNumaralariniGuncelle = () => {
        document.querySelectorAll('#urunListesi tr').forEach((row, index) => {
            const noHucresi = row.querySelector('td:first-child');
            if (noHucresi) {
                noHucresi.textContent = index + 1;
            }
        });
        
        // Toplam ürün sayısını güncelle
        const toplamUrun = document.querySelectorAll('#urunListesi tr').length;
        document.getElementById('toplamUrunAdedi').textContent = `${toplamUrun} adet ürün eklendi`;
    };

    // Hesaplama ve Arayüz Güncelleme
    window.hesaplaVeGuncelle = () => {
        let araToplam = 0;
        let toplamKdv = 0;
        
        document.querySelectorAll('#urunListesi tr').forEach(row => {
            const miktar = parseFloatOrZero(row.querySelector('input[name^="miktar"]').value);
            const birimFiyat = parseFloatOrZero(row.querySelector('input[name^="birim_fiyat"]').value);
            const kdvOrani = parseFloatOrZero(row.querySelector('input[name^="kdv_orani"]').value);
            const kur = cokluParaBirimiAktif ? parseFloatOrZero(row.querySelector('input[name^="kur"]')?.value || '1') : 1;
            
            // Orijinal para birimindeki hesaplama
            const satirToplam_orj = miktar * birimFiyat;
            const kdvTutari_orj = (satirToplam_orj * kdvOrani) / 100;
            
            // Fatura para birimine çevrilmiş hesaplama
            const satirToplam_fatura = satirToplam_orj * kur;
            const kdvTutari_fatura = kdvTutari_orj * kur;
            
            row.querySelector('.kdv-tutari').textContent = formatCurrency(kdvTutari_fatura);
            row.querySelector('.satir-toplam').textContent = formatCurrency(satirToplam_fatura);
            
            araToplam += satirToplam_fatura;
            toplamKdv += kdvTutari_fatura;
        });

        const indirim = parseFloatOrZero(document.getElementById('indirim_tutari').value);
        const genelToplam = araToplam + toplamKdv - indirim;

        document.getElementById('araToplam').textContent = formatCurrency(araToplam) + ' ' + paraBirimi;
        document.getElementById('toplamKdv').textContent = formatCurrency(toplamKdv) + ' ' + paraBirimi;
        document.getElementById('toplamTutar').textContent = formatCurrency(genelToplam) + ' ' + paraBirimi;
        
        // Satır numaralarını güncelle
        satirNumaralariniGuncelle();
    };

    // Yeni Ürün Satırı Ekleme
    window.urunEkle = (urun) => {
        const tr = document.createElement('tr');
        const islemTuru = '<?= $fatura['tur'] ?>'; // 'satis' veya 'alis'
        const urunParaBirimi = islemTuru === 'satis' ? (urun.satis_para_birimi || 'TL') : (urun.alis_para_birimi || 'TL');
        const birimFiyat = islemTuru === 'satis' ? (urun.birim_fiyat || 0) : (urun.alis_fiyati || 0);
        
        let satirHTML = `
            <td class="text-center">0</td>
            <td>
                <input type="hidden" name="urun_id[]" value="${urun.id}">
                ${urun.urun_adi}
            </td>
            <td><input type="text" class="form-control form-control-sm text-end" name="miktar[]" value="1,00" oninput="hesaplaVeGuncelle()"></td>
            <td><input type="text" class="form-control form-control-sm text-end" name="birim_fiyat[]" value="${birimFiyat.toString().replace('.', ',')}" oninput="hesaplaVeGuncelle()"></td>
        `;
        
        if (cokluParaBirimiAktif) {
            satirHTML += `
                <td>
                    <select class="form-select form-select-sm" name="${islemTuru}_para_birimi[]" onchange="kurGuncelle(this); hesaplaVeGuncelle();">
                        ${paraBirimleri.map(pb => `<option value="${pb}" ${urunParaBirimi === pb ? 'selected' : ''}>${pb}</option>`).join('')}
                    </select>
                </td>
                <td><input type="text" class="form-control form-control-sm text-end" name="kur[]" value="1,0000" oninput="hesaplaVeGuncelle()"></td>
            `;
        }
        
        satirHTML += `
            <td><input type="text" class="form-control form-control-sm text-end" name="kdv_orani[]" value="${(urun.kdv_orani || 0).toString().replace('.', ',')}" oninput="hesaplaVeGuncelle()"></td>
            <td class="text-end kdv-tutari">0,00</td>
            <td class="text-end satir-toplam">0,00</td>
            <td><button type="button" class="btn btn-danger btn-sm" onclick="this.closest('tr').remove(); hesaplaVeGuncelle();"><i class="bi bi-trash"></i></button></td>
        `;
        
        tr.innerHTML = satirHTML;
        urunListesiTbody.appendChild(tr);
        
        // Satır numaralarını güncelle
        satirNumaralariniGuncelle();
        
        // Kur güncelle
        if (cokluParaBirimiAktif) {
            kurGuncelle(tr.querySelector('select[name$="_para_birimi[]"]'));
        }
        
        hesaplaVeGuncelle();
    };

    // Mevcut Ürünleri Yükle
    mevcutUrunler.forEach(detay => {
        const urun = urunler.find(u => u.id == detay.urun_id) || { id: detay.urun_id, urun_adi: '<?= __("unknown_product") ?>' };
        const tr = document.createElement('tr');
        const islemTuru = '<?= $fatura['tur'] ?>'; // 'satis' veya 'alis'
        const urunParaBirimi = islemTuru === 'satis' ? (detay.satis_para_birimi || 'TL') : (detay.alis_para_birimi || 'TL');
        
        let satirHTML = `
            <td class="text-center">0</td>
            <td>
                <input type="hidden" name="urun_id[]" value="${detay.urun_id}">
                ${urun.urun_adi}
            </td>
            <td><input type="text" class="form-control form-control-sm text-end" name="miktar[]" value="${parseFloat(detay.miktar).toFixed(2).replace('.', ',')}" oninput="hesaplaVeGuncelle()"></td>
            <td><input type="text" class="form-control form-control-sm text-end" name="birim_fiyat[]" value="${parseFloat(detay.birim_fiyat).toFixed(2).replace('.', ',')}" oninput="hesaplaVeGuncelle()"></td>
        `;
        
        if (cokluParaBirimiAktif) {
            satirHTML += `
                <td>
                    <select class="form-select form-select-sm" name="${islemTuru}_para_birimi[]" onchange="kurGuncelle(this); hesaplaVeGuncelle();">
                        ${paraBirimleri.map(pb => `<option value="${pb}" ${urunParaBirimi === pb ? 'selected' : ''}>${pb}</option>`).join('')}
                    </select>
                </td>
                <td><input type="text" class="form-control form-control-sm text-end" name="kur[]" value="${parseFloat(detay.kur || 1).toFixed(4).replace('.', ',')}" oninput="hesaplaVeGuncelle()"></td>
            `;
        }
        
        satirHTML += `
            <td><input type="text" class="form-control form-control-sm text-end" name="kdv_orani[]" value="${parseFloat(detay.kdv_orani).toFixed(2).replace('.', ',')}" oninput="hesaplaVeGuncelle()"></td>
            <td class="text-end kdv-tutari">0,00</td>
            <td class="text-end satir-toplam">0,00</td>
            <td><button type="button" class="btn btn-danger btn-sm" onclick="this.closest('tr').remove(); hesaplaVeGuncelle();"><i class="bi bi-trash"></i></button></td>
        `;
        
        tr.innerHTML = satirHTML;
        urunListesiTbody.appendChild(tr);
    });

    // Modal Ürün Listesini Doldurma ve Filtreleme
    const renderModalUrunler = (filter = '') => {
        modalUrunListesiTbody.innerHTML = '';
        const filteredUrunler = urunler.filter(u => 
            u.urun_adi.toLowerCase().includes(filter.toLowerCase()) || 
            (u.stok_kodu && u.stok_kodu.toLowerCase().includes(filter.toLowerCase()))
        );
        filteredUrunler.forEach(urun => {
            const tr = document.createElement('tr');
            tr.innerHTML = `
                <td>${urun.urun_adi}</td>
                <td>${urun.stok_kodu || '-'}</td>
                <td>${formatCurrency(urun.birim_fiyat)}</td>
                <td><button type="button" class="btn btn-success btn-sm" data-bs-dismiss="modal" onclick='urunEkle(${JSON.stringify(urun)})'>Ekle</button></td>
            `;
            modalUrunListesiTbody.appendChild(tr);
        });
    };

    urunAramaInput.addEventListener('input', () => renderModalUrunler(urunAramaInput.value));

    // Initial Load
    renderModalUrunler();
    hesaplaVeGuncelle();
    document.getElementById('indirim_tutari').addEventListener('input', hesaplaVeGuncelle);
});

// Fatura para birimi değiştiğinde çalışacak fonksiyon
window.handleFaturaParaBirimiChange = function() {
    // Tüm kur değerlerini güncelle
    document.querySelectorAll('#urunListesi select[name$="_para_birimi[]"]').forEach(select => {
        kurGuncelle(select);
    });
    hesaplaVeGuncelle();
};

// Kur güncelleme fonksiyonu
window.kurGuncelle = function(selectElement) {
    if (!cokluParaBirimiAktif) return;
    
    const row = selectElement.closest('tr');
    const kurInput = row.querySelector('input[name^="kur"]');
    const urunParaBirimi = selectElement.value;
    const faturaParaBirimi = document.getElementById('fatura_para_birimi')?.value || 'TL';
    
    if (urunParaBirimi === faturaParaBirimi) {
        kurInput.value = '1,0000';
    } else {
        // API'den kur bilgisini al
        getExchangeRate(urunParaBirimi, faturaParaBirimi).then(rate => {
            if (rate) {
                kurInput.value = parseFloat(rate).toFixed(4).replace('.', ',');
                hesaplaVeGuncelle();
            }
        });
    }
};
</script>

