<?php
require_once __DIR__ . '/../includes/config.php';
yetkili_mi();

$sayfa_baslik = "Cari Detay";

// Çoklu para birimi durumunu kontrol et
$aktif_sirket_id = $_SESSION['aktif_sirket_id'] ?? 0;
$stmt_coklu_pb = $db->prepare("SELECT coklu_para_birimi, para_birimi FROM sirketler WHERE id = ?");
$stmt_coklu_pb->execute([$aktif_sirket_id]);
$coklu_para_birimi_aktif = (bool) ($stmt_coklu_pb->fetchColumn() ?? 0);
$sirket_para_birimi = $stmt_coklu_pb->fetch(PDO::FETCH_ASSOC)['para_birimi'] ?? 'TL';

if (!isset($_GET['id']) || !($cari_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT))) {
    $_SESSION['hata'] = "Geçersiz Cari ID.";
    header("Location: cariler.php");
    exit();
}

// Cari bilgilerini ve bakiye bilgilerini getir
try {


    $stmt = $db->prepare("
        SELECT c.*, g.grup_adi
        FROM cariler c
        LEFT JOIN cari_gruplari g ON c.grup_id = g.id AND g.sirket_id = c.sirket_id
        WHERE c.id = ? AND c.sirket_id = ?
    ");
    $stmt->execute([$cari_id, $aktif_sirket_id]);
    $cari = $stmt->fetch();

    if (!$cari) {
        $_SESSION['hata'] = "Cari bulunamadı.";
        header("Location: cariler.php");
        exit();
    }

    // Cari Hesap Hareketleri (Satışlar, Alışlar, Ödemeler, Tahsilatlar)
    // Bu sorgu cari ekstresi için daha detaylı olmalı, şimdilik satış/alışları ve hesap hareketlerini ayrı alalım

    // Satışları (Müşteriye yapılan)
    $satislar_stmt = $db->prepare("
        SELECT b.*, k.kategori_adi, (b.tutar + b.toplam_kdv - b.indirim_tutari) AS toplam_kdv_dahil_tutar, b.para_birimi
        FROM borclar b
        LEFT JOIN kategoriler k ON b.kategori_id = k.id AND k.sirket_id = b.sirket_id
        WHERE b.cari_id = ? AND b.tur = 'satis' AND b.sirket_id = ?
        ORDER BY b.tarih DESC, b.id DESC
    ");
    $satislar_stmt->execute([$cari_id, $aktif_sirket_id]);
    $satislar = $satislar_stmt->fetchAll();

    // Alışları (Tedarikçiden yapılan)
    $alislar_stmt = $db->prepare("
        SELECT b.*, k.kategori_adi, (b.tutar + b.toplam_kdv - b.indirim_tutari) AS toplam_kdv_dahil_tutar, b.para_birimi
        FROM borclar b
        LEFT JOIN kategoriler k ON b.kategori_id = k.id AND k.sirket_id = b.sirket_id
        WHERE b.cari_id = ? AND b.tur = 'alis' AND b.sirket_id = ?
        ORDER BY b.tarih DESC, b.id DESC
    ");
    $alislar_stmt->execute([$cari_id, $aktif_sirket_id]);
    $alislar = $alislar_stmt->fetchAll();

    // Hesap Hareketleri (Ödemeler/Tahsilatlar)
    $hareketler = [];
    try {
        $sql = "
            SELECT hh.*, h.hesap_adi
            FROM hesap_hareketleri hh
            LEFT JOIN hesaplar h ON hh.hesap_id = h.id AND h.sirket_id = hh.sirket_id
            WHERE hh.cari_id = ? AND hh.tur != 'transfer' AND hh.sirket_id = ?
            ORDER BY hh.tarih DESC, hh.id DESC
        ";
        $hareketler_stmt = $db->prepare($sql);
        $hareketler_stmt->execute([$cari_id, $aktif_sirket_id]);
        $hareketler = $hareketler_stmt->fetchAll();
        
        // Hata ayıklama için
        if (count($hareketler) > 0) {
            error_log("İlk hareket örneği: " . print_r($hareketler[0], true));
        }
    } catch (PDOException $e) {
        error_log("Hesap hareketleri çekilirken hata: " . $e->getMessage());
        $_SESSION['hata'] = "Hesap hareketleri yüklenirken bir hata oluştu.";
    }

    // Bakiye Hesaplama (güvenlik için tekrar hesapla)
    $hesaplanan_bakiye = ($cari['toplam_alacak'] ?? 0.0) - ($cari['toplam_borc'] ?? 0.0);


} catch (PDOException $e) {
    error_log("Cari detay hatası (ID: {$cari_id}): " . $e->getMessage());
    $_SESSION['hata'] = "Cari detayları alınırken bir veritabanı hatası oluştu.";
     // Hata durumunda boş diziler
     $cari = $cari ?? null; // Cari null olabilir
     $satislar = [];
     $alislar = [];
     $hareketler = [];
     $hesaplanan_bakiye = 0.0;
}

$csrf_token = csrf_token_olustur(); // Silme işlemleri için

?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Odjoo Yönetim - <?= $sayfa_baslik ?> - <?= $cari ? temizle($cari['ad_soyad']) : '' ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        /* Tema uyumu: arkaplan beyaz kalsın */
        body { background-color: #ffffff; }
        .detail-card { border-radius: .75rem; }
        .badge { vertical-align: middle; }
        .bakiye-pozitif { color: #198754; font-weight: bold; }
        .bakiye-negatif { color: #dc3545; font-weight: bold; }
        .table th { background-color: #f8f9fa; }
        /* Tema uyumu: kartlar düz beyaz */
        .hero-card { background: #ffffff; border: 1px solid #e9eef7; }
        .avatar { width: 48px; height: 48px; border-radius: 50%; background: #0d6efd; color: #fff; display: inline-flex; align-items: center; justify-content: center; font-weight: 700; }
        .chip { border: 1px solid #e9ecef; background: #fff; }
        .stat-card { border: 1px solid #e9eef7; }
        .stat-value { font-weight: 700; font-size: 1.1rem; }
        .nav-tabs .nav-link { font-weight: 600; }
        /* Sekmeler için daha modern görünüm (tema beyaz kalır) */
        .tabs-wrap { background: #fff; border: 1px solid #e9eef7; border-radius: .5rem; padding: .25rem; }
        /* Sekme butonları: köşeler kare, beyaz zemin, ince kenarlık */
        .nav-pills .nav-link { border-radius: 0; color: #495057; background: #ffffff; border: 1px solid #e9eef7; }
        .nav-pills .nav-link + .nav-link { margin-left: -1px; } /* birleşik görünüm */
        .nav-pills .nav-link:hover { background: #f8f9fa; }
        .nav-pills .nav-link.active { color: #0d6efd; background: #e7f1ff; border-color: #0d6efd; box-shadow: none; }
        .nav-pills .nav-link .badge { background: #f1f3f5; }
        .empty-state { background: #fff; border: 1px dashed #dee2e6; border-radius: .5rem; padding: 1rem; color: #6c757d; }
    </style>
</head>
<body>
    <?php include __DIR__ . '/../includes/navbar.php'; ?>

    <div class="container mt-4">
        <?php if ($cari): // Cari bulunduysa göster ?>
        <?php
            // Kısa istatistikler için toplamları hesapla
            $total_satis_tutar = 0.0; foreach (($satislar ?? []) as $s) { $total_satis_tutar += (float)($s['toplam_kdv_dahil_tutar'] ?? 0); }
            $total_alis_tutar  = 0.0; foreach (($alislar  ?? []) as $a) { $total_alis_tutar  += (float)($a['toplam_kdv_dahil_tutar'] ?? 0); }
            $islem_sayisi = count($hareketler ?? []);
            $ilk_harf = mb_strtoupper(mb_substr($cari['ad_soyad'] ?? '?', 0, 1));
        ?>
        <div class="card hero-card detail-card shadow-sm mb-3">
            <div class="card-body d-flex align-items-center justify-content-between flex-wrap gap-3">
                <div class="d-flex align-items-center gap-3">
                    <div class="avatar shadow-sm">
                        <?= $ilk_harf ?>
                    </div>
                    <div>
                        <h4 class="mb-1 fw-bold">
                            <i class="bi bi-person-badge me-2 text-primary"></i><?= temizle($cari['ad_soyad']) ?>
                        </h4>
                        <div class="text-muted small d-flex flex-wrap gap-3">
                            <span><i class="bi bi-telephone me-1"></i><?= $cari['telefon'] ? temizle($cari['telefon']) : '-' ?></span>
                            <span><i class="bi bi-geo-alt me-1"></i><?= $cari['adres'] ? temizle($cari['adres']) : '-' ?></span>
                        </div>
                    </div>
                </div>
                <div class="d-flex align-items-center gap-2">
                    <span class="badge bg-secondary text-dark chip">
                        <i class="bi bi-collection me-1"></i><?= $cari['grup_adi'] ? temizle($cari['grup_adi']) : 'Grupsuz' ?>
                    </span>
                    <span class="badge chip <?= $hesaplanan_bakiye >= 0 ? 'text-success' : 'text-danger' ?>">
                        <i class="bi <?= $hesaplanan_bakiye >= 0 ? 'bi-graph-up-arrow' : 'bi-graph-down-arrow' ?> me-1"></i>
                        Bakiye: <?= number_format($hesaplanan_bakiye, 2, ',', '.') . ' ' . ($coklu_para_birimi_aktif ? 'Dinamik' : $sirket_para_birimi) ?>
                    </span>
                </div>
            </div>
        </div>

        <div class="d-flex justify-content-between align-items-center mb-3 flex-wrap gap-2">
            <a href="cariler.php" class="btn btn-sm btn-outline-secondary">
                <i class="bi bi-arrow-left"></i> Cari Listesine Dön
            </a>
            <div class="d-flex gap-2">
                <div class="card stat-card p-2 px-3">
                    <div class="small text-muted">Toplam Satış</div>
                    <div class="stat-value text-danger">
                        <?= number_format($total_satis_tutar, 2, ',', '.') . ' ' . ($coklu_para_birimi_aktif ? 'Dinamik' : $sirket_para_birimi) ?>
                    </div>
                </div>
                <div class="card stat-card p-2 px-3">
                    <div class="small text-muted">Toplam Alış</div>
                    <div class="stat-value text-success">
                        <?= number_format($total_alis_tutar, 2, ',', '.') . ' ' . ($coklu_para_birimi_aktif ? 'Dinamik' : $sirket_para_birimi) ?>
                    </div>
                </div>
                <div class="card stat-card p-2 px-3">
                    <div class="small text-muted">İşlem Sayısı</div>
                    <div class="stat-value">
                        <?= (int)$islem_sayisi ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="row g-4">
            <div class="col-lg-4">
                 <div class="card detail-card shadow-sm mb-4">
                    <div class="card-body">
                        <h5 class="card-title text-primary mb-3"><i class="bi bi-info-circle me-2"></i>Cari Bilgileri</h5>
                        <p class="mb-2">
                            <strong><i class="bi bi-telephone text-muted me-2"></i> Telefon:</strong>
                            <span class="text-muted"><?= $cari['telefon'] ? temizle($cari['telefon']) : '-' ?></span>
                        </p>
                        <p class="mb-1"><strong><i class="bi bi-geo-alt text-muted me-2"></i> Adres:</strong>
                        <i><?= $cari['adres'] ? nl2br(temizle($cari['adres'])) : '-' ?></i></p>
                        <a href="cari_duzenle.php?id=<?= $cari['id'] ?>" class="btn btn-outline-warning w-100">
                            <i class="bi bi-pencil me-1"></i> Bilgileri Düzenle
                        </a>
                    </div>
                </div>
                 <div class="card detail-card shadow-sm">
                    <div class="card-body">
                         <h5 class="card-title text-success mb-3"><i class="bi bi-lightning-charge me-2"></i>Hızlı İşlemler</h5>
                        <div class="d-grid gap-2">
                            <a href="satis_yeni.php?cari_id=<?= $cari['id'] ?>" class="btn btn-primary">
                                <i class="bi bi-cart-plus me-1"></i> Yeni Satış
                            </a>
                             <a href="alis_yeni.php?cari_id=<?= $cari['id'] ?>" class="btn btn-info text-white"> <?php // Renk değiştirildi ?>
                                <i class="bi bi-bag-plus me-1"></i> Yeni Alış
                            </a>
                             <a href="cari_alacaklandir.php?cari_id=<?= $cari['id'] ?>" class="btn btn-success">
                                <i class="bi bi-arrow-up-circle me-1"></i> Cariyi Alacaklandır
                            </a>
                             <a href="cari_borclandir.php?cari_id=<?= $cari['id'] ?>" class="btn btn-danger">
                                <i class="bi bi-arrow-down-circle me-1"></i> Cariyi Borçlandır
                            </a>
                             <a href="odeme_al.php?cari_id=<?= $cari['id'] ?>" class="btn btn-success">
                                <i class="bi bi-arrow-down-circle me-1"></i> Ödeme Al
                            </a>
                             <a href="odeme_yap.php?cari_id=<?= $cari['id'] ?>" class="btn btn-danger">
                                <i class="bi bi-arrow-up-circle me-1"></i> Ödeme Yap
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-8">
                 <div class="card detail-card shadow-sm">
                     <div class="card-header">
                         <h5 class="mb-0"><i class="bi bi-list-ul me-2"></i>İşlem Geçmişi</h5>
                     </div>
                    <div class="card-body p-0">
                        <div class="tabs-wrap mb-0">
                            <ul class="nav nav-pills nav-fill" id="myTab" role="tablist">
                              <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="satislar-tab" data-bs-toggle="tab" data-bs-target="#satislar" type="button" role="tab" aria-controls="satislar" aria-selected="true">
                                    <i class="bi bi-bag-check me-1"></i> Satışlar
                                    <span class="badge rounded-pill ms-2 bg-danger-subtle text-danger border border-danger-subtle"><?= count($satislar) ?></span>
                                </button>
                              </li>
                              <li class="nav-item" role="presentation">
                                <button class="nav-link" id="alislar-tab" data-bs-toggle="tab" data-bs-target="#alislar" type="button" role="tab" aria-controls="alislar" aria-selected="false">
                                    <i class="bi bi-bag-plus me-1"></i> Alışlar
                                    <span class="badge rounded-pill ms-2 bg-success-subtle text-success border border-success-subtle"><?= count($alislar) ?></span>
                                </button>
                              </li>
                              <li class="nav-item" role="presentation">
                                <button class="nav-link" id="odemeler-tab" data-bs-toggle="tab" data-bs-target="#odemeler" type="button" role="tab" aria-controls="odemeler" aria-selected="false">
                                    <i class="bi bi-cash-coin me-1"></i> Ödemeler / Tahsilatlar
                                    <span class="badge rounded-pill ms-2 bg-secondary-subtle text-secondary border border-secondary-subtle"><?= count($hareketler) ?></span>
                                </button>
                              </li>
                            </ul>
                        </div>
                        <div class="tab-content p-3" id="myTabContent">
                          <div class="tab-pane fade show active" id="satislar" role="tabpanel" aria-labelledby="satislar-tab">
                              <h6 class="text-danger mb-3">Müşterinin Borçları (Yapılan Satışlar)</h6>
                              <?php if (empty($satislar)): ?>
                                  <div class="empty-state"><i class="bi bi-inboxes me-2"></i> Bu cariye ait satış kaydı bulunmamaktadır.</div>
                              <?php else: ?>
                                <div class="table-responsive">
                                    <table class="table table-sm table-striped align-middle">
                                        <thead>
                                            <tr>
                                                <th>Tarih</th>
                                                <th>Açıklama</th>
                                                <th>Kategori</th>
                                                <th class="text-end">Tutar (<?= $coklu_para_birimi_aktif ? 'Dinamik' : $sirket_para_birimi ?>)</th>
                                                <th>Vade</th>
                                                <th>İşlem</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach($satislar as $satis): ?>
                                            <tr>
                                                <td><?= date('d.m.Y', strtotime($satis['tarih'])) ?></td>
                                                <td><?= temizle($satis['aciklama']) ?></td>
                                                <td><?= temizle($satis['kategori_adi']) ?></td>
                                                <td class="text-end text-danger"><?= number_format($satis['toplam_kdv_dahil_tutar'], 2, ',', '.') . ' ' . ($coklu_para_birimi_aktif ? ($satis['para_birimi'] ?? 'TRY') : getParaBirimiSembolu()) ?></td>
                                                <td><?= $satis['vade_tarihi'] ? date('d.m.Y', strtotime($satis['vade_tarihi'])) : '-' ?></td>
                                                 <td>
                                                     <a href="borc_detay.php?id=<?= $satis['id'] ?>" class="btn btn-sm btn-outline-info" title="Detay"><i class="bi bi-eye"></i></a>
                                                     <a href="borc_duzenle.php?id=<?= $satis['id'] ?>" class="btn btn-sm btn-outline-warning" title="Düzenle"><i class="bi bi-pencil"></i></a>
                                                     <a href="borc_sil.php?id=<?= $satis['id'] ?>&csrf_token=<?= $csrf_token ?>"
                                                        class="btn btn-sm btn-outline-danger" title="Sil"
                                                        onclick="return confirm('Bu işlemi silmek istediğinize emin misiniz? Bu işlem geri alınamaz ve ilgili bakiye güncellemeleri tersine çevrilir.')">
                                                         <i class="bi bi-trash"></i>
                                                     </a>
                                                 </td>
                                            </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                              <?php endif; ?>
                          </div>
                          <div class="tab-pane fade" id="alislar" role="tabpanel" aria-labelledby="alislar-tab">
                              <h6 class="text-success mb-3">Tedarikçinin Alacakları (Yapılan Alışlar)</h6>
                               <?php if (empty($alislar)): ?>
                                  <div class="empty-state"><i class="bi bi-inboxes me-2"></i> Bu cariden alış kaydı bulunmamaktadır.</div>
                               <?php else: ?>
                                <div class="table-responsive">
                                    <table class="table table-sm table-striped align-middle">
                                        <thead>
                                            <tr>
                                                <th>Tarih</th>
                                                <th>Açıklama</th>
                                                <th>Kategori</th>
                                                <th class="text-end">Tutar (<?= $coklu_para_birimi_aktif ? 'Dinamik' : $sirket_para_birimi ?>)</th>
                                                <th>Vade</th>
                                                 <th>İşlem</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach($alislar as $alis): ?>
                                            <tr>
                                                <td><?= date('d.m.Y', strtotime($alis['tarih'])) ?></td>
                                                <td><?= temizle($alis['aciklama']) ?></td>
                                                <td><?= temizle($alis['kategori_adi']) ?></td>
                                                <td class="text-end text-success"><?= number_format($alis['toplam_kdv_dahil_tutar'], 2, ',', '.') . ' ' . ($coklu_para_birimi_aktif ? ($alis['para_birimi'] ?? 'TRY') : getParaBirimiSembolu()) ?></td>
                                                <td><?= $alis['vade_tarihi'] ? date('d.m.Y', strtotime($alis['vade_tarihi'])) : '-' ?></td>
                                                <td>
                                                    <a href="borc_detay.php?id=<?= $alis['id'] ?>" class="btn btn-sm btn-outline-info" title="Detay"><i class="bi bi-eye"></i></a>
                                                    <a href="borc_duzenle.php?id=<?= $alis['id'] ?>" class="btn btn-xs btn-outline-warning" title="Düzenle"><i class="bi bi-pencil"></i></a>
                                                     <a href="borc_sil.php?id=<?= $alis['id'] ?>&csrf_token=<?= $csrf_token ?>"
                                                        class="btn btn-xs btn-outline-danger" title="Sil"
                                                        onclick="return confirm('Bu işlemi silmek istediğinize emin misiniz? Bu işlem geri alınamaz ve ilgili bakiye güncellemeleri tersine çevrilir.')">
                                                         <i class="bi bi-trash"></i>
                                                     </a>
                                                </td>
                                            </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                              <?php endif; ?>
                          </div>
                           <div class="tab-pane fade" id="odemeler" role="tabpanel" aria-labelledby="odemeler-tab">
                                <h6 class="text-secondary mb-3">Yapılan Ödemeler ve Alınan Tahsilatlar</h6>
                                <?php if (empty($hareketler)): ?>
                                    <div class="empty-state"><i class="bi bi-inboxes me-2"></i> Bu cari ile ilgili ödeme veya tahsilat kaydı bulunmamaktadır.</div>
                                <?php else: ?>
                                <div class="table-responsive">
                                    <table class="table table-sm table-striped align-middle">
                                        <thead>
                                            <tr>
                                                <th>Tarih</th>
                                                <th>Tür</th>
                                                <th>Hesap</th>
                                                <th>Açıklama</th>
                                                <th class="text-end">Tutar (<?= $coklu_para_birimi_aktif ? 'Dinamik' : $sirket_para_birimi ?>)</th>
                                                <th>İşlem</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach($hareketler as $hareket): ?>
                                            <tr>
                                                <td><?= date('d.m.Y H:i', strtotime($hareket['tarih'])) ?></td>
                                                <td>
                                                    <?php if ($hareket['tur'] == 'giris'): ?>
                                                        <span class="badge bg-success">Tahsilat</span>
                                                    <?php elseif ($hareket['tur'] == 'cikis'): ?>
                                                         <span class="badge bg-danger">Ödeme</span>
                                                    <?php else: ?>
                                                         <span class="badge bg-secondary"><?= ucfirst($hareket['tur']) ?></span>
                                                    <?php endif; ?>
                                                </td>
                                                <td><?= temizle($hareket['hesap_adi']) ?></td>
                                                <td><?= temizle($hareket['aciklama']) ?></td>
                                                <td class="text-end <?= $hareket['tur'] == 'giris' ? 'text-success' : 'text-danger' ?>">
                                                    <?= number_format($hareket['tutar'], 2, ',', '.') . ' ' . ($coklu_para_birimi_aktif ? 'Dinamik' : $sirket_para_birimi) ?>
                                                </td>
                                                 <td>
                                                     <?php /* Hesap hareketi silme/düzenleme genellikle risklidir, dikkatli olunmalı */ ?>
                                                      <button type="button" 
                                                              class="btn btn-xs btn-outline-danger" 
                                                              title="Sil"
                                                              onclick="hesapHareketiSil(<?= $hareket['id'] ?>, '<?= $csrf_token ?>')">
                                                         <i class="bi bi-trash"></i>
                                                     </button>
                                                 </td>
                                            </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                               <?php endif; ?>
                           </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php else: // Cari bulunamadıysa ?>
             <div class="alert alert-danger">
                 <i class="bi bi-exclamation-triangle-fill me-2"></i> Belirtilen cari bulunamadı veya detayları alınırken bir hata oluştu.
                 <a href="cariler.php" class="alert-link ms-2">Cari Listesine Dön</a>
             </div>
        <?php endif; ?>
    </div>

    <script>
    function hesapHareketiSil(hareketId, csrfToken) {
        if (confirm('Bu hesap hareketini silmek istediğinize emin misiniz? Bu işlem ilgili hesap ve cari bakiyelerini GÜNCELLEMEZ, sadece kaydı siler ve tutarsızlığa yol açabilir! Emin misiniz?')) {
            // AJAX isteği ile silme
            fetch('hesap_hareketi_sil.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: 'hareket_id=' + hareketId + '&csrf_token=' + csrfToken
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert('Hesap hareketi başarıyla silindi!');
                    // Sayfayı yenile
                    location.reload();
                } else {
                    alert('Hata: ' + data.message);
                }
            })
            .catch(error => {
                console.error('Hata:', error);
                alert('Silme işlemi sırasında bir hata oluştu!');
            });
        }
    }
    </script>

	<?php include("../includes/footer.php"); ?>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
