<?php
require_once __DIR__ . '/../includes/config.php';
yetkili_mi();

if(!isset($_GET['id']) || !tamsayi($_GET['id'])) {
    header("Location: cariler.php");
    exit();
}

$cari_id = (int)$_GET['id'];
$aktif_sirket_id = $_SESSION['aktif_sirket_id'] ?? 0;

// Cari bilgilerini getir ve şirkete ait olduğunu doğrula
$stmt_cari = $db->prepare("
    SELECT c.*, g.grup_adi 
    FROM cariler c
    LEFT JOIN cari_gruplari g ON c.grup_id = g.id AND g.sirket_id = c.sirket_id
    WHERE c.id = ? AND c.sirket_id = ?
");
$stmt_cari->execute([$cari_id, $aktif_sirket_id]);
$cari = $stmt_cari->fetch();

if(!$cari) {
    $_SESSION['hata'] = __("customer_not_found");
    header("Location: cariler.php");
    exit();
}

// Form gönderildiğinde
if($_SERVER['REQUEST_METHOD'] == 'POST') {
    if(!csrf_token_dogrula($_POST['csrf_token'])) {
        die(__("invalid_csrf_token"));
    }
    
    $ad_soyad = temizle($_POST['ad_soyad']);
    $telefon = temizle($_POST['telefon']);
    $adres = temizle($_POST['adres']);
    $grup_id = (int)$_POST['grup_id'];
    
    try {
        $stmt = $db->prepare("
            UPDATE cariler SET
                ad_soyad = ?,
                telefon = ?,
                adres = ?,
                grup_id = ?
            WHERE id = ? AND sirket_id = ?
        ");
        $stmt->execute([$ad_soyad, $telefon, $adres, $grup_id, $cari_id, $aktif_sirket_id]);
        
        $_SESSION['mesaj'] = __("customer_updated");
        header("Location: cari_detay.php?id=" . $cari_id);
        exit();
    } catch(PDOException $e) {
        $_SESSION['hata'] = __("error_updating_customer");
    }
}

$stmt_gruplar = $db->prepare("SELECT * FROM cari_gruplari WHERE sirket_id = ?");
$stmt_gruplar->execute([$aktif_sirket_id]);
$cari_gruplari = $stmt_gruplar->fetchAll(PDO::FETCH_ASSOC);

$csrf_token = csrf_token_olustur();
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= __("edit_customer") ?> - <?= temizle($cari['ad_soyad']) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
</head>
    <?php include __DIR__ . '/../includes/navbar.php'; ?>
    <div class="container mt-4">
        <div class="card">
            <div class="card-header bg-primary text-white">
                <h5 class="card-title mb-0">
                    <i class="bi bi-pencil-square"></i> <?= __("edit_customer") ?>: <?= temizle($cari['ad_soyad']) ?>
                </h5>
            </div>
            <div class="card-body">
                <?php if(isset($_SESSION['hata'])): ?>
                    <div class="alert alert-danger"><?= $_SESSION['hata'] ?></div>
                    <?php unset($_SESSION['hata']); ?>
                <?php endif; ?>

                <form method="post">
                    <input type="hidden" name="csrf_token" value="<?= $csrf_token ?>">
                    
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="ad_soyad" class="form-label"><?= __("customer_name_label") ?></label>
                            <input type="text" class="form-control" id="ad_soyad" name="ad_soyad" 
                                   value="<?= temizle($cari['ad_soyad']) ?>" required>
                        </div>
                        <div class="col-md-6">
                            <label for="telefon" class="form-label"><?= __("phone_label") ?></label>
                            <input type="text" class="form-control" id="telefon" name="telefon" 
                                   value="<?= temizle($cari['telefon']) ?>">
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="adres" class="form-label"><?= __("address_label") ?></label>
                        <textarea class="form-control" id="adres" name="adres" rows="3"><?= temizle($cari['adres']) ?></textarea>
                    </div>
                    
                    <div class="mb-3">
                        <label for="grup_id" class="form-label"><?= __("customer_group_label") ?></label>
                        <select class="form-select" id="grup_id" name="grup_id" required>
                            <?php foreach($cari_gruplari as $grup): ?>
                                <option value="<?= $grup['id'] ?>" 
                                    <?= $grup['id'] == $cari['grup_id'] ? 'selected' : '' ?>>
                                    <?= temizle($grup['grup_adi']) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    
                    <div class="d-flex justify-content-between">
                        <a href="cari_detay.php?id=<?= $cari_id ?>" class="btn btn-secondary">
                            <i class="bi bi-arrow-left"></i> <?= __("back_to_customer") ?>
                        </a>
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-save"></i> <?= __("save_changes") ?>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
	<?php include __DIR__ . "/../includes/footer.php"; ?>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>