<?php
require_once __DIR__ . '/../includes/config.php';
yetkili_mi(['cari_yonetimi', 'cari_goruntuleme']);

// tFPDF kütüphanesini dahil et
require_once __DIR__ . '/tfpdf/tfpdf.php';

// --- Veritabanı İşlemleri Başlangıç ---

// Gelen parametreleri al
$cari_id = filter_input(INPUT_GET, 'cari_id', FILTER_VALIDATE_INT);
$filtre_baslangic = $_GET['baslangic'] ?? '';
$filtre_bitis = $_GET['bitis'] ?? '';

// Parametreleri doğrula
if (!$cari_id) {
    die("Geçersiz Cari ID.");
}

if (empty($filtre_baslangic) || !preg_match("/^\d{4}-\d{2}-\d{2}$/", $filtre_baslangic)) {
    $filtre_baslangic = date('Y-m-01');
}

if (empty($filtre_bitis) || !preg_match("/^\d{4}-\d{2}-\d{2}$/", $filtre_bitis)) {
    $filtre_bitis = date('Y-m-d');
}

// Değişkenleri başlat
$aktif_sirket_id = $_SESSION['aktif_sirket_id'] ?? 0;
$secili_cari = null;
$ekstre = [];
$baslangic_bakiye = 0.0;
$donem_ici_borc = 0.0;
$donem_ici_alacak = 0.0;
$sirket_bilgileri = null;

try {
    // Şirket Bilgileri
    $stmt_sirket = $db->prepare("SELECT * FROM sirketler WHERE id = ?");
    $stmt_sirket->execute([$aktif_sirket_id]);
    $sirket_bilgileri = $stmt_sirket->fetch(PDO::FETCH_ASSOC);

    // Cari bilgilerini al ve şirkete ait olduğunu doğrula
    $stmt_cari = $db->prepare("SELECT * FROM cariler WHERE id = ? AND sirket_id = ?");
    $stmt_cari->execute([$cari_id, $aktif_sirket_id]);
    $secili_cari = $stmt_cari->fetch();

    if (!$secili_cari) {
        die("Cari bulunamadı veya bu şirkete ait değil.");
    }

    // 1. Dönem Başı Bakiyeyi Hesapla
    // Dönem başından ÖNCEKİ tüm işlemlerin net etkisi
    $sql_devir_borc = "SELECT SUM(tutar) FROM borclar WHERE cari_id = :cari_id AND tur = 'satis' AND tarih < :baslangic AND sirket_id = :sirket_id";
    $stmt_devir_borc = $db->prepare($sql_devir_borc);
    $stmt_devir_borc->execute([':cari_id' => $cari_id, ':baslangic' => $filtre_baslangic, ':sirket_id' => $aktif_sirket_id]);
    $devir_borc = $stmt_devir_borc->fetchColumn() ?: 0.0;

    $sql_devir_alacak = "SELECT SUM(tutar) FROM borclar WHERE cari_id = :cari_id AND tur = 'alis' AND tarih < :baslangic AND sirket_id = :sirket_id";
    $stmt_devir_alacak = $db->prepare($sql_devir_alacak);
    $stmt_devir_alacak->execute([':cari_id' => $cari_id, ':baslangic' => $filtre_baslangic, ':sirket_id' => $aktif_sirket_id]);
    $devir_alacak = $stmt_devir_alacak->fetchColumn() ?: 0.0;

    $sql_devir_tahsilat = "SELECT SUM(tutar) FROM hesap_hareketleri WHERE cari_id = :cari_id AND tur = 'giris' AND DATE(tarih) < :baslangic AND sirket_id = :sirket_id";
    $stmt_devir_tahsilat = $db->prepare($sql_devir_tahsilat);
    $stmt_devir_tahsilat->execute([':cari_id' => $cari_id, ':baslangic' => $filtre_baslangic, ':sirket_id' => $aktif_sirket_id]);
    $devir_tahsilat = $stmt_devir_tahsilat->fetchColumn() ?: 0.0; // Müşteriden alınan para (müşteri borcunu azaltır)

    $sql_devir_odeme = "SELECT SUM(tutar) FROM hesap_hareketleri WHERE cari_id = :cari_id AND tur = 'cikis' AND DATE(tarih) < :baslangic AND sirket_id = :sirket_id";
    $stmt_devir_odeme = $db->prepare($sql_devir_odeme);
    $stmt_devir_odeme->execute([':cari_id' => $cari_id, ':baslangic' => $filtre_baslangic, ':sirket_id' => $aktif_sirket_id]);
    $devir_odeme = $stmt_devir_odeme->fetchColumn() ?: 0.0; // Tedarikçiye yapılan ödeme (bizim borcumuzu azaltır)

    // Başlangıç Bakiyesi = (devir_alacak - devir_odeme) - (devir_borc - devir_tahsilat)
    $baslangic_bakiye = ($devir_alacak - $devir_odeme) - ($devir_borc - $devir_tahsilat);

    // 2. Dönem İçi Hareketleri Çek ve Birleştir
    $params_donem = [
        ':cari_id' => $cari_id,
        ':baslangic' => $filtre_baslangic,
        ':bitis' => $filtre_bitis . ' 23:59:59', // Bitiş tarihinin sonunu al
        ':sirket_id' => $aktif_sirket_id
    ];

    // Satışlar (Müşteriye borç yazılır)
    $stmt_satis = $db->prepare("SELECT id, tarih, aciklama, tutar, 'Satış' as islem_turu FROM borclar WHERE cari_id = :cari_id AND tur = 'satis' AND sirket_id = :sirket_id AND tarih BETWEEN :baslangic AND :bitis ORDER BY tarih ASC, id ASC");
    $stmt_satis->execute($params_donem);
    $satislar = $stmt_satis->fetchAll();

    // Alışlar (Müşteriye alacak yazılır)
    $stmt_alis = $db->prepare("SELECT id, tarih, aciklama, tutar, 'Alış' as islem_turu FROM borclar WHERE cari_id = :cari_id AND tur = 'alis' AND sirket_id = :sirket_id AND tarih BETWEEN :baslangic AND :bitis ORDER BY tarih ASC, id ASC");
    $stmt_alis->execute($params_donem);
    $alislar = $stmt_alis->fetchAll();

    // Tahsilatlar (Müşteri borcunu azaltır, hesaba GİRİŞ)
    $stmt_tahsilat = $db->prepare("SELECT id, tarih, aciklama, tutar, 'Tahsilat' as islem_turu FROM hesap_hareketleri WHERE cari_id = :cari_id AND tur = 'giris' AND sirket_id = :sirket_id AND tarih BETWEEN :baslangic AND :bitis ORDER BY tarih ASC, id ASC");
    $stmt_tahsilat->execute($params_donem);
    $tahsilatlar = $stmt_tahsilat->fetchAll();

    // Ödemeler (Bizim borcumuzu azaltır, hesaptan ÇIKIŞ)
    $stmt_odeme = $db->prepare("SELECT id, tarih, aciklama, tutar, 'Ödeme' as islem_turu FROM hesap_hareketleri WHERE cari_id = :cari_id AND tur = 'cikis' AND sirket_id = :sirket_id AND tarih BETWEEN :baslangic AND :bitis ORDER BY tarih ASC, id ASC");
    $stmt_odeme->execute($params_donem);
    $odemeler = $stmt_odeme->fetchAll();

    // Tüm hareketleri tek bir dizide birleştir
    $tum_hareketler = array_merge($satislar, $alislar, $tahsilatlar, $odemeler);

    // Tarihe göre sırala
    usort($tum_hareketler, function($a, $b) {
        $tarih_a = strtotime($a['tarih']);
        $tarih_b = strtotime($b['tarih']);
        if ($tarih_a == $tarih_b) {
            // Aynı tarihte ID'ye göre sırala
            return $a['id'] <=> $b['id'];
        }
        return $tarih_a <=> $tarih_b;
    });

    // Ekstreyi oluştur ve bakiyeyi hesapla
    $bakiye = $baslangic_bakiye;
    foreach($tum_hareketler as $hareket) {
        $borc_tutari = 0.0;
        $alacak_tutari = 0.0;

        switch ($hareket['islem_turu']) {
            case 'Satış':
                $borc_tutari = $hareket['tutar']; // Müşterinin borcu artar
                $donem_ici_borc += $borc_tutari;
                break;
            case 'Alış':
                $alacak_tutari = $hareket['tutar']; // Müşterinin alacağı (bizim borcumuz) artar
                $donem_ici_alacak += $alacak_tutari;
                break;
            case 'Tahsilat':
                $alacak_tutari = $hareket['tutar']; // Müşteri borcunu öder (alacak hareketi gibi)
                $donem_ici_alacak += $alacak_tutari;
                break;
            case 'Ödeme':
                $borc_tutari = $hareket['tutar']; // Biz borcumuzu öderiz (borç hareketi gibi)
                $donem_ici_borc += $borc_tutari;
                break;
        }
        // Bakiye = Önceki Bakiye + Alacak - Borç
        $bakiye += ($alacak_tutari - $borc_tutari);

        $ekstre[] = [
            'tarih' => $hareket['tarih'],
            'aciklama' => $hareket['aciklama'] . " (" . $hareket['islem_turu'] . " #" . $hareket['id'] . ")",
            'borc' => $borc_tutari,
            'alacak' => $alacak_tutari,
            'bakiye' => $bakiye
        ];
    }

} catch (PDOException $e) {
    die("Veritabanı hatası: " . $e->getMessage());
}

// --- Veritabanı İşlemleri Bitiş ---

// --- PDF Sınıfı ve Oluşturma Başlangıç ---

class PDF_Ekstre extends tFPDF
{
    public $sirket_bilgileri;
    public $rapor_basligi;
    public $rapor_tarihi;

    function Header()
    {
        if (!empty($this->sirket_bilgileri)) {
            // Logo (varsa)
            if (!empty($this->sirket_bilgileri['logo_yolu']) && file_exists(__DIR__ . '/../' . $this->sirket_bilgileri['logo_yolu'])) {
                $this->Image(__DIR__ . '/../' . $this->sirket_bilgileri['logo_yolu'], 170, 10, 30);
            }
            
            // Şirket adı ve rapor başlığı
            $this->SetFont('DejaVu', 'B', 16);
            $this->Cell(0, 10, $this->sirket_bilgileri['sirket_adi'], 0, 1, 'L');
            $this->SetFont('DejaVu', 'B', 14);
            $this->Cell(0, 10, $this->rapor_basligi, 0, 1, 'L');
            $this->SetFont('DejaVu', '', 10);
            $this->Cell(0, 5, $this->rapor_tarihi, 0, 1, 'L');
            $this->Ln(5);
        }
    }

    function Footer()
    {
        if (!empty($this->sirket_bilgileri)) {
            $this->SetY(-20);
            $this->SetDrawColor(150, 150, 150);
            $this->Cell(0, 5, '', 'T', 1, 'C');
            $this->SetFont('DejaVu', '', 8);
            $adres = $this->sirket_bilgileri['adres'] ?? '';
            $telefon = $this->sirket_bilgileri['telefon'] ?? '';
            $email = $this->sirket_bilgileri['email'] ?? '';
            $footer_text = trim("$adres | Tel: $telefon | E-posta: $email", ' |');
            $this->Cell(0, 5, $footer_text, 0, 1, 'C');
            $this->Cell(0, 5, 'Sayfa ' . $this->PageNo() . '/{nb}', 0, 0, 'C');
            $this->Cell(0, 5, date('d.m.Y H:i'), 0, 0, 'R');
        }
    }
}

// PDF nesnesini oluştur
$pdf = new PDF_Ekstre();
$pdf->sirket_bilgileri = $sirket_bilgileri;
$pdf->rapor_basligi = "CARİ EKSTRE: " . $secili_cari['ad_soyad'];
$pdf->rapor_tarihi = "Dönem: " . date('d.m.Y', strtotime($filtre_baslangic)) . " - " . date('d.m.Y', strtotime($filtre_bitis));

// Türkçe karakterler için font ekle
$pdf->AddFont('DejaVu', '', 'DejaVuSans.ttf', true);
$pdf->AddFont('DejaVu', 'B', 'DejaVuSans-Bold.ttf', true);

$pdf->AliasNbPages(); // Toplam sayfa sayısını hesaplamak için
$pdf->AddPage('L'); // Yatay sayfa

// Cari Bilgileri
$pdf->SetFont('DejaVu', 'B', 10);
$pdf->Cell(40, 7, 'Cari Adı:', 1, 0);
$pdf->SetFont('DejaVu', '', 10);
$pdf->Cell(150, 7, $secili_cari['ad_soyad'], 1, 1);

$pdf->SetFont('DejaVu', 'B', 10);
$pdf->Cell(40, 7, 'Adres:', 1, 0);
$pdf->SetFont('DejaVu', '', 10);
$pdf->Cell(150, 7, $secili_cari['adres'] ?: '-', 1, 1);

$pdf->SetFont('DejaVu', 'B', 10);
$pdf->Cell(40, 7, 'Telefon:', 1, 0);
$pdf->SetFont('DejaVu', '', 10);
$pdf->Cell(150, 7, $secili_cari['telefon'] ?: '-', 1, 1);

$pdf->SetFont('DejaVu', 'B', 10);
$pdf->Cell(40, 7, 'E-posta:', 1, 0);
$pdf->SetFont('DejaVu', '', 10);
$pdf->Cell(150, 7, $secili_cari['email'] ?? '-', 1, 1);

$pdf->Ln(10);

// Ekstre Tablosu
$pdf->SetFont('DejaVu', 'B', 10);
$pdf->SetFillColor(230, 230, 230);
$pdf->Cell(25, 7, 'Tarih', 1, 0, 'C', true);
$pdf->Cell(130, 7, 'Açıklama', 1, 0, 'C', true);
$pdf->Cell(35, 7, 'Borç (+)', 1, 0, 'C', true);
$pdf->Cell(35, 7, 'Alacak (-)', 1, 0, 'C', true);
$pdf->Cell(45, 7, 'Bakiye', 1, 1, 'C', true);

// Devir Bakiye Satırı
$pdf->SetFont('DejaVu', 'B', 10);
$pdf->Cell(155, 7, 'Devir Bakiye (' . date('d.m.Y', strtotime($filtre_baslangic)) . ' öncesi)', 1, 0, 'R');
$pdf->Cell(35, 7, '', 1, 0, 'R');
$pdf->Cell(35, 7, '', 1, 0, 'R');
$pdf->Cell(45, 7, number_format($baslangic_bakiye, 2, ',', '.') . ' ' . getParaBirimiSembolu() . ' ' . ($baslangic_bakiye > 0 ? 'A' : ($baslangic_bakiye < 0 ? 'B' : '')), 1, 1, 'R');

// Ekstre Hareketleri
$pdf->SetFont('DejaVu', '', 9);

if (empty($ekstre)) {
    $pdf->Cell(270, 10, 'Seçilen tarih aralığında hareket bulunamadı.', 1, 1, 'C');
} else {
    foreach ($ekstre as $hareket) {
        $pdf->Cell(25, 7, date('d.m.Y', strtotime($hareket['tarih'])), 1, 0, 'C');
        $pdf->Cell(130, 7, $hareket['aciklama'], 1, 0, 'L');
        $pdf->Cell(35, 7, $hareket['borc'] > 0 ? number_format($hareket['borc'], 2, ',', '.') . ' ' . getParaBirimiSembolu() : '-', 1, 0, 'R');
        $pdf->Cell(35, 7, $hareket['alacak'] > 0 ? number_format($hareket['alacak'], 2, ',', '.') . ' ' . getParaBirimiSembolu() : '-', 1, 0, 'R');
        $pdf->Cell(45, 7, number_format($hareket['bakiye'], 2, ',', '.') . ' ' . getParaBirimiSembolu() . ' ' . ($hareket['bakiye'] > 0 ? 'A' : ($hareket['bakiye'] < 0 ? 'B' : '')), 1, 1, 'R');
    }
}

// Dönem İçi Toplamlar
$pdf->SetFont('DejaVu', 'B', 10);
$pdf->SetFillColor(220, 220, 220);
$pdf->Cell(155, 7, 'Dönem İçi Toplamlar', 1, 0, 'R', true);
$pdf->Cell(35, 7, number_format($donem_ici_borc, 2, ',', '.') . ' ' . getParaBirimiSembolu(), 1, 0, 'R', true);
$pdf->Cell(35, 7, number_format($donem_ici_alacak, 2, ',', '.') . ' ' . getParaBirimiSembolu(), 1, 0, 'R', true);
$pdf->Cell(45, 7, '', 1, 1, 'R', true);

// Son Bakiye
$pdf->SetFillColor(200, 200, 200);
$pdf->Cell(225, 7, 'Son Bakiye (' . date('d.m.Y', strtotime($filtre_bitis)) . ')', 1, 0, 'R', true);
$pdf->Cell(45, 7, number_format($bakiye, 2, ',', '.') . ' ' . getParaBirimiSembolu() . ' ' . ($bakiye > 0 ? 'A' : ($bakiye < 0 ? 'B' : '')), 1, 1, 'R', true);

// Açıklama
$pdf->Ln(5);
$pdf->AddFont('DejaVu', 'I', 'DejaVuSans-Oblique.ttf', true);
$pdf->SetFont('DejaVu', 'I', 8);
$pdf->Cell(0, 5, 'A: Alacaklı (Biz borçluyuz) | B: Borçlu (Bize borçlu)', 0, 1, 'L');

// PDF'i çıktıla
$pdf->Output('I', 'cari-ekstre-' . $cari_id . '.pdf');

// --- PDF Sınıfı ve Oluşturma Bitiş ---
?>