<?php
require_once __DIR__ . '/../includes/config.php';

// Çıkış logu ekle (oturum yok edilmeden önce)
if (isset($_SESSION['kullanici_id'])) {
    oturum_log_ekle($db, 'cikis', $_SESSION['kullanici_id']);
    
    // Aktif oturumu sil
    aktif_oturum_sil($db, session_id());
}

// Tüm oturum verilerini temizle
$_SESSION = array();

// Oturum çerezi sil
if(ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
        $params["path"], $params["domain"],
        $params["secure"], $params["httponly"]
    );
}

// Oturumu yok et
session_destroy();

// Giriş sayfasına yönlendir
header("Location: login.php");
exit();
?>
