<?php
// Initialize dismissed announcements array in session if not exists
if (!isset($_SESSION['dismissed_announcements'])) {
    $_SESSION['dismissed_announcements'] = [];
}

// Handle announcement dismissal via AJAX
if (isset($_POST['dismiss_announcement']) && !empty($_POST['announcement_id'])) {
    if (!in_array($_POST['announcement_id'], $_SESSION['dismissed_announcements'])) {
        $_SESSION['dismissed_announcements'][] = $_POST['announcement_id'];
    }
    // AJAX yanıtı göndermeye gerek yok, sadece çıkış yapıyoruz
    exit(); 
}

if (getCurrentLanguage() == 'tr') {
    $announcement_url = 'http://arajans.com/duyuru/odjoo.json';
} else {
    $announcement_url = 'http://arajans.com/duyuru/odjooen.json';
}

// 1. Duyuru kaynağının URL'si (Kendi sitenizin URL'si ile değiştirin!)

// 2. cURL veya file_get_contents ile JSON verisini çekme mantığı
$json_data = false;
$announcements = null;

if (function_exists('curl_init')) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $announcement_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true); 
    curl_setopt($ch, CURLOPT_TIMEOUT, 5);
    $json_data = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($http_code == 200 && $json_data !== false) {
        $announcements = json_decode($json_data, true);
    }
} elseif (ini_get('allow_url_fopen')) {
    $json_data = @file_get_contents($announcement_url, false, stream_context_create(['http' => ['timeout' => 5]]));
    $announcements = $json_data ? json_decode($json_data, true) : null;
} 

// 3. Veri geçerliyse duyuruları göster
if ($announcements && isset($announcements['announcements']) && is_array($announcements['announcements'])) {
    // En son duyuruyu al
    $latest_announcement = $announcements['announcements'][0];
    
    // Duyuru ID'si yoksa oluştur (başlık ve tarih kombinasyonu)
    $announcement_id = md5($latest_announcement['title'] . $latest_announcement['date']);
    
    // Eğer bu duyuru kapatılmışsa gösterme
    if (in_array($announcement_id, $_SESSION['dismissed_announcements'])) {
        return; // Duyuruyu gösterme
    }
    
    // DUYURU TÜRÜNE GÖRE BOOTSTRAP 5 STİL SINIFI EŞLEŞTİRMESİ (GENİŞLETİLDİ)
    $type = $latest_announcement['type'];
    $alert_class = 'alert-info'; // Varsayılan değer
    
    switch ($type) {
        case 'critical':
        case 'danger':
            $alert_class = 'alert-danger';      // Kırmızı
            break;
        case 'warning':
            $alert_class = 'alert-warning';     // Sarı
            break;
        case 'success':
            $alert_class = 'alert-success';     // Yeşil
            break;
        case 'info':
            $alert_class = 'alert-info';        // Açık Mavi
            break;
        case 'primary':
            $alert_class = 'alert-primary';     // Koyu Mavi
            break;
        case 'secondary':
            $alert_class = 'alert-secondary';    // Gri
            break;
        case 'light':
            $alert_class = 'alert-light';        // Açık Gri/Beyaz
            break;
        case 'dark':
            $alert_class = 'alert-dark';         // Koyu Gri/Siyah
            break;
        // Varsayılan değer zaten yukarıda ayarlandı
    }
    
    // HTML Çıktısı (Bootstrap 5 ile uyumlu - Kapatma düğmesi dahil)
    ?>
    <div class="announcement-area mb-4" data-announcement-id="<?php echo $announcement_id; ?>">
        <div class="alert <?php echo $alert_class; ?> alert-dismissible fade show" role="alert">
            <h5 class="alert-heading"><?php echo htmlspecialchars($latest_announcement['title']); ?></h5>
            <p><?php echo htmlspecialchars($latest_announcement['message']); ?></p>
            <hr>
            <p class="mb-0">
                <?= __("version") ?>: <strong><?php echo htmlspecialchars($latest_announcement['version']); ?></strong> | 
                <?= __("date") ?>: <?php echo htmlspecialchars($latest_announcement['date']); ?>
            </p>
            
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="<?= __("close") ?>"></button>
        </div>
    </div>
    
    <script>
    // AJAX ile duyuru kapatma işlemi
    document.addEventListener('DOMContentLoaded', function() {
        const announcementArea = document.querySelector('.announcement-area');
        if (announcementArea) {
            const announcementId = announcementArea.getAttribute('data-announcement-id');
            const closeButton = announcementArea.querySelector('.btn-close');
            
            // X düğmesine (btn-close) tıklandığında
            closeButton.addEventListener('click', function(e) {
                // AJAX ile sunucuya bildir
                fetch(window.location.href, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                    },
                    // Bu AJAX isteği sayfa yüklenmeden önce PHP'nin session'a kaydetme bloğunu tetikleyecek.
                    body: 'dismiss_announcement=1&announcement_id=' + encodeURIComponent(announcementId)
                });
                
                // Bootstrap'in varsayılan kapatma işlemi (fade out) kendiliğinden çalışacaktır.
            });
        }
    });
    </script>
    <?php
}

// Opsiyonel: Veri çekilemediyse kullanıcıya hiçbir şey gösterme
?>