<?php
function exportExcel($filename = 'ExportExcel', $columns = array(), $data = array(), $replaceDotCol = array()) {
    // Set headers for Excel file
    header('Content-Type: application/vnd.ms-excel; charset=utf-8');
    header('Content-Disposition: attachment; filename="' . $filename . '.xls"');
    header('Pragma: no-cache');
    header('Expires: 0');
    
    // Start output buffering
    ob_start();
    
    // Create a file handle to output
    $output = fopen('php://output', 'w');
    
    // Add BOM for UTF-8
    echo "\xEF\xBB\xBF";
    
    // Start HTML table with Excel XML/HTML format
    echo '<html xmlns:o="urn:schemas-microsoft-com:office:office" '.
         'xmlns:x="urn:schemas-microsoft-com:office:excel" '.
         'xmlns="http://www.w3.org/TR/REC-html40">'.
         '<head>'.'<meta http-equiv="Content-Type" content="text/html; charset=utf-8">'.
         '<!--[if gte mso 9]><xml>'.'<x:ExcelWorkbook>'.'<x:ExcelWorksheets>'.'<x:ExcelWorksheet>'.'<x:Name>'.htmlspecialchars($filename).'</x:Name>'.'<x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions>'.'</x:ExcelWorksheet>'.'</x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]-->'.
         '</head><body><table border="1">';
    
    // Add headers
    echo '<tr>';
    foreach ($columns as $column) {
        echo '<th style="background-color:#FFA500">' . htmlspecialchars($column) . '</th>';
    }
    echo '</tr>';
    
    // Add data rows
    foreach ($data as $row) {
        echo '<tr>';
        foreach ($row as $i => $cell) {
            // Format numbers with comma as decimal separator if needed
            if (in_array($i, $replaceDotCol)) {
                $cell = str_replace('.', ',', $cell);
            }
            echo '<td>' . htmlspecialchars($cell) . '</td>';
        }
        echo '</tr>';
    }
    
    // Close the table and HTML
    echo '</table></body></html>';
    
    // Flush the output buffer and turn off output buffering
    ob_end_flush();
    exit;
}