<?php
// Bu dosya, modern tFPDF implementasyonu (fatura_goruntule_pdf.php) ile değiştirildiği için devre dışı bırakılmıştır.
// Hatalı 'vendor/autoload.php' çağrısı nedeniyle fatal error vermektedir.
die('Bu PDF oluşturma yöntemi artık kullanılmamaktadır. Lütfen fatura_goruntule_pdf.php kullanın.');

require_once __DIR__ . '/../includes/config.php';
yetkili_mi();

// Fatura ID ve türünü al
$fatura_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
$fatura_tur = filter_input(INPUT_GET, 'tur', FILTER_SANITIZE_SPECIAL_CHARS);

if (!$fatura_id || !in_array($fatura_tur, ['satis', 'alis'])) {
    die('Geçersiz fatura bilgisi!');
}

// Fatura bilgilerini getir
try {
    $stmt = $db->prepare("
        SELECT b.*, c.ad_soyad as cari_adi, c.telefon as cari_telefon, c.adres as cari_adres, 
               k.kategori_adi
        FROM borclar b
        LEFT JOIN cariler c ON b.cari_id = c.id
        LEFT JOIN kategoriler k ON b.kategori_id = k.id
        WHERE b.id = ? AND b.tur = ?
    ");
    $stmt->execute([$fatura_id, $fatura_tur]);
    $fatura = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$fatura) {
        die('Fatura bulunamadı!');
    }
    
    // Fatura detaylarını getir (stoklu işlem ise)
    $fatura_detaylari = [];
    if ($fatura['stoklu_islem']) {
        $stmt_detay = $db->prepare("
            SELECT fd.*, u.urun_adi, u.birim
            FROM fatura_detaylari fd
            LEFT JOIN urunler u ON fd.urun_id = u.id
            WHERE fd.borc_id = ?
            ORDER BY fd.id
        ");
        $stmt_detay->execute([$fatura_id]);
        $fatura_detaylari = $stmt_detay->fetchAll(PDO::FETCH_ASSOC);
    }
    
} catch (PDOException $e) {
    error_log("PDF fatura hatası: " . $e->getMessage());
    die('Fatura bilgileri yüklenirken bir hata oluştu.');
}

// PDF içeriğini oluştur
$html = '
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <style>
        body { font-family: Arial, sans-serif; font-size: 12px; margin: 20px; }
        .header { text-align: center; border-bottom: 2px solid #333; padding-bottom: 20px; margin-bottom: 30px; }
        .header h1 { font-size: 24px; margin: 0; color: #333; }
        .info-section { margin-bottom: 30px; }
        .info-box { border: 1px solid #ddd; padding: 15px; margin-bottom: 15px; background-color: #f9f9f9; }
        .info-box h3 { margin: 0 0 10px 0; color: #333; font-size: 14px; }
        .info-box p { margin: 5px 0; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f5f5f5; font-weight: bold; }
        .text-right { text-align: right; }
        .text-center { text-align: center; }
        .total-row { background-color: #e9ecef; font-weight: bold; }
        .grand-total { background-color: #007bff; color: white; font-weight: bold; }
        .footer { text-align: center; margin-top: 40px; padding-top: 20px; border-top: 1px solid #ddd; font-size: 10px; color: #666; }
    </style>
</head>
<body>
    <div class="header">
        <h1>' . ($fatura_tur == 'satis' ? 'SATIŞ FATURASI' : 'ALIŞ FATURASI') . '</h1>
        <p>Fatura No: <strong>#' . $fatura['id'] . '</strong></p>
    </div>

    <div class="info-section">
        <div style="width: 48%; float: left;">
            <div class="info-box">
                <h3>' . ($fatura_tur == 'satis' ? 'Müşteri Bilgileri' : 'Tedarikçi Bilgileri') . '</h3>
                <p><strong>' . htmlspecialchars($fatura['cari_adi']) . '</strong></p>';

if (!empty($fatura['cari_telefon'])) {
    $html .= '<p>Tel: ' . htmlspecialchars($fatura['cari_telefon']) . '</p>';
}
if (!empty($fatura['cari_adres'])) {
    $html .= '<p>Adres: ' . htmlspecialchars($fatura['cari_adres']) . '</p>';
}

$html .= '
            </div>
        </div>
        <div style="width: 48%; float: right;">
            <div class="info-box">
                <h3>Fatura Detayları</h3>
                <p><strong>Tarih:</strong> ' . date('d.m.Y', strtotime($fatura['tarih'])) . '</p>';

if ($fatura['vade_tarihi']) {
    $html .= '<p><strong>Vade Tarihi:</strong> ' . date('d.m.Y', strtotime($fatura['vade_tarihi'])) . '</p>';
}

$html .= '<p><strong>Kategori:</strong> ' . htmlspecialchars($fatura['kategori_adi'] ?? '-') . '</p>
                <p><strong>Durum:</strong> ';

switch($fatura['durum']) {
    case 'odendi': $html .= 'Ödendi'; break;
    case 'kismen_odendi': $html .= 'Kısmi Ödendi'; break;
    default: $html .= 'Ödenmedi'; break;
}

$html .= '</p>
            </div>
        </div>
        <div style="clear: both;"></div>
    </div>';

// Fatura içeriği
if ($fatura['stoklu_islem'] && !empty($fatura_detaylari)) {
    // Stoklu işlem - detay tablosu
    $html .= '
    <table>
        <thead>
            <tr>
                <th>Ürün Adı</th>
                <th class="text-center">Miktar</th>
                <th class="text-right">Birim Fiyat</th>
                <th class="text-center">KDV (%)</th>
                <th class="text-right">KDV Tutarı</th>
                <th class="text-right">Toplam</th>
            </tr>
        </thead>
        <tbody>';
    
    $ara_toplam = 0;
    $toplam_kdv = 0;
    
    foreach ($fatura_detaylari as $detay) {
        $ara_toplam += $detay['toplam_tutar'];
        $toplam_kdv += $detay['kdv_tutari'];
        
        $html .= '
            <tr>
                <td>' . htmlspecialchars($detay['urun_adi']) . '</td>
                <td class="text-center">' . number_format($detay['miktar'], 2, ',', '.') . ' ' . htmlspecialchars($detay['birim']) . '</td>
               <td class="text-right">' . number_format($detay['birim_fiyat'], 2, ',', '.') . ' ' . getParaBirimiSembolu($fatura['para_birimi'] ?? null) . '</td>
                <td class="text-center">%' . number_format($detay['kdv_orani'], 0) . '</td>
               <td class="text-right">' . number_format($detay['kdv_tutari'], 2, ',', '.') . ' ' . getParaBirimiSembolu($fatura['para_birimi'] ?? null) . '</td>
               <td class="text-right">' . number_format($detay['toplam_tutar'], 2, ',', '.') . ' ' . getParaBirimiSembolu($fatura['para_birimi'] ?? null) . '</td>
            </tr>';
    }
    
    $html .= '
        </tbody>
        <tfoot>
            <tr class="total-row">
                <td colspan="5" class="text-right"><strong>Ara Toplam:</strong></td>
               <td class="text-right"><strong>' . number_format($ara_toplam, 2, ',', '.') . ' ' . getParaBirimiSembolu($fatura['para_birimi'] ?? null) . '</strong></td>
            </tr>
            <tr class="total-row">
                <td colspan="5" class="text-right"><strong>Toplam KDV:</strong></td>
               <td class="text-right"><strong>' . number_format($toplam_kdv, 2, ',', '.') . ' ' . getParaBirimiSembolu($fatura['para_birimi'] ?? null) . '</strong></td>
            </tr>
            <tr class="grand-total">
                <td colspan="5" class="text-right"><strong>GENEL TOPLAM:</strong></td>
               <td class="text-right"><strong>' . number_format($ara_toplam + $toplam_kdv, 2, ',', '.') . ' ' . getParaBirimiSembolu($fatura['para_birimi'] ?? null) . '</strong></td>
            </tr>
        </tfoot>
    </table>';
} else {
    // Stoksuz işlem
    if (!empty($fatura['aciklama'])) {
        $html .= '
        <div class="info-box">
            <h3>Açıklama:</h3>
            <p>' . nl2br(htmlspecialchars($fatura['aciklama'])) . '</p>
        </div>';
    }
    
    $html .= '
    <table>
        <tr class="grand-total">
           <td class="text-right" style="font-size: 18px; padding: 20px;"><strong>TOPLAM TUTAR: ' . number_format($fatura['tutar'], 2, ',', '.') . ' ' . getParaBirimiSembolu($fatura['para_birimi'] ?? null) . '</strong></td>
        </tr>
    </table>';
}

// Ödeme bilgileri
if ($fatura['odenen_tutar'] > 0) {
    $html .= '
    <div class="info-box">
        <h3>Ödeme Bilgileri</h3>
        <p><strong>Ödenen Tutar:</strong> ' . number_format($fatura['odenen_tutar'], 2, ',', '.') . ' ' . getParaBirimiSembolu($fatura['para_birimi'] ?? null) . '</p>
        <p><strong>Kalan Tutar:</strong> ' . number_format($fatura['tutar'] - $fatura['odenen_tutar'], 2, ',', '.') . ' ' . getParaBirimiSembolu($fatura['para_birimi'] ?? null) . '</p>
    </div>';
}

$html .= '
    <div class="footer">
        Bu fatura ' . date('d.m.Y H:i', strtotime($fatura['olusturulma_tarihi'])) . ' tarihinde oluşturulmuştur.
    </div>
</body>
</html>';

// PDF oluştur
require_once 'vendor/autoload.php'; // Composer autoload (eğer varsa)

try {
    // mPDF kullanarak PDF oluştur
    if (class_exists('Mpdf\Mpdf')) {
        $mpdf = new \Mpdf\Mpdf([
            'mode' => 'utf-8',
            'format' => 'A4',
            'margin_left' => 15,
            'margin_right' => 15,
            'margin_top' => 16,
            'margin_bottom' => 16,
        ]);
        
        $mpdf->WriteHTML($html);
        $filename = ($fatura_tur == 'satis' ? 'Satis' : 'Alis') . '_Faturasi_' . $fatura['id'] . '.pdf';
        $mpdf->Output($filename, 'D'); // D = Download
    } else {
        // Alternatif: TCPDF kullan
        require_once 'tcpdf/tcpdf.php';
        
        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        $pdf->SetCreator('Odjoo Yönetim Sistemi');
        $pdf->SetTitle(($fatura_tur == 'satis' ? 'Satış' : 'Alış') . ' Faturası #' . $fatura['id']);
        
        $pdf->AddPage();
        $pdf->writeHTML($html, true, false, true, false, '');
        
        $filename = ($fatura_tur == 'satis' ? 'Satis' : 'Alis') . '_Faturasi_' . $fatura['id'] . '.pdf';
        $pdf->Output($filename, 'D');
    }
} catch (Exception $e) {
    // PDF kütüphanesi yoksa, HTML olarak göster
    header('Content-Type: text/html; charset=utf-8');
    echo $html;
    echo '<script>window.print();</script>';
}
?>

