<?php
require_once __DIR__ . '/../includes/config.php';

// Yetki kontrolü (Sadece fatura silme yetkisi olanlar)
yetkili_mi('faturalar'); // Fatura silme yetkisi

// Sadece POST isteklerini kabul et
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: index.php');
    exit();
}

// CSRF token kontrolü
if (!isset($_POST['csrf_token']) || !csrf_token_dogrula($_POST['csrf_token'])) {
    $_SESSION['hata'] = 'Geçersiz işlem denemesi.';
    header('Location: ' . ($_SERVER['HTTP_REFERER'] ?? 'index.php'));
    exit();
}

// Fatura ID'sini al ve doğrula
$borc_id = filter_input(INPUT_POST, 'borc_id', FILTER_VALIDATE_INT);
if (!$borc_id) {
    $_SESSION['hata'] = 'Geçersiz fatura ID\'si.';
    header('Location: satis_faturalari.php'); // Genel bir sayfaya yönlendir
    exit();
}

// Yetki kontrolü (Admin veya ilgili işlem yetkisi olanlar silebilir)
yetkili_mi(['admin', 'satis_islemleri', 'alis_islemleri']);

$aktif_sirket_id = $_SESSION['aktif_sirket_id'];

try {
    $db->beginTransaction();

    // 1. Fatura (borç) bilgilerini al
    $stmt_borc = $db->prepare("SELECT * FROM borclar WHERE id = ? AND sirket_id = ?");
    $stmt_borc->execute([$borc_id, $aktif_sirket_id]);
    $borc = $stmt_borc->fetch();

    if (!$borc) {
        throw new Exception('Fatura bulunamadı veya bu şirkete ait değil.');
    }

    $fatura_turu = $borc['tur']; // 'satis' veya 'alis'
    $odenecek_tutar = $borc['tutar'] + $borc['toplam_kdv'] - $borc['indirim_tutari'];

    // 2. İlişkili hesap hareketlerini sil ve bakiye iadesi yap
    $stmt_hareketler = $db->prepare("SELECT * FROM hesap_hareketleri WHERE borc_id = ?");
    $stmt_hareketler->execute([$borc_id]);
    $hareketler = $stmt_hareketler->fetchAll();

    foreach ($hareketler as $hareket) {
        // Bakiyeyi tersine çevir
        $tutar_iade = ($hareket['islem_turu'] == 'giris') ? -$hareket['tutar'] : $hareket['tutar'];
        hesapBakiyeGuncelle($db, $hareket['hesap_id'], $tutar_iade);
    }
    $db->prepare("DELETE FROM hesap_hareketleri WHERE borc_id = ?")->execute([$borc_id]);

    // 3. Cari bakiye iadesi yap (Peşin olmayan işlemler için)
    if ($borc['odenen_tutar'] < $odenecek_tutar) {
        $kalan_borc = $odenecek_tutar - $borc['odenen_tutar'];
        if ($fatura_turu == 'satis') {
            // Müşterinin alacağını azalt
            cariBakiyeGuncelle($db, $borc['cari_id'], -$kalan_borc, 0.0);
        } else { // alis
            // Tedarikçiye olan borcu azalt
            cariBakiyeGuncelle($db, $borc['cari_id'], 0.0, -$kalan_borc);
        }
    }

    // 4. Stok iadesi yap (Stoklu işlemler için)
    if ($borc['stoklu_islem']) {
        $stmt_detaylar = $db->prepare("SELECT * FROM fatura_detaylari WHERE borc_id = ?");
        $stmt_detaylar->execute([$borc_id]);
        $detaylar = $stmt_detaylar->fetchAll();

        foreach ($detaylar as $detay) {
            // Satışta stok geri eklenir, alışta stok geri çıkarılır
            $stok_degisim = ($fatura_turu == 'satis') ? $detay['miktar'] : -$detay['miktar'];
            stokGuncelle($db, $detay['urun_id'], $stok_degisim, null);
        }
        // Fatura detaylarını sil
        $db->prepare("DELETE FROM fatura_detaylari WHERE borc_id = ?")->execute([$borc_id]);
    }

    // 5. Faturayı (borç kaydını) sil
    $db->prepare("DELETE FROM borclar WHERE id = ?")->execute([$borc_id]);

    // 6. Log kaydı oluştur
    $log_mesaji = "#{$borc_id} ID'li '{$fatura_turu}' faturası silindi. İşlem veritabanında saklanmaktadır ve geri alınabilir.";
    $log_id = sistem_log_ekle($db, 'Fatura Silme', 'borclar', $borc_id, $borc, null, $log_mesaji);
    
    // 7. Silinen kaydı geri alma tablosuna ekle
    if ($log_id) {
        silinen_kayit_ekle($db, $log_id, 'borclar', $borc_id, $borc);
    }

    $db->commit();

    $_SESSION['mesaj'] = "#{$borc_id} numaralı fatura ve ilişkili tüm kayıtlar başarıyla silindi.";

} catch (Exception $e) {
    // Bir hata oluşursa işlemi geri al
    $db->rollBack();

    // Hata mesajını logla ve kullanıcıya daha detaylı bilgi ver
    error_log("Fatura silme hatası (Fatura ID: {$borc_id}): " . $e->getMessage());
    $_SESSION['hata'] = 'Silme işlemi başarısız oldu. Hata: ' . $e->getMessage();

    // Kullanıcıyı geldiği sayfaya geri yönlendir
    $redirect_url = 'index.php?page=satis_faturalari'; // Varsayılan yönlendirme
    header('Location: ' . $redirect_url);
    exit();
}

// Kullanıcıyı fatura listesine geri yönlendir
$yonlendirme_sayfasi = ($fatura_turu ?? 'satis') == 'satis' ? 'satis_faturalari.php' : 'alis_faturalari.php';
header('Location: ' . $yonlendirme_sayfasi);
exit();
