<?php
require_once __DIR__ . '/../includes/config.php';

// AJAX isteği kontrolü
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Geçersiz istek metodu']);
    exit();
}

// Yetki kontrolü
if (!yetkili_mi(['hesap_yonetimi', 'raporlar'], false)) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Erişim izniniz yok']);
    exit();
}

// Aktif şirket ID'sini session'dan al
$aktif_sirket_id = $_SESSION['aktif_sirket_id'] ?? null;

// Debug bilgisi
error_log("Hesap hareketi detay - Session: " . print_r($_SESSION, true));
error_log("Hesap hareketi detay - Aktif şirket ID: " . $aktif_sirket_id);

if (!$aktif_sirket_id) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Aktif şirket bulunamadı']);
    exit();
}

// Hareket ID'sini al ve doğrula
$hareket_id = filter_input(INPUT_GET, 'hareket_id', FILTER_VALIDATE_INT);

// Debug log
error_log("Hareket ID: " . ($hareket_id ?: "NULL"));
error_log("GET parameters: " . print_r($_GET, true));

if (!$hareket_id) {
    $error_msg = 'Geçersiz veya eksik hareket ID. Gönderilen değer: ' . 
                (isset($_GET['hareket_id']) ? htmlspecialchars($_GET['hareket_id']) : 'YOK');
    error_log($error_msg);
    http_response_code(400);
    echo json_encode([
        'success' => false, 
        'message' => $error_msg,
        'debug' => [
            'hareket_id' => $_GET['hareket_id'] ?? null,
            'filtered_id' => $hareket_id,
            'request_method' => $_SERVER['REQUEST_METHOD'],
            'request_uri' => $_SERVER['REQUEST_URI'] ?? null,
            'query_string' => $_SERVER['QUERY_STRING'] ?? null
        ]
    ]);
    exit();
}

try {
    // Hareket detaylarını çek
    $sql = "SELECT hh.*, h.hesap_adi, h.para_birimi as hesap_para_birimi, 
                   c.ad_soyad as cari_ad_soyad, c.email as cari_email,
                   b.referans_id as borc_referans_id, b.aciklama as borc_aciklama,
                   b.borc_tutari as borc_tutari, b.plaka as borc_plaka, b.senaryo_adi as borc_senaryo,
                   b.id as borc_kayit_id, hh_transfer.id as transfer_baglanti_id,
                   h_transfer.hesap_adi as transfer_hedef_hesap,
                   f.tur as fatura_tur, f.id as fatura_id
            FROM hesap_hareketleri hh
            LEFT JOIN hesaplar h ON hh.hesap_id = h.id
            LEFT JOIN cariler c ON hh.cari_id = c.id
            LEFT JOIN borclar b ON hh.borc_id = b.id
            LEFT JOIN hesap_hareketleri hh_transfer ON (hh.tur = 'transfer' AND hh.baglanti_id = hh_transfer.id)
            LEFT JOIN hesaplar h_transfer ON hh_transfer.hesap_id = h_transfer.id
            LEFT JOIN faturalar f ON (hh.fatura_id = f.id AND f.sirket_id = hh.sirket_id)
            WHERE hh.id = ? AND hh.sirket_id = ?";
    
    error_log("SQL Query: " . $sql);
    error_log("Parameters: hareket_id=" . $hareket_id . ", sirket_id=" . $aktif_sirket_id);
    
    $stmt = $db->prepare($sql);
    $stmt->execute([$hareket_id, $aktif_sirket_id]);
    $hareket = $stmt->fetch(PDO::FETCH_ASSOC);
    
    error_log("Query result: " . print_r($hareket, true));

    if (!$hareket) {
        throw new Exception("Hesap hareketi bulunamadı");
    }
    
    // Detaylı bilgiyi dön
    echo json_encode([
        'success' => true,
        'hareket' => [
            'id' => $hareket['id'],
            'tarih' => date('d.m.Y H:i', strtotime($hareket['tarih'])),
            'hesap_adi' => $hareket['hesap_adi'],
            'hesap_para_birimi' => $hareket['hesap_para_birimi'] ?: '₺',
            'tur' => $hareket['tur'],
            'tutar' => number_format($hareket['tutar'], 2, ',', '.'),
            'aciklama' => $hareket['aciklama'],
            'cari_ad_soyad' => $hareket['cari_ad_soyad'],
            'cari_email' => $hareket['cari_email'],
            'borc_kayit_id' => $hareket['borc_kayit_id'],
            'borc_referans_id' => $hareket['borc_referans_id'],
            'fatura_id' => $hareket['fatura_id'] ?? null,
            'fatura_tur' => $hareket['fatura_tur'] ?? null,
            'borc_tutari' => $hareket['borc_tutari'] ? number_format($hareket['borc_tutari'], 2, ',', '.') : null,
            'borc_plaka' => $hareket['borc_plaka'],
            'borc_senaryo' => $hareket['borc_senaryo'],
            'fatura_id' => $hareket['fatura_id'],
            'transfer_hedef_hesap' => $hareket['transfer_hedef_hesap'],
            'baglanti_id' => $hareket['baglanti_id'],
            'olusturma_tarihi' => $hareket['olusturma_tarihi'] ? date('d.m.Y H:i', strtotime($hareket['olusturma_tarihi'])) : null,
            'guncelleme_tarihi' => $hareket['guncelleme_tarihi'] ? date('d.m.Y H:i', strtotime($hareket['guncelleme_tarihi'])) : null,
            'ip_adresi' => $hareket['ip_adresi']
        ]
    ]);

} catch (Exception $e) {
    error_log('Hesap hareketi detay hatası: ' . $e->getMessage());
    http_response_code(500);
    echo json_encode([
        'success' => false, 
        'message' => 'Hesap hareketi detayları çekilirken bir hata oluştu'
    ]);
    exit();
}
?>
