<?php
require_once __DIR__ . '/../includes/config.php';
yetkili_mi(['hesap_yonetimi']);

// AJAX isteği kontrolü
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Geçersiz istek metodu']);
    exit();
}

// CSRF token kontrolü
if (!csrf_token_dogrula($_POST['csrf_token'] ?? '')) {
    echo json_encode(['success' => false, 'message' => 'Geçersiz güvenlik tokeni']);
    exit();
}

// Gerekli alanları kontrol et
$hareket_id = filter_input(INPUT_POST, 'hareket_id', FILTER_VALIDATE_INT);
$tarih = filter_input(INPUT_POST, 'tarih', FILTER_SANITIZE_SPECIAL_CHARS);
$tutar = filter_var(str_replace(',', '.', $_POST['tutar'] ?? '0'), FILTER_VALIDATE_FLOAT);
$aciklama = temizle($_POST['aciklama'] ?? '');
$tur = filter_input(INPUT_POST, 'tur', FILTER_SANITIZE_SPECIAL_CHARS);

if (!$hareket_id || !$tarih || $tutar === false || empty($aciklama) || !in_array($tur, ['giris', 'cikis', 'transfer'])) {
    echo json_encode(['success' => false, 'message' => 'Geçersiz veri']);
    exit();
}

try {
    $db->beginTransaction();
    
    // Mevcut hareketi al
    $stmt_mevcut = $db->prepare("SELECT * FROM hesap_hareketleri WHERE id = ? AND sirket_id = ?");
    $stmt_mevcut->execute([$hareket_id, $aktif_sirket_id]);
    $mevcut_hareket = $stmt_mevcut->fetch(PDO::FETCH_ASSOC);
    
    if (!$mevcut_hareket) {
        throw new Exception("Hesap hareketi bulunamadı");
    }
    
    // Hesap bakiyesini geri al (eski hareketi iptal et)
    $eski_tutar = $mevcut_hareket['tutar'];
    $eski_tur = $mevcut_hareket['tur'];
    $hesap_id = $mevcut_hareket['hesap_id'];
    
    if ($eski_tur == 'giris') {
        // Eski giriş işlemini geri al (hesaptan çıkar)
        $stmt_hesap = $db->prepare("UPDATE hesaplar SET bakiye = bakiye - ? WHERE id = ? AND sirket_id = ?");
        $stmt_hesap->execute([$eski_tutar, $hesap_id, $aktif_sirket_id]);
    } elseif ($eski_tur == 'cikis') {
        // Eski çıkış işlemini geri al (hesaba ekle)
        $stmt_hesap = $db->prepare("UPDATE hesaplar SET bakiye = bakiye + ? WHERE id = ? AND sirket_id = ?");
        $stmt_hesap->execute([$eski_tutar, $hesap_id, $aktif_sirket_id]);
    }
    
    // Yeni hareketi uygula
    if ($tur == 'giris') {
        // Yeni giriş işlemi (hesaba ekle)
        $stmt_hesap = $db->prepare("UPDATE hesaplar SET bakiye = bakiye + ? WHERE id = ? AND sirket_id = ?");
        $stmt_hesap->execute([$tutar, $hesap_id, $aktif_sirket_id]);
    } elseif ($tur == 'cikis') {
        // Yeni çıkış işlemi (hesaptan çıkar)
        $stmt_hesap = $db->prepare("UPDATE hesaplar SET bakiye = bakiye - ? WHERE id = ? AND sirket_id = ?");
        $stmt_hesap->execute([$tutar, $hesap_id, $aktif_sirket_id]);
    }
    
    // Transfer işlemleri için özel kontrol
    if ($tur == 'transfer' || $mevcut_hareket['tur'] == 'transfer') {
        // Transfer işlemleri için daha karmaşık mantık gerekebilir
        // Şimdilik basit tutuyoruz
    }
    
    // Hesap hareketini güncelle
    $stmt_guncelle = $db->prepare("UPDATE hesap_hareketleri SET 
        tarih = ?, tutar = ?, aciklama = ?, tur = ?, guncelleme_tarihi = NOW()
        WHERE id = ? AND sirket_id = ?");
    
    if (!$stmt_guncelle->execute([$tarih, $tutar, $aciklama, $tur, $hareket_id, $aktif_sirket_id])) {
        throw new Exception("Hesap hareketi güncellenemedi");
    }
    
    // Log kaydı ekle
    $log_mesaji = "kullanıcısı, #{$hareket_id} ID'li hesap hareketini düzenledi. Eski: {$eski_tutar} ({$eski_tur}), Yeni: {$tutar} ({$tur})";
    sistem_log_ekle($db, 'Hesap Hareketi Düzenleme', 'hesap_hareketleri', $hareket_id, null, null, $log_mesaji);
    
    $db->commit();
    
    echo json_encode(['success' => true, 'message' => 'Hesap hareketi başarıyla güncellendi']);
    
} catch (Exception $e) {
    if ($db->inTransaction()) {
        $db->rollBack();
    }
    
    error_log("Hesap hareketi düzenleme hatası: " . $e->getMessage());
    echo json_encode(['success' => false, 'message' => 'Hesap hareketi güncellenirken bir hata oluştu: ' . $e->getMessage()]);
}
?>
