<?php
require_once __DIR__ . '/../includes/config.php';
yetkili_mi(['hesap_yonetimi']);

// GET veya POST isteği kontrolü
if ($_SERVER['REQUEST_METHOD'] !== 'GET' && $_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Geçersiz istek metodu']);
    exit();
}

// CSRF token kontrolü (GET isteklerinde URL'den, POST isteklerinde form'dan)
$csrf_token = '';
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $csrf_token = $_GET['csrf_token'] ?? '';
} else {
    $csrf_token = $_POST['csrf_token'] ?? '';
}

if (!csrf_token_dogrula($csrf_token)) {
    echo json_encode(['success' => false, 'message' => 'Geçersiz güvenlik tokeni']);
    exit();
}

// Gerekli alanları kontrol et (GET veya POST'tan)
$hareket_id = 0;
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $hareket_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
} else {
    $hareket_id = filter_input(INPUT_POST, 'hareket_id', FILTER_VALIDATE_INT);
}

if (!$hareket_id) {
    echo json_encode(['success' => false, 'message' => 'Geçersiz hareket ID']);
    exit();
}

try {
    $db->beginTransaction();
    
    // Mevcut hareketi al
    $stmt_mevcut = $db->prepare("SELECT * FROM hesap_hareketleri WHERE id = ? AND sirket_id = ?");
    $stmt_mevcut->execute([$hareket_id, $aktif_sirket_id]);
    $mevcut_hareket = $stmt_mevcut->fetch(PDO::FETCH_ASSOC);
    
    if (!$mevcut_hareket) {
        throw new Exception("Hesap hareketi bulunamadı");
    }
    
    // Hesap bakiyesini geri al
    $tutar = $mevcut_hareket['tutar'];
    $tur = $mevcut_hareket['tur'];
    $hesap_id = $mevcut_hareket['hesap_id'];
    
    if ($tur == 'giris') {
        // Giriş işlemini geri al (hesaptan çıkar)
        $stmt_hesap = $db->prepare("UPDATE hesaplar SET bakiye = bakiye - ? WHERE id = ? AND sirket_id = ?");
        $stmt_hesap->execute([$tutar, $hesap_id, $aktif_sirket_id]);
    } elseif ($tur == 'cikis') {
        // Çıkış işlemini geri al (hesaba ekle)
        $stmt_hesap = $db->prepare("UPDATE hesaplar SET bakiye = bakiye + ? WHERE id = ? AND sirket_id = ?");
        $stmt_hesap->execute([$tutar, $hesap_id, $aktif_sirket_id]);
    }
    
    // İlgili cari bakiyesini geri al (varsa)
    $cari_id = !empty($mevcut_hareket['cari_id']) ? (int)$mevcut_hareket['cari_id'] : 0;
    if ($cari_id > 0) {
        if ($tur === 'giris') {
            // Tahsilat siliniyor: müşteri borcu tekrar artar
            if (!cariBakiyeGuncelle($db, $cari_id, +$tutar, 0.0)) {
                throw new Exception('Cari bakiyesi geri alınamadı (tür: giris).');
            }
        } elseif ($tur === 'cikis') {
            // Ödeme siliniyor: tedarikçi alacağı tekrar artar
            if (!cariBakiyeGuncelle($db, $cari_id, 0.0, +$tutar)) {
                throw new Exception('Cari bakiyesi geri alınamadı (tür: cikis).');
            }
        }
    }

    // Transfer işlemleri için özel kontrol
    if ($tur == 'transfer') {
        // Transfer işlemleri için daha karmaşık mantık gerekebilir
        // Şimdilik basit tutuyoruz
    }
    
    // Hesap hareketini sil
    $stmt_sil = $db->prepare("DELETE FROM hesap_hareketleri WHERE id = ? AND sirket_id = ?");
    
    if (!$stmt_sil->execute([$hareket_id, $aktif_sirket_id])) {
        throw new Exception("Hesap hareketi silinemedi");
    }
    
    // Log kaydı ekle
    $log_mesaji = "kullanıcısı, #{$hareket_id} ID'li hesap hareketini sildi. Tutar: {$tutar}, Tür: {$tur}";
    sistem_log_ekle($db, 'Hesap Hareketi Silme', 'hesap_hareketleri', $hareket_id, null, null, $log_mesaji);
    
    $db->commit();
    
    echo json_encode(['success' => true, 'message' => 'Hesap hareketi başarıyla silindi']);
    
} catch (Exception $e) {
    if ($db->inTransaction()) {
        $db->rollBack();
    }
    
    error_log("Hesap hareketi silme hatası: " . $e->getMessage());
    echo json_encode(['success' => false, 'message' => 'Hesap hareketi silinirken bir hata oluştu: ' . $e->getMessage()]);
}
?>
