<?php
/**
 * Account Transactions Excel Export
 * Hesap Hareketleri Excel Dışa Aktarımı
 */

// 1) Include necessary files
// Gerekli dosyaları dahil et
$possible_paths = [
    __DIR__ . '/exportexcel.php',
    __DIR__ . '/ExportExcel.php',
    __DIR__ . '/../exportexcel.php',
    __DIR__ . '/../ExportExcel.php',
    __DIR__ . '/../../ExportExcel.php',
];

$included = false;
foreach ($possible_paths as $p) {
    if (file_exists($p)) {
        require_once $p;
        $included = true;
        break;
    }
}

if (!$included) {
    header('Content-Type: text/plain; charset=utf-8');
    die(__('error_export_file_not_found') . ":\n" . implode("\n", $possible_paths));
}

// 2) Include config and initialize language system
// Config dosyasını dahil et ve dil sistemini başlat
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/language_functions.php';

// Check authorization
// Yetki kontrolü
yetkili_mi();

// Initialize language system
// Dil sistemini başlat
initLanguageSystem();

// Set filename with translated text
// Çevirili metinle dosya adını ayarla
$filename = __('account_transactions', 'Hesap Hareketleri') . '_' . date("Y-m-d_H-i-s");

// Set column headers with translations
// Sütun başlıklarını çevirilerle ayarla
$columns = [
    __('date', 'Tarih'),
    __('description', 'Açıklama'),
    __('cash_register', 'Kasa'),
    __('type', 'Tür'),
    __('amount', 'Tutar')
];

// Initialize data array
// Veri dizisini başlat
$data = [];

try {
    // Get transactions with account names
    // Hesap isimleriyle birlikte işlemleri al
    $sql = "SELECT 
                hh.tarih, 
                hh.aciklama, 
                COALESCE(h.hesap_adi, :not_specified) as hesap_adi, 
                hh.tur,
                hh.tutar 
            FROM hesap_hareketleri hh
            LEFT JOIN hesaplar h ON hh.hesap_id = h.id 
            ORDER BY hh.tarih DESC";
    
    $stmt = $db->prepare($sql);
    $stmt->execute(['not_specified' => __('not_specified', 'Belirtilmemiş')]);

    // Format the data for Excel export
    // Excel çıktısı için verileri biçimlendir
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        // Format the transaction type
        // İşlem türünü biçimlendir
        $transactionType = $row['tur'];
        if (isset($lang[$row['tur']])) {
            $transactionType = $lang[$row['tur']];
        }

        $data[] = [
            formatDate($row['tarih']), // Format the date according to language settings
            $row['aciklama'],
            $row['hesap_adi'],
            $transactionType,
            formatNumber($row['tutar'], 2) // Format the number according to language settings
        ];
    }
} catch (Exception $e) {
    // Log the error and show a user-friendly message
    // Hatayı kaydet ve kullanıcı dostu bir mesaj göster
    error_log("Excel export error: " . $e->getMessage());
    header('Content-Type: text/plain; charset=utf-8');
    die(__('database_error', 'Veritabanı hatası: ') . $e->getMessage());
}

// Call the export function with the column for decimal replacement
// Ondalık ayracı değiştirilecek sütun numarasıyla birlikte dışa aktarım fonksiyonunu çağır
$replaceDotCol = [4]; // Tutar sütunu için ondalık ayracını değiştir
exportExcel($filename, $columns, $data, $replaceDotCol);

// script sonu
exit;
?>
