<?php
require_once __DIR__ . '/../includes/config.php';
yetkili_mi(['hesap_yonetimi', 'raporlar']);

// tFPDF kütüphanesini dahil et
require_once __DIR__ . '/tfpdf/tfpdf.php';

// --- Veritabanı İşlemleri Başlangıç ---

// FİLTRELEME PARAMETRELERİNİ AL (hesap_hareketleri.php ile aynı)
$filtre_hesap_id = filter_input(INPUT_GET, 'hesap_id', FILTER_VALIDATE_INT);
$filtre_cari_id = filter_input(INPUT_GET, 'cari_id', FILTER_VALIDATE_INT);
$filtre_baslangic = filter_input(INPUT_GET, 'baslangic', FILTER_SANITIZE_SPECIAL_CHARS);
$filtre_bitis = filter_input(INPUT_GET, 'bitis', FILTER_SANITIZE_SPECIAL_CHARS);
$filtre_tur = filter_input(INPUT_GET, 'tur', FILTER_SANITIZE_SPECIAL_CHARS);

if (!$filtre_baslangic || !preg_match("/^\d{4}-\d{2}-\d{2}$/", $filtre_baslangic)) {
    $filtre_baslangic = date('Y-m-01');
}
if (!$filtre_bitis || !preg_match("/^\d{4}-\d{2}-\d{2}$/", $filtre_bitis)) {
    $filtre_bitis = date('Y-m-d');
}
$filtre_hesap_id = $filtre_hesap_id ?: null;
$filtre_cari_id = $filtre_cari_id ?: null;
$filtre_tur = in_array($filtre_tur, ['giris', 'cikis', 'transfer']) ? $filtre_tur : null;

$aktif_sirket_id = $_SESSION['aktif_sirket_id'] ?? 0;
$sirket_bilgileri = null;
$hareketler = [];

try {
    // Şirket Bilgileri
    $stmt_sirket = $db->prepare("SELECT * FROM sirketler WHERE id = ?");
    $stmt_sirket->execute([$aktif_sirket_id]);
    $sirket_bilgileri = $stmt_sirket->fetch(PDO::FETCH_ASSOC);

    // Filtreler için WHERE koşulları ve parametreler
    $where_clauses = ["hh.sirket_id = :sirket_id", "hh.tarih BETWEEN :baslangic AND DATE_ADD(:bitis, INTERVAL 1 DAY)"];
    $params = [
        ':sirket_id' => $aktif_sirket_id,
        ':baslangic' => $filtre_baslangic,
        ':bitis' => $filtre_bitis
    ];

    if ($filtre_hesap_id) {
        $where_clauses[] = "hh.hesap_id = :hesap_id";
        $params[':hesap_id'] = $filtre_hesap_id;
    }
    if ($filtre_cari_id) {
        $where_clauses[] = "hh.cari_id = :cari_id";
        $params[':cari_id'] = $filtre_cari_id;
    }
    if ($filtre_tur) {
        $where_clauses[] = "hh.tur = :tur";
        $params[':tur'] = $filtre_tur;
    }

    $where_sql = implode(' AND ', $where_clauses);

    // Ana Sorgu
    $sql = "SELECT hh.*, h.hesap_adi, c.ad_soyad as cari_ad_soyad FROM hesap_hareketleri hh LEFT JOIN hesaplar h ON hh.hesap_id = h.id LEFT JOIN cariler c ON hh.cari_id = c.id WHERE $where_sql ORDER BY hh.tarih DESC, hh.id DESC";
    $stmt = $db->prepare($sql);
    $stmt->execute($params);
    $hareketler = $stmt->fetchAll(PDO::FETCH_ASSOC);

} catch (PDOException $e) {
    die("Veritabanı hatası: " . $e->getMessage());
}

// --- Veritabanı İşlemleri Bitiş ---


// --- PDF Sınıfı ve Oluşturma Başlangıç ---

class PDF_Report extends tFPDF
{
    public $sirket_bilgileri;

    function Header()
    {
        if (!empty($this->sirket_bilgileri)) {
            $this->SetFont('DejaVu', 'B', 16);
            $this->Cell(0, 10, $this->sirket_bilgileri['sirket_adi'], 0, 1, 'C');
            $this->SetFont('DejaVu', '', 9);
            $this->Cell(0, 5, 'Hesap Hareketleri Raporu', 0, 1, 'C');
            $this->Ln(5);
        }
    }

    function Footer()
    {
        if (!empty($this->sirket_bilgileri)) {
            $this->SetY(-20);
            $this->SetDrawColor(150, 150, 150);
            $this->Cell(0, 5, '', 'T', 1, 'C');
            $this->SetFont('DejaVu', '', 8);
            $adres = $this->sirket_bilgileri['adres'] ?? '';
            $telefon = $this->sirket_bilgileri['telefon'] ?? '';
            $email = $this->sirket_bilgileri['email'] ?? '';
            $footer_text = trim("$adres | Tel: $telefon | E-posta: $email", ' |');
            $this->Cell(0, 5, $footer_text, 0, 1, 'C');
            $this->Cell(0, 5, 'Sayfa ' . $this->PageNo() . '/{nb}', 0, 0, 'C');
        }
    }
}

$pdf = new PDF_Report();
$pdf->sirket_bilgileri = $sirket_bilgileri;
$pdf->AddFont('DejaVu', '', 'DejaVuSans.ttf', true);
$pdf->AddFont('DejaVu', 'B', 'DejaVuSans-Bold.ttf', true);
$pdf->AliasNbPages();
$pdf->AddPage('L', 'A4'); // Yatay sayfa

// Rapor Başlığı ve Filtre Bilgileri
$pdf->SetFont('DejaVu', 'B', 14);
$pdf->Cell(0, 10, 'HESAP HAREKETLERİ', 0, 1, 'C');
$pdf->SetFont('DejaVu', '', 9);
$pdf->Cell(0, 6, 'Tarih Aralığı: ' . date('d.m.Y', strtotime($filtre_baslangic)) . ' - ' . date('d.m.Y', strtotime($filtre_bitis)), 0, 1, 'C');
$pdf->Ln(5);

// Tablo Başlıkları
$pdf->SetFont('DejaVu', 'B', 10);
$pdf->SetFillColor(230, 230, 230);
$pdf->Cell(25, 7, 'Tarih', 1, 0, 'C', true);
$pdf->Cell(50, 7, 'Hesap', 1, 0, 'C', true);
$pdf->Cell(20, 7, 'Tür', 1, 0, 'C', true);
$pdf->Cell(85, 7, 'Açıklama', 1, 0, 'C', true);
$pdf->Cell(50, 7, 'Cari', 1, 0, 'C', true);
$pdf->Cell(25, 7, 'Giriş', 1, 0, 'C', true);
$pdf->Cell(25, 7, 'Çıkış', 1, 1, 'C', true);

// Tablo İçeriği
$pdf->SetFont('DejaVu', '', 9);
$toplam_giris = 0;
$toplam_cikis = 0;

if (empty($hareketler)) {
    $pdf->Cell(280, 10, 'Bu kriterlere uygun hareket bulunamadı.', 1, 1, 'C');
} else {
    foreach ($hareketler as $hareket) {
        $giris = 0;
        $cikis = 0;
        if ($hareket['tur'] == 'giris') {
            $giris = $hareket['tutar'];
            $toplam_giris += $giris;
        } elseif ($hareket['tur'] == 'cikis') {
            $cikis = $hareket['tutar'];
            $toplam_cikis += $cikis;
        }

        $x = $pdf->GetX();
        $y = $pdf->GetY();
        
        // Tarih hücresi
        $pdf->MultiCell(25, 7, date('d.m.Y', strtotime($hareket['tarih'])), 1, 'L', 0, 0, $x, $y);
        $x += 25;
        
        // Hesap adı hücresi
        $pdf->SetXY($x, $y);
        $pdf->MultiCell(50, 7, $hareket['hesap_adi'], 1, 'L', 0, 0, $x, $y);
        $x += 50;
        
        // Tür hücresi
        $pdf->SetXY($x, $y);
        $pdf->MultiCell(20, 7, ucfirst($hareket['tur']), 1, 'L', 0, 0, $x, $y);
        $x += 20;
        
        // Açıklama hücresi (MultiCell kullanarak çok satırlı destek)
        $pdf->SetXY($x, $y);
        $aciklama = iconv('UTF-8', 'UTF-8//TRANSLIT', $hareket['aciklama']);
        // Açıklama metninin kaç satır olacağını hesapla
        $aciklama_satir_sayisi = ceil($pdf->GetStringWidth($hareket['aciklama']) / 85 * 1.2); // Yaklaşık satır sayısı
        $aciklama_satir_sayisi = max(1, $aciklama_satir_sayisi); // En az 1 satır
        $h = $aciklama_satir_sayisi * 7; // Her satır 7 birim yüksekliğinde
        
        $pdf->MultiCell(85, 7, $hareket['aciklama'], 1, 'L', 0, 0, $x, $y);
        $x += 85;
        
        // Cari adı hücresi
        $pdf->SetXY($x, $y);
        $pdf->MultiCell(50, 7, $hareket['cari_ad_soyad'] ?: '-', 1, 'L', 0, 0, $x, $y);
        $x += 50;
        
        // Giriş hücresi
        $pdf->SetXY($x, $y);
        $pdf->MultiCell(25, 7, $giris > 0 ? number_format($giris, 2, ',', '.') : '-', 1, 'R', 0, 0, $x, $y);
        $x += 25;
        
        // Çıkış hücresi
        $pdf->SetXY($x, $y);
        $pdf->MultiCell(25, 7, $cikis > 0 ? number_format($cikis, 2, ',', '.') : '-', 1, 'R', 0, 0, $x, $y);
        
        // Sonraki satıra geç
        $pdf->SetY($y + $h); // Hesaplanan yükseklik kadar aşağı in
    }
}

// Toplamlar
$pdf->SetFont('DejaVu', 'B', 10);
$pdf->Cell(230, 8, 'TOPLAMLAR', 1, 0, 'R');
$pdf->Cell(25, 8, number_format($toplam_giris, 2, ',', '.'), 1, 0, 'R');
$pdf->Cell(25, 8, number_format($toplam_cikis, 2, ',', '.'), 1, 1, 'R');

$net_bakiye = $toplam_giris - $toplam_cikis;
$pdf->Cell(230, 8, 'NET BAKİYE', 1, 0, 'R');
$pdf->Cell(50, 8, number_format($net_bakiye, 2, ',', '.'), 1, 1, 'R');

$pdf->Output('I', 'hesap-hareketleri-raporu.pdf');

// --- PDF Sınıfı ve Oluşturma Bitiş ---
?>
