// DÖVİZ VE PARA BİRİMİ İŞLEMLERİ ORTAK MODÜLÜ

// Kur çekme fonksiyonu (global)
window.fetchKur = async function(from, to) {
    // TL/TRY dönüşümü için özel kontrol
    if ((from === 'TL' || from === 'TRY') && (to === 'TL' || to === 'TRY')) {
        console.log('TL/TRY dönüşümü için kur 1.0 olarak ayarlandı');
        return 1.0;
    }
    
    // Aynı para birimleri için 1.0 döndür
    if (from === to) {
        console.log(`Aynı para birimleri (${from}), kur 1.0 olarak ayarlandı`);
        return 1.0;
    }
    
    // TL/TRY dönüşümü için isimlendirmeyi standartlaştır
    const fromCode = (from === 'TL') ? 'TRY' : from;
    const toCode = (to === 'TL') ? 'TRY' : to;
    
    console.log(`Kur isteniyor: ${fromCode} -> ${toCode}`);

    // Harici istek yerine sayfaya gömülü veritabanı kurlarını kullan
    try {
        const kurlar = (typeof window.dovizKurlari !== 'undefined' && Array.isArray(window.dovizKurlari)) ? window.dovizKurlari : [];
        // dizi -> harita dönüştür (para_birimi -> {alis,satis})
        const map = {};
        kurlar.forEach(k => {
            if (!k || !k.para_birimi) return;
            const kod = String(k.para_birimi).toUpperCase();
            map[kod] = {
                alis: parseFloat(k.alis || k.buying || 0) || 0,
                satis: parseFloat(k.satis || k.selling || 0) || 0,
                guncelleme_tarihi: k.guncelleme_tarihi || k.updated || k.date || null,
            };
        });

        // TRY kurlarını 1.0 olarak ata
        if (!map.TRY) map.TRY = { alis: 1.0, satis: 1.0 };
        if (!map.TL) map.TL = map.TRY;

        const fromKur = map[fromCode];
        const toKur = map[toCode];

        if (!fromKur || !toKur) {
            console.warn(`Kur bulunamadı: from=${fromCode}, to=${toCode}. Varsayılan 1.0 kullanılacak.`);
            return 1.0;
        }

        // A->B kuru: (A->TRY) / (B->TRY)
        const aToTry = parseFloat(fromKur.satis || 0) || 0;
        const bToTry = parseFloat(toKur.satis || 0) || 0;

        if (aToTry > 0 && bToTry > 0) {
            const rate = aToTry / bToTry;
            console.log(`Kur hesaplandı (DB): 1 ${fromCode} = ${rate} ${toCode}`);
            return rate;
        }

        console.warn(`Geçersiz kur değerleri (A->TRY=${aToTry}, B->TRY=${bToTry}), varsayılan 1.0.`);
        return 1.0;
    } catch (error) {
        console.error('Kur hesaplanırken hata oluştu (DB):', error);
        return 1.0;
    }
};

// Döviz kurları kutusunu güncelleyen fonksiyon
window.dovizKurlariGuncelle = function() {
    const loading = document.getElementById('dovizKurlariLoading');
    const list = document.getElementById('dovizKurlariList');
    const tarih = document.getElementById('dovizKurlariTarih');
    
    if (!loading || !list || !tarih) {
        console.error('Döviz kuru güncelleme elemanları bulunamadı:', { loading, list, tarih });
        return;
    }

    console.log('Döviz kurları (DB) güncelleniyor...');
    loading.style.display = 'block';
    list.innerHTML = 'Kurlar yükleniyor...';

    try {
        const kurlar = (typeof window.dovizKurlari !== 'undefined' && Array.isArray(window.dovizKurlari)) ? window.dovizKurlari : [];
        const map = {};
        kurlar.forEach(k => {
            if (!k || !k.para_birimi) return;
            const kod = String(k.para_birimi).toUpperCase();
            map[kod] = {
                alis: parseFloat(k.alis || k.buying || 0) || 0,
                satis: parseFloat(k.satis || k.selling || 0) || 0,
                guncelleme_tarihi: k.guncelleme_tarihi || null,
            };
        });

        // Görüntülenecek para birimleri
        const paraBirimleri = ['USD', 'EUR', 'GBP'];
        let html = '';
        paraBirimleri.forEach(kod => {
            const item = map[kod];
            if (item && item.satis > 0) {
                html += `<div><strong>${kod}/TL:</strong> ${item.satis.toLocaleString('tr-TR', {minimumFractionDigits: 4, maximumFractionDigits: 4})}</div>`;
            } else {
                html += `<div class="text-warning">${kod}: Kur bilgisi yok</div>`;
            }
        });

        list.innerHTML = html || '<div class="text-warning">Kur bilgisi bulunamadı</div>';
        const tarihler = kurlar.map(k => k.guncelleme_tarihi).filter(Boolean);
        const guncellemeTarihi = tarihler.length ? tarihler[0] : new Date().toLocaleString('tr-TR');
        tarih.textContent = 'Güncelleme: ' + guncellemeTarihi;

        console.log('Döviz kurları (DB) başarıyla güncellendi');
    } catch (error) {
        console.error('Döviz kurları hazırlanırken hata oluştu (DB):', error);
        list.innerHTML = `<span class="text-danger">Hata: ${error.message || 'Bilinmeyen hata'}</span>`;
    } finally {
        loading.style.display = 'none';
        console.log('Döviz kuru güncelleme işlemi tamamlandı');
    }
};

// Fatura para birimi değiştiğinde kurları ve toplamları güncelleyen fonksiyon
window.handleFaturaParaBirimiChange = async function() {
    const yeniParaBirimi = this.value;
    const isMultiCurrency = typeof cokluParaBirimiAktif !== 'undefined' && cokluParaBirimiAktif;

    // 1. Toplam alanlarındaki para birimi etiketlerini güncelle
    const araToplamParaBirimi = document.getElementById('araToplamParaBirimi');
    const toplamKdvParaBirimi = document.getElementById('toplamKdvParaBirimi');
    const genelToplamParaBirimi = document.getElementById('genelToplamParaBirimi');
    
    if (araToplamParaBirimi) araToplamParaBirimi.textContent = ' ' + yeniParaBirimi;
    if (toplamKdvParaBirimi) toplamKdvParaBirimi.textContent = ' ' + yeniParaBirimi;
    if (genelToplamParaBirimi) genelToplamParaBirimi.textContent = ' ' + yeniParaBirimi;

    // 2. Her satırın kurunu yeni para birimine göre güncelle
    const promises = [];
    document.querySelectorAll('#urunListesi tr').forEach(row => {
        const alisParaBirimiInput = row.querySelector('input[name="alis_para_birimi[]"]');
        const kurInput = row.querySelector('input[name="kur[]"]');
        if (!alisParaBirimiInput || !kurInput) return;

        const alisParaBirimi = alisParaBirimiInput.value;
        if (alisParaBirimi === yeniParaBirimi) {
            kurInput.value = (1.0).toFixed(4);
            kurInput.readOnly = true;
        } else {
            kurInput.readOnly = false;
            const promise = window.fetchKur(alisParaBirimi, yeniParaBirimi)
                .then(yeniKur => {
                    kurInput.value = yeniKur.toFixed(4);
                });
            promises.push(promise);
        }
    });

    // 3. Tüm kur istekleri tamamlandıktan sonra genel toplamı güncelle
    await Promise.all(promises);
    if (typeof window.genelToplamGuncelle === 'function') window.genelToplamGuncelle();
};

// Sayfa yüklendiğinde döviz kurlarını getir
document.addEventListener('DOMContentLoaded', function() {
    if (typeof window.dovizKurlariGuncelle === 'function') {
        window.dovizKurlariGuncelle();
    }
});
