// Stok/Ürün arama ve seçim işlemleri merkezi script

document.addEventListener('DOMContentLoaded', function() {
    const urunAramaInput = document.getElementById('urunArama');
    const tedarikciFiltre = document.getElementById('tedarikciFiltre');
    if(urunAramaInput) urunAramaInput.addEventListener('input', urunAra);
    if(tedarikciFiltre) tedarikciFiltre.addEventListener('change', urunAra);
    
    // Modal açıldığında focus
    const urunSecModalEl = document.getElementById('urunSecModal');
    if(urunSecModalEl) {
        urunSecModalEl.addEventListener('shown.bs.modal', function () {
            document.getElementById('urunArama').focus();
            // Modal açıldığında tedarikçi filtresi varsa otomatik arama yap
            if(tedarikciFiltre && tedarikciFiltre.value) {
                urunAra();
            }
        });
    }
});

function urunAra() {
    const arama = document.getElementById('urunArama').value;
    const tedarikci_id = document.getElementById('tedarikciFiltre') ? document.getElementById('tedarikciFiltre').value : '';
    const urunSonuclari = document.getElementById('urunSonuclari');

    // Tedarikçi seçilmişse veya arama yapılıyorsa sonuçları göster
    if (arama.length < 2 && !tedarikci_id) {
        urunSonuclari.innerHTML = '';
        return;
    }

    const formData = new FormData();
    formData.append('arama', arama);
    formData.append('tedarikci_id', tedarikci_id);

    // AJAX yolunu otomatik bulmak için:
    let ajaxUrl = 'ajax/urun_ara_ajax.php';
    if (window.location.pathname.includes('/views/')) {
        ajaxUrl = '../ajax/urun_ara_ajax.php';
    }
    fetch(ajaxUrl, {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        let html = '<div class="list-group">';
        if (data.success && data.urunler.length > 0) {
            data.urunler.forEach(urun => {
                const adi = urun.urun_adi.replace(/'/g, "\\'").replace(/"/g, "&quot;");
                // Sayfanın 'alis_yeni.php' olup olmadığını kontrol et
                const isPurchasePage = window.location.pathname.endsWith('alis_yeni.php');
                const fiyat = isPurchasePage ? (urun.alis_fiyati || 0) : (urun.satis_fiyati || 0);
                const paraBirimi = isPurchasePage 
                    ? (urun.alis_para_birimi || (window.initialFaturaParaBirimi || 'TL')) 
                    : (urun.satis_para_birimi || (window.initialFaturaParaBirimi || 'TL'));
                html += `<a href="#" class="list-group-item list-group-item-action" onclick="event.preventDefault(); window.urunSec(${urun.id}, '${adi}', ${fiyat}, ${urun.kdv_orani || 0}, '${paraBirimi}')">
                    ${urun.urun_adi} <span class="float-end">${parseFloat(fiyat).toFixed(2)} ${paraBirimi}</span>
                 </a>`;
            });
        } else {
            html += '<div class="list-group-item text-muted">Ürün bulunamadı.</div>';
        }
        html += '</div>';
        urunSonuclari.innerHTML = html;
    });
}

// Otomatik kur getirme fonksiyonu
window.otomatikKurGetir = async function(button) {
    const row = button.closest('tr');
    const paraBirimi = row.querySelector('input[name^="satis_para_birimi"]').value;
    const faturaParaBirimi = document.getElementById('fatura_para_birimi')?.value || (window.initialFaturaParaBirimi || 'TL');
    
    if (paraBirimi === faturaParaBirimi) {
        alert('Fatura para birimi ile ürün para birimi aynı, kur hesaplaması yapılamaz.');
        return;
    }
    
    const spinner = document.createElement('span');
    spinner.className = 'spinner-border spinner-border-sm me-1';
    button.disabled = true;
    button.innerHTML = '';
    button.appendChild(spinner);
    
    try {
        const kur = await window.fetchKur(paraBirimi, faturaParaBirimi);
        const kurInput = row.querySelector('.kur-input');
        const hiddenKurInput = row.querySelector('.kur');
        
        kurInput.value = kur.toFixed(4);
        hiddenKurInput.value = kur;
        
        // Satırı güncelle
        satirGuncelle(button);
    } catch (error) {
        console.error('Kur alınırken hata oluştu:', error);
        alert('Kur alınırken bir hata oluştu. Lütfen tekrar deneyin.');
    } finally {
        button.innerHTML = '<i class="bi bi-arrow-repeat"></i>';
        button.disabled = false;
    }
};

// Fonksiyonu global yap!
window.urunSec = async function(id, adi, fiyat, kdvOrani, paraBirimi = (window.initialFaturaParaBirimi || 'TL')) {
    // Ürünün zaten ekli olup olmadığını kontrol et
    let isAdded = false;
    for (const input of document.querySelectorAll('input[name="urun_id[]"]')) {
        if (input.value == id) {
            isAdded = true;
            // Miktarı artır
            const existingRow = input.closest('tr');
            const miktarInput = existingRow.querySelector('.miktar');
            miktarInput.value = parseInt(miktarInput.value) + 1;
            await satirGuncelle(miktarInput);
        }
    }
    if (isAdded) return;

    // Yeni satır ekle
    if (typeof urunSayaci === 'undefined') window.urunSayaci = 0;
    urunSayaci++;
    const tbody = document.getElementById('urunListesi');
    const placeholderRow = document.getElementById('placeholder-row');
    if (placeholderRow) {
        placeholderRow.style.display = 'none';
    }
    
    // Çoklu para birimi aktif mi kontrol et
    const cokluParaBirimiAktif = document.getElementById('coklu_para_birimi_aktif') ? 
        document.getElementById('coklu_para_birimi_aktif').value === '1' : false;
    
    // Teklif para birimini al (fatura_para_birimi veya teklif_para_birimi)
    const teklifParaBirimi = document.getElementById('teklif_para_birimi') ? 
        document.getElementById('teklif_para_birimi').value : 
        (document.getElementById('fatura_para_birimi') ? 
        document.getElementById('fatura_para_birimi').value : (window.initialFaturaParaBirimi || 'TL'));
        
    // Döviz kuru hesapla (sadece çoklu para birimi aktifse)
    let kur = 1.0;
    if (cokluParaBirimiAktif && paraBirimi !== teklifParaBirimi) {
        try {
            kur = await window.fetchKur(paraBirimi, teklifParaBirimi);
        } catch (error) {
            console.error('Döviz kuru alınırken hata oluştu:', error);
            kur = 1.0;
        }
    }
    
    // Yeni satır oluştur
    const newRow = tbody.insertRow();
    newRow.id = `urun_satir_${urunSayaci}`;
    newRow.classList.add('urun-satiri');
    
    // Sıra numarasını al (mevcut satır sayısı, çünkü yeni satır henüz eklenmedi)
    const siraNo = tbody.querySelectorAll('tr.urun-satiri').length;
    
    // Tablo hücrelerini oluştur
    let rowHtml = `
        <td class="align-middle text-center fw-bold">${siraNo}</td>
        <td class="align-middle">${adi}<input type="hidden" name="urun_id[]" value="${id}"></td>
        <td><input type="text" class="form-control form-control-sm miktar text-end" name="miktar[]" value="1" oninput="satirGuncelle(this)" inputmode="decimal"></td>
        <td><input type="text" class="form-control form-control-sm fiyat text-end" name="birim_fiyat[]" value="${fiyat.toFixed(2).replace('.', ',')}" oninput="satirGuncelle(this)" inputmode="decimal"></td>`;
    
    // Çoklu para birimi aktifse para birimi sütununu göster
    if (cokluParaBirimiAktif) {
        rowHtml += `
        <td class="align-middle fw-bold">${paraBirimi}<input type="hidden" name="satis_para_birimi[]" value="${paraBirimi}"></td>`;
    } else {
        // Çoklu para birimi aktif değilse gizli para birimi alanı ekle
        rowHtml += `
        <input type="hidden" name="satis_para_birimi[]" value="${teklifParaBirimi}">`;
    }
    
    // Çoklu para birimi aktifse kur sütunlarını ekle
    if (cokluParaBirimiAktif) {
        rowHtml += `
        <td class="align-middle">
            <div class="input-group input-group-sm">
                <input type="text" class="form-control form-control-sm text-end kur-input" value="${kur.toFixed(4)}" onchange="this.nextElementSibling.value=this.value; satirGuncelle(this)">
                <input type="hidden" class="kur" name="kur[]" value="${kur}">
                <button type="button" class="btn btn-outline-secondary btn-sm" onclick="otomatikKurGetir(this)" title="Otomatik Kur Getir">
                    <i class="bi bi-arrow-repeat"></i>
                </button>
            </div>
        </td>`;
    } else {
        // Çoklu para birimi aktif değilse gizli kur alanı ekle
        rowHtml += `
        <input type="hidden" class="kur" name="kur[]" value="1.0">`;
    }
    
    // Diğer hücreleri ekle
    rowHtml += `
        <td><input type="text" class="form-control form-control-sm kdv text-end" name="kdv_orani[]" value="${kdvOrani}" oninput="satirGuncelle(this)" inputmode="decimal"></td>
        <td class="align-middle text-end kdv-tutar">0,00</td>
        <td class="align-middle text-end fw-bold satir-toplam">0,00</td>
        <td class="align-middle text-center">
            <a href="#" class="btn btn-danger btn-sm btn-icon" onclick="event.preventDefault(); urunSil(this)" title="Sil">
                <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-trash" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                   <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                   <path d="M4 7l16 0"></path>
                   <path d="M10 11l0 6"></path>
                   <path d="M14 11l0 6"></path>
                   <path d="M5 7l1 12a2 2 0 0 0 2 2h8a2 2 0 0 0 2 -2l1 -12"></path>
                   <path d="M9 7v-3a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v3"></path>
                </svg>
            </a>
        </td>`;
    
    newRow.innerHTML = rowHtml;
    
    // Satırı güncelle
    satirGuncelle(newRow.querySelector('.miktar'));
    
    // Update product count after adding a new product
    if (typeof urunAdediGuncelle === 'function') {
        urunAdediGuncelle();
    } else if (typeof genelToplamGuncelle === 'function') {
        // Eğer urunAdediGuncelle fonksiyonu yoksa, genelToplamGuncelle'yi çağır
        genelToplamGuncelle();
    }
    
    // Sadece arama kutusunu temizle, modalı kapatma
    document.getElementById('urunArama').value = '';
    document.getElementById('urunArama').focus(); // Odağı arama kutusuna ver
    document.getElementById('urunSonuclari').innerHTML = '';
}
