<?php
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/guvenlik_kontrol.php';
require_once __DIR__ . '/../functions/log_fonksiyonlari.php'; // islem_tipi_aciklama ve tablo_adi_aciklama için eklendi
require_once __DIR__ . '/../functions/yardimci_fonksiyonlar.php'; // temizle fonksiyonu için eklendi

$sayfa_baslik = __("log_records");

// Yetki kontrolü - loglar sayfasına erişim
yetki_kontrol_ve_yonlendir('loglar', 'goruntule');

// Filtreleme parametreleri
$filtreler = [];
$sayfa = isset($_GET['sayfa']) ? max(1, intval($_GET['sayfa'])) : 1;
$limit = 50;
$offset = ($sayfa - 1) * $limit;

// Filtreleri al
if (!empty($_GET['kullanici_id'])) {
    $filtreler['kullanici_id'] = intval($_GET['kullanici_id']);
}
if (!empty($_GET['islem_tipi'])) {
    $filtreler['islem_tipi'] = $_GET['islem_tipi'];
}
if (!empty($_GET['tablo_adi'])) {
    $filtreler['tablo_adi'] = $_GET['tablo_adi'];
}
if (!empty($_GET['baslangic_tarihi'])) {
    $filtreler['baslangic_tarihi'] = $_GET['baslangic_tarihi'];
}
if (!empty($_GET['bitis_tarihi'])) {
    $filtreler['bitis_tarihi'] = $_GET['bitis_tarihi'];
}

// Geri alma işlemi
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['geri_al']) && isset($_POST['silinen_kayit_id'])) {
    if (silinen_kayit_geri_al($db, intval($_POST['silinen_kayit_id']))) {
        $_SESSION['mesaj'] = __("record_restored_successfully");
    } else {
        $_SESSION['hata'] = __("error_restoring_record");
    }
    header("Location: loglar.php");
    exit();
}

// Log kayıtlarını getir
$log_kayitlari = log_kayitlari_getir($db, $filtreler, $limit, $offset);
$toplam_kayit = log_kayit_sayisi_getir($db, $filtreler);
$toplam_sayfa = ceil($toplam_kayit / $limit);

// Kullanıcıları getir (filtre için)
$stmt = $db->prepare("SELECT id, ad_soyad FROM kullanicilar ORDER BY ad_soyad");
$stmt->execute();
$kullanicilar = $stmt->fetchAll();

// İşlem türleri (yeni eklenen 'donusturme' tipi de dahil edildi)
$islem_turleri = [
    'ekle', 'guncelle', 'sil', 'geri_al', 'giris', 'cikis', 'basarisiz_giris',
    'transfer_cikis', 'transfer_giris', 'transfer', 'donusturme'
];

// Tablo adları (yeni eklenen 'teklifler' tablosu da dahil edildi)
$tablo_adlari = ['urunler', 'cariler', 'hesaplar', 'kategoriler', 'borclar', 'teklifler', 'hesap_hareketleri', 'kullanicilar', 'fatura_detaylari'];

/**
 * Log gösterimi için özel metin ve renk belirler.
 */
function getLogDisplayInfo($log) {
    $islem_tipi = $log['islem_tipi'];
    $tablo_adi = $log['tablo_adi'];
    $aciklama = $log['aciklama'];

    $metin = islem_tipi_aciklama($islem_tipi);
    $renk_sinifi = 'dark';

    switch ($islem_tipi) {
        case 'ekle':
            if ($tablo_adi == 'teklifler') {
                $metin = 'Teklif Oluşturma';
                $renk_sinifi = 'primary';
            } elseif ($tablo_adi == 'borclar' && strpos($aciklama, 'satış faturası') !== false) {
                $metin = 'Satış Faturası';
                $renk_sinifi = 'success';
            } elseif ($tablo_adi == 'borclar' && strpos($aciklama, 'alış faturası') !== false) {
                $metin = 'Alış Faturası';
                $renk_sinifi = 'warning text-dark';
            } else {
                $metin = tablo_adi_aciklama($tablo_adi) . ' Ekleme';
                $renk_sinifi = 'success';
            }
            break;
        case 'guncelle':
            $metin = tablo_adi_aciklama($tablo_adi) . ' Güncelleme';
            $renk_sinifi = 'warning text-dark';
            break;
        case 'sil':
            $metin = tablo_adi_aciklama($tablo_adi) . ' Silme';
            $renk_sinifi = 'danger';
            break;
        case 'donusturme':
            if ($tablo_adi == 'teklifler') {
                $metin = 'Teklif Dönüştürme';
                $renk_sinifi = 'info text-dark';
            }
            break;
        case 'giris': $renk_sinifi = 'primary'; break;
        case 'cikis': $renk_sinifi = 'secondary'; break;
        case 'basarisiz_giris': $renk_sinifi = 'danger'; break;
        case 'geri_al': $renk_sinifi = 'info text-dark'; break;
        case 'transfer_cikis': $renk_sinifi = 'warning text-dark'; break;
        case 'transfer_giris': $renk_sinifi = 'success'; break;
        case 'transfer': $renk_sinifi = 'primary'; break;
    }
    
    return ['metin' => $metin, 'renk_sinifi' => $renk_sinifi];
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Odjoo Yönetim - <?= temizle($sayfa_baslik) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <style>
        .log-details {
            font-size: 0.85em;
            white-space: nowrap; /* Metni tek satırda tut */
            overflow: hidden; /* Taşmayı gizle */
            text-overflow: ellipsis; /* Taşma durumunda üç nokta göster */
        }
        .log-json {
            background: #f8f9fa;
            border: 1px solid #dee2e6;
            border-radius: 4px;
            padding: 8px;
            font-family: monospace;
            font-size: 0.8em;
            max-height: 150px; /* Biraz artırıldı */
            overflow-y: auto;
            word-wrap: break-word; /* Uzun kelimeleri kırmak için */
        }
    </style>
</head>
<body>
    <?php include __DIR__ . '/../includes/navbar.php'; ?>

    <div class="container mt-4">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2><i class="bi bi-journal-text"></i> <?= temizle($sayfa_baslik) ?></h2>
        </div>

        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0"><i class="bi bi-funnel"></i> <?= __("filters") ?></h5>
            </div>
            <div class="card-body">
                <form method="GET" class="row g-3">
                    <div class="col-md-3">
                        <label for="kullanici_id" class="form-label"><?= __("user") ?></label>
                        <select class="form-select" id="kullanici_id" name="kullanici_id">
                            <option value=""><?= __("all") ?></option>
                            <?php foreach ($kullanicilar as $kullanici): ?>
                                <option value="<?= $kullanici['id'] ?>" <?= isset($filtreler['kullanici_id']) && $filtreler['kullanici_id'] == $kullanici['id'] ? 'selected' : '' ?>>
                                    <?= temizle($kullanici['ad_soyad']) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label for="islem_tipi" class="form-label"><?= __("operation_type") ?></label>
                        <select class="form-select" id="islem_tipi" name="islem_tipi">
                            <option value=""><?= __("all") ?></option>
                            <?php foreach ($islem_turleri as $tur): ?>
                                <option value="<?= $tur ?>" <?= isset($filtreler['islem_tipi']) && $filtreler['islem_tipi'] == $tur ? 'selected' : '' ?>>
                                    <?= islem_tipi_aciklama($tur) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label for="tablo_adi" class="form-label"><?= __("table") ?></label>
                        <select class="form-select" id="tablo_adi" name="tablo_adi">
                            <option value=""><?= __("all") ?></option>
                            <?php foreach ($tablo_adlari as $tablo): ?>
                                <option value="<?= $tablo ?>" <?= isset($filtreler['tablo_adi']) && $filtreler['tablo_adi'] == $tablo ? 'selected' : '' ?>>
                                    <?= tablo_adi_aciklama($tablo) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label for="baslangic_tarihi" class="form-label"><?= __("start_date") ?></label>
                        <input type="date" class="form-control" id="baslangic_tarihi" name="baslangic_tarihi" 
                               value="<?= $filtreler['baslangic_tarihi'] ?? '' ?>">
                    </div>
                    <div class="col-md-3">
                        <label for="bitis_tarihi" class="form-label"><?= __("end_date") ?></label>
                        <input type="date" class="form-control" id="bitis_tarihi" name="bitis_tarihi" 
                               value="<?= $filtreler['bitis_tarihi'] ?? '' ?>">
                    </div>
                    <div class="col-md-3 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary me-2">
                            <i class="bi bi-search"></i> Filtrele
                        </button>
                        <a href="loglar.php" class="btn btn-secondary">
                            <i class="bi bi-x-circle"></i> Temizle
                        </a>
                    </div>
                </form>
            </div>
        </div>

        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0"><?= __("log_records") ?> (<?= number_format($toplam_kayit) ?> <?= __("records") ?>)</h5>
            </div>
            <div class="card-body p-0">
                <?php if (!empty($log_kayitlari)): ?>
                    <div class="table-responsive">
                        <table class="table table-striped table-hover mb-0">
                            <thead class="table-dark">
                                <tr>
                                    <th><?= __("date_time") ?></th>
                                    <th><?= __("user") ?></th>
                                    <th><?= __("operation") ?></th>
                                    <th><?= __("table") ?></th>
                                    <th><?= __("record_id") ?></th>
                                    <th><?= __("description") ?></th>
                                    <th><?= __("ip_address") ?></th>
                                    <th><?= __("actions") ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($log_kayitlari as $log): ?>
                                    <tr>
                                        <td>
                                            <small><?= date('d.m.Y H:i:s', strtotime($log['olusturulma_tarihi'])) ?></small>
                                        </td>
                                        <td>
                                            <?= $log['kullanici_adi'] ? temizle($log['kullanici_adi']) : '<span class="text-muted">Sistem</span>' ?>
                                        </td>
                                        <td>
                                            <?php $displayInfo = getLogDisplayInfo($log); ?>
                                            <span class="badge bg-<?= $displayInfo['renk_sinifi'] ?>"><?= $displayInfo['metin'] ?></span>
                                        </td>
                                        <td>
                                            <?= $log['tablo_adi'] ? tablo_adi_aciklama($log['tablo_adi']) : '-' ?>
                                        </td>
                                        <td>
                                            <?= $log['kayit_id'] ?? '-' ?>
                                        </td>
                                        <td class="log-details" title="<?= temizle($log['aciklama']) ?>">
                                            <?= temizle($log['aciklama']) ?>
                                        </td>
                                        <td>
                                            <small><?= temizle($log['ip_adresi']) ?></small>
                                        </td>
                                        <td>
                                            <div class="btn-group btn-group-sm">
                                                <button type="button" class="btn btn-outline-info btn-sm" 
                                                        data-bs-toggle="modal" data-bs-target="#detayModal<?= $log['id'] ?>">
                                                    <i class="bi bi-eye"></i> <?= __("view") ?>
                                                </button>
                                                <?php if ($log['islem_tipi'] == 'sil' && !empty($log['eski_deger']) && !$log['geri_alindi']): ?>
                                                    <form method="POST" class="d-inline" onsubmit="return confirm('<?= __("confirm_restore_record") ?>')">
                                                        <input type="hidden" name="silinen_kayit_id" value="<?= $log['id'] ?>">
                                                        <button type="submit" name="geri_al" class="btn btn-outline-success btn-sm" title="Geri Al">
                                                            <i class="bi bi-arrow-counterclockwise"></i> <?= __("restore") ?>
                                                        </button>
                                                    </form>
                                                <?php elseif ($log['islem_tipi'] == 'sil' && $log['geri_alindi']): ?>
                                                    <span class="badge bg-success"><?= __("restored") ?></span>
                                                <?php elseif ($log['islem_tipi'] == 'sil' && empty($log['eski_deger'])): ?>
                                                    <span class="badge bg-warning text-dark"><?= __("no_restore_info") ?></span>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>

                                    <div class="modal fade" id="detayModal<?= $log['id'] ?>" tabindex="-1">
                                        <div class="modal-dialog modal-lg">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title"><?= __("log_details") ?></h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <strong><?= __("date_time") ?>:</strong><br>
                                                            <?= date('d.m.Y H:i:s', strtotime($log['olusturulma_tarihi'])) ?>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <strong><?= __("user") ?>:</strong><br>
                                                            <?= $log['kullanici_adi'] ? temizle($log['kullanici_adi']) : 'Sistem' ?>
                                                        </div>
                                                    </div>
                                                    <hr>
                                                    <div class="row">
                                                        <div class="col-md-4">
                                                            <strong><?= __("operation_type") ?>:</strong><br>
                                                            <?= islem_tipi_aciklama($log['islem_tipi']) ?>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <strong><?= __("table") ?>:</strong><br>
                                                            <?= $log['tablo_adi'] ? tablo_adi_aciklama($log['tablo_adi']) : '-' ?>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <strong><?= __("record_id") ?>:</strong><br>
                                                            <?= $log['kayit_id'] ?? '-' ?>
                                                        </div>
                                                    </div>
                                                    <hr>
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <strong><?= __("ip_address") ?>:</strong><br>
                                                            <?= temizle($log['ip_adresi']) ?>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <strong><?= __("user_agent") ?>:</strong><br>
                                                            <small><?= temizle($log['user_agent']) ?></small>
                                                        </div>
                                                    </div>
                                                    <?php if ($log['aciklama']): ?>
                                                        <hr>
                                                        <strong><?= __("description") ?>:</strong><br>
                                                        <?= temizle($log['aciklama']) ?>
                                                    <?php endif; ?>
                                                    <?php if ($log['eski_deger']): ?>
                                                        <hr>
                                                        <strong><?= __("old_values") ?>:</strong>
                                                        <div class="log-json"><?= temizle($log['eski_deger']) ?></div>
                                                    <?php endif; ?>
                                                    <?php if ($log['yeni_deger']): ?>
                                                        <hr>
                                                        <strong><?= __("new_values") ?>:</strong>
                                                        <div class="log-json"><?= temizle($log['yeni_deger']) ?></div>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>

                    <?php if ($toplam_sayfa > 1): ?>
                        <div class="card-footer">
                            <nav aria-label="Log sayfalama">
                                <ul class="pagination justify-content-center mb-0">
                                    <?php if ($sayfa > 1): ?>
                                        <li class="page-item">
                                            <a class="page-link" href="?<?= http_build_query(array_merge($_GET, ['sayfa' => $sayfa - 1])) ?>"><?= __("previous") ?></a>
                                        </li>
                                    <?php endif; ?>
                                    
                                    <?php for ($i = max(1, $sayfa - 2); $i <= min($toplam_sayfa, $sayfa + 2); $i++): ?>
                                        <li class="page-item <?= $i == $sayfa ? 'active' : '' ?>">
                                            <a class="page-link" href="?<?= http_build_query(array_merge($_GET, ['sayfa' => $i])) ?>"><?= $i ?></a>
                                        </li>
                                    <?php endfor; ?>
                                    
                                    <?php if ($sayfa < $toplam_sayfa): ?>
                                        <li class="page-item">
                                            <a class="page-link" href="?<?= http_build_query(array_merge($_GET, ['sayfa' => $sayfa + 1])) ?>"><?= __("next") ?></a>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </nav>
                        </div>
                    <?php endif; ?>
                <?php else: ?>
                    <div class="text-center py-5">
                        <i class="bi bi-journal-x display-1 text-muted"></i>
                        <h5 class="mt-3"><?= __("no_logs_found") ?></h5>
                        <p class="text-muted"><?= __("no_logs_matching_criteria") ?></p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <?php include __DIR__ . '/../includes/footer.php'; ?>
</body>
</html>
