<?php
require_once __DIR__ . '/../includes/config.php';
yetkili_mi();

$sayfa_baslik = __("make_payment");
$aktif_sirket_id = $_SESSION['aktif_sirket_id'] ?? 0;

// Form gönderildiğinde
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (!csrf_token_dogrula($_POST['csrf_token'] ?? '')) {
        $_SESSION['hata'] = __("invalid_form_submission");
        header("Location: odeme_yap.php");
        exit();
    }

    // Form verilerini al
    $cari_id = filter_input(INPUT_POST, 'cari_id', FILTER_VALIDATE_INT); // Tedarikçi
    $hesap_id = filter_input(INPUT_POST, 'hesap_id', FILTER_VALIDATE_INT); // Para çıkan hesap
    $tutar_str = str_replace(',', '.', $_POST['tutar'] ?? '0');
    $tutar = filter_var($tutar_str, FILTER_VALIDATE_FLOAT);
    $aciklama = temizle($_POST['aciklama'] ?? '');
    $tarih = filter_input(INPUT_POST, 'tarih', FILTER_SANITIZE_SPECIAL_CHARS);
    $borc_id = filter_input(INPUT_GET, 'borc_id', FILTER_VALIDATE_INT) ?? filter_input(INPUT_POST, 'borc_id', FILTER_VALIDATE_INT);

	
    // Veri doğrulama
    $hatalar = [];
    if (empty($cari_id)) $hatalar[] = __("payment_recipient_required");
    if (empty($hesap_id)) $hatalar[] = __("account_selection_required");
    if ($tutar === false || $tutar <= 0) $hatalar[] = __("valid_payment_amount");
    if (empty($tarih) || !preg_match("/^\d{4}-\d{2}-\d{2}$/", $tarih)) $hatalar[] = __("invalid_date_format");

    // Hesapta yeterli bakiye var mı kontrolü (Kullanıcı isteği üzerine devre dışı bırakıldı)
    /* if (!empty($hesap_id)) {
        $stmt_bakiye = $db->prepare("SELECT bakiye FROM hesaplar WHERE id = ? AND sirket_id = ?");
        $stmt_bakiye->execute([$hesap_id, $aktif_sirket_id]);
        $hesap_bakiye = $stmt_bakiye->fetchColumn();
        
        if ($hesap_bakiye === false || $hesap_bakiye < $tutar) {
            $hatalar[] = "Ödeme yapılacak hesapta yeterli bakiye yok! (Mevcut: ".number_format($hesap_bakiye ?: 0, 2, ',', '.')." " . getParaBirimiSembolu() . ")";
        }
    } */


     if (empty($hatalar)) {
        try {
            $db->beginTransaction();
            $aktif_sirket_id = $_SESSION['aktif_sirket_id'];

            // 1. Hesap bakiyesini düşür
            if (!hesapBakiyeGuncelle($db, $hesap_id, -$tutar)) { // Negatif değer
                 throw new Exception("Hesap bakiyesi güncellenemedi.");
            }

            // 2. Hesap hareketi ekle ('cikis' olarak)
            $hareket_aciklama = "Ödeme: " . $aciklama;
            if (!hesapHareketiEkle($db, $hesap_id, $aktif_sirket_id, 'cikis', $tutar, $hareket_aciklama, $tarih, $cari_id, $borc_id)) {
                throw new Exception("Hesap hareketi eklenemedi.");
            }

            // 3. Cari'ye olan borcumuzu azalt (toplam_alacak azalır)
            if (!cariBakiyeGuncelle($db, $cari_id, 0.0, -$tutar)) { // Alacak azalıyor
                 throw new Exception("Cari bakiyesi güncellenemedi.");
            }

            $db->commit();
            $_SESSION['mesaj'] = "Ödeme başarıyla kaydedildi.";
            if ($borc_id) {
                header("Location: borc_detay.php?id=" . $borc_id);
                exit();
            } else {
                header("Location: odeme_yap.php");
                exit();
            }

        } catch (Exception $e) {
            $db->rollBack();
            error_log("Ödeme yapma hatası: " . $e->getMessage());
            $_SESSION['hata'] = "Ödeme yapılırken bir hata oluştu: " . $e->getMessage();
            $_SESSION['form_verileri_odeme_yap'] = $_POST;
            header("Location: odeme_yap.php");
            exit();
        }
    } else {
         $_SESSION['form_hatalari_odeme_yap'] = $hatalar;
         $_SESSION['form_verileri_odeme_yap'] = $_POST;
         header("Location: odeme_yap.php");
         exit();
    }
}

// Formu göstermek için carileri, hesapları ve ödenmemiş alış borçlarını getir
try {
    // Sadece aktif şirkete ait cariler
    $cariler = $db->prepare("SELECT id, ad_soyad FROM cariler WHERE sirket_id = ? ORDER BY ad_soyad");
    $cariler->execute([$aktif_sirket_id]);
    $cariler = $cariler->fetchAll(PDO::FETCH_ASSOC);
    // Sadece aktif şirkete ait hesaplar
    $hesaplar = $db->prepare("SELECT id, hesap_adi, bakiye, para_birimi FROM hesaplar WHERE sirket_id = ? ORDER BY hesap_adi");
    $hesaplar->execute([$aktif_sirket_id]);
    $hesaplar = $hesaplar->fetchAll(PDO::FETCH_ASSOC);
    // Sadece aktif şirkete ait cari grupları
    $cari_gruplari = $db->prepare("SELECT * FROM cari_gruplari WHERE sirket_id = ? ORDER BY grup_adi");
    $cari_gruplari->execute([$aktif_sirket_id]);
    $cari_gruplari = $cari_gruplari->fetchAll(PDO::FETCH_ASSOC);
    // Sadece aktif şirkete ve ödenmemiş olan alış borçları
    $odenmemis_alislar = $db->prepare("
        SELECT b.id, b.tarih, b.tutar, b.odenen_tutar, b.aciklama, c.ad_soyad
        FROM borclar b
        JOIN cariler c ON b.cari_id = c.id AND c.sirket_id = b.sirket_id
        WHERE b.tur = 'alis' AND b.durum != 'odendi' AND b.sirket_id = ?
        ORDER BY c.ad_soyad, b.tarih DESC
    ");
    $odenmemis_alislar->execute([$aktif_sirket_id]);
    $odenmemis_alislar = $odenmemis_alislar->fetchAll(PDO::FETCH_ASSOC);

} catch (PDOException $e) {
    error_log("Ödeme Yapma sayfası veri çekme hatası: " . $e->getMessage());
    $_SESSION['hata'] = "Gerekli veriler yüklenirken bir hata oluştu.";
    $cariler = []; $hesaplar = [];
}

// URL'den cari_id parametresini kontrol et
$url_cari_id = filter_input(INPUT_GET, 'cari_id', FILTER_VALIDATE_INT);

$csrf_token = csrf_token_olustur();
$form_hatalari = $_SESSION['form_hatalari_odeme_yap'] ?? [];
$form_verileri = $_SESSION['form_verileri_odeme_yap'] ?? [];

// Eğer URL'den cari_id geldiyse ve form verileri yoksa (ilk yükleme) cari_id'yi ayarla
if ($url_cari_id && empty($form_verileri)) {
    $form_verileri['cari_id'] = $url_cari_id;
}

unset($_SESSION['form_hatalari_odeme_yap'], $_SESSION['form_verileri_odeme_yap']);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Odjoo Yönetim - <?= temizle($sayfa_baslik) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
</head>
<body>
    <?php include __DIR__ . '/../includes/navbar.php'; ?>

    <div class="container mt-4">
        <h2><i class="bi bi-arrow-up-circle"></i> <?= temizle($sayfa_baslik) ?></h2>
        <hr>

         <?php if (!empty($form_hatalari)): ?>
             <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <strong><i class="bi bi-exclamation-triangle-fill me-2"></i> Lütfen hataları düzeltin:</strong>
                <ul>
                    <?php foreach ($form_hatalari as $hata): ?>
                        <li><?= htmlspecialchars($hata) ?></li>
                    <?php endforeach; ?>
                </ul>
                 <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

        <form method="post">
            <input type="hidden" name="csrf_token" value="<?= $csrf_token ?>">
             <div class="card shadow-sm mb-4">
                 <div class="card-header bg-primary text-white">
                     <h5 class="mb-0"><i class="bi bi-info-circle me-2"></i><?= __("payment_information") ?></h5>
                 </div>
                 <div class="card-body">
                     <div class="row g-3">
                        <div class="col-md-6">
                            <label for="cari_arama" class="form-label">Tedarikçi (Cari) <span class="text-danger">*</span></label>
                            <div class="input-group">
                                <input type="text" class="form-control" id="cari_arama" placeholder="Cari adı veya kodu..." autocomplete="off">
                                <button type="button" class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#yeniCariModal" title="Yeni Cari Ekle">
                                    <i class="bi bi-person-add"></i>
                                </button>
                            </div>
                            <div id="cariSonuclar" class="list-group position-absolute w-75 shadow-sm" style="z-index: 1000; display: none; max-height: 200px; overflow-y: auto;"></div>
                            <input type="hidden" id="cari_id" name="cari_id" value="<?= htmlspecialchars($form_verileri['cari_id'] ?? '') ?>" required>
                            <div id="seciliCari" class="form-text mt-2">
                                <?php if (isset($form_verileri['cari_id']) && !empty($form_verileri['cari_id'])): 
                                    $secili_cari_id = $form_verileri['cari_id'];
                                    $secili_cari = array_filter($cariler, function($c) use ($secili_cari_id) { 
                                        return $c['id'] == $secili_cari_id; 
                                    });
                                    $secili_cari = reset($secili_cari);
                                    if ($secili_cari): ?>
                                        <span class="badge bg-primary fs-6 py-2 px-3">
                                            <?= temizle($secili_cari['ad_soyad']) ?> <i class="bi bi-check-circle-fill ms-1"></i>
                                        </span>
                                    <?php endif; ?>
                                <?php else: ?>
                                    <span class="text-muted"><?= __("no_recipient_selected") ?>. <?= __("search_or_add_new_recipient") ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <label for="hesap_id" class="form-label"><?= __("payment_account") ?> <span class="text-danger">*</span></label>
                            <select class="form-select" id="hesap_id" name="hesap_id" required>
                                <option value=""><?= __("select_account") ?></option>
                                <?php foreach ($hesaplar as $hesap): ?>
                                    <option value="<?= $hesap['id'] ?>" <?= (isset($form_verileri['hesap_id']) && $form_verileri['hesap_id'] == $hesap['id']) ? 'selected' : '' ?>>
                                        <?= temizle($hesap['hesap_adi']) ?> (<?= number_format($hesap['bakiye'], 2, ',', '.') . ' ' . ($hesap['para_birimi'] === 'TRY' ? 'TL' : $hesap['para_birimi']) ?>)
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label for="tutar" class="form-label"><?= __("amount") ?> (<span class="para-birimi-etiketi"><?= getParaBirimiSembolu(); ?></span>) <span class="text-danger">*</span></label>
                            <input type="text" inputmode="decimal" class="form-control form-control-lg" id="tutar" name="tutar" required
                                    value="<?= htmlspecialchars($form_verileri['tutar'] ?? '', ENT_QUOTES) ?>" placeholder="0.00">
                        </div>
                        <div class="col-md-6">
                            <label for="tarih" class="form-label"><?= __("payment_date") ?> <span class="text-danger">*</span></label>
                            <input type="date" class="form-control" id="tarih" name="tarih" required
                                   value="<?= htmlspecialchars($form_verileri['tarih'] ?? date('Y-m-d'), ENT_QUOTES) ?>">
                        </div>
                        <div class="col-12">
                            <label for="aciklama" class="form-label"><?= __("description") ?></label>
                            <textarea class="form-control" id="aciklama" name="aciklama" rows="3" placeholder="<?= __("payment_description") ?>"><?= htmlspecialchars($form_verileri['aciklama'] ?? '', ENT_QUOTES) ?></textarea>
                        </div>
                     </div>
                 </div>
             </div>
            <div class="row mt-4">
                <div class="col-12 text-end">
                    <button type="submit" class="btn btn-danger btn-lg px-4">
                        <i class="bi bi-send-check me-2"></i> <?= __("save_payment_btn") ?>
                    </button>
                </div>
            </div>
        </form>
    </div>

    <?php include __DIR__ . '/../includes/cari_ekle_modal.php'; ?>

    <script src="<?= BASE_URL ?>/assets/js/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
    // AJAX ile cari ekleme işlemi
    $(function(){
        $('#cariEkleBtn').off('click').on('click', function() {
            var form = $('#yeniCariForm');
            var btn = $(this);
            btn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm"></span> ' + '<?= addslashes(__("saving")) ?>...');
            $.ajax({
                url: '<?= BASE_URL ?>/ajax/cari_ekle_ajax.php',
                method: 'POST',
                data: form.serialize(),
                dataType: 'json',
                success: function(data) {
                    if(data.success) {
                        $('#cariEkleMessage').removeClass('d-none alert-danger').addClass('alert-success').text(data.message);
                        setTimeout(function(){
                            $('#yeniCariModal').modal('hide');
                            form[0].reset();
                            $('#cariEkleMessage').addClass('d-none');
                            // Sayfada cari arama varsa otomatik ekle
                             if ($('#cari_arama').length) {
                                $('#cari_id').val(data.id);
                                $('#seciliCari').html(`<div class="alert alert-success p-2">Seçilen: <strong>${data.ad_soyad}</strong></div>`);
                                $('#cariSonuclar').hide();
                            }
                        }, 1000);
                    } else {
                        $('#cariEkleMessage').removeClass('d-none alert-success').addClass('alert-danger').text(data.message);
                    }
                },
                error: function() {
                    $('#cariEkleMessage').removeClass('d-none alert-success').addClass('alert-danger').text('Cari eklenirken bir hata oluştu.');
                },
                complete: function() {
                    btn.prop('disabled', false).html('Cari Ekle');
                }
            });
        });

        // Cari Arama AJAX
        $('#cari_arama').on('keyup', function() {
            var arama_terimi = $(this).val();
            var cariSonuclar = $('#cariSonuclar');
            if (arama_terimi.length >= 2) {
                $.ajax({
                    url: '<?= BASE_URL ?>/ajax/cari_ara_ajax.php',
                    method: 'POST',
                    data: { arama: arama_terimi },
                    success: function(data) {
                        cariSonuclar.empty();
                        if (data.success && data.cariler.length > 0) {
                            $.each(data.cariler, function(index, cari) {
                                cariSonuclar.append(
                                    `<a href="#" class="list-group-item list-group-item-action" data-id="${cari.id}" data-adsoyad="${cari.ad_soyad}">
                                        ${cari.ad_soyad} (${cari.telefon || 'Yok'})
                                    </a>`
                                );
                            });
                            cariSonuclar.show();
                        } else {
                            cariSonuclar.hide();
                        }
                    }
                });
            } else {
                cariSonuclar.hide();
            }
        });

        // Cari Seçimi
        $('#cariSonuclar').on('click', 'a', function(e) {
            e.preventDefault();
            var cari_id = $(this).data('id');
            var ad_soyad = $(this).data('adsoyad');
            $('#cari_id').val(cari_id);
            $('#cari_arama').val(ad_soyad);
            $('#seciliCari').html(`<span class="badge bg-primary">${ad_soyad} <i class="bi bi-check-circle-fill ms-1"></i></span>`);
            $('#cariSonuclar').hide();

            // URL'den gelen cari_id varsa otomatik seçme mantığı
            var urlParams = new URLSearchParams(window.location.search);
            var initialCariId = urlParams.get('cari_id');
            if (initialCariId && initialCariId == cari_id) {
                // Eğer URL'den gelen cari seçilmişse, form verilerini de güncelle
                // Bu kısım, sayfa yüklendiğinde otomatik seçimi destekler
                // ve kullanıcının manuel arama yapmasını etkilemez.
                $('#cari_arama').val(ad_soyad);
                $('#seciliCari').html(`<span class="badge bg-primary">${ad_soyad} <i class="bi bi-check-circle-fill ms-1"></i></span>`);
            }
        });

        // URL'den gelen cari_id varsa otomatik seçme
        const urlParams = new URLSearchParams(window.location.search);
        const initialCariId = urlParams.get('cari_id');
        if (initialCariId) {
            $.ajax({
                url: '<?= BASE_URL ?>/ajax/cari_ara_ajax.php',
                method: 'POST',
                data: { cari_id: initialCariId },
                success: function(data) {
                    if (data.success && data.cariler && data.cariler.length > 0) {
                        var cari = data.cariler[0];
                        $('#cari_id').val(cari.id);
                        $('#cari_arama').val(cari.ad_soyad);
                        $('#seciliCari').html(`<span class="badge bg-primary">${cari.ad_soyad} <i class="bi bi-check-circle-fill ms-1"></i></span>`);
                    } else {
                        $('#seciliCari').html(`<span class="text-danger">Cari bulunamadı veya yetkiniz yok.</span>`);
                    }
                },
                error: function() {
                    $('#seciliCari').html(`<span class="text-danger">Cari bilgileri yüklenirken hata oluştu.</span>`);
                }
            });
        }

        // Cari arama alanından odaklanma kalkınca sonuçları gizle (küçük bir gecikmeyle)
        $('#cari_arama').on('blur', function() {
            setTimeout(function() {
                $('#cariSonuclar').hide();
            }, 200);
        });
        // Sonuç listesine tıklayınca blur olayının tetiklenmemesi için
        $('#cariSonuclar').on('mousedown', function(e) {
            e.preventDefault();
        });
    });
    </script>
        <?php include __DIR__ . '/../includes/footer.php'; ?>
</body>
</html>
