<?php
// Bu dosya GÜVENLİ DEĞİLDİR ve sadece geçici kullanım içindir.
// İşiniz bittiğinde SİLİN.

require_once '../includes/config.php';

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $kullanici_adi = $_POST['kullanici_adi'] ?? '';
    $yeni_sifre = $_POST['yeni_sifre'] ?? '';
    $yeni_sifre_tekrar = $_POST['yeni_sifre_tekrar'] ?? '';

    if (empty($kullanici_adi) || empty($yeni_sifre) || empty($yeni_sifre_tekrar)) {
        $message = '<div class="alert alert-danger">Lütfen tüm alanları doldurun.</div>';
    } elseif ($yeni_sifre !== $yeni_sifre_tekrar) {
        $message = '<div class="alert alert-danger">Yeni şifreler eşleşmiyor.</div>';
    } else {
        try {
            // Kullanıcının var olup olmadığını kontrol et
            $stmt = $db->prepare("SELECT id FROM kullanicilar WHERE kullanici_adi = :kullanici_adi");
            $stmt->bindParam(':kullanici_adi', $kullanici_adi);
            $stmt->execute();

            if ($stmt->rowCount() > 0) {
                // Yeni şifreyi hash'le
                $hashed_password = password_hash($yeni_sifre, PASSWORD_DEFAULT);

                // Şifreyi güncelle
                $update_stmt = $db->prepare("UPDATE kullanicilar SET sifre = :sifre WHERE kullanici_adi = :kullanici_adi");
                $update_stmt->bindParam(':sifre', $hashed_password);
                $update_stmt->bindParam(':kullanici_adi', $kullanici_adi);
                
                if ($update_stmt->execute()) {
                    $message = '<div class="alert alert-success">' . htmlspecialchars($kullanici_adi) . ' kullanıcısının şifresi başarıyla güncellendi.</div>';
                } else {
                    $message = '<div class="alert alert-danger">Şifre güncellenirken bir hata oluştu.</div>';
                }
            } else {
                $message = '<div class="alert alert-danger">Kullanıcı bulunamadı.</div>';
            }
        } catch (PDOException $e) {
            $message = '<div class="alert alert-danger">Veritabanı hatası: ' . $e->getMessage() . '</div>';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Geçici Şifre Sıfırlama</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
<div class="container mt-5">
    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h3>Geçici Şifre Sıfırlama</h3>
                    <p class="text-danger">DİKKAT: Bu sayfa güvenli değildir. Sadece acil durumlar için kullanın ve sonra silin.</p>
                </div>
                <div class="card-body">
                    <?php echo $message; ?>
                    <form action="" method="post">
                        <div class="form-group">
                            <label for="kullanici_adi">Kullanıcı Adı</label>
                            <input type="text" name="kullanici_adi" id="kullanici_adi" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label for="yeni_sifre">Yeni Şifre</label>
                            <input type="password" name="yeni_sifre" id="yeni_sifre" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label for="yeni_sifre_tekrar">Yeni Şifre (Tekrar)</label>
                            <input type="password" name="yeni_sifre_tekrar" id="yeni_sifre_tekrar" class="form-control" required>
                        </div>
                        <button type="submit" class="btn btn-primary btn-block">Şifreyi Sıfırla</button>
                    </form>
                </div>
                 <div class="card-footer">
                    <a href="../index.php">Giriş Sayfasına Dön</a>
                </div>
            </div>
        </div>
    </div>
</div>
</body>
</html>