<?php
require_once __DIR__ . '/../includes/config.php';

// Kullanıcının giriş yapmış olduğundan emin ol
if (!isset($_SESSION['kullanici_id'])) {
    header('Location: login.php');
    exit();
}

// Değiştirilmek istenen şirket ID'sini al
$yeni_sirket_id = filter_input(INPUT_POST, 'sirket_id', FILTER_VALIDATE_INT);

if (!$yeni_sirket_id) {
    // POST ile gelmediyse veya geçersizse, GET ile deneyelim (eski yöntemlere uyum için)
    $yeni_sirket_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
}

if (!$yeni_sirket_id) {
    // Hala geçerli bir ID yoksa hata ver
    $_SESSION['hata'] = "Geçersiz şirket ID'si.";
    header('Location: index.php');
    exit();
}

// Kullanıcının bu şirkete erişim yetkisi var mı kontrol et
$yetki_var = false;
$yeni_sirket_adi = '';

if (isset($_SESSION['kullanici_sirketleri'])) {
    foreach ($_SESSION['kullanici_sirketleri'] as $sirket) {
        if ($sirket['id'] == $yeni_sirket_id) {
            $yetki_var = true;
            $yeni_sirket_adi = $sirket['sirket_adi'];
            break;
        }
    }
}

if ($yetki_var) {
    // Yetki varsa, session'daki aktif şirketi güncelle
    $_SESSION['aktif_sirket_id'] = $yeni_sirket_id;
    $_SESSION['aktif_sirket_adi'] = $yeni_sirket_adi;
    $_SESSION['mesaj'] = "'" . temizle($yeni_sirket_adi) . "' şirketine geçiş yapıldı.";
} else {
    // Yetki yoksa hata mesajı ver
    $_SESSION['hata'] = "Bu şirkete erişim yetkiniz bulunmuyor.";
}

// Kullanıcıyı ana sayfaya yönlendir
header('Location: index.php');
exit();
?> 
