<?php
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../functions/yardimci_fonksiyonlar.php';

// Sadece giriş yapmış kullanıcılar bu sayfayı görebilir
if (!isset($_SESSION['kullanici_id'])) {
    header("Location: login.php");
    exit();
}

$hatalar = [];
$sirket_adi = '';
$vergi_no = '';
$adres = '';
$telefon = '';
$secim = $_POST['secim'] ?? '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && $secim === 'sirket_olustur') {
    // Form verilerini al ve temizle
    $sirket_adi = trim($_POST['sirket_adi'] ?? '');
    $vergi_no = trim($_POST['vergi_no'] ?? '');
    $adres = trim($_POST['adres'] ?? '');
    $telefon = trim($_POST['telefon'] ?? '');
    $kullanici_id = $_SESSION['kullanici_id'];

    // Doğrulama
    if (empty($sirket_adi)) {
        $hatalar[] = "Şirket adı zorunludur.";
    }

    if (empty($hatalar)) {
        $db->beginTransaction();
        try {
            // 1. Yeni şirketi 'sirketler' tablosuna ekle
            $stmt_sirket = $db->prepare(
                "INSERT INTO sirketler (sirket_adi, vergi_no, adres, telefon) VALUES (?, ?, ?, ?)"
            );
            $stmt_sirket->execute([$sirket_adi, $vergi_no, $adres, $telefon]);
            $yeni_sirket_id = $db->lastInsertId();

            // 2. Kullanıcıyı yeni şirkete 'admin' rolüyle ata
            $stmt_iliski = $db->prepare(
                "INSERT INTO kullanici_sirket_iliskisi (kullanici_id, sirket_id, rol) VALUES (?, ?, 'admin')"
            );
            $stmt_iliski->execute([$kullanici_id, $yeni_sirket_id]);

            // 3. Kullanıcının yetki seviyesini admin yap
            $stmt_yetki = $db->prepare(
                "UPDATE kullanicilar SET yetki_seviyesi = 'admin' WHERE id = ?"
            );
            $stmt_yetki->execute([$kullanici_id]);

            // 4. Kullanıcının session bilgilerini güncelle
            $_SESSION['aktif_sirket_id'] = $yeni_sirket_id;
            $_SESSION['aktif_sirket_adi'] = $sirket_adi;
            $_SESSION['yetki_seviyesi'] = 'admin'; // Session'da da güncelle

            // Kullanıcının şirket listesini yeniden çek ve session'a ata
            $stmt_sirketler = $db->prepare("SELECT s.id, s.sirket_adi FROM kullanici_sirket_iliskisi k_s JOIN sirketler s ON k_s.sirket_id = s.id WHERE k_s.kullanici_id = ? AND s.aktif_mi = 1 ORDER BY s.id ASC");
            $stmt_sirketler->execute([$kullanici_id]);
            $_SESSION['kullanici_sirketleri'] = $stmt_sirketler->fetchAll(PDO::FETCH_ASSOC);
            
            // Log ekle
            require_once __DIR__ . '/../functions/log_fonksiyonlari.php';
            sistem_log_ekle($db, 'ekle', 'sirketler', $yeni_sirket_id, null, ['ad' => $sirket_adi], "Yeni şirket oluşturuldu.");

            $db->commit();

            // 5. Ana panele yönlendir
            $_SESSION['basari'] = "Şirketiniz başarıyla oluşturuldu! Artık sistem yöneticisi olarak tüm yetkilere sahipsiniz.";
            header("Location: index.php");
            exit();

        } catch (PDOException $e) {
            $db->rollBack();
            error_log("Şirket oluşturma hatası: " . $e->getMessage());
            $hatalar[] = "Veritabanı hatası nedeniyle şirket oluşturulamadı. Lütfen tekrar deneyin.";
        }
    }
}

$sayfa_baslik = "Şirket Seçimi";
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= temizle($sayfa_baslik) ?> - Odjoo Yönetim</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <style>
        .option-card {
            border: 2px solid #e9ecef;
            border-radius: 10px;
            padding: 2rem;
            margin: 1rem 0;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        .option-card:hover {
            border-color: #0d6efd;
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }
        .option-card.selected {
            border-color: #0d6efd;
            background-color: #f8f9ff;
        }
        .option-icon {
            font-size: 3rem;
            margin-bottom: 1rem;
        }
        .form-container {
            display: none;
            margin-top: 2rem;
        }
        .form-container.active {
            display: block;
        }
    </style>
</head>
<body style="background-color: #f4f7f6;">
    <?php 
    // Şirket oluşturma sayfasında navbar gösterme - yönlendirme sorununu önlemek için
    // include __DIR__ . '/../includes/navbar.php'; 
    ?>

    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-10 col-lg-8">
                <div class="card shadow-sm">
                    <div class="card-header text-center">
                        <h4 class="mb-0"><i class="bi bi-building me-2"></i><?= temizle($sayfa_baslik) ?></h4>
                        <p class="text-muted mt-2">Sistemi kullanmaya başlamak için bir seçenek belirleyin</p>
                    </div>
                    <div class="card-body">
                        
                        <?php if (!empty($hatalar)): ?>
                            <div class="alert alert-danger">
                                <ul class="mb-0">
                                    <?php foreach ($hatalar as $hata): ?>
                                        <li><?= htmlspecialchars($hata) ?></li>
                                    <?php endforeach; ?>
                                </ul>
                            </div>
                        <?php endif; ?>

                        <div class="row">
                            <!-- Seçenek 1: Mevcut Şirkete Davet Bekle -->
                            <div class="col-md-6">
                                <div class="option-card text-center" onclick="selectOption('davet_bekle')">
                                    <i class="bi bi-envelope-plus option-icon text-warning"></i>
                                    <h5>Mevcut Şirkete Katıl</h5>
                                    <p class="text-muted">Mevcut bir şirketiniz yok mu? Şirket sahibine e-posta adresinizi verin, sizi yönetici olarak atasın.</p>
                                    <div class="badge bg-warning text-dark">Davet Bekle</div>
                                </div>
                            </div>

                            <!-- Seçenek 2: Yeni Şirket Oluştur -->
                            <div class="col-md-6">
                                <div class="option-card text-center" onclick="selectOption('sirket_olustur')">
                                    <i class="bi bi-building-add option-icon text-success"></i>
                                    <h5>Yeni Şirket Oluştur</h5>
                                    <p class="text-muted">Kendi şirketinizi yönetmek için yeni bir şirket oluşturun ve sistemde tam yetkili olun.</p>
                                    <div class="badge bg-success">Şirket Oluştur</div>
                                </div>
                            </div>
                        </div>

                        <!-- Davet Bekle Formu -->
                        <div id="davet_bekle_form" class="form-container">
                            <div class="alert alert-info">
                                <h6><i class="bi bi-info-circle me-2"></i>Davet Beklemek İçin:</h6>
                                <ol class="mb-0">
                                    <li>Şirket sahibine e-posta adresinizi verin: <strong><?= htmlspecialchars($_SESSION['kullanici_adi']) ?></strong></li>
                                    <li>Şirket sahibi sizi "Kullanıcılar" bölümünden sisteme ekleyecek</li>
                                    <li>Davet aldıktan sonra sisteme giriş yapabileceksiniz</li>
                                </ol>
                            </div>
                            <div class="text-center">
                                <a href="cikis.php" class="btn btn-secondary">
                                    <i class="bi bi-box-arrow-left me-2"></i>Çıkış Yap
                                </a>
                            </div>
                        </div>

                        <!-- Şirket Oluştur Formu -->
                        <div id="sirket_olustur_form" class="form-container">
                            <form method="POST" action="sirket_olustur.php">
                                <input type="hidden" name="secim" value="sirket_olustur">
                                <div class="mb-3">
                                    <label for="sirket_adi" class="form-label">Şirket Adı <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="sirket_adi" name="sirket_adi" value="<?= htmlspecialchars($sirket_adi) ?>" required>
                                </div>
                                <div class="mb-3">
                                    <label for="vergi_no" class="form-label">Vergi Numarası (Opsiyonel)</label>
                                    <input type="text" class="form-control" id="vergi_no" name="vergi_no" value="<?= htmlspecialchars($vergi_no) ?>">
                                </div>
                                <div class="mb-3">
                                    <label for="adres" class="form-label">Adres (Opsiyonel)</label>
                                    <textarea class="form-control" id="adres" name="adres" rows="3"><?= htmlspecialchars($adres) ?></textarea>
                                </div>
                                <div class="mb-3">
                                    <label for="telefon" class="form-label">Telefon (Opsiyonel)</label>
                                    <input type="text" class="form-control" id="telefon" name="telefon" value="<?= htmlspecialchars($telefon) ?>">
                                </div>
                                <div class="d-grid">
                                    <button type="submit" class="btn btn-success btn-lg">
                                        <i class="bi bi-building-add me-2"></i>Şirketi Oluştur
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function selectOption(option) {
            // Tüm kartları temizle
            document.querySelectorAll('.option-card').forEach(card => {
                card.classList.remove('selected');
            });
            
            // Tüm formları gizle
            document.querySelectorAll('.form-container').forEach(form => {
                form.classList.remove('active');
            });
            
            // Seçili kartı işaretle
            event.target.closest('.option-card').classList.add('selected');
            
            // İlgili formu göster
            document.getElementById(option + '_form').classList.add('active');
        }
    </script>
</body>
</html> 