<?php
require_once __DIR__ . '/../includes/config.php';
yetkili_mi();

$backup_dir = __DIR__ . '/backups/';

// Kullanıcının erişim yetkisi olan şirketleri getir
$kullanici_sirketleri = [];
if (isset($_SESSION['kullanici_id'])) {
    $stmt_sirketler = $db->prepare("
        SELECT s.id, s.sirket_adi 
        FROM sirketler s
        JOIN kullanici_sirket_iliskisi ksi ON s.id = ksi.sirket_id
        WHERE ksi.kullanici_id = ?
    ");
    $stmt_sirketler->execute([$_SESSION['kullanici_id']]);
    $kullanici_sirketleri = $stmt_sirketler->fetchAll(PDO::FETCH_ASSOC);
}
$allowed_sirket_ids = array_column($kullanici_sirketleri, 'id');

if (isset($_GET['file'])) {
    $filename = basename($_GET['file']);
    $filepath = $backup_dir . $filename;

    // Dosya adından şirket ID'sini veya adını çıkarmaya çalış
    $sirket_id_from_filename = null;
    if (preg_match('/^Odjoo_yonetim_yedek_([a-zA-Z0-9_]+)_(\d{8}_\d{6})\.sql$/', $filename, $matches)) {
        $sirket_adi_in_filename = $matches[1];
        foreach ($kullanici_sirketleri as $sirket) {
            $sanitized_sirket_adi = preg_replace('/[^a-zA-Z0-9_]/u', '', str_replace(' ', '_', mb_strtolower($sirket['sirket_adi'], 'UTF-8')));
            if ($sanitized_sirket_adi === $sirket_adi_in_filename) {
                $sirket_id_from_filename = $sirket['id'];
                break;
            }
        }
    }

    // Yetki kontrolü: Genel yedek mi yoksa yetkili olunan bir şirkete mi ait?
    $is_authorized = false;
    if ($sirket_id_from_filename === null) {
        // Dosya adı bir şirket ID'si içermiyorsa, bu bir genel yedek olabilir.
        // Şimdilik genel yedekleri varsayılan olarak yetkili kabul edelim.
        // Gelecekte, genel yedekler için ayrı bir yetkilendirme mekanizması düşünülebilir.
        $is_authorized = true; 
    } else if (in_array($sirket_id_from_filename, $allowed_sirket_ids)) {
        $is_authorized = true;
    }

    if ($is_authorized && file_exists($filepath) && is_file($filepath) && strpos($filename, '.sql') !== false) {
        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename="' . $filename . '"');
        header('Expires: 0');
        header('Cache-Control: must-revalidate');
        header('Pragma: public');
        header('Content-Length: ' . filesize($filepath));
        readfile($filepath);
        exit;
    } else {
        $_SESSION['hata'] = 'Yedek dosyası bulunamadı, geçersiz veya indirme yetkiniz yok.';
    }
} else {
    $_SESSION['hata'] = 'Dosya adı belirtilmedi.';
}

header('Location: yedek_islemi.php');
exit;
?>

